/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.code;

import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileUserCodeUpdate {
    private Map<String, String> currentUserCodeMap;
    private Map<String, String> originUserCodeMap;
    private String Code;
    private String strLeftIndent = "";

    public FileUserCodeUpdate(String FilePath, String Code, int fileType, boolean isformatCode) {
        this.Code = Code;
        this.currentUserCodeMap = new HashMap<String, String>();
        this.originUserCodeMap = new HashMap<String, String>();
        this.GetUserCodeInfo(FilePath);
        FileUserCodeUpdate.updateUserCodeTagMap(fileType);
        this.updateUserTag();
        this.WriteUserCodeInFile();
        if (isformatCode) {
            this.Code = this.CodeFormat(this.Code);
        }
    }

    public FileUserCodeUpdate() {
    }

    public String GetCode() {
        return this.Code;
    }

    public void GetUserCodeInfo(String FilePath) {
        try {
            FileReader reader = new FileReader(FilePath);
            BufferedReader br = new BufferedReader(reader);
            String str = null;
            ArrayList<String> codeList = new ArrayList<String>();
            while ((str = br.readLine()) != null) {
                codeList.add(str);
            }
            br.close();
            reader.close();
            this.currentUserCodeMap = this.getUserCodeMap(codeList);
            String[] lines = this.Code.split(System.lineSeparator());
            ArrayList<String> originCodeList = new ArrayList<String>();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                originCodeList.add(line);
                ++n2;
            }
            this.originUserCodeMap = this.getUserCodeMap(originCodeList);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String WriteUserCodeInFile() {
        for (Map.Entry<String, String> entry : this.currentUserCodeMap.entrySet()) {
            String BeginString = entry.getKey();
            String replaceStr = entry.getValue();
            if (this.originUserCodeMap.containsKey(BeginString)) {
                BeginString = this.originUserCodeMap.get(BeginString);
            }
            if (BeginString.equals(replaceStr)) continue;
            this.Code = this.Code.replace(BeginString, replaceStr);
        }
        return this.Code;
    }

    private boolean IsUserCodeSignString(String Code, int type, String TagStr) {
        return type == 0 ? Code.contains("/* user code") && Code.contains("begin */") : type == 1 && Code.contains("/* user code") && Code.contains(TagStr) && Code.contains("end */");
    }

    private String getUserCodeTag(String Code) {
        if (Code == null || Code.isEmpty()) {
            return "";
        }
        int leftBracket = Code.indexOf(91);
        int rightBracket = Code.indexOf(93);
        if (leftBracket != -1 && rightBracket != -1 && rightBracket > leftBracket) {
            return Code.substring(leftBracket, rightBracket + 1);
        }
        return "";
    }

    private String getReplaceCodeString(String Code, String oldStr, String newStr) {
        if (Code == null || oldStr == null || newStr == null) {
            return Code;
        }
        return Code.replace(oldStr, newStr);
    }

    public String CodeFormat(String Code) {
        Code = GlobalVariables.formatCppCodeWithClangFormat(Code);
        return Code;
    }

    private void updateUserTag() {
        HashMap<String, String> tmpUserCodeInfos = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.currentUserCodeMap.entrySet()) {
            String key = entry.getKey();
            String tagStr = this.getUserCodeTag(key);
            String newUserCodeStr = "";
            if (!GlobalVariables.UserCodeTagUpdate.containsKey(tagStr)) continue;
            String newTagStr = GlobalVariables.UserCodeTagUpdate.get(tagStr);
            String newTagUserCodeKey = this.getUserCodeKeyByTag(newTagStr, this.currentUserCodeMap);
            String oldUserCodeStr = this.currentUserCodeMap.get(key);
            if (newTagUserCodeKey != null) {
                oldUserCodeStr = this.getReplaceCodeString(oldUserCodeStr, key, "");
                newUserCodeStr = this.currentUserCodeMap.get(newTagUserCodeKey);
                newUserCodeStr = String.valueOf(newUserCodeStr) + oldUserCodeStr;
            } else {
                newTagUserCodeKey = this.getUserCodeKeyByTag(newTagStr, this.originUserCodeMap);
                if (newTagUserCodeKey == null) continue;
                String replaceStr = this.originUserCodeMap.get(newTagUserCodeKey);
                newUserCodeStr = this.getReplaceCodeString(oldUserCodeStr, tagStr, newTagStr);
                newUserCodeStr = newUserCodeStr.replace(newTagUserCodeKey, replaceStr);
            }
            tmpUserCodeInfos.put(newTagUserCodeKey, newUserCodeStr);
        }
        this.currentUserCodeMap.putAll(tmpUserCodeInfos);
    }

    private String getUserCodeKeyByTag(String tagStr, Map<String, String> userCodeMap) {
        for (Map.Entry<String, String> entry : userCodeMap.entrySet()) {
            String key = entry.getKey();
            if (!key.contains("/* user code") || !key.contains(tagStr)) continue;
            return key;
        }
        return null;
    }

    private Map<String, String> getUserCodeMap(List<String> codeList) {
        HashMap<String, String> UserCodeMap = new HashMap<String, String>();
        String currentTag = "";
        String tmpBeginString = "";
        boolean StartFlag = false;
        boolean EndFlag = false;
        ArrayList<String> UserCodeList = new ArrayList<String>();
        for (String line : codeList) {
            if (this.IsUserCodeSignString(line, 0, "")) {
                StartFlag = true;
                EndFlag = false;
                tmpBeginString = line;
                currentTag = this.getUserCodeTag(line);
                UserCodeList.clear();
                UserCodeList.add(line);
                continue;
            }
            if (this.IsUserCodeSignString(line, 1, currentTag)) {
                StartFlag = false;
                EndFlag = true;
            }
            if (StartFlag && !EndFlag) {
                UserCodeList.add(line);
            }
            if (!EndFlag) continue;
            String UserCode = "";
            int i = 0;
            while (i < UserCodeList.size()) {
                UserCode = String.valueOf(UserCode) + (String)UserCodeList.get(i);
                if (i != UserCodeList.size() - 1) {
                    UserCode = String.valueOf(UserCode) + System.lineSeparator();
                }
                ++i;
            }
            UserCodeMap.put(tmpBeginString, UserCode);
            UserCodeList.clear();
            currentTag = "";
            tmpBeginString = "";
            EndFlag = false;
        }
        return UserCodeMap;
    }

    public static void updateUserCodeTagMap(int fileType) {
        GlobalVariables.UserCodeTagUpdate.clear();
        if (ConstantsUtil.FileTypeEnum.isCFile.ordinal() == fileType) {
            GlobalVariables.UserCodeTagUpdate.put("[global 0]", "[External Includes]");
            GlobalVariables.UserCodeTagUpdate.put("[global 1]", "[Public Functions Implementations]");
        } else if (ConstantsUtil.FileTypeEnum.isHeadFile.ordinal() == fileType) {
            GlobalVariables.UserCodeTagUpdate.put("[global 0]", "[External Includes]");
            GlobalVariables.UserCodeTagUpdate.put("[global 1]", "[Public Functions]");
        }
    }
}

