/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.baseinfo.jtreenode;

import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.baseinfo.mComboBox;
import com.gigadevice.venustool.periconfigbasestruct.GeneralPariParaNodeItemStruct;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JTreeComboxNode
extends AbstractJTreeNode {
    private static final long serialVersionUID = 1L;
    private Map<String, GeneralPariParaNodeItemStruct> PossibleValueList = new LinkedHashMap<String, GeneralPariParaNodeItemStruct>();
    private JLabel nameLabel;
    private JPanel comboBoxPanel;
    private mComboBox comboBox;

    public JTreeComboxNode(String name, String content, Map<String, GeneralPariParaNodeItemStruct> PossibleValueList) {
        this.InitJTreeComboxNode(name, content, PossibleValueList);
    }

    public void InitJTreeComboxNode(String name, String content, Map<String, GeneralPariParaNodeItemStruct> PossibleValueList) {
        this.setType(2);
        this.setName(name);
        this.setContent(content);
        this.PossibleValueList = PossibleValueList;
        this.initComboxGUI(PossibleValueList);
    }

    private void initComboxGUI(Map<String, GeneralPariParaNodeItemStruct> PossibleValueList) {
        this.comboBoxPanel = new JPanel(new GridLayout());
        this.comboBoxPanel.setBackground(Color.white);
        this.nameLabel = new JLabel(this.getContent());
        this.nameLabel.setFont(new Font("Arial", 1, 15));
        GridBagConstraints labelgbc = new GridBagConstraints();
        labelgbc.gridx = 0;
        labelgbc.gridy = 0;
        labelgbc.anchor = 21;
        List<String> items = this.getComboxItemsList(PossibleValueList);
        this.comboBox = new mComboBox(items);
        this.comboBox.setEditable(false);
        this.comboBox.setBackground(Color.white);
        this.comboBox.setFont(new Font("Arial", 0, 15));
        GridBagConstraints comboxgbc = new GridBagConstraints();
        comboxgbc.gridx = 1;
        comboxgbc.gridy = 0;
        comboxgbc.anchor = 2;
        this.comboBoxPanel.add((Component)this.nameLabel, labelgbc);
        this.comboBoxPanel.add((Component)this.comboBox, comboxgbc);
        this.nameLabel.setToolTipText(this.getContent());
        this.comboBoxPanel.setToolTipText(this.getContent());
    }

    public List<String> getComboxItemsList(Map<String, GeneralPariParaNodeItemStruct> PossibleValueList) {
        ArrayList<String> ItemList = new ArrayList<String>();
        for (Map.Entry<String, GeneralPariParaNodeItemStruct> entry : PossibleValueList.entrySet()) {
            String content = entry.getKey();
            GeneralPariParaNodeItemStruct Item = entry.getValue();
            if (!Item.isVisible()) continue;
            ItemList.add(content);
        }
        return ItemList;
    }

    public String updateComboxItemsGUI(JComboBox comboBox) {
        comboBox.removeAllItems();
        if (this.PossibleValueList.size() == 0) {
            return "";
        }
        for (Map.Entry<String, GeneralPariParaNodeItemStruct> entry : this.PossibleValueList.entrySet()) {
            if (entry.getValue().isVisible()) {
                comboBox.addItem(entry.getKey());
            }
            if (entry.getValue().isEnable()) continue;
            ((mComboBox)comboBox).disableItem(entry.getKey());
        }
        int maximumRowCount = comboBox.getItemCount();
        if (maximumRowCount > 20) {
            maximumRowCount = 20;
        }
        comboBox.setMaximumRowCount(maximumRowCount);
        String tempContent = this.getValue();
        if (!(!this.PossibleValueList.containsKey(tempContent) || this.PossibleValueList.get(tempContent).isVisible() && this.PossibleValueList.get(tempContent).isEnable())) {
            String defaultContent = this.getDefaultValue();
            if (!(this.PossibleValueList.get(defaultContent).isVisible() && this.PossibleValueList.get(defaultContent).isEnable() || comboBox.getItemCount() <= 0)) {
                int i = 0;
                while (i < comboBox.getItemCount()) {
                    String temp = comboBox.getItemAt(i).toString();
                    if (this.PossibleValueList.get(temp).isEnable() && this.PossibleValueList.get(temp).isVisible()) {
                        this.setDefaultValue(temp);
                        break;
                    }
                    ++i;
                }
            }
            this.value = this.getDefaultValue();
        }
        String itemContent = this.getValue();
        comboBox.setSelectedItem(itemContent);
        return this.getValue();
    }

    public void updateValueAndDefaultValue() {
        String tempContent = this.getValue();
        if (!(!this.PossibleValueList.containsKey(tempContent) || this.PossibleValueList.get(tempContent).isVisible() && this.PossibleValueList.get(tempContent).isEnable())) {
            String defaultContent = this.getDefaultValue();
            if (!(this.PossibleValueList.get(defaultContent).isVisible() && this.PossibleValueList.get(defaultContent).isEnable() || this.comboBox.getItemCount() <= 0)) {
                int i = 0;
                while (i < this.comboBox.getItemCount()) {
                    String temp = this.comboBox.getItemAt(i).toString();
                    if (this.PossibleValueList.get(temp).isEnable() && this.PossibleValueList.get(temp).isVisible()) {
                        this.setDefaultValue(temp);
                        break;
                    }
                    ++i;
                }
            }
            this.value = this.getDefaultValue();
        }
    }

    public String getVisibleAndEnableItem() {
        String ItemContent = this.getDefaultValue();
        if (!(!this.PossibleValueList.containsKey(this.getDefaultValue()) || this.PossibleValueList.get(this.getDefaultValue()).isVisible() && this.PossibleValueList.get(this.getDefaultValue()).isEnable())) {
            for (Map.Entry<String, GeneralPariParaNodeItemStruct> entry : this.PossibleValueList.entrySet()) {
                if (!entry.getValue().isVisible() || !entry.getValue().isEnable()) continue;
                ItemContent = entry.getKey();
                break;
            }
        }
        return ItemContent;
    }

    public void updateComboxItemVisible(String itemContent, boolean visible) {
        if (this.PossibleValueList.containsKey(itemContent)) {
            this.PossibleValueList.get(itemContent).setVisible(visible);
        }
    }

    public void updateComboxAllItemsVisible(boolean visible) {
        for (GeneralPariParaNodeItemStruct value : this.PossibleValueList.values()) {
            value.setVisible(visible);
        }
    }

    public String getValueDependItemContent(String content) {
        String value = "";
        if (this.PossibleValueList.size() > 0 && this.PossibleValueList.containsKey(content)) {
            value = this.PossibleValueList.get(content).getValue();
        }
        return value;
    }

    public String getContentDependItemValue(String value) {
        String content = "";
        if (this.PossibleValueList.size() > 0) {
            for (Map.Entry<String, GeneralPariParaNodeItemStruct> entry : this.PossibleValueList.entrySet()) {
                String temContent = entry.getKey();
                GeneralPariParaNodeItemStruct Item = entry.getValue();
                if (!Item.getValue().equals(value)) continue;
                content = temContent;
            }
        }
        return content;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.comboBox.setSelectedItem(value);
    }

    @Override
    public void setNodeDisable() {
        this.nameLabel.setForeground(Color.GRAY);
        this.comboBox.setEnabled(false);
    }

    @Override
    public void setNodeEnable() {
        this.nameLabel.setForeground(Color.BLACK);
        this.comboBox.setEnabled(true);
    }

    public JComboBox getJComboBox() {
        return this.comboBox;
    }

    public Component getComboxView() {
        return this.comboBoxPanel;
    }

    @Override
    public void setSize(int width, int height) {
        this.comboBoxPanel.setPreferredSize(new Dimension(width - 110, 30));
        this.nameLabel.setBounds(30, 0, width / 3, 30);
        this.comboBox.setBounds(width / 2, 0, width / 3, 30);
    }

    public Map<String, GeneralPariParaNodeItemStruct> getPossibleValueList() {
        return this.PossibleValueList;
    }

    public void setPossibleValueList(Map<String, GeneralPariParaNodeItemStruct> PossibleValueList) {
        this.PossibleValueList = PossibleValueList;
    }

    @Override
    public List<String> updateValueToDefaultValue() {
        int i;
        ArrayList<String> valueChangedNodesPath = new ArrayList<String>();
        String oldValue = this.getValue();
        String defaultContent = this.getDefaultValue();
        if (this.PossibleValueList.containsKey(defaultContent)) {
            if (!(this.PossibleValueList.get(defaultContent).isVisible() && this.PossibleValueList.get(defaultContent).isEnable() || this.comboBox.getItemCount() <= 0)) {
                i = 0;
                while (i < this.comboBox.getItemCount()) {
                    String temp = this.comboBox.getItemAt(i).toString();
                    if (this.PossibleValueList.get(temp).isEnable() && this.PossibleValueList.get(temp).isVisible()) {
                        defaultContent = temp;
                        break;
                    }
                    ++i;
                }
            }
        } else if (this.comboBox.getItemCount() > 0) {
            i = 0;
            while (i < this.comboBox.getItemCount()) {
                String temp = this.comboBox.getItemAt(i).toString();
                if (this.PossibleValueList.get(temp).isEnable() && this.PossibleValueList.get(temp).isVisible()) {
                    defaultContent = temp;
                    break;
                }
                ++i;
            }
        }
        this.setValue(defaultContent);
        String newValue = this.getValue();
        if (!oldValue.equals(newValue)) {
            valueChangedNodesPath.add(super.getNodeFullPath(this));
        }
        return valueChangedNodesPath;
    }

    public void enableErrorMark() {
        this.nameLabel.setForeground(Color.RED);
        this.comboBox.setForeground(Color.RED);
    }

    public void disableErrorMark() {
        if (this.isEnable()) {
            this.nameLabel.setForeground(Color.BLACK);
        } else {
            this.nameLabel.setForeground(Color.GRAY);
        }
        this.comboBox.setForeground(Color.BLACK);
    }

    @Override
    public void copyToTreeNode(AbstractJTreeNode dstTreeNode) {
        super.copyToTreeNode(dstTreeNode);
        Map<String, GeneralPariParaNodeItemStruct> dstPossibleValueList = ((JTreeComboxNode)dstTreeNode).getPossibleValueList();
        dstPossibleValueList.clear();
        for (Map.Entry<String, GeneralPariParaNodeItemStruct> entry : this.PossibleValueList.entrySet()) {
            dstPossibleValueList.put(entry.getKey(), new GeneralPariParaNodeItemStruct(entry.getValue()));
        }
    }

    @Override
    public void copyToTreeNodeNoUI(AbstractJTreeNode dstTreeNode) {
        super.copyToTreeNodeNoUI(dstTreeNode);
        Map<String, GeneralPariParaNodeItemStruct> dstPossibleValueList = ((JTreeComboxNode)dstTreeNode).getPossibleValueList();
        dstPossibleValueList.clear();
        for (Map.Entry<String, GeneralPariParaNodeItemStruct> entry : this.PossibleValueList.entrySet()) {
            dstPossibleValueList.put(entry.getKey(), new GeneralPariParaNodeItemStruct(entry.getValue()));
        }
    }

    @Override
    public void setValueNoUI(String value) {
        ActionListener al;
        ActionListener[] listeners;
        this.value = value;
        ActionListener[] actionListenerArray = listeners = (ActionListener[])this.comboBox.getListeners(ActionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            al = actionListenerArray[n2];
            this.comboBox.removeActionListener(al);
            ++n2;
        }
        if (!this.comboBox.containsItem(value)) {
            this.comboBox.addItem(value);
        }
        this.comboBox.setSelectedItem(value);
        actionListenerArray = listeners;
        n = listeners.length;
        n2 = 0;
        while (n2 < n) {
            al = actionListenerArray[n2];
            this.comboBox.addActionListener(al);
            ++n2;
        }
    }

    public boolean itemIsVisible(String item) {
        boolean isVisible = false;
        for (Map.Entry<String, GeneralPariParaNodeItemStruct> entry : this.PossibleValueList.entrySet()) {
            if (!entry.getKey().equals(item)) continue;
            isVisible = entry.getValue().isVisible();
        }
        return isVisible;
    }

    public boolean itemIsEnable(String item) {
        boolean isEnable = false;
        for (Map.Entry<String, GeneralPariParaNodeItemStruct> entry : this.PossibleValueList.entrySet()) {
            if (!entry.getKey().equals(item)) continue;
            isEnable = entry.getValue().isEnable();
        }
        return isEnable;
    }
}

