/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.baseinfo.jtreenode;

import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.baseinfo.mCheckBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JTreeCheckboxNode
extends AbstractJTreeNode {
    private static final long serialVersionUID = 1L;
    private JPanel checkBoxPanel;
    private JLabel nameLabel;
    private mCheckBox checkBox;

    public JTreeCheckboxNode(String name, String content, boolean value) {
        this.InitCheckboxJTreeNode(name, content, value);
    }

    @Override
    public void setValue(String value) {
    }

    public void InitCheckboxJTreeNode(String name, String content, boolean value) {
        this.setType(1);
        this.setName(name);
        this.setContent(content);
        this.initCheckboxGUI(value);
    }

    private void initCheckboxGUI(boolean value) {
        this.checkBoxPanel = new JPanel();
        this.checkBoxPanel.setLayout(new GridLayout(1, 2));
        this.checkBoxPanel.setBackground(Color.WHITE);
        this.checkBoxPanel.setPreferredSize(new Dimension(273, 30));
        this.nameLabel = new JLabel(this.getContent());
        this.nameLabel.setToolTipText(this.getContent());
        this.checkBox = new mCheckBox();
        this.checkBox.setSelected(value);
        this.checkBox.setEnabled(true);
        this.checkBox.setBackground(Color.WHITE);
        if (GlobalVariables.isCubeRoverTest) {
            this.checkBox.setContent(this.getContent());
        }
        this.checkBoxPanel.add(this.nameLabel);
        this.checkBoxPanel.add(this.checkBox);
    }

    @Override
    public void setNodeDisable() {
        this.nameLabel.setForeground(Color.gray);
        this.checkBox.setEnabled(false);
    }

    @Override
    public void setNodeEnable() {
        this.nameLabel.setForeground(Color.BLACK);
        this.checkBox.setEnabled(true);
    }

    @Override
    public Component getLabelView() {
        return this.nameLabel;
    }

    public Component getCheckboxView() {
        return this.checkBoxPanel;
    }

    public mCheckBox getJCheckBox() {
        return this.checkBox;
    }

    @Override
    public void setSize(int width, int height) {
        this.checkBoxPanel.setPreferredSize(new Dimension(width, 30));
        this.nameLabel.setBounds(30, 0, width / 3, 30);
        this.checkBox.setBounds(width / 2, 0, width / 3, 30);
    }

    @Override
    public List<String> updateValueToDefaultValue() {
        ArrayList<String> valueChangedNodesPath = new ArrayList<String>();
        return valueChangedNodesPath;
    }

    @Override
    public void setValueNoUI(String value) {
        this.value = value;
    }
}

