/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.baseinfo.jtreenode;

import com.gigadevice.venustool.periconfigbasestruct.GeneralPariParaNodeFunctionStruct;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class AbstractJTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private int type = 0;
    private String name = "";
    private String content = "";
    public String value = "";
    private String defaultValue = "";
    private boolean errorLabel = false;
    private boolean enable = true;
    private boolean visible = true;
    private boolean hasFunction = false;
    private GeneralPariParaNodeFunctionStruct Funtion = new GeneralPariParaNodeFunctionStruct();
    public JLabel nameLabel;
    private int state = 0;
    private String baseMessage = "";
    private String updateMessage = "";
    private String addMessage = "";
    private String Tips = "";
    private boolean isInitState = true;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isEnable() {
        return (this.state & 1) == 0;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
        this.state = enable ? (this.state &= 0xFFFFFFFE) : (this.state |= 1);
    }

    public boolean isVisible() {
        return (this.state >> 1 & 1) == 0;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.state = visible ? (this.state &= 0xFFFFFFFD) : (this.state |= 2);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean ifHasFunction() {
        return this.hasFunction;
    }

    public void setHasFunction(boolean hasFunction) {
        this.hasFunction = hasFunction;
    }

    public GeneralPariParaNodeFunctionStruct getFuntion() {
        return this.Funtion;
    }

    public void setFuntion(GeneralPariParaNodeFunctionStruct funtion) {
        this.Funtion = funtion;
    }

    public Component getLabelView() {
        return this.nameLabel;
    }

    public abstract void setSize(int var1, int var2);

    public abstract void setValue(String var1);

    public abstract void setValueNoUI(String var1);

    public abstract void setNodeDisable();

    public abstract void setNodeEnable();

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        this.visible = (state >> 1 & 1) == 0;
        this.enable = (state & 1) == 0;
    }

    public abstract List<String> updateValueToDefaultValue();

    public static void traverseTree(DefaultMutableTreeNode node, int width) {
        if (!node.isLeaf()) {
            int i = 0;
            while (i < node.getChildCount()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                AbstractJTreeNode JTreeNode = (AbstractJTreeNode)childNode;
                if (JTreeNode.getType() == 4) {
                    try {
                        Component view = (Component)JTreeNode.getClass().getMethod("getComboxView", new Class[0]).invoke((Object)JTreeNode, new Object[0]);
                        Dimension d = new Dimension(width, 30);
                        view.setMinimumSize(new Dimension(100, 30));
                        view.setPreferredSize(d);
                        view.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
                    }
                    catch (Exception exception) {
                        JTreeNode.setSize(width, 30);
                    }
                } else {
                    JTreeNode.setSize(width, 30);
                }
                AbstractJTreeNode.traverseTree(childNode, width);
                ++i;
            }
        }
    }

    public boolean isError() {
        return this.errorLabel;
    }

    public void setError(boolean isError) {
        this.errorLabel = isError;
    }

    public void setBaseMessage(String baseMessage) {
        this.baseMessage = baseMessage;
    }

    public void setUpdateMessage(String updateMessage) {
        this.updateMessage = updateMessage;
    }

    public void setAddMessage(String addMessage) {
        this.addMessage = addMessage;
    }

    public String getAllMessage() {
        String message = String.valueOf(this.baseMessage) + System.lineSeparator() + this.updateMessage + System.getProperty("line.separator") + this.addMessage;
        message = message.replaceAll("(\r\n|\n|\r){2,}", System.lineSeparator());
        return message;
    }

    public void initMessage() {
        String baseMessage = this.getContent();
        if (!this.Tips.equals("")) {
            baseMessage = String.valueOf(baseMessage) + System.lineSeparator() + this.getTips();
        }
        this.setBaseMessage(baseMessage);
    }

    public String getTips() {
        return this.Tips;
    }

    public void setTips(String tips) {
        this.Tips = tips;
    }

    public void copyToTreeNode(AbstractJTreeNode dstTreeNode) {
        dstTreeNode.setValue(this.value);
        dstTreeNode.setDefaultValue(this.defaultValue);
        dstTreeNode.setVisible(this.visible);
        dstTreeNode.setError(this.errorLabel);
        dstTreeNode.setEnable(this.enable);
        dstTreeNode.setTips(this.Tips);
        dstTreeNode.setBaseMessage(this.baseMessage);
        dstTreeNode.setAddMessage(this.addMessage);
        dstTreeNode.setUpdateMessage(this.updateMessage);
        dstTreeNode.initMessage();
        dstTreeNode.setInitState(this.isInitState);
    }

    public void copyToTreeNodeNoUI(AbstractJTreeNode dstTreeNode) {
        dstTreeNode.setValueNoUI(this.value);
        dstTreeNode.setDefaultValue(this.defaultValue);
        dstTreeNode.setVisible(this.visible);
        dstTreeNode.setError(this.errorLabel);
        dstTreeNode.setEnable(this.enable);
        dstTreeNode.setTips(this.Tips);
        dstTreeNode.setBaseMessage(this.baseMessage);
        dstTreeNode.setAddMessage(this.addMessage);
        dstTreeNode.setUpdateMessage(this.updateMessage);
        dstTreeNode.initMessage();
        dstTreeNode.setInitState(this.isInitState);
    }

    public boolean isInitState() {
        return this.isInitState;
    }

    public void setInitState(boolean isInitState) {
        this.isInitState = isInitState;
    }

    public String getNodeFullPath(AbstractJTreeNode node) {
        if (node == null) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        this.buildNodePath(node, path);
        return path.toString();
    }

    private void buildNodePath(AbstractJTreeNode node, StringBuilder path) {
        AbstractJTreeNode parent = (AbstractJTreeNode)node.getParent();
        if (parent != null) {
            this.buildNodePath(parent, path);
            path.append("##");
        }
        path.append(node.getName());
    }

    @Override
    public String toString() {
        return this.name;
    }
}

