/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.baseinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PerisTreeStruct {
    private Object data = null;
    private String name;
    private boolean parent;
    private PerisTreeStruct parentNode;
    private List<PerisTreeStruct> childs;
    private Map<String, String> info;
    private List<String> lstFunction;
    private String action;
    private boolean itemFlag;

    public PerisTreeStruct() {
        this.name = null;
        this.parent = false;
        this.parentNode = null;
        this.itemFlag = false;
        this.childs = new ArrayList<PerisTreeStruct>();
        this.childs.clear();
        this.info = new HashMap<String, String>();
        this.info.clear();
        this.lstFunction = new ArrayList<String>();
        this.lstFunction.clear();
        this.action = "";
    }

    public PerisTreeStruct(String name) {
        this.name = name;
        this.parent = false;
        this.parentNode = null;
        this.itemFlag = false;
        this.childs = new ArrayList<PerisTreeStruct>();
        this.childs.clear();
        this.info = new HashMap<String, String>();
        this.info.clear();
        this.lstFunction = new ArrayList<String>();
        this.lstFunction.clear();
        this.action = "";
    }

    public void addChildNode(PerisTreeStruct tree) {
        this.childs.add(tree);
    }

    public void clearTree() {
        this.data = null;
        this.childs.clear();
    }

    public int dept() {
        return this.dept(this);
    }

    private int dept(PerisTreeStruct tree) {
        if (tree.isEmpty()) {
            return 0;
        }
        if (tree.isLeaf()) {
            return 1;
        }
        int n = this.childs.size();
        int[] a = new int[n];
        int i = 0;
        while (i < n) {
            a[i] = this.childs.get(i).isEmpty() ? 1 : this.dept(this.childs.get(i)) + 1;
            ++i;
        }
        Arrays.sort(a);
        return a[n - 1];
    }

    public PerisTreeStruct getChild(int i) {
        return this.childs.get(i);
    }

    public PerisTreeStruct getChild(String name) {
        PerisTreeStruct t = null;
        if (name.contains("##")) {
            int tmp = name.lastIndexOf("##");
            name = name.substring(tmp + 2, name.length());
        }
        int n = this.childs.size();
        int i = 0;
        while (i < n) {
            PerisTreeStruct tchild = this.childs.get(i);
            String childName = tchild.getName();
            if (name.equals(childName)) {
                return tchild;
            }
            ++i;
        }
        return t;
    }

    public PerisTreeStruct getFirstChild() {
        return this.childs.get(0);
    }

    public PerisTreeStruct getLastChild() {
        return this.childs.get(this.childs.size() - 1);
    }

    public List<PerisTreeStruct> getChilds() {
        return this.childs;
    }

    public boolean isEmpty() {
        return this.childs.isEmpty() && this.data == null;
    }

    public boolean isLeaf() {
        return this.childs.isEmpty();
    }

    public PerisTreeStruct root() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean getParentAttribute() {
        return this.parent;
    }

    public void setParentAttribute(boolean bl) {
        this.parent = bl;
    }

    public PerisTreeStruct getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(PerisTreeStruct node) {
        this.parentNode = node;
    }

    public boolean getItemFlag() {
        return this.itemFlag;
    }

    public void setItemFlag(boolean bl) {
        this.itemFlag = bl;
    }

    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, String> info) {
        this.info = info;
        if (info.containsKey("Function")) {
            String strFunction = info.get("Function");
            StringTokenizer st = new StringTokenizer(strFunction, ",");
            while (st.hasMoreTokens()) {
                this.lstFunction.add(st.nextToken());
            }
        }
        if (info.containsKey("Action")) {
            this.action = info.get("Action");
        }
    }

    public List<String> getFunction() {
        return this.lstFunction;
    }

    public void setFunction(List<String> lstFunction) {
        this.lstFunction = lstFunction;
    }

    public void setAction(String strAction) {
        this.action = strAction;
    }

    public String getAction() {
        return this.action;
    }

    public int size() {
        return this.size(this);
    }

    private int size(PerisTreeStruct tree) {
        if (tree.isEmpty()) {
            return 0;
        }
        if (tree.isLeaf()) {
            return 1;
        }
        int count = 1;
        int n = this.childs.size();
        int i = 0;
        while (i < n) {
            if (!this.childs.get(i).isEmpty()) {
                count += this.size(this.childs.get(i));
            }
            ++i;
        }
        return count;
    }
}

