/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.baseinfo;

import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.PinFunctionStruct;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GD32PinPad
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int PinIndex = 0;
    private String PinNumberStr = "";
    private String PinName = "";
    private String DisplayName = "";
    private int PinType = 0;
    private String PinTypeStr;
    private String PinIOLevel = "";
    private int PinFunctionCount = 0;
    private String PinUsedFunctionStr = "";
    private String RemapAF_Value = "";
    private int PinUsedType = 0;
    private String PinUsedPeri = "";
    private int GPIOModel = 0;
    private String PinAllUsedFunction = "";
    private List<GD32PinPad> ChildGD32PinPads;
    private List<GD32PinPad> RemapPins;
    private List<PinFunctionStruct> PinFunctionList = new ArrayList<PinFunctionStruct>();
    private String reSharedPin = "";
    private String reUsedSharedPin = "";
    private boolean isSharedPin = false;
    private boolean isLockPin;
    private String PinNameOrigin;
    private boolean isDisablePin;
    private String PinUseLabel;

    public GD32PinPad() {
        this.ChildGD32PinPads = new ArrayList<GD32PinPad>();
        this.RemapPins = new ArrayList<GD32PinPad>();
        this.setPinUseLabel("");
        this.setLockPin(false);
        this.setDisablePin(false);
    }

    public String getPinUsedPeri() {
        return this.PinUsedPeri;
    }

    public void putPinUsedPeri(String pinUsedPeri) {
        this.PinUsedPeri = pinUsedPeri;
    }

    public void putPinIndex(int PinIndex) {
        this.PinIndex = PinIndex;
    }

    public int getPinIndex() {
        return this.PinIndex;
    }

    public void putPinNumberStr(String PinNumberStr) {
        this.PinNumberStr = PinNumberStr;
    }

    public String getPinNumberStr() {
        return this.PinNumberStr;
    }

    public void putPinName(String PinName) {
        String suffix;
        this.PinName = PinName;
        if (PinName.length() > 2 && (suffix = PinName.substring(PinName.length() - 2)).equals("_C")) {
            String sharePinName = PinName.replace("_C", "");
            this.setAttrValue("SharedPin", sharePinName);
        }
    }

    public String getPinName() {
        return this.PinName;
    }

    public void putPinType(int PinType) {
        this.PinType = PinType;
    }

    public int getPinType() {
        return this.PinType;
    }

    public void putPinIOLevel(String PinIOLevel) {
        this.PinIOLevel = PinIOLevel;
    }

    public String getPinIOLevel() {
        return this.PinIOLevel;
    }

    public void putPinUsedType(int PinUsedType) {
        this.PinUsedType = PinUsedType;
    }

    public int getPinUsedType() {
        return this.PinUsedType;
    }

    public void putPinUsedFunctionStr(String PinUsedFunctionStr) {
        this.PinUsedFunctionStr = PinUsedFunctionStr;
    }

    public String getPinUsedFunctionStr() {
        return this.PinUsedFunctionStr;
    }

    public void putRemapAF_Value(String RemapAF_Value) {
        this.RemapAF_Value = RemapAF_Value;
    }

    public String getRemapAF_Value() {
        return this.RemapAF_Value;
    }

    public void putPinFunctionCount(int PinFunctionCount) {
        this.PinFunctionCount = PinFunctionCount;
    }

    public int getPinFunctionCount() {
        return this.PinFunctionCount;
    }

    public void putPinFunctionList(String FunctionType, String PinFunctionStr) {
        if (PinFunctionStr.isEmpty()) {
            return;
        }
        String[] PinFunctionUnitList = PinFunctionStr.split(",");
        this.PinFunctionCount += PinFunctionUnitList.length;
        int i = 0;
        while (i < PinFunctionUnitList.length) {
            PinFunctionStruct pinFunctionStruct = new PinFunctionStruct();
            pinFunctionStruct.putPinFunctionName(PinFunctionUnitList[i]);
            pinFunctionStruct.putPinFunctionType(FunctionType);
            this.PinFunctionList.add(pinFunctionStruct);
            ++i;
        }
    }

    public List<PinFunctionStruct> getPinFunctionList() {
        return this.PinFunctionList;
    }

    public Boolean isEqual(GD32PinPad obj) {
        if (obj.getPinIndex() >= 0 && obj.getPinIndex() == this.getPinIndex()) {
            return true;
        }
        return false;
    }

    public void equalTo(GD32PinPad obj) {
        obj.PinFunctionCount = this.PinFunctionCount;
        obj.PinIndex = this.PinIndex;
        obj.PinName = this.PinName;
        obj.PinIOLevel = this.PinIOLevel;
        obj.PinNumberStr = this.PinNumberStr;
        obj.PinType = this.PinType;
        obj.PinUsedFunctionStr = this.PinUsedFunctionStr;
        obj.PinUsedPeri = this.PinUsedPeri;
        obj.RemapAF_Value = this.RemapAF_Value;
        obj.PinUsedType = this.PinUsedType;
    }

    public Boolean isLessThan(GD32PinPad obj) {
        if (obj.getPinIndex() < this.getPinIndex()) {
            return true;
        }
        return false;
    }

    public void setAttrValue(String key, String Value) {
        switch (key) {
            case "Name": {
                this.putPinName(Value);
                this.setPinNameOrigin(Value);
                break;
            }
            case "DisplayName": {
                this.setDisplayName(Value);
                break;
            }
            case "Type": {
                if (Value.equals("I/O")) {
                    this.putPinType(0);
                } else {
                    this.putPinType(1);
                }
                this.setPinTypeStr(Value);
                break;
            }
            case "I_O_Level": {
                this.putPinIOLevel(Value);
                break;
            }
            case "Alternate2Functions": 
            case "Alternate1Functions": 
            case "AlternateFunctions": 
            case "MainFunction": 
            case "AdditionalFunctions": 
            case "RemapFunctions": {
                this.putPinFunctionList(key, Value);
                break;
            }
            case "SharedPin": {
                this.setReSharedPin(Value);
                this.setSharedPin(true);
            }
        }
    }

    public List<String> getAnalogModeFunctionInPin() {
        ArrayList<String> analogPins = new ArrayList<String>();
        int j = 0;
        while (j < this.PinFunctionList.size()) {
            String functionName = this.PinFunctionList.get(j).getPinFunctionName();
            if (!functionName.equals(this.PinUsedFunctionStr)) {
                for (String analogPin : GlobalVariables.AnalogModePins) {
                    if (!functionName.contains(analogPin)) continue;
                    analogPins.add(functionName);
                }
            }
            ++j;
        }
        return analogPins;
    }

    public int getGPIOModel() {
        return this.GPIOModel;
    }

    public void setGPIOModel(int gPIOModel) {
        this.GPIOModel = gPIOModel;
    }

    public String getPinAllUsedFunction() {
        return this.PinAllUsedFunction;
    }

    public void setPinAllUsedFunction(String pinAllUsedFunction) {
        this.PinAllUsedFunction = pinAllUsedFunction;
    }

    public List<GD32PinPad> getChildGD32PinPads() {
        return this.ChildGD32PinPads;
    }

    public void setChildGD32PinPads(List<GD32PinPad> childGD32PinPads) {
        this.ChildGD32PinPads = childGD32PinPads;
    }

    public void addChildGD32PinPad(GD32PinPad childGD32PinPad) {
        for (GD32PinPad child : this.ChildGD32PinPads) {
            if (!childGD32PinPad.getPinUsedFunctionStr().equals(child.getPinUsedFunctionStr()) || !childGD32PinPad.getPinUsedPeri().equals(child.getPinUsedPeri())) continue;
            return;
        }
        this.ChildGD32PinPads.add(childGD32PinPad);
    }

    public GD32PinPad getChildGD32PinPadByFunction(String functionName, String PeriName) {
        for (GD32PinPad child : this.ChildGD32PinPads) {
            if (!child.getPinUsedFunctionStr().equals(functionName)) continue;
            if (!PeriName.equals("")) {
                if (!child.getPinUsedPeri().equals(PeriName)) continue;
                return child;
            }
            return child;
        }
        return null;
    }

    public void removeChildGD32PinPadByFunction(String functionName, String PeriName) {
        for (GD32PinPad child : this.ChildGD32PinPads) {
            if (!child.getPinUsedFunctionStr().equals(functionName)) continue;
            if (PeriName.equals("")) {
                this.ChildGD32PinPads.remove(child);
                return;
            }
            if (!child.getPinUsedPeri().equals(PeriName)) continue;
            this.ChildGD32PinPads.remove(child);
            return;
        }
    }

    public void updateGD32PinPadInfo() {
        if (this.GPIOModel != 1 && this.GPIOModel != 2) {
            return;
        }
        if (this.ChildGD32PinPads.size() == 0) {
            this.GPIOModel = 0;
            this.putPinUsedFunctionStr("");
            this.putRemapAF_Value("");
            this.putPinUsedType(0);
            this.putPinUsedPeri("");
            return;
        }
        this.putPinUsedType(0);
        String functionStr = "";
        for (GD32PinPad child : this.ChildGD32PinPads) {
            if (!functionStr.contains(child.getPinUsedFunctionStr())) {
                functionStr = String.valueOf(functionStr) + child.getPinUsedFunctionStr() + ",";
            }
            if (this.PinUsedType < child.PinUsedType) {
                this.putPinUsedType(child.PinUsedType);
            }
            this.putRemapAF_Value(child.RemapAF_Value);
            this.putPinUsedPeri(child.getPinUsedPeri());
        }
        functionStr = functionStr.substring(0, functionStr.length() - 1);
        this.putPinUsedFunctionStr(functionStr);
    }

    public boolean checkFunctionUsedInGD32PinPad(String functionName) {
        if (!this.PinUsedFunctionStr.contains(",")) {
            if (this.PinUsedFunctionStr.equals(functionName)) {
                return true;
            }
        } else {
            String[] functionList = this.PinUsedFunctionStr.split(",");
            int i = 0;
            while (i < functionList.length) {
                if (functionList[i].equals(functionName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean checkFunctionExistInGD32PinPad(String functionName) {
        int i = 0;
        while (i < this.PinFunctionList.size()) {
            if (this.PinFunctionList.get(i).getPinFunctionName().equals(functionName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getReSharedPin() {
        return this.reSharedPin;
    }

    public void setReSharedPin(String reSharedPin) {
        this.reSharedPin = reSharedPin;
    }

    public boolean isSharedPin() {
        return this.isSharedPin;
    }

    public void setSharedPin(boolean isSharedPin) {
        this.isSharedPin = isSharedPin;
    }

    public String getReUsedSharedPin() {
        return this.reUsedSharedPin;
    }

    public void setReUsedSharedPin(String reUsedSharedPin) {
        this.reUsedSharedPin = reUsedSharedPin;
    }

    public String getPinTypeStr() {
        return this.PinTypeStr;
    }

    public void setPinTypeStr(String pinTypeStr) {
        this.PinTypeStr = pinTypeStr;
    }

    public List<GD32PinPad> getRemapPins() {
        return this.RemapPins;
    }

    public void setRemapPins(List<GD32PinPad> remapPins) {
        this.RemapPins = remapPins;
    }

    public void addRemapPin(GD32PinPad pinObj) {
        this.RemapPins.add(pinObj);
    }

    public void updatePinInfoByRemap(String PinNameStr) {
        int j = 0;
        while (j < this.RemapPins.size()) {
            GD32PinPad pinObj = this.RemapPins.get(j);
            if (pinObj.getPinName().equals(PinNameStr)) {
                this.PinName = PinNameStr;
                this.PinFunctionList.clear();
                this.PinFunctionList.addAll(pinObj.getPinFunctionList());
            }
            ++j;
        }
    }

    public boolean isLockPin() {
        return this.isLockPin;
    }

    public void setLockPin(boolean isLockPin) {
        this.isLockPin = isLockPin;
    }

    public boolean isDisablePin() {
        return this.isDisablePin;
    }

    public void setDisablePin(boolean isDisablePin) {
        this.isDisablePin = isDisablePin;
    }

    public String getPinNameOrigin() {
        return this.PinNameOrigin;
    }

    public void setPinNameOrigin(String pinNameOrigin) {
        this.PinNameOrigin = pinNameOrigin;
    }

    public String getPinUseLabel() {
        return this.PinUseLabel;
    }

    public void setPinUseLabel(String pinUseLabel) {
        this.PinUseLabel = pinUseLabel;
    }

    public String getDisplayName() {
        return this.DisplayName;
    }

    public void setDisplayName(String displayName) {
        this.DisplayName = displayName;
    }
}

