/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.adapter;

import com.gigadevice.venustool.GeneralPathUtil;
import java.io.File;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class JLinkInfoUtils {
    private static final String XML_MCUGROUP = "MCUSubGroup";
    private static final String XML_MCUPART = "MCUPart";
    private static final String ATTRIBUTES_NAME = "Name";
    private static final String ATTRIBUTES_JLinkName = "JLinkName";
    private static final String ATTRIBUTES_Length = "Length";

    public static String getJLinkPartNum(String mcuPart) {
        String filePath = String.valueOf(GeneralPathUtil.getResourcePath()) + File.separator + "JLink" + File.separator + "GDJlinkPartNum.xml";
        String newPartNum = mcuPart;
        if (filePath.isEmpty()) {
            return newPartNum;
        }
        SAXReader saxReader = new SAXReader();
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                return newPartNum;
            }
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            List groupNodeList = rootElm.elements(XML_MCUGROUP);
            block2: for (Element groupObj : groupNodeList) {
                String groupName = groupObj.attributeValue(ATTRIBUTES_NAME);
                if (groupName == null || !mcuPart.contains(groupName)) continue;
                List mcuPartNodeList = groupObj.elements(XML_MCUPART);
                for (Element mcuPartObj : mcuPartNodeList) {
                    String mcuPartName = mcuPartObj.attributeValue(ATTRIBUTES_NAME);
                    if (mcuPartName == null || !mcuPart.contains(mcuPartName)) continue;
                    String nameLength = mcuPartObj.attributeValue(ATTRIBUTES_Length);
                    String jLinkName = mcuPartObj.attributeValue(ATTRIBUTES_JLinkName);
                    if (nameLength != null && !nameLength.equals("")) {
                        int length = Integer.valueOf(nameLength);
                        jLinkName = mcuPart.substring(0, length);
                    }
                    newPartNum = jLinkName;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newPartNum;
    }
}

