/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target.gdconfigui;

import com.gigadevice.gdconfig.ui.access.SerializeAccess_Template;
import com.gigadevice.gdconfig.ui.utils.ProjectConfigUtil;
import com.gigadevice.templates.target.Messages;
import com.gigadevice.templates.target.gdconfigui.GDProjectBrowsegdcFile;
import com.gigadevice.venustool.GlobalVariables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;

public class GDProjectgdcFileWizard
extends Wizard
implements INewWizard {
    private GDProjectBrowsegdcFile<?> browsegdcFilePage;
    private IWorkbench workbench;

    public GDProjectgdcFileWizard() {
        this.setWindowTitle(Messages.wizard_gdcfile_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.browsegdcFilePage = new GDProjectBrowsegdcFile();
        this.addPage((IWizardPage)this.browsegdcFilePage);
    }

    public boolean performFinish() {
        this.closeExistingGdcEditors();
        String sourceGdcFilePath = this.browsegdcFilePage.getSourceFilePath();
        if (sourceGdcFilePath == null || sourceGdcFilePath.isEmpty()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dialog_error_title, (String)Messages.error_nogdcfile);
            return false;
        }
        File gdcFile = new File(sourceGdcFilePath);
        if (!gdcFile.exists()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dialog_error_title, (String)Messages.error_gdcfile_notexist);
            return false;
        }
        String sourceFileName = this.getFileNameWithoutExtension(gdcFile.getName());
        String projectName = this.browsegdcFilePage.getProjectName();
        boolean isProjectNameModified = !projectName.equals(sourceFileName);
        try {
            if (isProjectNameModified) {
                return this.createNewProjectWithCopiedFile(projectName, gdcFile);
            }
            return this.createLinkedProject();
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Failed to create project: " + e.getMessage()));
            return false;
        }
    }

    private boolean createLinkedProject() {
        String externalDirectoryPath = this.browsegdcFilePage.getSelectedFilePath();
        if (externalDirectoryPath == null || externalDirectoryPath.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.dialog_error_title, (String)Messages.error_nodirectory);
            return false;
        }
        File externalDirectory = new File(externalDirectoryPath);
        if (!externalDirectory.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.dialog_error_title, (String)Messages.error_directory_notexist);
            return false;
        }
        File[] gdcFiles = externalDirectory.listFiles((dir, name) -> name.endsWith(".gdc"));
        if (gdcFiles == null || gdcFiles.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.dialog_error_title, (String)Messages.error_nogdcfile_indirectory);
            return false;
        }
        File gdcFile = gdcFiles[0];
        String projectName = externalDirectory.getName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        Path locationPath = new Path(externalDirectory.getAbsolutePath());
        description.setLocation((IPath)locationPath);
        try {
            if (!project.exists()) {
                project.create(description, null);
            }
            project.open(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.dialog_error_title, (String)Messages.error_project_createfailed);
            return false;
        }
        IFile linkedFile = project.getFile(gdcFile.getName());
        IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (linkedFile.exists()) {
            try {
                IDE.openEditor((IWorkbenchPage)wbPage, (IFile)linkedFile);
                try {
                    Class<?> introPluginClass = Class.forName("org.eclipse.ui.internal.intro.impl.IntroPlugin");
                    Method closeIntroMethod = introPluginClass.getMethod("closeIntro", new Class[0]);
                    closeIntroMethod.invoke(null, new Object[0]);
                }
                catch (Exception exception) {}
            }
            catch (PartInitException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.dialog_error_title, (String)Messages.error_gdcfile_openfailed);
                return false;
            }
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.dialog_warning_title, (String)Messages.error_gdcfile_notfound);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createNewProjectWithCopiedFile(String projectName, File sourceGdcFile) throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            Object[] options = new Object[]{"OK"};
            JOptionPane.showOptionDialog(null, Messages.error_project_alreadyexists, Messages.dialog_message_title, -1, -1, null, options, options[0]);
            return false;
        }
        try {
            String customLocation = this.browsegdcFilePage.getProjectLocation();
            IProjectDescription description = workspace.newProjectDescription(projectName);
            if (customLocation != null && !customLocation.isEmpty()) {
                boolean created;
                String projectFolderPath;
                File projectFolder;
                if (!customLocation.endsWith(File.separator)) {
                    customLocation = String.valueOf(customLocation) + File.separator;
                }
                if (!(projectFolder = new File(projectFolderPath = String.valueOf(customLocation) + projectName)).exists() && !(created = projectFolder.mkdirs())) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dialog_error_title, (String)NLS.bind((String)Messages.error_directory_createfailed, (Object)projectFolderPath));
                    return false;
                }
                Path locationPath = new Path(projectFolderPath);
                description.setLocation((IPath)locationPath);
            }
            project.create(description, null);
            project.open(null);
            String projectPath = project.getLocation().toOSString();
            String newGdcFileName = String.valueOf(projectName) + ".gdc";
            File targetGdcFile = new File(projectPath, newGdcFileName);
            byte[] fileContent = this.readFileToByteArray(sourceGdcFile);
            this.writeByteArrayToFile(targetGdcFile, fileContent);
            project.refreshLocal(2, null);
            GlobalVariables.isInitProject = false;
            GlobalVariables.ProjectName = projectName;
            byte[] savedContent = this.readFileToByteArray(targetGdcFile);
            ProjectConfigUtil.InitAllGlobalVars();
            IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IFile file = project.getFile(newGdcFileName);
            this.writeByteArrayToFile(targetGdcFile, savedContent);
            project.refreshLocal(2, null);
            try {
                if (file == null) return true;
                IDE.openEditor((IWorkbenchPage)wbPage, (IFile)file);
                IntroPlugin.closeIntro();
                return true;
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dialog_error_title, (String)NLS.bind((String)Messages.error_project_createerror, (Object)e.getMessage()));
            return false;
        }
    }

    private byte[] readFileToByteArray(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] data = new byte[(int)file.length()];
            fis.read(data);
            return data;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeByteArrayToFile(File file, byte[] data) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data);
            fos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void openGdcFileInEditor(IProject project, IFile gdcFile) {
        if (gdcFile.exists()) {
            try {
                IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IDE.openEditor((IWorkbenchPage)wbPage, (IFile)gdcFile);
                IntroPlugin.closeIntro();
            }
            catch (PartInitException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dialog_error_title, (String)Messages.error_gdcfile_openfailed);
            }
        } else {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.dialog_warning_title, (String)Messages.warning_gdcfile_notfound);
        }
    }

    private void initializeProjectConfiguration(String projectName) {
        GlobalVariables.isInitProject = true;
        ProjectConfigUtil.ClearAllGlobalVars();
        GlobalVariables.ProjectName = projectName;
        ProjectConfigUtil.InitAllGlobalVars();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        SerializeAccess_Template.SerializeSave((IProject)project);
    }

    private void closeExistingGdcEditors() {
        Display.getDefault().syncExec(() -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                IEditorReference[] editorRefs = page.getEditorReferences();
                ArrayList<IEditorReference> gdcEditors = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = editorRefs;
                int n = editorRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    try {
                        if (ref.getEditorInput().getName().toLowerCase().endsWith(".gdc")) {
                            gdcEditors.add(ref);
                        }
                    }
                    catch (PartInitException partInitException) {}
                    ++n2;
                }
                if (!gdcEditors.isEmpty()) {
                    IEditorReference[] gdcEditorsArray = gdcEditors.toArray(new IEditorReference[gdcEditors.size()]);
                    page.closeEditors(gdcEditorsArray, true);
                }
            }
        });
    }

    private String getFileNameWithoutExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, dotIndex);
    }

    public void open() {
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)this);
        dialog.setPageSize(800, 400);
        dialog.open();
    }
}

