/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.clockconfigview.utils;

import com.gigadevice.clockconfigview.info.CommonPrivilege;
import com.gigadevice.clockconfigview.info.RelateControlType;
import com.gigadevice.conflict.NewConflictCheck;
import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ExpressionEvaluationInfo;
import com.gigadevice.conflict.baseinfo.ExtendFunctionNodeInfo;
import com.gigadevice.conflict.baseinfo.NewRelationGroup;
import com.gigadevice.conflict.baseinfo.ParamNodeInfo;
import com.gigadevice.conflict.reflectionfunction.InvokeReflectionFunc;
import com.gigadevice.conflict.tool.CalculatorFunctions;
import com.gigadevice.conflict.tool.ParamNodeWork;
import com.gigadevice.conflict.tool.Privilege2Sentences;
import com.gigadevice.conflict.xmlparse.NewConditionXmlParse;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.clockconfiginfo.RCUCondition;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigControl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RCURelateUtil {
    public static String RCUFilePath;
    public static Map<String, RelateControlType> RelateControlMap;
    private static String ControlType_Control;
    private static String ControlType_EnumValue;
    private static String ControlType_ClockSource;
    private static String ControlType_ControlGroup;
    private static String ControlType_ControlinGroup;
    private static String ControlType_ControlEnumValue;
    private static String PrivilegeName_Enable;
    private static String PrivilegeName_Update;
    private static String PrivilegeName_SetMinMax;
    private static String PrivilegeName_UpdateSelected;
    private static String Step_BeforeLoad;
    public static final String CONFLICT_OPERTYPE_COMMON = "";
    public static final String CONFLICT_OPERTYPE_FUNCTION = "F";
    public static final String CONFLICT_OPERTYPE_EXPRESSION = "E";

    static {
        RelateControlMap = new HashMap<String, RelateControlType>();
        ControlType_Control = "CONTROL";
        ControlType_EnumValue = "ENUMVALUE";
        ControlType_ClockSource = "CLOCKSOURCE";
        ControlType_ControlGroup = "CONTROLGROUP";
        ControlType_ControlinGroup = "CONTROLINGROUP";
        ControlType_ControlEnumValue = "CONTROL_ENUMVALUE";
        PrivilegeName_Enable = "ENABLE";
        PrivilegeName_Update = "UPDATE";
        PrivilegeName_SetMinMax = "SETMINMAX";
        PrivilegeName_UpdateSelected = "UPDATESELECTED";
        Step_BeforeLoad = "1";
    }

    public static boolean InitRCUConditionFile() {
        RelateControlMap.clear();
        RCUFilePath = String.valueOf(GeneralPathUtil.ResourcePath) + GlobalVariables.McuSeletorInfo.getRCUPath();
        if (RCUFilePath.lastIndexOf(".xml") > -1) {
            RCUFilePath = RCUFilePath.replace(".xml", "_add.xml");
        }
        Element rootElement = null;
        SAXReader reader = new SAXReader();
        File file = new File(RCUFilePath);
        if (!file.exists()) {
            return false;
        }
        Document document = null;
        try {
            document = reader.read(file);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        if (document == null) {
            return false;
        }
        rootElement = document.getRootElement();
        Element ControlsEle = rootElement.element("Controls");
        Iterator It = ControlsEle.elementIterator();
        while (It.hasNext()) {
            Element ControlEle = (Element)It.next();
            if (!ControlEle.getName().equals("Control")) continue;
            RelateControlType RelateControlObj = new RelateControlType();
            Attribute Name = ControlEle.attribute("Name");
            Attribute Type2 = ControlEle.attribute("Type");
            Attribute OperType = ControlEle.attribute("OperType");
            if (Name == null || Type2 == null) continue;
            RelateControlObj.setType(Type2.getValue());
            if (OperType != null) {
                RelateControlObj.setOperType(OperType.getValue());
            }
            String ControlType = CONFLICT_OPERTYPE_COMMON;
            ControlEle.element("EnumValue");
            if (ControlEle.element("EnumValue") != null) {
                ControlType = "EnumValue";
                RCURelateUtil.ParseEnumValueNode(ControlEle, RelateControlObj);
            } else if (ControlEle.element("ExtendNode") != null) {
                ControlType = "ExtendNode";
                List ExtendNodeList = ControlEle.elements("ExtendNode");
                RCURelateUtil.ParseExtendNode(RelateControlObj, ExtendNodeList);
            } else {
                List<CommonPrivilege> CommonPrivilegeList = RCURelateUtil.ParsePrivilegeListNode(ControlEle);
                RelateControlObj.setCommonPrivilegeList(CommonPrivilegeList);
            }
            String NameStr = Name.getValue();
            if (RelateControlMap.containsKey(NameStr)) {
                RelateControlType relateControlTypeTemp;
                if (ControlType.equals("EnumValue")) {
                    relateControlTypeTemp = RelateControlMap.get(NameStr);
                    if (relateControlTypeTemp == null) continue;
                    Map<String, CommonPrivilege> mapOld = relateControlTypeTemp.getEnumValueMap();
                    Map<String, CommonPrivilege> mapNewAdd = RelateControlObj.getEnumValueMap();
                    mapOld.putAll(mapNewAdd);
                    relateControlTypeTemp.setEnumValueMap(mapOld);
                    if (relateControlTypeTemp.getType() != null && relateControlTypeTemp.getType().equals("Control")) {
                        relateControlTypeTemp.setType("Control_EnumValue");
                    }
                    RelateControlMap.put(NameStr, relateControlTypeTemp);
                    continue;
                }
                if (ControlType.equals("ExtendNode")) {
                    relateControlTypeTemp = RelateControlMap.get(NameStr);
                    if (relateControlTypeTemp == null) continue;
                    Map<String, ExpressionEvaluationInfo> ExpressionEvaluationNodeMapAddNew = RelateControlObj.getExpressionEvaluationNodeMap();
                    Map<String, ExtendFunctionNodeInfo> FunctionNodeMapAddNew = RelateControlObj.getFunctionNodeMap();
                    relateControlTypeTemp.setExpressionEvaluationNodeMap(ExpressionEvaluationNodeMapAddNew);
                    relateControlTypeTemp.setFunctionNodeMap(FunctionNodeMapAddNew);
                    RelateControlMap.put(NameStr, relateControlTypeTemp);
                    continue;
                }
                relateControlTypeTemp = RelateControlMap.get(NameStr);
                if (relateControlTypeTemp == null) continue;
                if (relateControlTypeTemp.getType() != null && relateControlTypeTemp.getType().equals("EnumValue")) {
                    relateControlTypeTemp.setType("Control_EnumValue");
                }
                List<CommonPrivilege> CommonPrivilegeList = RCURelateUtil.ParsePrivilegeListNode(ControlEle);
                relateControlTypeTemp.setCommonPrivilegeList(CommonPrivilegeList);
                RelateControlMap.put(NameStr, relateControlTypeTemp);
                continue;
            }
            RelateControlMap.put(NameStr, RelateControlObj);
        }
        RCURelateUtil.InitRCUConditionAddInfoFile();
        return true;
    }

    public static int GetControlType(String ControlName) {
        int RetVal = 0;
        RelateControlType Obj = RelateControlMap.get(ControlName);
        if (Obj == null) {
            return RetVal;
        }
        Map<String, CommonPrivilege> enumValueMap = Obj.getEnumValueMap();
        if (Obj.getType().equalsIgnoreCase(ControlType_ControlEnumValue)) {
            RetVal = 12;
            return RetVal;
        }
        RetVal = Obj.getType().equalsIgnoreCase(ControlType_EnumValue) || !enumValueMap.isEmpty() ? 2 : (Obj.getType().equalsIgnoreCase(ControlType_ControlinGroup) ? 3 : 1);
        return RetVal;
    }

    public static int GetPrivilegeState(String ControlName, List<String> ItemList) {
        int RetVal = -1;
        RelateControlType Obj = RelateControlMap.get(ControlName);
        if (Obj == null) {
            return RetVal;
        }
        String OperType = Obj.getOperType();
        if (OperType != null) {
            return RetVal;
        }
        if (Obj.getType().equalsIgnoreCase(ControlType_EnumValue)) {
            RetVal = 3;
            return RetVal;
        }
        CommonPrivilege CommonPrivilegeObj = Obj.getCommonPrivilegeList().get(0);
        String PrivilegeName = CommonPrivilegeObj.getName();
        if (PrivilegeName.equalsIgnoreCase(PrivilegeName_Enable)) {
            Boolean Ret = NewConflictCheck.PrivilegeCheck((NewRelationGroup)CommonPrivilegeObj.getNestConditionGroupObj());
            RetVal = Ret.booleanValue() ? 1 : 0;
        } else if (PrivilegeName.equalsIgnoreCase(PrivilegeName_Update)) {
            if (CommonPrivilegeObj.getRole().equals("1")) {
                RetVal = 2;
            }
        } else if (PrivilegeName.equalsIgnoreCase(PrivilegeName_UpdateSelected)) {
            Boolean Ret = NewConflictCheck.PrivilegeCheck((NewRelationGroup)CommonPrivilegeObj.getNestConditionGroupObj());
            RetVal = Ret != false ? 4 : 5;
        }
        return RetVal;
    }

    private static List<String> UpdateRelateControl(CommonPrivilege commonPrivilegeObj) {
        if (commonPrivilegeObj.getConditionInfoList() == null) {
            return null;
        }
        List<String> RetList = new ArrayList<String>();
        List<ConditionInfo> ConditionInfoList = commonPrivilegeObj.getConditionInfoList();
        int index = 0;
        while (index < ConditionInfoList.size()) {
            ConditionInfo Temp = ConditionInfoList.get(index);
            if (Temp.getRelateFrom() == "2") {
                RetList = RCURelateUtil.GetEnumValueList(Temp.getControlName());
                break;
            }
            ++index;
        }
        return RetList;
    }

    public static List<String> GetEnumValueList(String ControlName) {
        RelateControlType Obj = RelateControlMap.get(ControlName);
        if (Obj == null) {
            return null;
        }
        ArrayList<String> RetList = new ArrayList<String>();
        if (Obj.getType().equalsIgnoreCase(ControlType_EnumValue)) {
            Map<String, CommonPrivilege> EnumValueList = Obj.getEnumValueMap();
            for (Map.Entry<String, CommonPrivilege> entry : EnumValueList.entrySet()) {
                CommonPrivilege PrivilegeObj = entry.getValue();
                if (PrivilegeObj == null) {
                    return RetList;
                }
                NewRelationGroup RelateObj = PrivilegeObj.getNestConditionGroupObj();
                if (!NewConflictCheck.PrivilegeCheck((NewRelationGroup)RelateObj)) continue;
                RetList.add(entry.getKey());
            }
        }
        return RetList;
    }

    private static List<CommonPrivilege> ParsePrivilegeListNode(Element controlEle) {
        ArrayList<CommonPrivilege> PrivilegeObjList = new ArrayList<CommonPrivilege>();
        for (Element PrivilegeEle : controlEle.elements("Privilege")) {
            if (PrivilegeEle == null) {
                return null;
            }
            CommonPrivilege PrivilegeObj = new CommonPrivilege();
            PrivilegeObj = RCURelateUtil.ParsePrivilegeNode(PrivilegeEle);
            PrivilegeObjList.add(PrivilegeObj);
        }
        return PrivilegeObjList;
    }

    private static CommonPrivilege ParsePrivilegeNode(Element PrivilegeEle) {
        Attribute PrivilegeRole;
        Attribute PrivilegeStep;
        CommonPrivilege PrivilegeObj = new CommonPrivilege();
        Attribute PrivilegeName = PrivilegeEle.attribute("Name");
        PrivilegeObj.setName(PrivilegeName.getValue());
        Attribute PrivilegeMaxValue = PrivilegeEle.attribute("MaxValue");
        if (PrivilegeMaxValue != null) {
            PrivilegeObj.setMaxValue(PrivilegeMaxValue.getValue());
            CommonPrivilege TempPrivilegeObj = RCURelateUtil.ParseRelationNode(PrivilegeEle);
            PrivilegeObj.setNestConditionGroupObj(TempPrivilegeObj.getNestConditionGroupObj());
        }
        if ((PrivilegeStep = PrivilegeEle.attribute("Step")) != null) {
            PrivilegeObj.setStep(PrivilegeStep.getValue());
        }
        if ((PrivilegeRole = PrivilegeEle.attribute("Role")) != null) {
            PrivilegeObj.setRole(PrivilegeRole.getValue());
            List<ConditionInfo> PrivilegeUserList = RCURelateUtil.ParsePrivilegeUserNode(PrivilegeEle);
            PrivilegeObj.setConditionInfoList(PrivilegeUserList);
        } else if (PrivilegeMaxValue == null && PrivilegeRole == null) {
            CommonPrivilege TempPrivilegeObj = RCURelateUtil.ParseRelationNode(PrivilegeEle);
            PrivilegeObj.setNestConditionGroupObj(TempPrivilegeObj.getNestConditionGroupObj());
        }
        return PrivilegeObj;
    }

    private static void ParseEnumValueNode(Element controlEle, RelateControlType relateControlObj) {
        Iterator It = controlEle.elementIterator();
        while (It.hasNext()) {
            Element EnumValueEle = (Element)It.next();
            String Text = null;
            if (EnumValueEle.getName().equals("EnumValue")) {
                Attribute TextAttribute2 = EnumValueEle.attribute("Text");
                Text = TextAttribute2.getValue();
            }
            CommonPrivilege CommonPrivilegeObj = new CommonPrivilege();
            if (EnumValueEle.elements("Privilege") == null) {
                return;
            }
            CommonPrivilegeObj = RCURelateUtil.ParsePrivilegeNode(EnumValueEle.element("Privilege"));
            relateControlObj.insertEnumValueMap(Text, CommonPrivilegeObj);
        }
    }

    private static CommonPrivilege ParseRelationNode(Element PrivilegeEle) {
        CommonPrivilege PrivilegeObj = new CommonPrivilege();
        for (Element RelationEle : PrivilegeEle.elements("Relation")) {
            NewRelationGroup NewRelationGroupObj = NewConditionXmlParse.ParseNewConditionRelationNode((Element)RelationEle);
            PrivilegeObj.setNestConditionGroupObj(NewRelationGroupObj);
        }
        return PrivilegeObj;
    }

    private static List<ConditionInfo> ParsePrivilegeUserNode(Element relationEle) {
        ArrayList<ConditionInfo> ConditionInfoList = new ArrayList<ConditionInfo>();
        for (Element PrivilegeUserEle : relationEle.elements("PrivilegeUser")) {
            if (PrivilegeUserEle == null) {
                return null;
            }
            ConditionInfo PrivilegeUserObj = new ConditionInfo();
            Iterator itAttribute = PrivilegeUserEle.attributeIterator();
            while (itAttribute.hasNext()) {
                Attribute attribute = (Attribute)itAttribute.next();
                String attributeName = attribute.getName();
                String attributeValue = attribute.getText();
                if (attributeValue.equals(CONFLICT_OPERTYPE_COMMON)) continue;
                PrivilegeUserObj.setAttrValue(attributeName, attributeValue);
            }
            ConditionInfoList.add(PrivilegeUserObj);
        }
        return ConditionInfoList;
    }

    public static void UpdatePropertyBeforeLoad() {
        block0: for (Map.Entry<String, RelateControlType> entry : RelateControlMap.entrySet()) {
            List<CommonPrivilege> CommonPrivilegeList = entry.getValue().getCommonPrivilegeList();
            if (CommonPrivilegeList.size() <= 0) continue;
            int i = 0;
            while (i < CommonPrivilegeList.size()) {
                NewRelationGroup RelateObj;
                CommonPrivilege CommonPrivilegeObj = CommonPrivilegeList.get(i);
                if (CommonPrivilegeObj.getStep().equals(Step_BeforeLoad) && NewConflictCheck.PrivilegeCheck((NewRelationGroup)(RelateObj = CommonPrivilegeObj.getNestConditionGroupObj()))) {
                    RCURelateUtil.UpdateControlProperty(entry.getKey(), entry.getValue().getType(), CommonPrivilegeObj);
                    continue block0;
                }
                ++i;
            }
        }
    }

    private static void UpdateControlProperty(String ControlName, String ControlType, CommonPrivilege CommonPrivilegeObj) {
        String MaxValue;
        RCUConfigControl ControlObj;
        if (ControlType.equalsIgnoreCase(ControlType_Control) && RCUCondition.RCUConfigControlMap.size() > 0 && (ControlObj = (RCUConfigControl)RCUCondition.RCUConfigControlMap.get(ControlName)) != null && CommonPrivilegeObj.getName().equalsIgnoreCase(PrivilegeName_SetMinMax) && !(MaxValue = CommonPrivilegeObj.getMaxValue()).equals(CONFLICT_OPERTYPE_COMMON)) {
            ControlObj.setMaxValue(MaxValue);
        }
    }

    private static void ParseExtendNode(RelateControlType relateControlObj, List<Element> extendNodeList) {
        if (extendNodeList == null) {
            return;
        }
        Map functionNodeMap = NewConditionXmlParse.ParseExtendFunctionNode(extendNodeList);
        relateControlObj.setFunctionNodeMap(functionNodeMap);
        Map expressionNodeMap = NewConditionXmlParse.ParseExpressionEvaluationNode(extendNodeList);
        relateControlObj.setExpressionEvaluationNodeMap(expressionNodeMap);
    }

    public static Object getExtendNodeResult(String controlName, String operName) {
        Object result = CONFLICT_OPERTYPE_COMMON;
        RelateControlType relateControlObj = RelateControlMap.get(controlName);
        if (relateControlObj == null) {
            return result;
        }
        String operType = relateControlObj.getOperType();
        if (operType == null) {
            return result;
        }
        if (operType.equals(CONFLICT_OPERTYPE_FUNCTION)) {
            ExtendFunctionNodeInfo funcObj = relateControlObj.getFunctionNode(operName);
            if (funcObj == null) {
                return result;
            }
            result = RCURelateUtil.getFunctionResult(funcObj);
        } else if (operType.equals(CONFLICT_OPERTYPE_EXPRESSION)) {
            ExpressionEvaluationInfo expressionEvaObj = relateControlObj.getExpressionNode(operName);
            if (expressionEvaObj == null) {
                return result;
            }
            result = RCURelateUtil.expressEvaluation(expressionEvaObj);
        }
        return result;
    }

    private static String expressEvaluation(ExpressionEvaluationInfo expressionInfo) {
        String result = CONFLICT_OPERTYPE_COMMON;
        if (expressionInfo.getType().equals("CommonFormula")) {
            CalculatorFunctions calFuncObj = new CalculatorFunctions();
            String expressionStr = expressionInfo.getExpression();
            List paramNodeList = expressionInfo.getParamNodeList();
            int i = 0;
            while (i < paramNodeList.size()) {
                ParamNodeInfo paraObj = (ParamNodeInfo)paramNodeList.get(i);
                String Param = ParamNodeWork.GetParaValue((ParamNodeInfo)paraObj);
                Param.contains("@Ref_");
                String replaceStr = "[p" + String.valueOf(i) + "]";
                expressionStr = expressionStr.replace(replaceStr, Param);
                ++i;
            }
            if (expressionStr.contains("%InvalidValue%")) {
                return null;
            }
            double resultDouble = calFuncObj.calculate(expressionStr);
            String format = expressionInfo.getFormat();
            if (!format.contains("%")) {
                return result;
            }
            if (format.contains("f")) {
                result = String.format(format, resultDouble);
            } else {
                int resultInt = (int)resultDouble;
                result = String.format(format, resultInt);
            }
        }
        return result;
    }

    public static Object getFunctionResult(ExtendFunctionNodeInfo FunctionNodeObj) {
        String MethodName = FunctionNodeObj.getInterFace();
        ArrayList<String> ParamList = new ArrayList<String>();
        int i = 0;
        while (i < FunctionNodeObj.getParamNodeList().size()) {
            ParamNodeInfo FuncPara = (ParamNodeInfo)FunctionNodeObj.getParamNodeList().get(i);
            String Param = ParamNodeWork.GetParaValue((ParamNodeInfo)FuncPara);
            Param.contains("@Ref_");
            if (Param.equals("%InvalidValue%")) {
                return null;
            }
            ParamList.add(Param);
            ++i;
        }
        Object[] args = ParamList.toArray();
        Object Value = InvokeReflectionFunc.InvokeReflectionFunction((String)CONFLICT_OPERTYPE_COMMON, (String)MethodName, (Object[])args);
        return Value;
    }

    public static boolean InitRCUConditionAddInfoFile() {
        RCUFilePath = String.valueOf(GeneralPathUtil.ResourcePath) + GlobalVariables.McuSeletorInfo.getRCUPath();
        if (RCUFilePath.lastIndexOf(".xml") > -1) {
            RCUFilePath = RCUFilePath.replace(".xml", "_add_AddInfo.xml");
        }
        Element rootElement = null;
        SAXReader reader = new SAXReader();
        File file = new File(RCUFilePath);
        if (!file.exists()) {
            return false;
        }
        Document document = null;
        try {
            document = reader.read(file);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        if (document == null) {
            return false;
        }
        rootElement = document.getRootElement();
        String ControlType = CONFLICT_OPERTYPE_COMMON;
        Element ControlsEle = rootElement.element("Controls");
        Iterator It = ControlsEle.elementIterator();
        while (It.hasNext()) {
            Element ControlEle = (Element)It.next();
            if (!ControlEle.getName().equals("Control")) continue;
            RelateControlType RelateControlObj = new RelateControlType();
            Attribute Name = ControlEle.attribute("Name");
            Attribute Type2 = ControlEle.attribute("Type");
            Attribute OperType = ControlEle.attribute("OperType");
            if (Name == null || Type2 == null) continue;
            RelateControlObj.setType(Type2.getValue());
            if (OperType != null) {
                RelateControlObj.setOperType(OperType.getValue());
            }
            ControlEle.element("EnumValue");
            if (ControlEle.element("EnumValue") != null) {
                ControlType = "EnumValue";
                RCURelateUtil.ParseEnumValueNode(ControlEle, RelateControlObj);
            } else if (ControlEle.element("ExtendNode") != null) {
                ControlType = "ExtendNode";
                List ExtendNodeList = ControlEle.elements("ExtendNode");
                RCURelateUtil.ParseExtendNode(RelateControlObj, ExtendNodeList);
            } else {
                List<CommonPrivilege> CommonPrivilegeList = RCURelateUtil.ParsePrivilegeListNode(ControlEle);
                RelateControlObj.setCommonPrivilegeList(CommonPrivilegeList);
            }
            String NameStr = Name.getValue();
            if (RelateControlMap.containsKey(NameStr)) {
                RelateControlType RelateControlObjTemp = RelateControlMap.get(NameStr);
                if (OperType != null) {
                    RelateControlObjTemp.setOperType(OperType.getValue());
                }
                if (ControlType.equals("EnumValue")) {
                    Map<String, CommonPrivilege> mapOld = RelateControlObjTemp.getEnumValueMap();
                    Map<String, CommonPrivilege> mapNewAdd = RelateControlObj.getEnumValueMap();
                    mapOld.putAll(mapNewAdd);
                    if (RelateControlObjTemp.getType() != null && RelateControlObjTemp.getType().equals("Control")) {
                        RelateControlObjTemp.setType("Control_EnumValue");
                    }
                    RelateControlObjTemp.setEnumValueMap(mapOld);
                } else if (ControlType.equals("ExtendNode")) {
                    Map<String, ExpressionEvaluationInfo> ExpressionEvaluationNodeMapAddNew = RelateControlObj.getExpressionEvaluationNodeMap();
                    Map<String, ExtendFunctionNodeInfo> FunctionNodeMapAddNew = RelateControlObj.getFunctionNodeMap();
                    RelateControlObjTemp.setExpressionEvaluationNodeMap(ExpressionEvaluationNodeMapAddNew);
                    RelateControlObjTemp.setFunctionNodeMap(FunctionNodeMapAddNew);
                    RelateControlMap.put(NameStr, RelateControlObjTemp);
                }
                System.out.println(CONFLICT_OPERTYPE_COMMON);
                continue;
            }
            RelateControlMap.put(NameStr, RelateControlObj);
        }
        return true;
    }

    public static String getPrivilege2Sentence(String ControlName) {
        String MCUPart = GlobalVariables.McuSeletorInfo.getCodeGroup();
        String MCUPartUpperCase = MCUPart.toUpperCase();
        if (MCUPartUpperCase.equals("GD32E23X") || MCUPartUpperCase.equals("GD32F3X0") || MCUPartUpperCase.equals("GD32H7XX") || MCUPartUpperCase.equals("GD32G5X3")) {
            return CONFLICT_OPERTYPE_COMMON;
        }
        StringBuilder resSentences = new StringBuilder();
        RelateControlType Obj = RelateControlMap.get(ControlName);
        if (Obj == null) {
            return CONFLICT_OPERTYPE_COMMON;
        }
        String OperType = Obj.getOperType();
        if (OperType != null) {
            return CONFLICT_OPERTYPE_COMMON;
        }
        if (Obj.getType().equalsIgnoreCase(ControlType_EnumValue)) {
            return CONFLICT_OPERTYPE_COMMON;
        }
        if (Obj.getCommonPrivilegeList() == null || Obj.getCommonPrivilegeList().size() < 0) {
            return CONFLICT_OPERTYPE_COMMON;
        }
        CommonPrivilege CommonPrivilegeObj = Obj.getCommonPrivilegeList().get(0);
        if (CommonPrivilegeObj == null) {
            return CONFLICT_OPERTYPE_COMMON;
        }
        String PrivilegeName = CommonPrivilegeObj.getName();
        if (PrivilegeName.equalsIgnoreCase(PrivilegeName_Enable)) {
            boolean disable2EnableFlag = false;
            resSentences.append(Privilege2Sentences.getFIRST_STR()).append(System.lineSeparator());
            NewRelationGroup newRelationGroup = CommonPrivilegeObj.getNestConditionGroupObj();
            if (newRelationGroup == null) {
                return CONFLICT_OPERTYPE_COMMON;
            }
            String relationType = newRelationGroup.getRelationType();
            if (relationType.equals("OR")) {
                resSentences.append(disable2EnableFlag ? Privilege2Sentences.getAND_STR() : Privilege2Sentences.getOR_STR()).append(System.lineSeparator());
            } else if (relationType.equals("AND")) {
                resSentences.append(disable2EnableFlag ? Privilege2Sentences.getOR_STR() : Privilege2Sentences.getAND_STR()).append(System.lineSeparator());
            }
            Privilege2Sentences.parseRelation((NewRelationGroup)newRelationGroup, (int)1, (StringBuilder)resSentences, (boolean)disable2EnableFlag, null);
        }
        return resSentences.toString();
    }

    public static Map<String, String> GetEnumValueListForPrivilege(String ControlName) {
        RelateControlType Obj = RelateControlMap.get(ControlName);
        if (Obj == null) {
            return null;
        }
        Map<String, CommonPrivilege> enumValueMap = Obj.getEnumValueMap();
        HashMap<String, String> retPrivilegeMap = new HashMap<String, String>();
        if (Obj.getType().equalsIgnoreCase(ControlType_EnumValue) || !enumValueMap.isEmpty()) {
            Map<String, CommonPrivilege> EnumValueList = Obj.getEnumValueMap();
            for (Map.Entry<String, CommonPrivilege> entry : EnumValueList.entrySet()) {
                CommonPrivilege PrivilegeObj = entry.getValue();
                if (PrivilegeObj == null) {
                    return retPrivilegeMap;
                }
                NewRelationGroup RelateObj = PrivilegeObj.getNestConditionGroupObj();
                if (!NewConflictCheck.PrivilegeCheck((NewRelationGroup)RelateObj)) continue;
                String privilegeName = PrivilegeObj.getName();
                retPrivilegeMap.put(privilegeName, entry.getKey());
            }
        }
        return retPrivilegeMap;
    }
}

