/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.clockconfigview.info;

import com.gigadevice.clockconfigview.info.ControlinGroup;
import com.gigadevice.clockconfigview.info.RCUConfigInfo_Abstract;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class RCUConfigControlGroup
extends RCUConfigInfo_Abstract
implements Serializable {
    private static final long serialVersionUID = 1L;
    String Type;
    String Name;
    String ClockOutputName;
    String Peri;
    String PeriItem;
    String PeriItemSource;
    String Location;
    Map<String, ControlinGroup> ControlGroupMap = new HashMap<String, ControlinGroup>();

    public String getType() {
        return this.Type;
    }

    public void setType(String type) {
        this.Type = type;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
        this.setRCUConfigClassType(3);
    }

    @Override
    public String getClockOutputName() {
        return this.ClockOutputName;
    }

    public void setClockOutputName(String clockOutputName) {
        this.ClockOutputName = clockOutputName;
    }

    @Override
    public String getClockInputName(String Name) {
        if (this.ControlGroupMap.size() == 0) {
            return null;
        }
        String inputName = null;
        ControlinGroup Obj = this.ControlGroupMap.get(Name);
        if (Obj != null) {
            inputName = Obj.getClockInputName(Name);
        }
        return inputName;
    }

    public void setControlDefault(String Name) {
        if (this.ControlGroupMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, ControlinGroup> entry : this.ControlGroupMap.entrySet()) {
            if (entry.getKey().equals(Name)) {
                entry.getValue().setDefault("true");
                continue;
            }
            entry.getValue().setDefault("false");
        }
    }

    @Override
    public boolean setControlCurrentValue(double value) {
        this.ControlCurrentValue = value;
        return true;
    }

    @Override
    public double getControlCurrentValue() {
        return this.ControlCurrentValue;
    }

    public String getPeri() {
        return this.Peri;
    }

    public void setPeri(String peri) {
        this.Peri = peri;
    }

    public String getPeriItem() {
        return this.PeriItem;
    }

    public void setPeriItem(String periItem) {
        this.PeriItem = periItem;
    }

    public String getPeriItemSource() {
        return this.PeriItemSource;
    }

    public void setPeriItemSource(String periItemSource) {
        this.PeriItemSource = periItemSource;
    }

    public String getLocation() {
        return this.Location;
    }

    public void setLocation(String location) {
        this.Location = location;
    }

    public Map<String, ControlinGroup> getControlGroup() {
        return this.ControlGroupMap;
    }

    public void setControlGroup(Map<String, ControlinGroup> controlGroup) {
        this.ControlGroupMap = controlGroup;
    }

    public void insertControltoGroup(String ControlName, String ControlClockInputName, String ControlPositionX, String ControlPositionY, String Value, String Default, String Macro) {
        ControlinGroup Obj = new ControlinGroup();
        Obj.setControlClockInputName(ControlClockInputName);
        Obj.setControlName(ControlName);
        Obj.setControlPositionX(ControlPositionX);
        Obj.setControlPositionY(ControlPositionY);
        Obj.setValue(Value);
        Obj.setDefault(Default);
        Obj.setMacro(Macro);
        if (Default != null && Default.toUpperCase().equalsIgnoreCase("TRUE")) {
            this.setControlInitValue(ControlName);
        }
        this.ControlGroupMap.put(ControlName, Obj);
    }

    public boolean setControlComponent(String ControlName, Component ControlComponent) {
        if (this.ControlGroupMap.size() == 0) {
            return false;
        }
        ControlinGroup Obj = this.ControlGroupMap.get(ControlName);
        if (Obj != null) {
            Obj.setControlComponent(ControlComponent);
        }
        return true;
    }

    public Component getControlComponent(String ControlName) {
        if (this.ControlGroupMap.size() == 0) {
            return null;
        }
        Component ControlComponent = null;
        ControlinGroup Obj = this.ControlGroupMap.get(ControlName);
        if (Obj != null) {
            ControlComponent = Obj.getControlComponent();
        }
        return ControlComponent;
    }

    public int getControlPositionX(String ControlName) {
        if (this.ControlGroupMap.size() == 0) {
            return -1;
        }
        int PositionX = 0;
        ControlinGroup Obj = this.ControlGroupMap.get(ControlName);
        if (Obj != null) {
            PositionX = Obj.getControlPositionX();
        }
        return PositionX;
    }

    public int getControlPositionY(String ControlName) {
        if (this.ControlGroupMap.size() == 0) {
            return -1;
        }
        int PositionY = 0;
        ControlinGroup Obj = this.ControlGroupMap.get(ControlName);
        if (Obj != null) {
            PositionY = Obj.getControlPositionY();
        }
        return PositionY;
    }

    public String getControlGroupDefault() {
        String Default = null;
        if (this.ControlGroupMap.size() == 0) {
            return null;
        }
        for (Map.Entry<String, ControlinGroup> entry : this.ControlGroupMap.entrySet()) {
            if (!this.getControlDefault(entry.getKey())) continue;
            Default = entry.getKey();
        }
        return Default;
    }

    public boolean getControlDefault(String ControlName) {
        if (this.ControlGroupMap.size() == 0) {
            return false;
        }
        boolean isDefault = false;
        ControlinGroup Obj = this.ControlGroupMap.get(ControlName);
        if (Obj != null) {
            isDefault = Obj.isDefault();
        }
        return isDefault;
    }

    public TreeSet<String> GetControlSet() {
        TreeSet<String> ItemList = new TreeSet<String>();
        if (this.ControlGroupMap.size() > 0) {
            for (Map.Entry<String, ControlinGroup> ControlEntry : this.ControlGroupMap.entrySet()) {
                ItemList.add(ControlEntry.getKey());
            }
        }
        return ItemList;
    }

    public void setControlCurrentValue(String Name, double value) {
        if (this.ControlGroupMap.size() == 0) {
            return;
        }
        ControlinGroup Obj = this.ControlGroupMap.get(Name);
        if (Obj != null) {
            Obj.setControlCurrentValue(value);
        }
    }

    public double getControlCurrentValue(String Name) {
        if (this.ControlGroupMap.size() == 0) {
            return -1.0;
        }
        double Value = 0.0;
        ControlinGroup Obj = this.ControlGroupMap.get(Name);
        if (Obj != null) {
            Value = Obj.getControlCurrentValue();
        }
        return Value;
    }

    public String getControlMacro(String Name) {
        if (this.ControlGroupMap.size() == 0) {
            return "";
        }
        String Macro = null;
        ControlinGroup Obj = this.ControlGroupMap.get(Name);
        if (Obj != null) {
            Macro = Obj.getMacro();
        }
        return Macro;
    }

    public String getCurrentControlMacro() {
        if (this.ControlGroupMap.size() == 0) {
            return "";
        }
        String Macro = null;
        for (Map.Entry<String, ControlinGroup> entry : this.ControlGroupMap.entrySet()) {
            if (!entry.getValue().isDefault()) continue;
            Macro = entry.getValue().getMacro();
        }
        return Macro;
    }

    public void setControlMacro(String Name, String Macro) {
        if (this.ControlGroupMap.size() == 0) {
            return;
        }
        ControlinGroup Obj = this.ControlGroupMap.get(Name);
        if (Obj != null) {
            Obj.setMacro(Macro);
        }
    }

    @Override
    public boolean setControlInitValue(String value) {
        this.ControlInitValue = value;
        return true;
    }
}

