/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.xmlparse;

import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.baseinfo.PinNamesStruct;
import com.gigadevice.venustool.baseinfo.PinStruct;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PinInfoXmlParse {
    private static final String TREE_NODE = "PinPad";
    private static final String ANALOG_NODE = "AnalogPin";

    public static void parseDatasheetXML(String filePath, List<GD32PinPad> GD32PinPads, String PackageType, int MCUPackage) {
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            List PinPadList = rootElm.elements(TREE_NODE);
            int num = 0;
            int i = 0;
            while (i < MCUPackage) {
                GD32PinPad gd32PinPad = new GD32PinPad();
                gd32PinPad.putPinIndex(i);
                GD32PinPads.add(gd32PinPad);
                ++i;
            }
            for (Element elmPinPad : PinPadList) {
                String strNumber;
                int Index = 0;
                String xmlPackageType = "Package_" + PackageType;
                Element itPackageNodes = elmPinPad.element(xmlPackageType);
                if (itPackageNodes == null || (strNumber = itPackageNodes.attributeValue("Number")).equals("-")) continue;
                if (PackageType.contains("BGA") || PackageType.contains("WLCSP")) {
                    Index = num;
                } else {
                    try {
                        Index = Integer.parseInt(strNumber) - 1;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                GD32PinPad gd32PinPad = null;
                if (GD32PinPads.get(Index) == null) continue;
                if (!GD32PinPads.get(Index).getPinNumberStr().equals("")) {
                    if (GD32PinPads.get(Index).getRemapPins().size() <= 0) {
                        GD32PinPad childRemapPinPad = GlobalVariables.cloneFrom(GD32PinPads.get(Index));
                        GD32PinPads.get(Index).addRemapPin(childRemapPinPad);
                    }
                    gd32PinPad = new GD32PinPad();
                    GD32PinPads.get(Index).addRemapPin(gd32PinPad);
                } else {
                    gd32PinPad = GD32PinPads.get(Index);
                    ++num;
                }
                Iterator itAttribute = elmPinPad.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    gd32PinPad.setAttrValue(attributeName, attributeValue);
                }
                gd32PinPad.putPinIndex(Index);
                gd32PinPad.putPinNumberStr(strNumber);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean parseAFIOXML(String filePath, Map<String, Map<String, List<PinNamesStruct>>> AFIORemapMap) {
        boolean isRemap = false;
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            String strRemap = rootElm.attributeValue("Remap");
            if (strRemap.equals("true")) {
                isRemap = true;
            }
            List AFIOPinItemList = rootElm.elements("AFIOPinItem");
            for (Element elmAFIOPinItem : AFIOPinItemList) {
                HashMap<String, List> mapPinNames = new HashMap<String, List>();
                String PeriNameStr = elmAFIOPinItem.attributeValue("name");
                List PinNamesList = elmAFIOPinItem.elements("PinNames");
                for (Element elmPinNames : PinNamesList) {
                    PinNamesStruct PinNamesStructObj = new PinNamesStruct();
                    String FunctionGroupName = elmPinNames.attributeValue("FunctionGroupName");
                    String RemapAFValue = elmPinNames.attributeValue("RemapAFValue");
                    PinNamesStructObj.setFunctionGroupName(FunctionGroupName);
                    PinNamesStructObj.setRemapAFValue(RemapAFValue);
                    List PinList = elmPinNames.elements("Pin");
                    for (Element elmPin : PinList) {
                        Element elmPinName;
                        PinStruct pinStruct = new PinStruct();
                        Element elmPinUsedFunction = elmPin.element("PinUsedFunction");
                        if (elmPinUsedFunction != null) {
                            pinStruct.setPinUsedFunction(elmPinUsedFunction.getText());
                        }
                        if ((elmPinName = elmPin.element("PinName")) == null) continue;
                        pinStruct.setPinName(elmPinName.getText());
                        Iterator itAttribute = elmPinName.attributeIterator();
                        while (itAttribute.hasNext()) {
                            Attribute attribute = (Attribute)itAttribute.next();
                            String attributeName = attribute.getName();
                            String attributeValue = attribute.getText();
                            if (attributeName.equals("FlashSize") || attributeName.equals("FlashSizeMin") || attributeName.equals("FlashSizeMax")) {
                                pinStruct.setFlashSizeType(attributeName);
                                pinStruct.setFlashSize(attributeValue);
                                continue;
                            }
                            if (!attributeName.equals("PartNumber")) continue;
                            pinStruct.setAvailablePart(attributeValue);
                        }
                        PinNamesStructObj.putPinStructList(pinStruct);
                    }
                    if (!mapPinNames.containsKey(FunctionGroupName)) {
                        ArrayList<PinNamesStruct> PinNamesStructList = new ArrayList<PinNamesStruct>();
                        PinNamesStructList.add(PinNamesStructObj);
                        mapPinNames.put(FunctionGroupName, PinNamesStructList);
                        continue;
                    }
                    List tmp = (List)mapPinNames.get(FunctionGroupName);
                    mapPinNames.remove(FunctionGroupName);
                    tmp.add(PinNamesStructObj);
                    mapPinNames.put(FunctionGroupName, tmp);
                }
                AFIORemapMap.put(PeriNameStr, mapPinNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isRemap;
    }

    public static void parseAnalogPinsXML(String filePath) {
        GlobalVariables.AnalogModePins.clear();
        SAXReader saxReader = new SAXReader();
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                GlobalVariables.isAnalogMode = false;
                return;
            }
            Document document = saxReader.read(f);
            Element rootElm = document.getRootElement();
            String isAnalogMode = rootElm.attributeValue("isAnalogMode");
            if (isAnalogMode.toUpperCase().equals("TRUE")) {
                GlobalVariables.isAnalogMode = true;
            }
            List AnalogPinList = rootElm.elements(ANALOG_NODE);
            for (Element elmAnalogPin : AnalogPinList) {
                String pinName = elmAnalogPin.attributeValue("Name");
                GlobalVariables.AnalogModePins.add(pinName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

