/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.mcuxmlinfo;

import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.TargetOSInfo;
import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.CoreInfo;
import com.gigadevice.venustool.mcuxmlinfo.IMcuTree;
import com.gigadevice.venustool.mcuxmlinfo.MCUs;
import com.gigadevice.venustool.mcuxmlinfo.McuGroup;
import com.gigadevice.venustool.mcuxmlinfo.McuSubGroup;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class McuFactory {
    public static ArrayList<Object> McuTree = new ArrayList();
    private static boolean WriteChangeLog = false;
    private static boolean lastMatchSucceeded = false;
    private static boolean isTemplateProjectTree = false;
    public static final int MATCH_NONE = 0;
    public static final int MATCH_PARTIAL = 1;
    public static final int MATCH_FULL = 2;
    public static final String LDFileType = "ld";
    public static final String StartupFileType = "startup";
    public static final String OpenocdType = "openocd";

    public static String getResourcePath() {
        String resourcePath = null;
        String filePath = "";
        Location l = Platform.getInstallLocation();
        filePath = l.getURL().toString();
        int start = 0;
        int length = 0;
        if (TargetOSInfo.isWindows()) {
            start = filePath.indexOf("file:/") + 6;
            length = filePath.length() - filePath.indexOf("file:/");
        } else if (TargetOSInfo.isLinux()) {
            start = filePath.indexOf("file:") + 5;
            length = filePath.length() - filePath.indexOf("file:");
        }
        filePath = filePath.substring(start, length);
        filePath = filePath.replace("/", File.separator);
        resourcePath = GeneralPathUtil.ResourcePath;
        return resourcePath;
    }

    public static String getFirmwarePath(String Core, String Chip) {
        String FirmwarePath = "";
        String PluginName = "com.gigadevice.templatefwlib.";
        PluginName = Core.contains("ARM") ? String.valueOf(PluginName) + "arm." : String.valueOf(PluginName) + "riscv.";
        PluginName = String.valueOf(PluginName) + Chip.toLowerCase();
        try {
            if (TargetOSInfo.isWindows()) {
                FirmwarePath = String.valueOf(FileLocator.toFileURL((URL)Platform.getBundle((String)PluginName).getEntry("")).getPath().substring(1)) + "Firmware" + File.separator;
            } else if (TargetOSInfo.isLinux()) {
                FirmwarePath = String.valueOf(FileLocator.toFileURL((URL)Platform.getBundle((String)PluginName).getEntry("")).getPath()) + "Firmware" + File.separator;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return FirmwarePath;
    }

    public static String getMcuXMLPath(String mcuType) {
        String McuXMLPath = String.valueOf(McuFactory.getResourcePath()) + "templatemcus" + File.separator + mcuType + ".xml";
        return McuXMLPath;
    }

    public static String getGDMcuXMLPath(String mcuType) {
        String McuXMLPath = String.valueOf(McuFactory.getResourcePath()) + "mcus" + File.separator + mcuType + ".xml";
        return McuXMLPath;
    }

    public static String getPluginPath(String PluginName) {
        String PluginPath = "";
        try {
            PluginPath = FileLocator.toFileURL((URL)Platform.getBundle((String)PluginName).getEntry("")).getPath().substring(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return PluginPath;
    }

    public static String getLibPath() {
        String LibPath = String.valueOf(McuFactory.getResourcePath()) + "lib" + File.separator;
        return LibPath;
    }

    public static String getDLLAndSOPath() {
        String path = McuFactory.getLibPath();
        if (TargetOSInfo.isWindows()) {
            path = String.valueOf(path) + "GDLinkDLL" + File.separator + "GDLink.dll";
        } else if (TargetOSInfo.isLinux()) {
            path = String.valueOf(path) + "GDLinkSO" + File.separator + "libGDLink.so";
            McuFactory.copySOFile();
        }
        return path;
    }

    public static void copySOFile() {
        String path = String.valueOf(McuFactory.getLibPath()) + File.separator + "GDLinkSO";
        try {
            McuFactory.copyDir(path, "/usr/lib/");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyDir(String sourcePath, String newPath) throws IOException {
        File file = new File(sourcePath);
        String[] filePath = file.list();
        if (!new File(newPath).exists()) {
            new File(newPath).mkdir();
        }
        int i = 0;
        while (i < filePath.length) {
            if (new File(String.valueOf(sourcePath) + File.separator + filePath[i]).isDirectory()) {
                McuFactory.copyDir(String.valueOf(sourcePath) + File.separator + filePath[i], String.valueOf(newPath) + File.separator + filePath[i]);
            }
            if (new File(String.valueOf(sourcePath) + File.separator + filePath[i]).isFile()) {
                McuFactory.copyFile(String.valueOf(sourcePath) + File.separator + filePath[i], String.valueOf(newPath) + File.separator + filePath[i]);
            }
            ++i;
        }
    }

    public static void copyFile(String oldPath, String newPath) throws IOException {
        File oldFile = new File(oldPath);
        File file = new File(newPath);
        FileInputStream in = new FileInputStream(oldFile);
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[0x200000];
        int readByte = 0;
        while ((readByte = in.read(buffer)) != -1) {
            out.write(buffer, 0, readByte);
        }
        in.close();
        out.close();
    }

    public static Document parseFileToDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputFile = new InputSource(new FileInputStream(file));
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(inputFile);
        return document;
    }

    public static List<Object> sortMcuTree(ArrayList<Object> mcuTree) {
        Collections.sort(mcuTree, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((McuGroup)o1).compareTo((McuGroup)o2);
            }
        });
        for (Object node : mcuTree) {
            McuGroup mcuGroupNode = (McuGroup)node;
            List<Object> mcuGroupChildren = mcuGroupNode.getChildren();
            Collections.sort(mcuGroupChildren, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((McuSubGroup)o1).compareTo((McuSubGroup)o2);
                }
            });
            for (Object node1 : mcuGroupChildren) {
                McuSubGroup mcuSubGroupNode = (McuSubGroup)node1;
                List<Object> mcuSubGroupChildren = mcuSubGroupNode.getChildren();
                Collections.sort(mcuSubGroupChildren, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ((MCUs)o1).compareTo((MCUs)o2);
                    }
                });
            }
        }
        return mcuTree;
    }

    public static List<Object> getMcuTree(String mcuType) {
        File file = new File(McuFactory.getMcuXMLPath(mcuType));
        Document document = null;
        try {
            document = McuFactory.parseFileToDocument(file);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (document == null) {
            return null;
        }
        Element rootElement = document.getDocumentElement();
        ArrayList<Object> _McuTree = new ArrayList();
        WriteChangeLog = true;
        isTemplateProjectTree = true;
        _McuTree = McuFactory.McuXMLParse(rootElement, null);
        return McuFactory.sortMcuTree(_McuTree);
    }

    public static List<Object> getGDMcuTree(String mcuType) {
        File file = new File(McuFactory.getGDMcuXMLPath(mcuType));
        Document document = null;
        try {
            document = McuFactory.parseFileToDocument(file);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (document == null) {
            return null;
        }
        Element rootElement = document.getDocumentElement();
        ArrayList<Object> _McuTree = new ArrayList();
        isTemplateProjectTree = false;
        _McuTree = McuFactory.McuXMLParse(rootElement, null);
        return _McuTree;
    }

    public static ArrayList<Object> McuXMLParse(Node node, Object parent) {
        WriteChangeLog = false;
        String ChangeLogPath = String.valueOf(McuFactory.getResourcePath()) + "ChangeLog.txt";
        String FirmwareVersionPath = String.valueOf(McuFactory.getResourcePath()) + "FirmwareVersion.txt";
        BufferedWriter bufferedWriter = null;
        node.getNodeName();
        NodeList GroupList = node.getChildNodes();
        TreeMap<String, String> FirmwareVersionMap = new TreeMap<String, String>();
        ArrayList<Object> MCUGroupList = new ArrayList<Object>(GroupList.getLength());
        String coreType = "";
        try {
            if (WriteChangeLog) {
                File file = new File(ChangeLogPath);
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ChangeLogPath, true), StandardCharsets.UTF_8);
                bufferedWriter = new BufferedWriter(fileWriter);
                if (!file.exists() || file.length() <= 0L) {
                    bufferedWriter.write("[Support MCU series]");
                    bufferedWriter.newLine();
                    bufferedWriter.write("===============");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<Template Project>");
                    bufferedWriter.newLine();
                }
                WriteChangeLog = false;
            }
            int i = 0;
            while (i < GroupList.getLength()) {
                Node ChildNode = GroupList.item(i);
                int WritePartNoCount = 0;
                if (ChildNode.getNodeType() == 1) {
                    NamedNodeMap attribute = ChildNode.getAttributes();
                    attribute.item(0).getNodeName();
                    String value = "";
                    String fwlibType = "Standard";
                    int n = 0;
                    while (n < attribute.getLength()) {
                        if (attribute.item(n).getNodeName().equals("name")) {
                            value = attribute.item(n).getNodeValue();
                        } else if (attribute.item(n).getNodeName().equals("fwlibType")) {
                            fwlibType = attribute.item(n).getNodeValue();
                        }
                        ++n;
                    }
                    McuGroup mcugroup = new McuGroup(value);
                    mcugroup.setFwlibType(fwlibType);
                    ChildNode.getNodeName();
                    NodeList SubGroupList = ChildNode.getChildNodes();
                    ArrayList<Object> MCUSubGroupList = new ArrayList<Object>(SubGroupList.getLength());
                    String CPUCore = "";
                    int j = 0;
                    while (j < SubGroupList.getLength()) {
                        Node SubGroupNode = SubGroupList.item(j);
                        if (SubGroupNode.getNodeType() == 1) {
                            String datasheetPath = "";
                            McuSubGroup mcusubgroup = new McuSubGroup();
                            mcusubgroup.setPeriConfigAndCodePath(mcugroup.getName());
                            NamedNodeMap subattribute = SubGroupNode.getAttributes();
                            int n2 = 0;
                            while (n2 < subattribute.getLength()) {
                                McuFactory.setMcuSubGroupPara(mcusubgroup, subattribute.item(n2));
                                String McuSubGroupNodeName = subattribute.item(n2).getNodeName();
                                if (McuSubGroupNodeName.equalsIgnoreCase("DataSheetPath")) {
                                    datasheetPath = subattribute.item(n2).getNodeValue();
                                }
                                ++n2;
                            }
                            if (CPUCore.isEmpty()) {
                                CPUCore = mcusubgroup.getCPUCore();
                            }
                            if (coreType.isEmpty()) {
                                coreType = CPUCore;
                            }
                            SubGroupNode.getNodeName();
                            NodeList List2 = SubGroupNode.getChildNodes();
                            ArrayList<Object> MCUList = new ArrayList<Object>(List2.getLength());
                            int k = 0;
                            while (k < List2.getLength()) {
                                Node MCUNode = List2.item(k);
                                String type = MCUNode.getNodeName();
                                if (MCUNode.getNodeType() == 1 && type.equalsIgnoreCase("CORES")) {
                                    NodeList coreNodeList = MCUNode.getChildNodes();
                                    int s = 0;
                                    while (s < coreNodeList.getLength()) {
                                        McuFactory.analyseCores(coreNodeList, s, mcusubgroup, 1);
                                        ++s;
                                    }
                                } else if (MCUNode.getNodeType() == 1 && type.equals("MCU")) {
                                    MCUs mcus = new MCUs();
                                    NamedNodeMap mcuattribute = MCUNode.getAttributes();
                                    int tmp = 0;
                                    while (tmp < mcuattribute.getLength()) {
                                        Node MCUAttributeNode = mcuattribute.item(tmp);
                                        McuFactory.setMcuPara(mcus, MCUAttributeNode);
                                        String LowerMCUNodeName = MCUAttributeNode.getNodeName().toLowerCase();
                                        if (LowerMCUNodeName.equals("name") && bufferedWriter != null) {
                                            bufferedWriter.write(String.valueOf(mcuattribute.item(tmp).getNodeValue()) + " ");
                                            if (++WritePartNoCount >= 8) {
                                                bufferedWriter.newLine();
                                                WritePartNoCount = 0;
                                            }
                                        }
                                        ++tmp;
                                    }
                                    mcus.setDataSheetPath(datasheetPath);
                                    NodeList leafs = MCUNode.getChildNodes();
                                    int m = 0;
                                    while (m < leafs.getLength()) {
                                        Node LeafNode = leafs.item(m);
                                        String leafType = LeafNode.getNodeName();
                                        if (leafType.equals("FLASH")) {
                                            int a = 0;
                                            while (a < leafs.item(m).getChildNodes().getLength()) {
                                                if (leafs.item(m).getChildNodes().item(a).getNodeName().equals("Size")) {
                                                    String flashsize = leafs.item(m).getChildNodes().item(a).getTextContent();
                                                    mcus.setFlashSize(flashsize);
                                                }
                                                if (leafs.item(m).getChildNodes().item(a).getNodeName().equals("Address")) {
                                                    String flashaddress = leafs.item(m).getChildNodes().item(a).getTextContent();
                                                    mcus.setFlashAddress(flashaddress);
                                                }
                                                ++a;
                                            }
                                        }
                                        if (leafType.equals("RAM")) {
                                            int b = 0;
                                            while (b < leafs.item(m).getChildNodes().getLength()) {
                                                if (leafs.item(m).getChildNodes().item(b).getNodeName().equals("Size")) {
                                                    String ramsize = leafs.item(m).getChildNodes().item(b).getTextContent();
                                                    mcus.setRamSize(ramsize);
                                                }
                                                if (leafs.item(m).getChildNodes().item(b).getNodeName().equals("Address")) {
                                                    String ramaddress = leafs.item(m).getChildNodes().item(b).getTextContent();
                                                    mcus.setRamAddress(ramaddress);
                                                }
                                                ++b;
                                            }
                                        }
                                        if (leafType.equals("Symbols")) {
                                            ArrayList<String> symbols = new ArrayList<String>();
                                            int c = 0;
                                            while (c < leafs.item(m).getChildNodes().getLength()) {
                                                if (leafs.item(m).getChildNodes().item(c).getNodeName().equals("Symbol")) {
                                                    String symbol = leafs.item(m).getChildNodes().item(c).getTextContent();
                                                    symbols.add(symbol);
                                                }
                                                ++c;
                                            }
                                            mcus.setSymbols(symbols);
                                        }
                                        if (leafType.equals("LDRAM")) {
                                            int d = 0;
                                            while (d < leafs.item(m).getChildNodes().getLength()) {
                                                if (leafs.item(m).getChildNodes().item(d).getNodeName().equals("Size")) {
                                                    String ldramsize = leafs.item(m).getChildNodes().item(d).getTextContent();
                                                    mcus.setldRamSize(ldramsize);
                                                }
                                                ++d;
                                            }
                                        }
                                        if (leafType.equals("DataSheetPath")) {
                                            mcus.setDataSheetPath(leafs.item(m).getTextContent());
                                        }
                                        if (leafType.equals("PerisTreeFilePath")) {
                                            mcus.setPerisTreeFilePath(leafs.item(m).getTextContent());
                                        }
                                        if (leafType.equals("AFIOPath")) {
                                            mcus.setAFIOPath(leafs.item(m).getTextContent());
                                        }
                                        if (leafType.equals("Options")) {
                                            McuFactory.addOptions(LeafNode, null, mcus);
                                        }
                                        if (leafType.equals("CORES")) {
                                            NodeList coreNodeList = LeafNode.getChildNodes();
                                            int s = 0;
                                            while (s < coreNodeList.getLength()) {
                                                McuFactory.analyseCores(coreNodeList, s, mcus, 0);
                                                ++s;
                                            }
                                        }
                                        ++m;
                                    }
                                    mcus.setParent(mcusubgroup);
                                    MCUList.add(mcus);
                                }
                                ++k;
                            }
                            mcusubgroup.setChildren(MCUList);
                            MCUSubGroupList.add(mcusubgroup);
                            mcusubgroup.setParent(mcugroup);
                        }
                        ++j;
                    }
                    mcugroup.setChildren(MCUSubGroupList);
                    MCUGroupList.add(mcugroup);
                    if (bufferedWriter != null) {
                        if (WritePartNoCount != 0) {
                            bufferedWriter.newLine();
                        }
                        if (isTemplateProjectTree) {
                            FirmwareVersionMap.put(value, McuFactory.getFirmwareVersion(CPUCore, value));
                            bufferedWriter.write(String.valueOf(value) + ":" + (String)FirmwareVersionMap.get(value));
                            bufferedWriter.newLine();
                        }
                        if (WritePartNoCount != 0) {
                            bufferedWriter.newLine();
                        }
                    }
                }
                ++i;
            }
            if (bufferedWriter != null) {
                if (isTemplateProjectTree) {
                    int LineCount = 2;
                    File VeriosnFile = new File(FirmwareVersionPath);
                    OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(VeriosnFile, true), StandardCharsets.UTF_8);
                    BufferedWriter VeriosnBufferedWriter = new BufferedWriter(fileWriter);
                    VeriosnBufferedWriter.newLine();
                    if (coreType.toLowerCase().contains("cortex")) {
                        VeriosnBufferedWriter.write("ARM:");
                    } else {
                        VeriosnBufferedWriter.write("RISC-V:");
                    }
                    VeriosnBufferedWriter.newLine();
                    Set keySet = FirmwareVersionMap.keySet();
                    for (String key : keySet) {
                        VeriosnBufferedWriter.write(String.valueOf(key) + ":" + (String)FirmwareVersionMap.get(key) + "    ");
                        if (--LineCount >= 1) continue;
                        VeriosnBufferedWriter.newLine();
                        LineCount = 2;
                    }
                    VeriosnBufferedWriter.newLine();
                    VeriosnBufferedWriter.close();
                }
                bufferedWriter.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return MCUGroupList;
    }

    private static void setMcuSubGroupPara(McuSubGroup mcusubgroup, Node McuSubGroupNode) {
        String McuSubGroupNodeName = McuSubGroupNode.getNodeName();
        String McuSubGroupNodeValue = McuSubGroupNode.getNodeValue();
        switch (McuSubGroupNodeName) {
            case "name": {
                mcusubgroup.setName(McuSubGroupNodeValue);
                break;
            }
            case "CPUcore": {
                mcusubgroup.setCPUCore(McuSubGroupNodeValue);
                break;
            }
            case "RelationFilePath": {
                mcusubgroup.setRelationFilePath(McuSubGroupNodeValue);
                break;
            }
            case "RCUPath": {
                mcusubgroup.setRCUPath(McuSubGroupNodeValue);
                break;
            }
            case "codeGroup": {
                mcusubgroup.setCodeGroup(McuSubGroupNodeValue);
                break;
            }
            case "supportCodeGen": {
                if (!McuSubGroupNodeValue.equals("false")) break;
                mcusubgroup.setSupportCodeGen(false);
                break;
            }
            case "isSupport": {
                if (!McuSubGroupNodeValue.equals("true")) break;
                mcusubgroup.setSupport(true);
                break;
            }
            case "spPeri2FuncFilePath": {
                mcusubgroup.setSPPeri2FuncFilePath(McuSubGroupNodeValue);
                break;
            }
            case "srcFolder": {
                mcusubgroup.setSrcFolder(McuSubGroupNodeValue);
                break;
            }
            case "excludeFileAndFolder": {
                mcusubgroup.setExcludeFileAndFolder(McuSubGroupNodeValue);
                break;
            }
            case "ld": {
                mcusubgroup.setLdFiles(McuSubGroupNodeValue);
                break;
            }
            case "startup": {
                mcusubgroup.setStartups(McuSubGroupNodeValue);
                break;
            }
            case "openocd": {
                mcusubgroup.setOpenocds(McuSubGroupNodeValue);
                break;
            }
            case "ToolChainPath": {
                mcusubgroup.setToolChainPath(McuSubGroupNodeValue);
                break;
            }
            case "PeriConfigAndCodePath": {
                mcusubgroup.setPeriConfigAndCodePath(McuSubGroupNodeValue);
                break;
            }
        }
    }

    private static void setMcuPara(MCUs mcus, Node McuNode) {
        String LowerMCUNodeName = McuNode.getNodeName().toLowerCase();
        String MCUNodeValue = McuNode.getNodeValue();
        switch (LowerMCUNodeName) {
            case "name": {
                mcus.setName(MCUNodeValue);
                break;
            }
            case "projectfolder": {
                mcus.setProjectFolder(MCUNodeValue);
                break;
            }
            case "startup": {
                mcus.setStartups(MCUNodeValue);
                break;
            }
            case "svd": {
                mcus.setSVD(MCUNodeValue);
                break;
            }
            case "package": {
                mcus.setPackageType(MCUNodeValue);
                break;
            }
            case "io": {
                mcus.setIO(MCUNodeValue);
                break;
            }
            case "srcfolder": {
                mcus.setSrcFolder(MCUNodeValue);
                break;
            }
            case "excludefileandfolder": {
                mcus.setExcludeFileAndFolder(MCUNodeValue);
                break;
            }
            case "openocd": {
                mcus.setOpenocds(MCUNodeValue);
                break;
            }
            case "ld": {
                mcus.setLdFiles(MCUNodeValue);
                break;
            }
        }
    }

    public static void analyseCores(NodeList leafs, int index, IMcuTree mcu, int level) {
        block27: {
            Node LeafNode = leafs.item(index);
            if (!LeafNode.getNodeName().equalsIgnoreCase("CORE") || !LeafNode.hasAttributes()) break block27;
            NamedNodeMap namedNodeMap = LeafNode.getAttributes();
            String CoreName = "";
            String CoreIndex = "";
            String LdFile = "";
            String APIndex = "";
            String Startup = "";
            String Openocd = "";
            int tmp = 0;
            while (tmp < namedNodeMap.getLength()) {
                Node AttributeNode = namedNodeMap.item(tmp);
                String NodeName = AttributeNode.getNodeName();
                String NodeValue = AttributeNode.getNodeValue();
                switch (NodeName) {
                    case "name": {
                        CoreName = NodeValue;
                        break;
                    }
                    case "index": {
                        CoreIndex = NodeValue;
                        break;
                    }
                    case "ld": {
                        LdFile = NodeValue;
                        break;
                    }
                    case "AP": {
                        APIndex = NodeValue;
                        break;
                    }
                    case "startup": {
                        Startup = NodeValue;
                        break;
                    }
                    case "openocd": {
                        Openocd = NodeValue;
                        break;
                    }
                }
                if (CoreName != "" && CoreIndex != "" && APIndex != "") {
                    CoreInfo coreInfo = McuFactory.getCoreInfo(LeafNode, CoreName, CoreIndex, LdFile, APIndex, Startup, Openocd);
                    if (level == 0) {
                        ((MCUs)mcu).addCore(String.valueOf(CoreIndex) + " - " + CoreName, coreInfo);
                    } else if (level == 1) {
                        ((McuSubGroup)mcu).addCore(String.valueOf(CoreIndex) + " - " + CoreName, coreInfo);
                    }
                }
                ++tmp;
            }
        }
    }

    public static MCUSeletorInfo getSeletorInfoByPartNo(int projectType, String TempMCUPartNo) {
        String mcuType;
        lastMatchSucceeded = false;
        MCUSeletorInfo mcuSeletorInfoObj = new MCUSeletorInfo();
        ArrayList<Object> McuList = new ArrayList<Object>();
        ConstantsUtil.typrProject = projectType;
        if (projectType == 0) {
            mcuType = "mcu_arm";
            McuList.addAll(McuFactory.getGDMcuTree(mcuType));
            mcuType = "mcu_riscv";
            McuList.addAll(McuFactory.getGDMcuTree(mcuType));
        } else if (projectType == 1 || projectType == 2 || projectType == 3) {
            mcuType = "mcu_arm";
            McuList.addAll(McuFactory.getMcuTree(mcuType));
            mcuType = "mcu_riscv";
            McuList.addAll(McuFactory.getMcuTree(mcuType));
        }
        Object[] MCUList = McuList.toArray();
        MCUs lastPartialMatchedMcu = null;
        McuGroup lastPartialMatchedGroup = null;
        McuSubGroup lastPartialMatchedSubGroup = null;
        int i = 0;
        while (i < MCUList.length) {
            McuGroup McuGroupObj = (McuGroup)MCUList[i];
            String fwlibType = McuGroupObj.getFwlibType();
            List<Object> McuSubGroupList = McuGroupObj.getChildren();
            int j = 0;
            while (j < McuSubGroupList.size()) {
                McuSubGroup McuSubGroupObj = (McuSubGroup)McuSubGroupList.get(j);
                List<Object> McuPartList = McuSubGroupObj.getChildren();
                int n = 0;
                while (n < McuPartList.size()) {
                    boolean isLastMcu;
                    MCUs mcuobj = (MCUs)McuPartList.get(n);
                    boolean flag = false;
                    if (projectType == 2) {
                        if (mcuobj.getName().contains(TempMCUPartNo)) {
                            mcuSeletorInfoObj.setMCUPart(mcuobj.getName());
                            flag = true;
                        }
                    } else if (projectType == 3) {
                        int matchResult = McuFactory.isMCUPartMatch(TempMCUPartNo, mcuobj.getName());
                        if (matchResult == 2) {
                            mcuSeletorInfoObj.setMCUPart(mcuobj.getName());
                            flag = true;
                        } else if (matchResult == 1) {
                            lastPartialMatchedMcu = mcuobj;
                            lastPartialMatchedGroup = McuGroupObj;
                            lastPartialMatchedSubGroup = McuSubGroupObj;
                        }
                    } else if (mcuobj.getName().equals(TempMCUPartNo)) {
                        flag = true;
                    }
                    boolean bl = isLastMcu = i == MCUList.length - 1 && j == McuSubGroupList.size() - 1 && n == McuPartList.size() - 1;
                    if (isLastMcu && !flag && lastPartialMatchedMcu != null) {
                        mcuobj = lastPartialMatchedMcu;
                        McuGroupObj = lastPartialMatchedGroup;
                        McuSubGroupObj = lastPartialMatchedSubGroup;
                        mcuSeletorInfoObj.setMCUPart(mcuobj.getName());
                        flag = true;
                    }
                    if (flag) {
                        lastMatchSucceeded = true;
                        String MCUGroup = McuGroupObj.getName();
                        String Series = McuSubGroupObj.getName();
                        String Core = McuSubGroupObj.getCPUCore();
                        String PerisRelationFilePath = McuSubGroupObj.getRelationFilePath();
                        String RCUPath = McuSubGroupObj.getRCUPath();
                        String CodeGroup = McuSubGroupObj.getCodeGroup();
                        String periConfigAndCodePath = McuSubGroupObj.getPeriConfigAndCodePath();
                        boolean SupportCodeGen = McuSubGroupObj.getSupportCodeGen();
                        String spPeri2FuncFilePath = McuSubGroupObj.getSPPeri2FuncFilePath();
                        if (CodeGroup.equals("")) {
                            CodeGroup = MCUGroup;
                        }
                        String FlashSize = mcuobj.getFlashSize();
                        String RamSize = mcuobj.getRamSize();
                        String PackageType = mcuobj.getPackageType();
                        String IO = mcuobj.getIO();
                        String DataSheetPath = mcuobj.getDataSheetPath();
                        String AFIOPath = mcuobj.getAFIOPath();
                        String PeriTreeFilePath = mcuobj.getPerisTreeFilePath();
                        String SVD = mcuobj.getSVD();
                        ArrayList<String> Symbols = mcuobj.getSymbols();
                        mcuSeletorInfoObj.setFwlibType(fwlibType);
                        LinkedHashMap<String, CoreInfo> CoreInfoMap = mcuobj.getCoreMap();
                        LinkedHashMap<String, CoreInfo> MCUSubGroupCoreInfoMap = ((McuSubGroup)mcuobj.getParent()).getCoreMap();
                        mcuSeletorInfoObj.setMCUPart(mcuobj.getName());
                        mcuSeletorInfoObj.setCodeGroup(CodeGroup);
                        mcuSeletorInfoObj.setMCUGroup(MCUGroup);
                        mcuSeletorInfoObj.setSeries(Series);
                        mcuSeletorInfoObj.setCore(Core);
                        mcuSeletorInfoObj.setFlashSize(FlashSize);
                        mcuSeletorInfoObj.setPackageType(PackageType);
                        mcuSeletorInfoObj.setRamSize(RamSize);
                        mcuSeletorInfoObj.setIOType(IO);
                        mcuSeletorInfoObj.setDataSheetPath(DataSheetPath);
                        mcuSeletorInfoObj.setAFIOPath(AFIOPath);
                        mcuSeletorInfoObj.setPerisTreeFilePath(PeriTreeFilePath);
                        mcuSeletorInfoObj.setPerisRelationFilePath(PerisRelationFilePath);
                        mcuSeletorInfoObj.setRCUPath(RCUPath);
                        mcuSeletorInfoObj.setSvdPath(SVD);
                        mcuSeletorInfoObj.setSymbols(Symbols);
                        mcuSeletorInfoObj.setSupportCodeGen(SupportCodeGen);
                        mcuSeletorInfoObj.setCoreInfoMap(CoreInfoMap);
                        mcuSeletorInfoObj.setMCUSubGroupCoreInfoMap(MCUSubGroupCoreInfoMap);
                        mcuSeletorInfoObj.setSPPeri2FuncFilePath(spPeri2FuncFilePath);
                        mcuSeletorInfoObj.setMcuObj(mcuobj);
                        mcuSeletorInfoObj.setPeriConfigAndCodePath(periConfigAndCodePath);
                        return mcuSeletorInfoObj;
                    }
                    ++n;
                }
                ++j;
            }
            ++i;
        }
        return mcuSeletorInfoObj;
    }

    public static int isMCUPartMatch(String tempMCUPartNo, String mcuPartNo) {
        int mcuSuffixLength;
        if (tempMCUPartNo == null) {
            return 0;
        }
        tempMCUPartNo = tempMCUPartNo.toUpperCase();
        mcuPartNo = mcuPartNo.toUpperCase();
        if (!tempMCUPartNo.startsWith("GD32") || tempMCUPartNo.length() < 8) {
            return 0;
        }
        int middleLength = Character.isDigit(tempMCUPartNo.charAt(5)) ? 4 : (!Character.isDigit(tempMCUPartNo.charAt(6)) ? 4 : 5);
        int prefixMiddleLength = 4 + middleLength;
        if (tempMCUPartNo.length() < prefixMiddleLength || mcuPartNo.length() < prefixMiddleLength) {
            return 0;
        }
        boolean hasNoSuffix = tempMCUPartNo.length() == prefixMiddleLength;
        int i = 0;
        while (i < prefixMiddleLength) {
            char tempChar = tempMCUPartNo.charAt(i);
            char mcuChar = mcuPartNo.charAt(i);
            if (tempChar != 'X' && tempChar != 'x' && tempChar != mcuChar) {
                return 0;
            }
            ++i;
        }
        if (hasNoSuffix) {
            return 1;
        }
        int tempSuffixLength = tempMCUPartNo.length() - prefixMiddleLength;
        if (tempSuffixLength > (mcuSuffixLength = mcuPartNo.length() - prefixMiddleLength)) {
            return 1;
        }
        int i2 = 0;
        while (i2 < tempSuffixLength) {
            char tempChar = tempMCUPartNo.charAt(prefixMiddleLength + i2);
            char mcuChar = mcuPartNo.charAt(prefixMiddleLength + i2);
            if (tempChar != 'X' && tempChar != 'x' && tempChar != mcuChar) {
                return 1;
            }
            ++i2;
        }
        return 2;
    }

    public static boolean isLastMatchSucceeded() {
        return lastMatchSucceeded;
    }

    public static int getMaxIndex(LinkedHashMap<String, CoreInfo> map, String CoreName) {
        int index = -1;
        Set<String> CoreSet = map.keySet();
        for (String Core : CoreSet) {
            if (!Core.contains(CoreName)) continue;
            if (Core.contains("_")) {
                int temp = Integer.parseInt(Core.split("_")[1]);
                if (temp <= index) continue;
                index = temp;
                continue;
            }
            if (index != -1) continue;
            index = 0;
            CoreInfo tempCorenfo = map.get(CoreName);
            String newCoreName = String.valueOf(CoreName) + "_0";
            map.remove(CoreName);
            map.put(newCoreName, tempCorenfo);
        }
        return index + 1;
    }

    public static void addOptions(Node ConfigNode, CoreInfo coreInfo, MCUs MCU) {
        if (ConfigNode.getNodeName().equals("Options")) {
            NodeList OptionNodes = ConfigNode.getChildNodes();
            int i = 0;
            while (i < OptionNodes.getLength()) {
                Node OptionNode = OptionNodes.item(i);
                if (OptionNode.getNodeName().equals("Option")) {
                    String OptionID = "";
                    String OptionValue = "";
                    String OptionType = "";
                    NamedNodeMap OptionAttribute = OptionNode.getAttributes();
                    int tmp = 0;
                    while (tmp < OptionAttribute.getLength()) {
                        Node AttributeNode = OptionAttribute.item(tmp);
                        if (AttributeNode.getNodeName().equals("id")) {
                            OptionID = AttributeNode.getNodeValue();
                        } else if (AttributeNode.getNodeName().equals("value")) {
                            OptionValue = AttributeNode.getNodeValue();
                        } else if (AttributeNode.getNodeName().equals("type")) {
                            OptionType = AttributeNode.getNodeValue();
                        }
                        ++tmp;
                    }
                    if (OptionID.length() == 0 || OptionValue.length() == 0) {
                        NodeList Option = OptionNode.getChildNodes();
                        int j = 0;
                        while (j < Option.getLength()) {
                            Node OptionSubNode = Option.item(j);
                            if (OptionSubNode.getNodeName().equals("id")) {
                                OptionID = OptionSubNode.getTextContent();
                            } else if (OptionSubNode.getNodeName().equals("value")) {
                                OptionValue = OptionSubNode.getTextContent();
                            } else if (OptionSubNode.getNodeName().equals("type")) {
                                OptionType = OptionSubNode.getTextContent();
                            }
                            ++j;
                        }
                    }
                    if (coreInfo != null) {
                        coreInfo.addOptions(OptionID, OptionValue, OptionType);
                    } else if (MCU != null) {
                        MCU.addOptions(OptionID, OptionValue, OptionType);
                    }
                }
                ++i;
            }
        }
    }

    public static CoreInfo getCoreInfo(Node LeafNode, String CoreName, String CoreIndex, String LdFile, String APIndex, String Startup, String Openocd) {
        CoreInfo coreInfo = new CoreInfo();
        coreInfo.setCoreID(CoreName);
        coreInfo.setCoreIndex(CoreIndex);
        coreInfo.setLdFile(LdFile);
        coreInfo.setAPIndex(APIndex);
        coreInfo.setStartup(Startup);
        coreInfo.setOpenocd(Openocd);
        NodeList ConfigNodes = LeafNode.getChildNodes();
        int ConfigLength = ConfigNodes.getLength();
        int c = 0;
        while (c < ConfigLength) {
            int i;
            Node ConfigNode = ConfigNodes.item(c);
            if (ConfigNode.getNodeName().equals("Options")) {
                McuFactory.addOptions(ConfigNode, coreInfo, null);
            } else if (ConfigNode.getNodeName().equals("ExcludeResourceFromBuild")) {
                NodeList ResourceNodes = ConfigNode.getChildNodes();
                i = 0;
                while (i < ResourceNodes.getLength()) {
                    Node ResourceNode = ResourceNodes.item(i);
                    if (ResourceNode.getNodeName().equals("Resource")) {
                        coreInfo.addExcludeResource(ResourceNode.getTextContent());
                    }
                    ++i;
                }
            } else if (ConfigNode.getNodeName().equals("Symbols")) {
                NodeList SymbolNodes = ConfigNode.getChildNodes();
                i = 0;
                while (i < SymbolNodes.getLength()) {
                    Node SymbolNode = SymbolNodes.item(i);
                    if (SymbolNode.getNodeName().equals("Symbol")) {
                        coreInfo.addSymbol(SymbolNode.getTextContent());
                    }
                    ++i;
                }
            }
            ++c;
        }
        return coreInfo;
    }

    public static ArrayList<String> getFileParaList(String FileType, MCUs mcu) {
        McuFactory.analyseFiles(FileType, mcu);
        ArrayList<String> List2 = new ArrayList<String>();
        switch (FileType) {
            case "ld": {
                List2 = mcu.getLdFiles();
                break;
            }
            case "startup": {
                List2 = mcu.getStartups();
                break;
            }
            case "openocd": {
                List2 = mcu.getOpenocds();
                break;
            }
        }
        return List2;
    }

    public static void analyseFiles(String FileType, MCUs mcu) {
        CoreInfo coreInfo;
        Set<String> Set2;
        McuSubGroup mcusubgroup = (McuSubGroup)mcu.getParent();
        if (!McuFactory.ContinueAnalyse(FileType, mcu).booleanValue()) {
            return;
        }
        LinkedHashMap<String, CoreInfo> CoreMap = mcu.getCoreMap();
        if (CoreMap.size() > 0) {
            Set2 = CoreMap.keySet();
            for (String string : Set2) {
                coreInfo = CoreMap.get(string);
                McuFactory.addFile(FileType, coreInfo, "", "", true, mcu);
            }
        }
        if (!McuFactory.ContinueAnalyse(FileType, mcu).booleanValue()) {
            return;
        }
        CoreMap = mcusubgroup.getCoreMap();
        if (CoreMap.size() > 0) {
            Set2 = CoreMap.keySet();
            for (String string : Set2) {
                coreInfo = CoreMap.get(string);
                McuFactory.addFile(FileType, coreInfo, "", "", true, mcu);
            }
        }
        if (!McuFactory.ContinueAnalyse(FileType, mcu).booleanValue()) {
            return;
        }
        String SubGroupLdFile = McuFactory.getSubGroupPara(FileType, mcusubgroup);
        if (SubGroupLdFile.length() > 0) {
            McuFactory.addFile(FileType, null, SubGroupLdFile, "", true, mcu);
        }
        if (!McuFactory.ContinueAnalyse(FileType, mcu).booleanValue()) {
            return;
        }
        McuGroup mcugroup = (McuGroup)mcusubgroup.getParent();
        String ChipGroupName = mcugroup.getName();
        if (mcusubgroup.getCPUCore().toLowerCase().contains("risc")) {
            McuFactory.addFile(FileType, null, "", ChipGroupName, false, mcu);
        } else {
            McuFactory.addFile(FileType, null, "", ChipGroupName, true, mcu);
        }
    }

    public static String getSubGroupPara(String FileType, McuSubGroup mcusubgroup) {
        String SubGroupPara = "";
        switch (FileType) {
            case "ld": {
                SubGroupPara = mcusubgroup.getLdFiles();
                break;
            }
            case "startup": {
                SubGroupPara = mcusubgroup.getStartups();
                break;
            }
            case "openocd": {
                SubGroupPara = mcusubgroup.getOpenocds();
            }
        }
        return SubGroupPara;
    }

    public static void addFile(String FileType, CoreInfo coreInfo, String Files, String ChipGroupName, Boolean isARM, MCUs mcu) {
        switch (FileType) {
            case "ld": {
                if (coreInfo != null) {
                    String LdFile = coreInfo.getLdFile();
                    if (LdFile.length() <= 0) break;
                    mcu.addLdFile(LdFile);
                    break;
                }
                if (Files.length() > 0) {
                    mcu.setLdFiles(Files);
                    break;
                }
                String ld = "";
                ld = isARM != false ? String.valueOf(ChipGroupName.toLowerCase()) + "_flash.ld" : String.valueOf(ChipGroupName.toUpperCase()) + ".lds";
                mcu.setLdFiles(ld);
                break;
            }
            case "startup": {
                if (coreInfo != null) {
                    String Startup = coreInfo.getStartup();
                    if (Startup.length() <= 0) break;
                    mcu.addStartup(Startup);
                    break;
                }
                if (Files.length() > 0) {
                    mcu.setStartups(Files);
                    break;
                }
                String startup = "";
                if (!isARM.booleanValue()) break;
                startup = "startup_" + ChipGroupName.toLowerCase() + ".S";
                mcu.setStartups(startup);
                break;
            }
            case "openocd": {
                if (coreInfo != null) {
                    String Openocd = coreInfo.getOpenocd();
                    if (Openocd.length() <= 0) break;
                    mcu.addOpenocd(Openocd);
                    break;
                }
                if (Files.length() > 0) {
                    mcu.setOpenocds(Files);
                    break;
                }
                mcu.setOpenocds("openocd_gdlink.cfg");
                break;
            }
        }
    }

    public static Boolean ContinueAnalyse(String FileType, MCUs mcu) {
        switch (FileType) {
            case "ld": {
                if (mcu.getLdFiles().size() <= 0) break;
                return false;
            }
            case "startup": {
                if (mcu.getStartups().size() <= 0) break;
                return false;
            }
            case "openocd": {
                if (mcu.getOpenocds().size() <= 0) break;
                return false;
            }
        }
        return true;
    }

    public static String getFirmwareVersion(String Core, String Chip) {
        try {
            if (Core.contains("cortex")) {
                Core = "ARM";
            } else if (Core.contains("risc")) {
                Core = "risc";
            }
            String SourcePath = McuFactory.getFirmwarePath(Core, Chip);
            String firmwareFilePath = "";
            firmwareFilePath = Core.equalsIgnoreCase("arm") ? String.valueOf(SourcePath) + File.separator + "Firmware" + File.separator + "CMSIS" + File.separator + "GD" + File.separator + Chip.toUpperCase() + File.separator + "Include" + File.separator + Chip.toLowerCase() + ".h" : String.valueOf(SourcePath) + File.separator + "src" + File.separator + "main.c";
            Path p = Paths.get(firmwareFilePath, new String[0]);
            String VersionInfo = McuFactory.firstVersionInfoSimple(p);
            try {
                if (VersionInfo.contains(",")) {
                    String[] splitVersion = VersionInfo.split(",");
                    VersionInfo = String.valueOf(splitVersion[1]) + "(" + splitVersion[0] + ")";
                }
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(Chip) + "\u7eef\u8bf2\u57aa\u9365\u8f70\u6b22\u6434\u64b6\u5897\u93c8\ue101\u7278\u5bee\u5fdb\u654a\u7487\ufffd");
            }
            return VersionInfo;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String firstVersionInfoSimple(Path file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String line;
            while ((line = br.readLine()) != null) {
                String tail;
                int idx = line.indexOf("\\version");
                if (idx < 0 || idx != 0 && !Character.isWhitespace(line.charAt(idx - 1)) && line.charAt(idx - 1) != '*' && line.charAt(idx - 1) != '/' || (tail = line.substring(idx + "\\version".length()).trim()).isEmpty()) continue;
                return tail;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }
}

