/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.clockconfiginfo;

import com.gigadevice.venustool.clockconfiginfo.ControlinGroup;
import com.gigadevice.venustool.clockconfiginfo.RCUClockSource;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigControl;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigControlGroup;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigImage;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigInfo_Abstract;
import com.gigadevice.venustool.clockconfiginfo.RCUFunctionUtil;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class RCUCondition {
    public static Set<RCUConfigImage> RCUConfigImageList = new HashSet<RCUConfigImage>();
    public static Map<String, RCUConfigControl> RCUConfigControlMap = new HashMap<String, RCUConfigControl>();
    public static Map<String, RCUConfigControlGroup> RCUConfigControlGroupMap = new HashMap<String, RCUConfigControlGroup>();
    public static Map<String, RCUClockSource> RCUClockSourceMap = new HashMap<String, RCUClockSource>();
    public static Map<String, RCUConfigControl> TempRCUConfigControlMap = new HashMap<String, RCUConfigControl>();
    public static Map<String, RCUConfigControlGroup> TempRCUConfigControlGroupMap = new HashMap<String, RCUConfigControlGroup>();
    public static Map<String, RCUClockSource> TempRCUClockSourceMap = new HashMap<String, RCUClockSource>();
    public static final String Type_Combo = "COMBO";
    public static final String Type_Edit = "EDIT";
    public static final String Type_Label = "LABEL";
    public static final String Type_Selector = "SELECTOR";

    public static boolean GetRCUControlState(String ControlName) {
        RCUConfigInfo_Abstract ObjClass = RCUCondition.GetRCUClassTypebyName(ControlName);
        if (ObjClass == null) {
            return false;
        }
        int RCUConfigClassType = ObjClass.getRCUConfigClassType();
        if (RCUConfigClassType == 1) {
            if (((RCUClockSource)ObjClass).getControlComponent() == null) {
                return false;
            }
            if (((RCUClockSource)ObjClass).getControlComponent().isEnabled()) {
                return true;
            }
        } else if (RCUConfigClassType == 2) {
            if (((RCUConfigControl)ObjClass).getControlComponent() == null) {
                return false;
            }
            if (((RCUConfigControl)ObjClass).getControlComponent().isEnabled()) {
                return true;
            }
        } else if (RCUConfigClassType == 4) {
            if (((ControlinGroup)ObjClass).getControlComponent() == null) {
                return false;
            }
            if (((ControlinGroup)ObjClass).getControlComponent().isEnabled()) {
                for (Map.Entry<String, RCUConfigControlGroup> entry : RCUConfigControlGroupMap.entrySet()) {
                    RCUConfigInfo_Abstract ObjGroupClass;
                    if (!entry.getValue().getControlGroup().containsKey(ControlName) || (ObjGroupClass = (RCUConfigInfo_Abstract)entry.getValue()) == null) continue;
                    return ((RCUConfigControlGroup)ObjGroupClass).getControlDefault(ControlName);
                }
            }
        }
        return false;
    }

    public static RCUConfigInfo_Abstract GetRCUClassTypebyName(String name) {
        RCUConfigInfo_Abstract ObjClass = null;
        if (RCUConfigControlMap.size() > 0) {
            ObjClass = RCUConfigControlMap.get(name);
        }
        if (ObjClass == null && RCUConfigControlGroupMap.size() > 0) {
            for (Map.Entry<String, RCUConfigControlGroup> entry : RCUConfigControlGroupMap.entrySet()) {
                if (!entry.getValue().getControlGroup().containsKey(name)) continue;
                ObjClass = entry.getValue().getControlGroup().get(name);
            }
        }
        if (ObjClass == null && RCUClockSourceMap.size() > 0) {
            ObjClass = RCUClockSourceMap.get(name);
        }
        return ObjClass;
    }

    public static double GetRCUControlValue(String name) {
        double Value = 0.0;
        RCUConfigInfo_Abstract Obj = RCUCondition.GetRCUClassTypebyName(name);
        if (Obj != null) {
            RCUConfigControl rCUConfigControlObj;
            String Type2;
            boolean isComboItem = false;
            double comboItemValue = 0.0;
            int rCUConfigClassType = Obj.getRCUConfigClassType();
            if (rCUConfigClassType == 2 && (Type2 = (rCUConfigControlObj = (RCUConfigControl)Obj).getType()).toUpperCase().equals(Type_Combo) && rCUConfigControlObj.getDisplayText() != null) {
                String displayText = rCUConfigControlObj.getDisplayText();
                String sString = rCUConfigControlObj.GetCurrentEnumValue(displayText);
                comboItemValue = Double.parseDouble(sString);
                isComboItem = true;
            }
            Value = isComboItem ? comboItemValue : Obj.getControlCurrentValue();
        }
        return Value;
    }

    public static boolean ConditionExaminebyType1(String ControlName, String ClockInput) {
        RCUConfigInfo_Abstract Obj;
        boolean ConditionResult = false;
        boolean isFind = false;
        if (RCUConfigControlMap.size() > 0) {
            Obj = RCUConfigControlMap.get(ControlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind && ((RCUConfigControl)Obj).getClockInputName(ControlName).toUpperCase().equals(ClockInput.toUpperCase())) {
                ConditionResult = true;
            }
        }
        if (!isFind && RCUConfigControlGroupMap.size() > 0) {
            Obj = RCUConfigControlGroupMap.get(ControlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind && ((RCUConfigControlGroup)Obj).getControlDefault(ClockInput)) {
                ConditionResult = true;
            }
        }
        return ConditionResult;
    }

    public static boolean ConditionExaminebyType2(String ControlName, String MaximumValue, String MinimumValue) {
        boolean ConditionResult = false;
        boolean isFind = false;
        if (RCUConfigControlMap.size() > 0) {
            RCUConfigControl Obj = RCUConfigControlMap.get(ControlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                JTextField Comp;
                String Text;
                double Val;
                double MaximumVal = Double.parseDouble(MaximumValue);
                double MinimumVal = Double.parseDouble(MinimumValue);
                if (Obj.getType().toUpperCase().equals(Type_Edit) && (Val = Double.parseDouble(Text = (Comp = (JTextField)Obj.getControlComponent()) == null ? Obj.getControlCurrentTextValue() : Comp.getText())) <= MaximumVal && Val > MinimumVal) {
                    ConditionResult = true;
                }
            }
        }
        return ConditionResult;
    }

    public static boolean ConditionExaminebyType4(String ControlName, String ControlValue) {
        Component controlComponent;
        RCUConfigInfo_Abstract Obj;
        boolean ConditionResult = false;
        boolean isFind = false;
        if (RCUConfigControlMap.size() > 0) {
            Obj = RCUConfigControlMap.get(ControlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                controlComponent = ((RCUConfigControl)Obj).getControlComponent();
                if (controlComponent != null && !controlComponent.isEnabled()) {
                    return false;
                }
                if (ControlValue.equals(((RCUConfigControl)Obj).GetCurrentEnumValue())) {
                    ConditionResult = true;
                }
            }
        }
        if (isFind) {
            return ConditionResult;
        }
        if (RCUConfigControlGroupMap.size() > 0) {
            Obj = RCUConfigControlGroupMap.get(ControlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                String currentText = Obj.getControlCurrentTextValue();
                JRadioButton radioButton = (JRadioButton)((RCUConfigControlGroup)Obj).getControlComponent(ControlValue);
                if (radioButton != null) {
                    if (!radioButton.isEnabled()) {
                        return false;
                    }
                    if (radioButton.isSelected() && currentText.equals(ControlValue)) {
                        ConditionResult = true;
                    }
                } else if (ControlValue.equals(Obj.getControlCurrentTextValue())) {
                    ConditionResult = true;
                }
            }
        }
        if (isFind) {
            return ConditionResult;
        }
        if (RCUClockSourceMap.size() > 0) {
            Obj = RCUClockSourceMap.get(ControlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                controlComponent = ((RCUClockSource)Obj).getControlComponent();
                if (controlComponent == null) {
                    if (ControlValue.equals(Obj.getControlCurrentTextValue())) {
                        ConditionResult = true;
                    }
                } else {
                    if (!controlComponent.isEnabled()) {
                        return false;
                    }
                    double CurrentValue = ((RCUClockSource)Obj).getControlCurrentValue();
                    if (CurrentValue == Double.valueOf(ControlValue)) {
                        ConditionResult = true;
                    }
                }
            }
        }
        if (isFind) {
            return ConditionResult;
        }
        return ConditionResult;
    }

    public static boolean CheckRCUControlValue(String controlName, String itemName) {
        return RCUCondition.ConditionExaminebyType4(controlName, itemName);
    }

    public static String getClockCurrentValue(String controlName) {
        RCUConfigInfo_Abstract Obj;
        boolean isFind = false;
        if (RCUConfigControlMap.size() > 0) {
            Obj = RCUConfigControlMap.get(controlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                String type = ((RCUConfigControl)Obj).getType();
                if (type.equals("Combo")) {
                    return ((RCUConfigControl)Obj).GetCurrentEnumValue();
                }
                if (type.equals("Edit")) {
                    JTextField jTextField = (JTextField)((RCUConfigControl)Obj).getControlComponent();
                    if (jTextField == null) {
                        return Obj.getControlCurrentTextValue();
                    }
                    if (jTextField != null) {
                        return jTextField.getText();
                    }
                }
            }
        }
        if (RCUClockSourceMap.size() > 0) {
            Obj = RCUClockSourceMap.get(controlName);
            if (Obj != null) {
                isFind = true;
            }
            if (isFind) {
                double CurrentValue = ((RCUClockSource)Obj).getControlCurrentValue();
                return String.valueOf(CurrentValue);
            }
        }
        return "";
    }

    public static Map<String, Vector<String>> checkClockTree() {
        HashMap<String, Vector<String>> clockTreeInvalidMap = new HashMap<String, Vector<String>>();
        for (Map.Entry<String, RCUConfigControlGroup> entry : RCUConfigControlGroupMap.entrySet()) {
            Vector vectorTemp;
            String keyTemp = entry.getKey();
            RCUConfigControlGroup valueTemp = entry.getValue();
            Map<String, ControlinGroup> controlinGroupMap = valueTemp.getControlGroup();
            int sizecontrolinGroupMap = controlinGroupMap.size();
            boolean isInvalid = false;
            String SelectorCurInputName = "";
            for (Map.Entry<String, ControlinGroup> controlinGroupMapEntry : controlinGroupMap.entrySet()) {
                ControlinGroup controlinGroup = controlinGroupMapEntry.getValue();
                JRadioButton radioButton = (JRadioButton)controlinGroup.getControlComponent();
                if (radioButton.isSelected()) {
                    SelectorCurInputName = controlinGroupMapEntry.getValue().getClockInputName("");
                }
                if (!radioButton.isEnabled()) {
                    --sizecontrolinGroupMap;
                }
                if (!radioButton.isEnabled() || !radioButton.isSelected()) continue;
                isInvalid = true;
                break;
            }
            if (sizecontrolinGroupMap == 0) continue;
            String errorInfo = "The \"" + SelectorCurInputName + "\" option selected by selector " + "\"" + keyTemp + "\" is invalid;";
            if (isInvalid) continue;
            if (clockTreeInvalidMap.containsKey("Selector")) {
                vectorTemp = (Vector)clockTreeInvalidMap.get("Selector");
                vectorTemp.add(errorInfo);
                continue;
            }
            vectorTemp = new Vector();
            vectorTemp.add(errorInfo);
            clockTreeInvalidMap.put("Selector", vectorTemp);
        }
        return clockTreeInvalidMap;
    }

    public static Map<String, Vector<String>> getClockTreeErrorInfo() {
        HashMap<String, Vector<String>> clockTreeInvalidMap = new HashMap<String, Vector<String>>();
        for (Map.Entry<String, RCUConfigControlGroup> entry : RCUConfigControlGroupMap.entrySet()) {
            Vector vectorTemp;
            entry.getKey();
            RCUConfigControlGroup valueTemp = entry.getValue();
            Map<String, ControlinGroup> controlinGroupMap = valueTemp.getControlGroup();
            int sizecontrolinGroupMap = controlinGroupMap.size();
            boolean isInvalid = false;
            String SelectorCurControlName = "";
            for (Map.Entry<String, ControlinGroup> controlinGroupMapEntry : controlinGroupMap.entrySet()) {
                ControlinGroup controlinGroup = controlinGroupMapEntry.getValue();
                JRadioButton radioButton = (JRadioButton)controlinGroup.getControlComponent();
                if (radioButton == null) continue;
                if (radioButton.isSelected()) {
                    SelectorCurControlName = controlinGroupMapEntry.getValue().getControlName();
                    controlinGroupMapEntry.getValue().getClockInputName("");
                }
                if (!radioButton.isEnabled()) {
                    --sizecontrolinGroupMap;
                }
                if (!radioButton.isEnabled() || !radioButton.isSelected()) continue;
                isInvalid = true;
                break;
            }
            if (sizecontrolinGroupMap == 0 || isInvalid) continue;
            if (clockTreeInvalidMap.containsKey("Selector")) {
                vectorTemp = (Vector)clockTreeInvalidMap.get("Selector");
                vectorTemp.add(SelectorCurControlName);
                continue;
            }
            vectorTemp = new Vector();
            vectorTemp.add(SelectorCurControlName);
            clockTreeInvalidMap.put("Selector", vectorTemp);
        }
        return clockTreeInvalidMap;
    }

    public static Map<String, String> getClockTreeErrorInfo_MinMax() {
        HashMap<String, String> clockTreeInvalidMap = new HashMap<String, String>();
        if (RCUConfigControlMap.size() > 0) {
            for (Map.Entry<String, RCUConfigControl> entry : RCUConfigControlMap.entrySet()) {
                double CurrentValue;
                String IntervalValue;
                String MaxValue;
                RCUConfigControl RCUConfigControlTemp;
                String MinValue;
                String clockName = entry.getKey();
                String reString = RCUCondition.checkMinMax(clockName, MinValue = (RCUConfigControlTemp = entry.getValue()).getMinValue(), MaxValue = RCUConfigControlTemp.getMaxValue(), IntervalValue = RCUConfigControlTemp.getIntervalValue(), CurrentValue = RCUConfigControlTemp.getControlCurrentValue());
                if (reString.equals("")) continue;
                clockTreeInvalidMap.put(clockName, reString);
            }
        }
        return clockTreeInvalidMap;
    }

    public static String checkMinMax(String clockName, String MinValue, String MaxValue, String IntervalValue, double CurrentValue) {
        Boolean isEnable = RCUCondition.GetRCUControlState(clockName);
        if (!isEnable.booleanValue()) {
            return "";
        }
        Boolean hasDisplayText = RCUCondition.CheckControlHasDisplayText(clockName);
        if (!hasDisplayText.booleanValue()) {
            return "";
        }
        if (MaxValue == null && MinValue == null && IntervalValue == null) {
            return "";
        }
        if (MinValue != null && CurrentValue < Double.valueOf(MinValue)) {
            String Content = String.valueOf(clockName) + " value is invalid, it must be great than " + MinValue + ".";
            return Content;
        }
        if (MaxValue != null && CurrentValue > Double.valueOf(MaxValue)) {
            String Content = String.valueOf(clockName) + " value is invalid, it must be less than " + MaxValue + ".";
            return Content;
        }
        if (IntervalValue != null) {
            boolean isWithInInterval = false;
            Vector<String> intervalVector = RCUFunctionUtil.parseIntervalValue(IntervalValue);
            int i = 0;
            while (i < intervalVector.size()) {
                String intervalValue = intervalVector.get(i);
                isWithInInterval = isWithInInterval || RCUFunctionUtil.checkIntervalValue(intervalValue, CurrentValue);
                ++i;
            }
            if (!isWithInInterval) {
                String Content = String.valueOf(clockName) + " value is invalid, it must be within the interval: " + IntervalValue + ".";
                return Content;
            }
        }
        return "";
    }

    public static boolean CheckControlHasDisplayText(String ControlName) {
        RCUConfigInfo_Abstract ObjClass = RCUCondition.GetRCUClassTypebyName(ControlName);
        if (ObjClass == null) {
            return false;
        }
        int RCUConfigClassType = ObjClass.getRCUConfigClassType();
        if (RCUConfigClassType == 1) {
            String displayValue;
            if (((RCUClockSource)ObjClass).getControlComponent() == null) {
                return false;
            }
            Component component = ((RCUConfigControl)ObjClass).getControlComponent();
            if (component instanceof JTextField && (displayValue = ((JTextField)component).getText()).equals("")) {
                return false;
            }
        } else if (RCUConfigClassType == 2) {
            if (((RCUConfigControl)ObjClass).getControlComponent() == null) {
                return false;
            }
            Component component = ((RCUConfigControl)ObjClass).getControlComponent();
            if (component instanceof JTextField) {
                Object selectedItem;
                String displayValue = ((JTextField)component).getText();
                if (displayValue.equals("")) {
                    return false;
                }
                if (component instanceof JComboBox && (selectedItem = ((JComboBox)component).getSelectedItem()) == null) {
                    return false;
                }
            }
        } else if (RCUConfigClassType == 4 && ((ControlinGroup)ObjClass).getControlComponent() == null) {
            return false;
        }
        return true;
    }
}

