/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.baseinfo;

import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class mComboBox
extends JComboBox {
    private Set<Object> disabled_items = new HashSet<Object>();
    private NodeStruct nodeObj = new NodeStruct();

    public mComboBox(String[] Items) {
        super.setRenderer(new DisabledItemsRenderer());
        int i = 0;
        while (i < Items.length) {
            this.addItem(Items[i]);
            ++i;
        }
        this.setupEventListeners();
    }

    public mComboBox(List<String> Items) {
        super.setRenderer(new DisabledItemsRenderer());
        int i = 0;
        while (i < Items.size()) {
            this.addItem(Items.get(i));
            ++i;
        }
        this.setupEventListeners();
    }

    public mComboBox() {
        super.setRenderer(new DisabledItemsRenderer());
        this.setupEventListeners();
    }

    private void setupEventListeners() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                mComboBox.this.hidePopup();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                mComboBox.this.hidePopup();
            }
        });
        this.addHierarchyListener(e -> {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        mComboBox.this.hidePopup();
                    }

                    @Override
                    public void componentResized(ComponentEvent e) {
                        mComboBox.this.hidePopup();
                    }
                });
                window.addWindowFocusListener(new WindowAdapter(){

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        mComboBox.this.hidePopup();
                    }
                });
            }
        });
    }

    public void addItems(List<String> Items) {
        int i = 0;
        while (i < Items.size()) {
            super.addItem(Items.get(i));
            ++i;
        }
    }

    public void addItem(Object anObject) {
        super.addItem(anObject);
    }

    public void CtrlItem(int index, boolean bl) {
        if (!bl) {
            this.disabled_items.add(index);
        } else {
            this.disabled_items.remove(index);
        }
    }

    public void disableItem(Object anObject) {
        int i = 0;
        while (i < this.getItemCount()) {
            if (this.getItemAt(i).equals(anObject)) {
                this.disabled_items.add(i);
            }
            ++i;
        }
    }

    public void setNodeObj(NodeStruct nodeStruct) {
        this.nodeObj = nodeStruct;
    }

    public NodeStruct getNodeObj() {
        return this.nodeObj;
    }

    @Override
    public void removeAllItems() {
        super.removeAllItems();
        this.disabled_items = new HashSet<Object>();
    }

    @Override
    public void removeItemAt(int anIndex) {
        super.removeItemAt(anIndex);
        this.disabled_items.remove(anIndex);
    }

    @Override
    public void removeItem(Object anObject) {
        int i = 0;
        while (i < this.getItemCount()) {
            if (this.getItemAt(i).equals(anObject)) {
                this.disabled_items.remove(i);
            }
            ++i;
        }
    }

    public boolean containsItem(String item) {
        int i = 0;
        while (i < this.getModel().getSize()) {
            String tempItem = " " + this.getModel().getElementAt(i);
            if (tempItem.equals(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (!this.disabled_items.contains(index)) {
            super.setSelectedIndex(index);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    public void addScrollbars() {
        this.setUI(new CustomComboBoxWithScrollbarsUI());
    }

    public void addTooltips() {
        this.setRenderer(new CustomComboBoxRenderer());
    }

    private class CustomComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private CustomComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                renderer.setToolTipText(value.toString());
            }
            return renderer;
        }
    }

    private class CustomComboBoxWithScrollbarsUI
    extends MetalComboBoxUI {
        private CustomComboBoxWithScrollbarsUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){
                private static final long serialVersionUID = 1L;

                @Override
                protected JScrollPane createScroller() {
                    JScrollPane sp = new JScrollPane(this.list);
                    sp.setHorizontalScrollBarPolicy(30);
                    sp.setVerticalScrollBarPolicy(20);
                    return sp;
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }

    private class DisabledItemsRenderer
    extends BasicComboBoxRenderer {
        private DisabledItemsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (mComboBox.this.disabled_items.contains(index)) {
                this.setBackground(list.getBackground());
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

