/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.baseinfo.jtreenode;

import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JTreeTextNode
extends AbstractJTreeNode {
    private static final long serialVersionUID = 1L;
    private String editMaximumValue = "";
    private String editMinimumValue = "";
    private String editRegex = "";
    private String editByteLength = "";
    private String editMaxByteLength = "";
    private String editMinByteLength = "";
    private String InvalidStrLength = "";
    private boolean hasMax = false;
    private boolean hasMin = false;
    private boolean hasStrLength = false;
    private boolean hasMaxStrLength = false;
    private boolean hasMinStrLength = false;
    private boolean hasMaxMinStrLength = false;
    private boolean hasValidStrLength = true;
    private boolean hasRegExp = false;
    private String MaxStr = "";
    private String MinStr = "";
    private String editFractionDigits = "";
    private String editMaxFractionDigits = "";
    private String editMinFractionDigits = "";
    private String InvalidFractionDigits = "";
    private boolean hasFractionDigits = false;
    private boolean hasMaxFractionDigits = false;
    private boolean hasMinFractionDigits = false;
    private boolean hasMaxMinFractionDigits = false;
    private boolean hasValidFractionDigits = true;
    private String ControlType = "";
    private boolean hasControlType = false;
    private JPanel txtfieldPanel;
    private JLabel nameLabel;
    private JTextField txtfield;

    public JTreeTextNode(String name, String content, String value) {
        this.InitJTreeTextNode(name, content, value);
    }

    public void InitJTreeTextNode(String name, String content, String value) {
        this.setType(3);
        this.setName(name);
        this.setContent(content);
        this.initTextGUI(value);
    }

    private void initTextGUI(String value) {
        this.txtfieldPanel = new JPanel(new GridLayout());
        this.txtfieldPanel.setBackground(Color.white);
        this.nameLabel = new JLabel(this.getContent());
        this.nameLabel.setFont(new Font("Arial", 1, 15));
        this.txtfield = new JTextField(value);
        this.txtfield.setEditable(true);
        this.txtfield.setFont(new Font("Arial", 0, 15));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.txtfieldPanel.add((Component)this.nameLabel, gbc);
        gbc.gridx = 1;
        gbc.anchor = 2;
        this.txtfieldPanel.add((Component)this.txtfield, gbc);
        this.nameLabel.setToolTipText(this.getContent());
        this.txtfieldPanel.setToolTipText(this.getContent());
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.txtfield.setText(value);
    }

    @Override
    public void setNodeDisable() {
        this.nameLabel.setForeground(Color.GRAY);
        this.txtfield.setEditable(false);
    }

    @Override
    public void setNodeEnable() {
        this.nameLabel.setForeground(Color.BLACK);
        this.txtfield.setEditable(true);
    }

    public void setControlType(String ControlType2) {
        if (!ControlType2.isEmpty() && ControlType2 != null) {
            this.ControlType = ControlType2 = ControlType2.trim();
            this.setHasControlType(true);
        }
    }

    public boolean ifHasControlType() {
        return this.hasControlType;
    }

    public void setHasControlType(boolean hasControlType) {
        this.hasControlType = hasControlType;
    }

    public String getControlType() {
        return this.ControlType;
    }

    public String getEditRegex() {
        return this.editRegex;
    }

    public void setEditRegex(String editRegex) {
        if (!editRegex.isEmpty()) {
            this.editRegex = editRegex;
            this.RegExp(true);
        }
    }

    public String getEditByteLength() {
        return this.editByteLength;
    }

    public void setEditByteLengthValue(String value) {
        this.editByteLength = value;
    }

    public String getMaxEditByteLength() {
        return this.editMaxByteLength;
    }

    public void setMaxEditByteLength(String value) {
        this.editMaxByteLength = value;
    }

    public String getMinEditByteLength() {
        return this.editMinByteLength;
    }

    public void setMinEditByteLength(String value) {
        this.editMinByteLength = value;
    }

    public void setValidStrLength(String value) {
        this.InvalidStrLength = value;
    }

    public String[] geMaxtMinEditByteLength() {
        String[] numbersLength = new String[]{this.editMinByteLength, this.editMaxByteLength};
        return numbersLength;
    }

    public boolean ifHasStrLength() {
        return this.hasStrLength;
    }

    public boolean ifHasMaxStrLength() {
        return this.hasMaxStrLength;
    }

    public boolean ifHasMinStrLength() {
        return this.hasMinStrLength;
    }

    public boolean ifHasMaxMinStrLength() {
        return this.hasMaxMinStrLength;
    }

    public boolean ifHasValidStrLength() {
        return this.hasValidStrLength;
    }

    public void setHasStrLength(boolean hasStrLength) {
        this.hasStrLength = hasStrLength;
    }

    public void setHasStrMaxLength(boolean hasMaxStrLength) {
        this.hasMaxStrLength = hasMaxStrLength;
    }

    public void setHasStrMinLength(boolean hasMinStrLength) {
        this.hasMinStrLength = hasMinStrLength;
    }

    public void setHasStrMaxMinLength(boolean hasMaxMinStrLength) {
        this.hasMaxMinStrLength = hasMaxMinStrLength;
    }

    public void setHasValidStrLength(boolean hasValidStrLength) {
        this.hasValidStrLength = hasValidStrLength;
    }

    private void initStrLengthInfo() {
        this.hasStrLength = false;
        this.hasMaxStrLength = false;
        this.hasMinStrLength = false;
        this.hasMaxMinStrLength = false;
        this.hasValidStrLength = true;
        this.editByteLength = "";
        this.editMaxByteLength = "";
        this.editMinByteLength = "";
        this.InvalidStrLength = "";
    }

    public void setEditByteLength(String sLenth) {
        block7: {
            block8: {
                this.initStrLengthInfo();
                if (sLenth.equals("")) break block7;
                String[] numbersLenth = null;
                if (!sLenth.matches("\\[\\d+\\]") && !sLenth.matches("\\[\\d+,\\*\\]") && !sLenth.matches("\\[\\*,\\d+\\]") && !sLenth.matches("\\[\\d+,\\d+\\]")) break block8;
                this.setHasValidStrLength(true);
                sLenth = sLenth.trim().replaceAll("[\\[\\]]", "");
                numbersLenth = sLenth.split(",");
                switch (numbersLenth.length) {
                    case 1: {
                        this.editByteLength = numbersLenth[0];
                        this.setHasStrLength(true);
                        break;
                    }
                    case 2: {
                        if (numbersLenth[0].equals("*")) {
                            this.editMaxByteLength = numbersLenth[1];
                            this.setHasStrMaxLength(true);
                        }
                        if (numbersLenth[1].equals("*")) {
                            this.editMinByteLength = numbersLenth[0];
                            this.setHasStrMinLength(true);
                        }
                        if (!numbersLenth[0].equals("*") && !numbersLenth[1].equals("*")) {
                            this.editMinByteLength = numbersLenth[0];
                            this.editMaxByteLength = numbersLenth[1];
                            this.setHasStrMaxMinLength(true);
                            break;
                        }
                        break block7;
                    }
                    default: {
                        System.out.println("Invalid format. Expected a single number, a range, or a range with missing bounds.");
                        break;
                    }
                }
                break block7;
            }
            System.out.println("Invalid format: Expected format is [value1], [value1,*], [*,value1], [value1,value2]");
            this.setHasValidStrLength(false);
            this.InvalidStrLength = String.valueOf(sLenth) + " <-- INVALID";
        }
    }

    public String getEditFractionDigits() {
        return this.editFractionDigits;
    }

    public void setEditFractionDigitsValue(String value) {
        this.editFractionDigits = value;
    }

    public String getMaxEditFractionDigits() {
        return this.editMaxFractionDigits;
    }

    public void setMaxEditFractionDigits(String value) {
        this.editMaxFractionDigits = value;
    }

    public String getMinEditFractionDigits() {
        return this.editMinFractionDigits;
    }

    public void setMinEditFractionDigits(String value) {
        this.editMinFractionDigits = value;
    }

    public String getInvalidFractionDigits() {
        return this.InvalidFractionDigits;
    }

    public void setInvalidFractionDigits(String invalidFractionDigits) {
        this.InvalidFractionDigits = invalidFractionDigits;
    }

    public String[] geMaxtMinEditFractionDigits() {
        String[] decimalPlacesRange = new String[]{this.editMinFractionDigits, this.editMaxFractionDigits};
        return decimalPlacesRange;
    }

    public void setEditFractionDigits(String strFractionDigits) {
        block7: {
            block8: {
                this.initFractionDigitsInfo();
                if (strFractionDigits.equals("") || strFractionDigits == null) break block7;
                String[] decimalPlacesRange = null;
                if (!strFractionDigits.matches("\\[\\d+\\]") && !strFractionDigits.matches("\\[\\d+,\\*\\]") && !strFractionDigits.matches("\\[\\*,\\d+\\]") && !strFractionDigits.matches("\\[\\d+,\\d+\\]")) break block8;
                this.setHasValidFractionDigits(true);
                strFractionDigits = strFractionDigits.trim().replaceAll("[\\[\\]]", "");
                decimalPlacesRange = strFractionDigits.split(",");
                switch (decimalPlacesRange.length) {
                    case 1: {
                        this.editFractionDigits = decimalPlacesRange[0];
                        this.setHasFractionDigits(true);
                        break;
                    }
                    case 2: {
                        if (decimalPlacesRange[0].equals("*")) {
                            this.editMaxFractionDigits = decimalPlacesRange[1];
                            this.setHasMaxFractionDigits(true);
                        }
                        if (decimalPlacesRange[1].equals("*")) {
                            this.editMinFractionDigits = decimalPlacesRange[0];
                            this.setHasMinFractionDigits(true);
                        }
                        if (!decimalPlacesRange[0].equals("*") && !decimalPlacesRange[1].equals("*")) {
                            this.editMinFractionDigits = decimalPlacesRange[0];
                            this.editMaxFractionDigits = decimalPlacesRange[1];
                            this.setHasMaxMinFractionDigits(true);
                            break;
                        }
                        break block7;
                    }
                    default: {
                        System.out.println("Invalid format. Expected a single number, a range, or a range with missing bounds.");
                        break;
                    }
                }
                break block7;
            }
            System.out.println("Invalid format: Expected format is [value1], [value1,*], [*,value1], [value1,value2]");
            this.setHasValidFractionDigits(false);
            this.InvalidFractionDigits = String.valueOf(strFractionDigits) + " <-- INVALID";
        }
    }

    public boolean ifHasFractionDigits() {
        return this.hasFractionDigits;
    }

    public boolean ifHasMaxFractionDigits() {
        return this.hasMaxFractionDigits;
    }

    public boolean ifHasMinFractionDigits() {
        return this.hasMinFractionDigits;
    }

    public boolean ifHasMaxMinFractionDigits() {
        return this.hasMaxMinFractionDigits;
    }

    public boolean ifHasValidFractionDigits() {
        return this.hasValidFractionDigits;
    }

    private void initFractionDigitsInfo() {
        this.editFractionDigits = "";
        this.editMaxFractionDigits = "";
        this.editMinFractionDigits = "";
        this.InvalidFractionDigits = "";
        this.hasFractionDigits = false;
        this.hasMaxFractionDigits = false;
        this.hasMinFractionDigits = false;
        this.hasMaxMinFractionDigits = false;
        this.hasValidFractionDigits = true;
    }

    public void setHasFractionDigits(boolean hasFractionDigits) {
        this.hasFractionDigits = hasFractionDigits;
    }

    public void setHasMaxFractionDigits(boolean hasMaxFractionDigits) {
        this.hasMaxFractionDigits = hasMaxFractionDigits;
    }

    public void setHasMinFractionDigits(boolean hasMinFractionDigits) {
        this.hasMinFractionDigits = hasMinFractionDigits;
    }

    public void setHasMaxMinFractionDigits(boolean hasMaxMinFractionDigits) {
        this.hasMaxMinFractionDigits = hasMaxMinFractionDigits;
    }

    public void setHasValidFractionDigits(boolean hasValidFractionDigits) {
        this.hasValidFractionDigits = hasValidFractionDigits;
    }

    public String getEditMax() {
        return this.editMaximumValue;
    }

    public void setEditMax(String editMaximumValue) {
        if (!editMaximumValue.isEmpty() && editMaximumValue != null) {
            this.editMaximumValue = editMaximumValue = editMaximumValue.trim();
        }
    }

    public String getEditMin() {
        return this.editMinimumValue;
    }

    public void setEditMin(String editMinimumValue) {
        if (!editMinimumValue.isEmpty() && editMinimumValue != null) {
            this.editMinimumValue = editMinimumValue = editMinimumValue.trim();
        }
    }

    public boolean ifHasMax() {
        return this.hasMax;
    }

    public void setHasMax(boolean hasMax) {
        this.hasMax = hasMax;
    }

    public boolean ifHasMin() {
        return this.hasMin;
    }

    public void setHasMin(boolean hasMin) {
        this.hasMin = hasMin;
    }

    public boolean ifHasRegExp() {
        return this.hasRegExp;
    }

    public void RegExp(boolean hasRegExp) {
        this.hasRegExp = hasRegExp;
    }

    public JTextField getJTextField() {
        return this.txtfield;
    }

    public Component getTextView() {
        return this.txtfieldPanel;
    }

    @Override
    public void setSize(int width, int height) {
        this.txtfieldPanel.setPreferredSize(new Dimension(width - 110, 30));
        this.nameLabel.setBounds(30, 0, width / 3, 30);
        this.txtfield.setBounds(width / 2, 0, width / 3, 30);
    }

    public String getMaxStr() {
        return this.MaxStr;
    }

    public void setMaxStr(String maxStr) {
        if (maxStr.equals("*")) {
            this.setHasMax(false);
            this.MaxStr = "";
            this.setEditMax(this.MaxStr);
        }
        this.MaxStr = maxStr;
        this.setEditMax(maxStr);
        String regex = "[A-Fa-f0-9]+$";
        String regex10 = "^-?\\d+(\\.\\d+)?$";
        if (!maxStr.equals("") && !maxStr.equals("/")) {
            if (maxStr.contains("0x")) {
                try {
                    String str = maxStr.substring(0, 2);
                    if (str.equals("0x") && (maxStr = maxStr.substring(2)).matches(regex)) {
                        this.setEditMax(maxStr);
                        this.setHasMax(true);
                    }
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            } else if (maxStr.matches(regex10)) {
                try {
                    this.setEditMax(maxStr);
                    this.setHasMax(true);
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            this.setHasMax(false);
        }
    }

    public String getMinStr() {
        return this.MinStr;
    }

    public void setMinStr(String minStr) {
        if (minStr.equals("*")) {
            this.setHasMin(false);
            this.MinStr = "";
            this.setEditMin(this.MinStr);
        }
        this.MinStr = minStr;
        this.setEditMin(minStr);
        if (!minStr.equals("") && !minStr.equals("/")) {
            if (minStr.contains("0x")) {
                try {
                    String regex;
                    String str = minStr.substring(0, 2);
                    if (str.equals("0x") && (minStr = minStr.substring(2)).matches(regex = "[A-Fa-f0-9]+$")) {
                        this.setEditMin(minStr);
                        this.setHasMin(true);
                    }
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            } else {
                String regex10 = "^-?\\d+(\\.\\d+)?$";
                if (minStr.matches(regex10)) {
                    try {
                        this.setEditMin(minStr);
                        this.setHasMin(true);
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        } else {
            this.setHasMin(false);
        }
    }

    @Override
    public List<String> updateValueToDefaultValue() {
        ArrayList<String> valueChangedNodesPath = new ArrayList<String>();
        String oldValue = this.getValue();
        this.setValue(this.getDefaultValue());
        String newValue = this.getValue();
        if (!oldValue.equals(newValue)) {
            valueChangedNodesPath.add(super.getNodeFullPath(this));
        }
        return valueChangedNodesPath;
    }

    public void enableErrorMark() {
        this.nameLabel.setForeground(Color.RED);
        this.txtfield.setForeground(Color.RED);
    }

    public void disableErrorMark() {
        if (this.isEnable()) {
            this.nameLabel.setForeground(Color.BLACK);
        } else {
            this.nameLabel.setForeground(Color.GRAY);
        }
        this.txtfield.setForeground(Color.BLACK);
    }

    public void setNodeinfoValue(String keyNode, String nodeValue) {
        switch (keyNode) {
            case "MaximumValue": {
                this.setMaxStr(nodeValue);
                break;
            }
            case "MinimumValue": {
                this.setMinStr(nodeValue);
                break;
            }
            case "StrLength": {
                this.setEditByteLength(nodeValue);
                break;
            }
            case "FractionDigits": {
                this.setEditFractionDigits(nodeValue);
                break;
            }
            default: {
                System.out.println("Unhandled keyNode: " + keyNode);
            }
        }
    }

    @Override
    public void initMessage() {
        String MaxValue;
        String minValue;
        String baseMessage = this.getContent();
        if (!this.getTips().equals("")) {
            baseMessage = String.valueOf(baseMessage) + System.lineSeparator() + this.getTips();
        }
        this.setBaseMessage(baseMessage);
        String updateMessage = "";
        String fractionMessage = "";
        if (this.ifHasFractionDigits()) {
            fractionMessage = ", and fractionDigits must be " + this.getEditFractionDigits();
        } else if (this.ifHasMaxFractionDigits()) {
            fractionMessage = ", and fractionDigits must be less than " + this.getMaxEditFractionDigits();
        } else if (this.ifHasMinFractionDigits()) {
            fractionMessage = ", and fractionDigits must be more than " + this.getMinEditFractionDigits();
        } else if (this.ifHasMaxMinFractionDigits()) {
            minValue = this.geMaxtMinEditFractionDigits()[0];
            MaxValue = this.geMaxtMinEditFractionDigits()[1];
            fractionMessage = String.valueOf(fractionMessage) + System.lineSeparator() + "The fractionDigits of " + this.getContent() + " must be within the range of " + "[" + minValue + "," + MaxValue + "]";
        } else if (!this.ifHasValidFractionDigits()) {
            fractionMessage = String.valueOf(fractionMessage) + System.lineSeparator() + "The fractionDigits of " + this.getContent() + " Invalid fractionDigits format:" + this.InvalidFractionDigits;
        }
        if (this.ifHasMax() && this.ifHasMin()) {
            updateMessage = String.valueOf(this.getContent()) + " must be between " + this.getMinStr() + " to " + this.getMaxStr() + fractionMessage;
        } else if (this.ifHasMax()) {
            updateMessage = String.valueOf(this.getContent()) + " must be less than " + this.getMaxStr() + fractionMessage;
        } else if (this.ifHasMin()) {
            updateMessage = String.valueOf(this.getContent()) + " must be more than " + this.getMinStr() + fractionMessage;
        } else if (!fractionMessage.equals("")) {
            updateMessage = String.valueOf(this.getContent()) + fractionMessage.substring(4);
        }
        if (this.ifHasStrLength()) {
            updateMessage = updateMessage != "" ? String.valueOf(updateMessage) + System.lineSeparator() + "The length of " + this.getContent() + " must be " + this.getEditByteLength() : "The length of " + this.getContent() + " must be " + this.getEditByteLength();
        } else if (this.ifHasMaxStrLength()) {
            updateMessage = updateMessage != "" ? String.valueOf(updateMessage) + System.lineSeparator() + "The length of " + this.getContent() + " must be less than " + this.getMaxEditByteLength() : "The length of " + this.getContent() + " must be less than " + this.getMaxEditByteLength();
        } else if (this.ifHasMinStrLength()) {
            updateMessage = updateMessage != "" ? String.valueOf(updateMessage) + System.lineSeparator() + "The length of " + this.getContent() + " must be more than " + this.getMinEditByteLength() : "The length of " + this.getContent() + " must be more than " + this.getMinEditByteLength();
        } else if (this.ifHasMaxMinStrLength()) {
            minValue = this.geMaxtMinEditByteLength()[0];
            MaxValue = this.geMaxtMinEditByteLength()[1];
            updateMessage = updateMessage != "" ? String.valueOf(updateMessage) + System.lineSeparator() + "The length of " + this.getContent() + " must be within the range of " + "[" + minValue + "," + MaxValue + "]" : "The length of " + this.getContent() + " must be within the range of " + "[" + minValue + "," + MaxValue + "]";
        }
        if (!this.ifHasValidStrLength()) {
            updateMessage = "The length of " + this.getContent() + " Invalid strlength format:" + this.InvalidStrLength;
        }
        this.setUpdateMessage(updateMessage);
    }

    @Override
    public void copyToTreeNode(AbstractJTreeNode dstTreeNode) {
        super.copyToTreeNode(dstTreeNode);
        ((JTreeTextNode)dstTreeNode).setMaxStr(this.MaxStr);
        ((JTreeTextNode)dstTreeNode).setMinStr(this.MinStr);
        ((JTreeTextNode)dstTreeNode).setEditRegex(this.editRegex);
        ((JTreeTextNode)dstTreeNode).setControlType(this.ControlType);
        ((JTreeTextNode)dstTreeNode).setEditByteLengthValue(this.editByteLength);
        ((JTreeTextNode)dstTreeNode).setMaxEditByteLength(this.editMaxByteLength);
        ((JTreeTextNode)dstTreeNode).setMinEditByteLength(this.editMinByteLength);
        ((JTreeTextNode)dstTreeNode).setHasStrLength(this.ifHasStrLength());
        ((JTreeTextNode)dstTreeNode).setHasStrMaxLength(this.ifHasMaxStrLength());
        ((JTreeTextNode)dstTreeNode).setHasStrMinLength(this.ifHasMinStrLength());
        ((JTreeTextNode)dstTreeNode).setHasStrMaxMinLength(this.ifHasMaxMinStrLength());
        ((JTreeTextNode)dstTreeNode).setHasValidStrLength(this.ifHasValidStrLength());
        ((JTreeTextNode)dstTreeNode).setEditFractionDigitsValue(this.editFractionDigits);
        ((JTreeTextNode)dstTreeNode).setMaxEditFractionDigits(this.editMaxFractionDigits);
        ((JTreeTextNode)dstTreeNode).setMinEditFractionDigits(this.editMinFractionDigits);
        ((JTreeTextNode)dstTreeNode).setInvalidFractionDigits(this.InvalidFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasFractionDigits(this.hasFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasMaxFractionDigits(this.hasMaxFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasMinFractionDigits(this.hasMinFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasMaxMinFractionDigits(this.hasMaxMinFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasValidFractionDigits(this.hasValidFractionDigits);
        dstTreeNode.initMessage();
    }

    @Override
    public void copyToTreeNodeNoUI(AbstractJTreeNode dstTreeNode) {
        super.copyToTreeNodeNoUI(dstTreeNode);
        ((JTreeTextNode)dstTreeNode).setMaxStr(this.MaxStr);
        ((JTreeTextNode)dstTreeNode).setMinStr(this.MinStr);
        ((JTreeTextNode)dstTreeNode).setEditRegex(this.editRegex);
        ((JTreeTextNode)dstTreeNode).setControlType(this.ControlType);
        ((JTreeTextNode)dstTreeNode).setEditByteLengthValue(this.editByteLength);
        ((JTreeTextNode)dstTreeNode).setMaxEditByteLength(this.editMaxByteLength);
        ((JTreeTextNode)dstTreeNode).setMinEditByteLength(this.editMinByteLength);
        ((JTreeTextNode)dstTreeNode).setHasStrLength(this.ifHasStrLength());
        ((JTreeTextNode)dstTreeNode).setHasStrMaxLength(this.ifHasMaxStrLength());
        ((JTreeTextNode)dstTreeNode).setHasStrMinLength(this.ifHasMinStrLength());
        ((JTreeTextNode)dstTreeNode).setHasStrMaxMinLength(this.ifHasMaxMinStrLength());
        ((JTreeTextNode)dstTreeNode).setHasValidStrLength(this.ifHasValidStrLength());
        ((JTreeTextNode)dstTreeNode).setEditFractionDigitsValue(this.editFractionDigits);
        ((JTreeTextNode)dstTreeNode).setMaxEditFractionDigits(this.editMaxFractionDigits);
        ((JTreeTextNode)dstTreeNode).setMinEditFractionDigits(this.editMinFractionDigits);
        ((JTreeTextNode)dstTreeNode).setInvalidFractionDigits(this.InvalidFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasFractionDigits(this.hasFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasMaxFractionDigits(this.hasMaxFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasMinFractionDigits(this.hasMinFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasMaxMinFractionDigits(this.hasMaxMinFractionDigits);
        ((JTreeTextNode)dstTreeNode).setHasValidFractionDigits(this.hasValidFractionDigits);
        dstTreeNode.initMessage();
    }

    @Override
    public void setValueNoUI(String value) {
        ActionListener al;
        ActionListener[] listeners;
        this.value = value;
        ActionListener[] actionListenerArray = listeners = (ActionListener[])this.txtfield.getListeners(ActionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            al = actionListenerArray[n2];
            this.txtfield.removeActionListener(al);
            ++n2;
        }
        this.txtfield.setText(value);
        actionListenerArray = listeners;
        n = listeners.length;
        n2 = 0;
        while (n2 < n) {
            al = actionListenerArray[n2];
            this.txtfield.addActionListener(al);
            ++n2;
        }
    }
}

