/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.utils.preferences;

import com.gigadevice.utils.Activator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class EclipsePreferences {
    private static final String LINKER_FILE_SRC_PATH = "ldfile.src.path";
    private static final String LINKER_FILE_TARGET_PATH = "ldfile.target.path";
    private static final String LINKER_FILE_CODE_LOCATION = "ldfile.code.location";
    private static final String LINKER_FILE_RAM_LENGTH = "ldfile.ram.length";
    private static final String LINKER_FILE_RAM_ORIGIN = "ldfile.ram.Origin";
    private static final String LINKER_FILE_ENVM_LENGTH = "ldfile.envm.length";
    private static final String LINKER_FILE_ENVM_ORIGIN = "ldfile.envm.Origin";
    private static final String LINKER_FILE_FLASH_LENGTH = "ldfile.flash.length";
    private static final String LINKER_FILE_FLASH_ORIGIN = "ldfile.flash.Origin";
    private static final String LINKER_FILE_STACK_ORIGIN = "ldfile.stack.Origin";
    private static final String LINKER_FILE_STACK_LENGTH = "ldfile.stack.length";
    private static final String LINKER_FILE_FLASH_BASE_IN_FLASH = "ldfile.flash.base.in.flash";
    private static final String LINKER_FILE_FLASH_SIZE_IN_FLASH = "ldfile.flash.size.in.flash";
    private static final String LINKER_FILE_RAM_BASE_IN_FLASH = "ldfile.ram.base.in.flash";
    private static final String LINKER_FILE_RAM_SIZE_IN_FLASH = "ldfile.ram.size.in.flash";
    private static final String LINKER_FILE_FLASH_BASE_IN_RAM = "ldfile.flash.base.in.ram";
    private static final String LINKER_FILE_FLASH_SIZE_IN_RAM = "ldfile.flash.size.in.ram";
    private static final String LINKER_FILE_RAM_BASE_IN_RAM = "ldfile.ram.base.in.ram";
    private static final String LINKER_FILE_RAM_SIZE_IN_RAM = "ldfile.ram.size.in.ram";
    public static final String COMPILER_CODE_POSTION_KEY = "compiler.codeposition";
    public static final String COMPILER_STACK_SIZE_KEY = "compiler.stacksize";
    public static final String COMPILER_STACK_BAS_KEYE = "compiler.stackbase";
    public static final String COMPILER_CODE_BASE_KEY = "compiler.codebase";
    public static final String COMPILER_CODE_SIZE_KEY = "compiler.codesize";
    public static final String COMPILER_RAM_BAS_KEYE = "compiler.rambase";
    public static final String COMPILER_RAM_SIZE_KEY = "compiler.ramsize";
    public static final String PROJECT_PATH_KEY = "project.path";
    private static final String MCU_TARGET_SVD = "mcu.target.svd";
    private static final String MCU_TARGET = "mcu.target";
    public static final String TOOLCHAIN_PREFIX_KEY = "toolchain.prefix";
    public static final String TOOLCHAIN_NAME_KEY = "toolchain.name";
    public static final String BUILDTOOLS_PATH_KEY = "buildtools.path";
    private static final String TOOLCHAIN_PATH_KEY = "toolchain.path.%d";
    private static final String INPUT_FLASH_DOWNLOAD_ADDRESS = "input.flash.download.address";
    public static final String RELATIVE_LD_FOLDER = "ldscripts";
    public static final String RELATIVE_STARTUP_FOLDER = "gcc_startup";
    public static final String RELATIVE_OPENOCD_FOLDER = "openocd_gdlink";
    protected String fPluginId;

    public EclipsePreferences(String pluginId) {
        this.fPluginId = pluginId;
    }

    protected void putGlobalString(String key, String value) {
        String oldValue = this.getStringFromInstanceScope(key, null);
        if (oldValue != null) {
            this.putStringToInstanceScope(key, value);
        } else {
            this.putStringToConfigurationScope(key, value);
        }
    }

    protected void putProjectString(String key, String value, IProject project) {
        value = value.trim();
        IEclipsePreferences preferences = new ProjectScope(project).getNode(this.fPluginId);
        preferences.put(key, value);
    }

    protected String getString(String key, String defaultValue, IProject project) {
        String value = EclipsePreferences.getPreferenceValue(this.fPluginId, key, defaultValue, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    private String getStringFromInstanceScope(String key, String defaultValue) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(this.fPluginId);
        String value = preferences.get(key, defaultValue);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("EclipsePreferences.getStringFromInstanceScope(\"" + key + "\", \"" + defaultValue + "\") returns \"" + value + "\". qualifier is \"" + this.fPluginId + "\"");
        }
        return value;
    }

    protected void putStringToConfigurationScope(String key, String value) {
        value = value.trim();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("EclipsePreferences.putStringToConfigurationScope(\"" + key + "\", \"" + value + "\"). qualifier is \"" + this.fPluginId + "\"");
        }
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode(this.fPluginId);
        preferences.put(key, value);
    }

    protected void putStringToInstanceScope(String key, String value) {
        value = value.trim();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("EclipsePreferences.putStringToInstanceScope(\"" + key + "\", \"" + value + "\"). qualifier is \"" + this.fPluginId + "\"");
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(this.fPluginId);
        preferences.put(key, value);
    }

    public static String getPreferenceValue(String pluginId, String key, String defaultValue, IProject project) {
        IScopeContext[] contexts = EclipsePreferences.getProjectScopeContexts(project);
        return EclipsePreferences.getPreferenceValue(pluginId, key, defaultValue, contexts);
    }

    private static String getPreferenceValue(String pluginId, String key, String defaultValue, IScopeContext[] contexts) {
        String retValue = null;
        int index = 0;
        index = 0;
        while (index < contexts.length) {
            retValue = contexts[index].getNode(pluginId).get(key, null);
            if (retValue != null && !(retValue = retValue.trim()).isEmpty()) break;
            ++index;
        }
        if (retValue != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("EclipsePreferences.getPreferenceValue(\"" + pluginId + "\", \"" + key + "\", \"" + defaultValue + "\", contexts ) returns \"" + retValue + "\" from " + contexts[index].getName());
            }
            return retValue;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("EclipsePreferences.getPreferenceValue(\"" + pluginId + "\", \"" + key + "\", \"" + defaultValue + "\", contexts ) returns \"" + defaultValue + "\" from defaultValue parameter.");
        }
        return defaultValue;
    }

    private static IScopeContext[] getProjectScopeContexts(IProject project) {
        IScopeContext[] contexts = project != null ? new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
        return contexts;
    }

    public void flush(IProject project) {
        try {
            if (project != null) {
                new ProjectScope(project).getNode(this.fPluginId).flush();
            } else {
                ConfigurationScope.INSTANCE.getNode(this.fPluginId).flush();
                InstanceScope.INSTANCE.getNode(this.fPluginId).flush();
            }
        }
        catch (BackingStoreException e) {
            System.out.println("EclipsePreferences.flush(... ) error:" + e.getMessage());
        }
    }

    public void putMCUTargetSVD(String valueStr, IProject project) {
        this.putProjectString(MCU_TARGET_SVD, valueStr, project);
    }

    public String getMCUTargetSVD(IProject project) {
        String value = this.getString(MCU_TARGET_SVD, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileSrcPath(String path, IProject project) {
        this.putProjectString(LINKER_FILE_SRC_PATH, path, project);
    }

    public String getLinkFileSrcPath(IProject project) {
        String value = this.getString(LINKER_FILE_SRC_PATH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileTargetPath(String path, IProject project) {
        this.putProjectString(LINKER_FILE_TARGET_PATH, path, project);
    }

    public String getLinkFileTargetPath(IProject project) {
        String value = this.getString(LINKER_FILE_TARGET_PATH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileCodeLoaction(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_CODE_LOCATION, valueStr, project);
    }

    public String getLinkFileCodeLoaction(IProject project) {
        String value = this.getString(LINKER_FILE_CODE_LOCATION, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileRamLength(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_RAM_LENGTH, valueStr, project);
    }

    public String getLinkFileRamLength(IProject project) {
        String value = this.getString(LINKER_FILE_RAM_LENGTH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileRamOrigin(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_RAM_ORIGIN, valueStr, project);
    }

    public String getLinkFileRamOrigin(IProject project) {
        String value = this.getString(LINKER_FILE_RAM_ORIGIN, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileFlashlength(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_FLASH_LENGTH, valueStr, project);
    }

    public String getLinkFileFlashlength(IProject project) {
        String value = this.getString(LINKER_FILE_FLASH_LENGTH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileFlashOrigin(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_FLASH_ORIGIN, valueStr, project);
    }

    public String getLinkFileFlashOrigin(IProject project) {
        String value = this.getString(LINKER_FILE_FLASH_ORIGIN, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileEnvmlength(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_ENVM_LENGTH, valueStr, project);
    }

    public String getLinkFileEnvmlength(IProject project) {
        String value = this.getString(LINKER_FILE_ENVM_LENGTH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileEnvmOrigin(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_ENVM_ORIGIN, valueStr, project);
    }

    public String getLinkFileEnvmOrigin(IProject project) {
        String value = this.getString(LINKER_FILE_ENVM_ORIGIN, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileStacklength(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_STACK_LENGTH, valueStr, project);
    }

    public String getLinkFileStacklength(IProject project) {
        String value = this.getString(LINKER_FILE_STACK_LENGTH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putLinkFileStackOrigin(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_STACK_ORIGIN, valueStr, project);
    }

    public String getLinkFileStackOrigin(IProject project) {
        String value = this.getString(LINKER_FILE_STACK_ORIGIN, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putTargetMCU(String valueStr, IProject project) {
        this.putProjectString(MCU_TARGET, valueStr, project);
    }

    public String getTargetMCU(IProject project) {
        String value = this.getString(MCU_TARGET, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putFlashBaseInFlash(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_FLASH_BASE_IN_FLASH, valueStr, project);
    }

    public String getFlashBaseInFlash(IProject project) {
        String value = this.getString(LINKER_FILE_FLASH_BASE_IN_FLASH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putFlashSizeInFlash(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_FLASH_SIZE_IN_FLASH, valueStr, project);
    }

    public String getFlashSizeInFlash(IProject project) {
        String value = this.getString(LINKER_FILE_FLASH_SIZE_IN_FLASH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putRamBaseInFlash(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_RAM_BASE_IN_FLASH, valueStr, project);
    }

    public String getRamBaseInFlash(IProject project) {
        String value = this.getString(LINKER_FILE_RAM_BASE_IN_FLASH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putRamSizeInFlash(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_RAM_SIZE_IN_FLASH, valueStr, project);
    }

    public String getRamSizeInFlash(IProject project) {
        String value = this.getString(LINKER_FILE_RAM_SIZE_IN_FLASH, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putFlashBaseInRam(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_FLASH_BASE_IN_RAM, valueStr, project);
    }

    public String getFlashBaseInRam(IProject project) {
        String value = this.getString(LINKER_FILE_FLASH_BASE_IN_RAM, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putFlashSizeInRam(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_FLASH_SIZE_IN_RAM, valueStr, project);
    }

    public String getFlashSizeInRam(IProject project) {
        String value = this.getString(LINKER_FILE_FLASH_SIZE_IN_RAM, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putRamBaseInRam(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_RAM_BASE_IN_RAM, valueStr, project);
    }

    public String getRamBaseInRam(IProject project) {
        String value = this.getString(LINKER_FILE_RAM_BASE_IN_RAM, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putRamSizeInRam(String valueStr, IProject project) {
        this.putProjectString(LINKER_FILE_RAM_SIZE_IN_RAM, valueStr, project);
    }

    public String getRamSizeInRam(IProject project) {
        String value = this.getString(LINKER_FILE_RAM_SIZE_IN_RAM, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putCodePostion(String codePostion, IProject project) {
        this.putProjectString(COMPILER_CODE_POSTION_KEY, codePostion, project);
    }

    public void putStackSize(String stacksize, IProject project) {
        this.putProjectString(COMPILER_STACK_SIZE_KEY, stacksize, project);
    }

    public void putStackBase(String stackbase, IProject project) {
        this.putProjectString(COMPILER_STACK_BAS_KEYE, stackbase, project);
    }

    public String getCodePostion(IProject project) {
        String value = this.getString(COMPILER_CODE_POSTION_KEY, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public String getStackSize(IProject project) {
        String value = this.getString(COMPILER_STACK_SIZE_KEY, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public String getStackBase(IProject project) {
        String value = this.getString(COMPILER_STACK_BAS_KEYE, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putProjectPath(String path, IProject project) {
        this.putProjectString(PROJECT_PATH_KEY, path, project);
    }

    public String getProjectPath(IProject project) {
        String value = this.getString(PROJECT_PATH_KEY, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putCodeBase(String value, IProject project) {
        this.putProjectString(COMPILER_CODE_BASE_KEY, value, project);
    }

    public String getCodeBase(IProject project) {
        String value = this.getString(COMPILER_CODE_BASE_KEY, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putCodeSize(String value, IProject project) {
        this.putProjectString(COMPILER_CODE_SIZE_KEY, value, project);
    }

    public String getCodeSize(IProject project) {
        String value = this.getString(COMPILER_CODE_SIZE_KEY, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putRamBase(String value, IProject project) {
        this.putProjectString(COMPILER_RAM_BAS_KEYE, value, project);
    }

    public String getRamBase(IProject project) {
        String value = this.getString(COMPILER_RAM_BAS_KEYE, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putRamSize(String value, IProject project) {
        this.putProjectString(COMPILER_RAM_SIZE_KEY, value, project);
    }

    public String getRamSize(IProject project) {
        String value = this.getString(COMPILER_RAM_SIZE_KEY, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public String getLastUsedToolchainName(IProject project) {
        String toolchainName = this.getString(TOOLCHAIN_NAME_KEY, null, project);
        if (toolchainName != null && !toolchainName.isEmpty()) {
            return toolchainName;
        }
        return "";
    }

    public void putToolchainName(String toolchainName, IProject project) {
        if (project != null) {
            this.putProjectString(TOOLCHAIN_NAME_KEY, toolchainName, project);
        } else {
            this.putGlobalString(TOOLCHAIN_NAME_KEY, toolchainName);
        }
    }

    public String getToolchainPath(String toolchainName, IProject project) {
        String value = this.getString(EclipsePreferences.getToolchainKey(toolchainName), null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putToolchainPath(String toolchainName, String path, IProject project) {
        if (project != null) {
            this.putProjectString(EclipsePreferences.getToolchainKey(toolchainName), path, project);
        } else {
            this.putGlobalString(EclipsePreferences.getToolchainKey(toolchainName), path);
        }
    }

    public static String getToolchainKey(String toolchainName) {
        int hash = Math.abs(toolchainName.trim().hashCode());
        String key = String.format(TOOLCHAIN_PATH_KEY, hash);
        return key;
    }

    public String getBuildToolsPath(IProject project) {
        String value = this.getString(BUILDTOOLS_PATH_KEY, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putBuildToolsPath(String value, IProject project) {
        if (project != null) {
            this.putProjectString(BUILDTOOLS_PATH_KEY, value, project);
        } else {
            this.putGlobalString(BUILDTOOLS_PATH_KEY, value);
        }
    }

    public String getToolchainPrefix(IProject project) {
        String value = this.getString(TOOLCHAIN_PREFIX_KEY, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }

    public void putToolchainPrefix(String value, IProject project) {
        if (project != null) {
            this.putProjectString(TOOLCHAIN_PREFIX_KEY, value, project);
        } else {
            this.putGlobalString(TOOLCHAIN_PREFIX_KEY, value);
        }
    }

    public void putInputFlashDownloadAddress(String value, IProject project) {
        if (project != null) {
            this.putProjectString(INPUT_FLASH_DOWNLOAD_ADDRESS, value, project);
        }
    }

    public String getInputFlashDownloadAddress(IProject project) {
        String value = this.getString(INPUT_FLASH_DOWNLOAD_ADDRESS, null, project);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return "";
    }
}

