/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs.riscv.ui;

import com.gigadevice.mbs.Activator;
import com.gigadevice.mbs.riscv.Option;
import com.gigadevice.mbs.riscv.ToolchainDefinition;
import com.gigadevice.utils.preferences.EclipsePreferences;
import com.gigadevice.venustool.TargetOSInfo;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CTestToolChainPropertyTab
extends AbstractCBuildPropertyTab {
    private static final String TOOL_CCOMPILER_ID = "com.gigadevice.mbs.riscv.tool.CCompiler";
    private static final String TOOLCHAIN_ID = "com.gigadevice.mbs.riscv.toolChain";
    private static Combo combotoolchainName;
    private static Text TextToolChainPrefix;
    private static Text TextToolChainPath;
    private Text TextBuildToolPath;
    private EclipsePreferences projPreferences = com.gigadevice.mbs.riscv.Activator.getInstance().getProjectPreferences();
    private IConfiguration fConfig;
    private IConfiguration fLastUpdatedConfig;
    private IProject project;

    public static void setCombotoolchainName(String _combotoolchainName) {
        combotoolchainName.removeAll();
        combotoolchainName.add(_combotoolchainName);
        combotoolchainName.select(0);
    }

    public static void setTextToolChainPrefix(String _TextToolChainPrefix) {
        TextToolChainPrefix.setText(_TextToolChainPrefix);
    }

    public static void setTextToolChainPath(String _TextToolChainPath) {
        TextToolChainPath.setText(_TextToolChainPath);
    }

    public static String getCombotoolchainName() {
        return combotoolchainName.getText();
    }

    public static String getTextToolChainPrefix() {
        return TextToolChainPrefix.getText();
    }

    public static String getTextToolChainPath() {
        return TextToolChainPath.getText();
    }

    public CTestToolChainPropertyTab() {
        com.gigadevice.mbs.riscv.Activator.setFieldEditorParent(null);
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.fConfig = this.getCfg();
        this.project = this.page.getProject();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.usercomp.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        this.usercomp.setLayoutData((Object)layoutData);
        Label LbltoolchainName = new Label(this.usercomp, 0);
        LbltoolchainName.setText("Toolchain name: ");
        combotoolchainName = new Combo(this.usercomp, 2056);
        String targetToolchainName = Option.getOptionStringValue((IConfiguration)this.fConfig, (String)Option.OPTIONID_TOOLCHAIN_NAME);
        if (targetToolchainName != null) {
            combotoolchainName.add(targetToolchainName);
            combotoolchainName.select(0);
        } else {
            for (ToolchainDefinition tempToolchain : ToolchainDefinition.getToolchainList()) {
                combotoolchainName.add(tempToolchain.getToolchainName());
            }
            combotoolchainName.select(ToolchainDefinition.getToolchainDefaultIndex());
        }
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        combotoolchainName.setLayoutData((Object)layoutData);
        Label LbltoolchainPrefix = new Label(this.usercomp, 0);
        LbltoolchainPrefix.setText("Toolchain Prefix: ");
        TextToolChainPrefix = new Text(this.usercomp, 2052);
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        TextToolChainPrefix.setLayoutData((Object)layoutData);
        TextToolChainPrefix.setEditable(true);
        Label label = new Label(this.usercomp, 0);
        label.setText("ToolChain Path:");
        TextToolChainPath = new Text(this.usercomp, 2052);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        TextToolChainPath.setLayoutData((Object)layoutData);
        Button button = new Button(this.usercomp, 0);
        button.setText("Browse");
        layoutData = new GridData(16384, 128, false, false, 1, 1);
        button.setLayoutData((Object)layoutData);
        Label buildLabel = new Label(this.usercomp, 0);
        buildLabel.setText("Build Tool Path:");
        this.TextBuildToolPath = new Text(this.usercomp, 2052);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.TextBuildToolPath.setLayoutData((Object)layoutData);
        this.updateControlsForConfig(this.fConfig);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(CTestToolChainPropertyTab.this.usercomp.getShell(), 65536);
                String ToolChainPath = TextToolChainPath.getText();
                ToolChainPath = Option.getAbsolutePath(ToolChainPath);
                dirDialog.setFilterPath(ToolChainPath);
                String browsedDirectory = dirDialog.open();
                if (browsedDirectory == null) {
                    return;
                }
                if (CTestToolChainPropertyTab.this.checkToolchainFileExists(browsedDirectory, TextToolChainPrefix.getText())) {
                    browsedDirectory = Option.getRelativePath(browsedDirectory);
                    TextToolChainPath.setText(browsedDirectory);
                }
            }
        });
        Button buildbutton = new Button(this.usercomp, 0);
        buildbutton.setText("Browse");
        buildbutton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(CTestToolChainPropertyTab.this.usercomp.getShell(), 65536);
                String BuildToolPath = CTestToolChainPropertyTab.this.TextBuildToolPath.getText();
                BuildToolPath = Option.getAbsolutePath(BuildToolPath);
                dirDialog.setFilterPath(BuildToolPath);
                String browsedDirectory = dirDialog.open();
                browsedDirectory = Option.getRelativePath(browsedDirectory);
                if (browsedDirectory.equals("")) {
                    return;
                }
                CTestToolChainPropertyTab.this.TextBuildToolPath.setText(browsedDirectory);
            }
        });
        layoutData = new GridData(16384, 128, false, false, 1, 1);
        buildbutton.setLayoutData((Object)layoutData);
        if (TargetOSInfo.isLinux()) {
            buildLabel.setVisible(false);
            this.TextBuildToolPath.setVisible(false);
            buildbutton.setVisible(false);
        }
    }

    public void handleTabEvent(int kind, Object data) {
        super.handleTabEvent(kind, data);
    }

    public boolean canBeVisible() {
        return this.isThisPlugin();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        try {
            if (!this.updateConfig(CTestToolChainPropertyTab.getCfg((ICConfigurationDescription)src.getConfiguration()))) {
                return;
            }
            if (!this.updateConfig(CTestToolChainPropertyTab.getCfg((ICConfigurationDescription)dst.getConfiguration()))) {
                return;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        this.updatePreferences();
        ManagedBuildManager.saveBuildInfo((IProject)this.project, (boolean)true);
        this.UpdataTemplateLdParameters();
        if (this.checkLinkFileUpdateNeeded(this.getCfg()).booleanValue() && !this.UpdataTemplateLdParameters().booleanValue()) {
            return;
        }
    }

    protected void performDefaults() {
    }

    protected void updateData(ICResourceDescription cfg) {
    }

    protected void updateButtons() {
    }

    public boolean canSupportMultiCfg() {
        return true;
    }

    private boolean updateConfig(IConfiguration srcConfig) throws BuildException {
        IToolChain toolchain = srcConfig.getToolChain();
        String ToolChainName = combotoolchainName.getText();
        IOption option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_NAME);
        srcConfig.setOption((IHoldsOptions)toolchain, option, ToolChainName);
        String BuildToolPath = this.TextBuildToolPath.getText();
        IOption option3 = toolchain.getOptionById(Option.OPTIONID_BUILDTOOL_PATH);
        srcConfig.setOption((IHoldsOptions)toolchain, option3, BuildToolPath);
        String ToolChainPath = TextToolChainPath.getText();
        if (!this.checkToolchainFileExists(Option.getAbsolutePath(ToolChainPath), TextToolChainPrefix.getText())) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Information ", (String)"The current configuration of the toolChain is invalid and has been restored to the default configuration");
            if (TargetOSInfo.isWindows()) {
                TextToolChainPrefix.setText("riscv-none-embed-");
                TextToolChainPath.setText(".\\Tools\\RISC-V Embedded GCC\\8.2.0-2.2-20190521-0004\\bin");
            } else if (TargetOSInfo.isLinux()) {
                TextToolChainPrefix.setText("riscv-none-embed-");
                TextToolChainPath.setText("./Tools/RISC-VEmbeddedGCC/8.2.0-2.2-20190521-0004/bin");
            }
            if (ToolChainName.equals("MCU RISC-V GCC")) {
                TextToolChainPrefix.setText("riscv-nuclei-elf-");
                TextToolChainPath.setText("./Tools/nuclei_riscv_newlibc_prebuilt_win32_2022.04/gcc/bin");
            }
            return false;
        }
        IOption option2 = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_PATH);
        srcConfig.setOption((IHoldsOptions)toolchain, option2, ToolChainPath);
        try {
            int index = ToolchainDefinition.getToolchainIndex(ToolChainName);
            ToolchainDefinition targetToolchain = ToolchainDefinition.getToolchain(index);
            String ToolchainPrefix = TextToolChainPrefix.getText();
            targetToolchain.updateToolchainPrefix(ToolchainPrefix.trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_PREFIX);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getToolchainPrefix().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_C);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getCCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_CPP);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getCPPCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_RM);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getRmCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_MAKE);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getMakeCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_OBJCOPY);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getObjcopyCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_OBJDUMP);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getObjdumpCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_SIZE);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getSizeCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_AR);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getArchiverCommander().trim());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            com.gigadevice.mbs.riscv.Activator.log("CTestToolChainPropertyTab.updateConfig():" + ToolChainName + " not found.");
            System.out.println("com.gigadevice.mbs.riscvCTestToolChainPropertyTab.updateConfig():" + ToolChainName + " not found.");
            return false;
        }
        return true;
    }

    private boolean checkToolchainFileExists(String ToolChainPath, String ToolChainPrefix) {
        File folder = new File(ToolChainPath);
        if (!folder.exists() && !folder.isDirectory()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning ", (String)"The toolChain path does not exist or is not a folder. Please check the path configuration.");
            return false;
        }
        ArrayList<String> toolchainList = new ArrayList<String>();
        if (TargetOSInfo.isWindows()) {
            toolchainList.add(String.valueOf(ToolChainPrefix) + "gcc.exe");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "objcopy.exe");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "objdump.exe");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "size.exe");
        } else if (TargetOSInfo.isLinux()) {
            toolchainList.add(String.valueOf(ToolChainPrefix) + "gcc");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "objcopy");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "objdump");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "size");
        }
        boolean result = true;
        String Tips = "";
        int i = 0;
        while (i < toolchainList.size()) {
            File file = new File(String.valueOf(ToolChainPath) + File.separator + (String)toolchainList.get(i));
            if (!file.exists()) {
                Tips = String.valueOf(Tips) + (String)toolchainList.get(i) + "," + System.lineSeparator();
                result = false;
            }
            ++i;
        }
        if (!result) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning ", (String)("Files: " + System.lineSeparator() + Tips + "do not exist. Please check the toolchain path configuration."));
            return false;
        }
        return true;
    }

    private Boolean UpdataTemplateLdParameters() {
        String sCCompilerId;
        IToolChain toolchain = this.getCfg().getToolChain();
        ITool[] OtherTools = toolchain.getToolsBySuperClassId(sCCompilerId = TOOL_CCOMPILER_ID);
        if (OtherTools != null) {
            ITool[] iToolArray = OtherTools;
            int n = OtherTools.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    ITool tool = iToolArray[n2];
                    String sId = Option.OPTIONID_CCOMPILER_HIDE;
                    IOption option = tool.getOptionBySuperClassId(sId);
                    if (option != null) {
                        String sepStr = "^";
                        if (!this.projPreferences.getLinkFileSrcPath(this.project).isEmpty()) {
                            String oldPath = this.projPreferences.getLinkFileSrcPath(this.project);
                            String newPath = this.projPreferences.getLinkFileTargetPath(this.project);
                            String estack = this.projPreferences.getLinkFileStackOrigin(this.project);
                            String MinStackSize = this.projPreferences.getLinkFileStacklength(this.project);
                            String flashOrigin = this.projPreferences.getLinkFileFlashOrigin(this.project);
                            String flashLength = this.projPreferences.getLinkFileFlashlength(this.project);
                            String ramOrigin = this.projPreferences.getLinkFileRamOrigin(this.project);
                            String ramLength = this.projPreferences.getLinkFileRamLength(this.project);
                            String codeLocation = this.projPreferences.getLinkFileCodeLoaction(this.project);
                            String flashBaseInFlash = this.projPreferences.getFlashBaseInFlash(this.project);
                            String flashSizeInFlash = this.projPreferences.getFlashSizeInFlash(this.project);
                            String ramBaseInFlash = this.projPreferences.getRamBaseInFlash(this.project);
                            String ramSizeInFlash = this.projPreferences.getRamSizeInFlash(this.project);
                            String flashBaseInRam = this.projPreferences.getFlashBaseInRam(this.project);
                            String flashSizeInRam = this.projPreferences.getFlashSizeInRam(this.project);
                            String ramBaseInRam = this.projPreferences.getRamBaseInRam(this.project);
                            String ramSizeInRam = this.projPreferences.getRamSizeInRam(this.project);
                            String ldorigininfo = String.valueOf(flashBaseInFlash) + sepStr + flashSizeInFlash + sepStr + ramBaseInFlash + sepStr + ramSizeInFlash + sepStr + flashBaseInRam + sepStr + flashSizeInRam + sepStr + ramBaseInRam + sepStr + ramSizeInRam;
                            String LdInfoStr = String.valueOf(oldPath) + sepStr + newPath + sepStr + estack + sepStr + MinStackSize + sepStr + flashOrigin + sepStr + flashLength + sepStr + ramOrigin + sepStr + ramLength + sepStr + codeLocation + sepStr + ldorigininfo;
                            ManagedBuildManager.setOption((IConfiguration)this.getCfg(), (IHoldsOptions)tool, (IOption)option, (String)LdInfoStr);
                        } else {
                            try {
                                String[] ldinfoArray;
                                int size;
                                String valueStr = option.getStringValue();
                                if (valueStr.equals("")) {
                                    this.UpdataParameters();
                                }
                                if ((size = (ldinfoArray = valueStr.split("\\" + sepStr)).length) > 8) {
                                    int i = 0;
                                    String oldPath = ldinfoArray[i++];
                                    String newPath = ldinfoArray[i++];
                                    String estack = ldinfoArray[i++];
                                    String MinStackSize = ldinfoArray[i++];
                                    String flashOrigin = ldinfoArray[i++];
                                    String flashLength = ldinfoArray[i++];
                                    String ramOrigin = ldinfoArray[i++];
                                    String ramLength = ldinfoArray[i++];
                                    String codeLocation = ldinfoArray[i++];
                                    String flashBaseInFlash = ldinfoArray[i++];
                                    String flashSizeInFlash = ldinfoArray[i++];
                                    String ramBaseInFlash = ldinfoArray[i++];
                                    String ramSizeInFlash = ldinfoArray[i++];
                                    String flashBaseInRam = ldinfoArray[i++];
                                    String flashSizeInRam = ldinfoArray[i++];
                                    String ramBaseInRam = ldinfoArray[i++];
                                    String ramSizeInRam = ldinfoArray[i++];
                                    this.projPreferences.putLinkFileSrcPath(oldPath, this.project);
                                    this.projPreferences.putLinkFileTargetPath(newPath, this.project);
                                    this.projPreferences.putLinkFileCodeLoaction(codeLocation, this.project);
                                    this.projPreferences.putLinkFileRamLength(ramLength, this.project);
                                    this.projPreferences.putLinkFileRamOrigin(ramOrigin, this.project);
                                    this.projPreferences.putLinkFileFlashlength(flashLength, this.project);
                                    this.projPreferences.putLinkFileFlashOrigin(flashOrigin, this.project);
                                    this.projPreferences.putLinkFileStacklength(MinStackSize, this.project);
                                    this.projPreferences.putLinkFileStackOrigin(estack, this.project);
                                    this.projPreferences.putFlashBaseInFlash(flashBaseInFlash, this.project);
                                    this.projPreferences.putFlashSizeInFlash(flashSizeInFlash, this.project);
                                    this.projPreferences.putRamBaseInFlash(ramBaseInFlash, this.project);
                                    this.projPreferences.putRamSizeInFlash(ramSizeInFlash, this.project);
                                    this.projPreferences.putFlashBaseInRam(flashBaseInRam, this.project);
                                    this.projPreferences.putFlashSizeInRam(flashSizeInRam, this.project);
                                    this.projPreferences.putRamBaseInRam(ramBaseInRam, this.project);
                                    this.projPreferences.putRamSizeInRam(ramSizeInRam, this.project);
                                    this.projPreferences.flush(this.project);
                                    break block9;
                                }
                                return false;
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                                return false;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    private void UpdataParameters() {
        String sCCompilerId;
        IToolChain toolchain = this.getCfg().getToolChain();
        ITool[] OtherTools = toolchain.getToolsBySuperClassId(sCCompilerId = TOOL_CCOMPILER_ID);
        if (OtherTools != null) {
            ITool[] iToolArray = OtherTools;
            int n = OtherTools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                String sepStr = "^";
                String oldPath = "";
                String newPath = "";
                String estack = "";
                String MinStackSize = "";
                String flashOrigin = "";
                String flashLength = "";
                String ramOrigin = "";
                String ramLength = "";
                String codeLocation = "";
                try {
                    oldPath = "";
                    newPath = "";
                    estack = tool.getOptionBySuperClassId(Option.OPTIONID_CCOMPILER_STACKBASE).getStringValue();
                    codeLocation = "";
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
                String flashBaseInFlash = "";
                String flashSizeInFlash = "";
                String ramBaseInFlash = "";
                String ramSizeInFlash = "";
                String flashBaseInRam = "";
                String flashSizeInRam = "";
                String ramBaseInRam = "";
                String ramSizeInRam = "";
                this.projPreferences.putLinkFileSrcPath(oldPath, this.project);
                this.projPreferences.putLinkFileTargetPath(newPath, this.project);
                this.projPreferences.putLinkFileCodeLoaction(codeLocation, this.project);
                this.projPreferences.putLinkFileRamLength(ramLength, this.project);
                this.projPreferences.putLinkFileRamOrigin(ramOrigin, this.project);
                this.projPreferences.putLinkFileFlashlength(flashLength, this.project);
                this.projPreferences.putLinkFileFlashOrigin(flashOrigin, this.project);
                this.projPreferences.putLinkFileStacklength(MinStackSize, this.project);
                this.projPreferences.putLinkFileStackOrigin(estack, this.project);
                this.projPreferences.putFlashBaseInFlash(flashBaseInFlash, this.project);
                this.projPreferences.putFlashSizeInFlash(flashSizeInFlash, this.project);
                this.projPreferences.putRamBaseInFlash(ramBaseInFlash, this.project);
                this.projPreferences.putRamSizeInFlash(ramSizeInFlash, this.project);
                this.projPreferences.putFlashBaseInRam(flashBaseInRam, this.project);
                this.projPreferences.putFlashSizeInRam(flashSizeInRam, this.project);
                this.projPreferences.putRamBaseInRam(ramBaseInRam, this.project);
                this.projPreferences.putRamSizeInRam(ramSizeInRam, this.project);
                this.projPreferences.flush(this.project);
                String ldorigininfo = String.valueOf(flashBaseInFlash) + sepStr + flashSizeInFlash + sepStr + ramBaseInFlash + sepStr + ramSizeInFlash + sepStr + flashBaseInRam + sepStr + flashSizeInRam + sepStr + ramBaseInRam + sepStr + ramSizeInRam;
                String LdInfoStr = String.valueOf(oldPath) + sepStr + newPath + sepStr + estack + sepStr + MinStackSize + sepStr + flashOrigin + sepStr + flashLength + sepStr + ramOrigin + sepStr + ramLength + sepStr + codeLocation + sepStr + ldorigininfo;
                String sId = Option.OPTIONID_CCOMPILER_HIDE;
                IOption option = tool.getOptionBySuperClassId(sId);
                if (option != null) {
                    ManagedBuildManager.setOption((IConfiguration)this.getCfg(), (IHoldsOptions)tool, (IOption)option, (String)LdInfoStr);
                }
                ++n2;
            }
        }
    }

    public static String getOptionValueFromTool(ITool holderTool, String optId) {
        IOption option = holderTool.getOptionBySuperClassId(optId);
        if (option != null) {
            String sValue = null;
            try {
                sValue = option.getStringValue();
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            if (sValue != null && sValue.length() > 0) {
                sValue = sValue.trim();
                return sValue;
            }
        }
        return null;
    }

    private Boolean checkLinkFileUpdateNeeded(IConfiguration configuration) {
        String sCCompilerId;
        Boolean dirtyflag = false;
        String TargetCodeBase = this.projPreferences.getCodeBase(this.project);
        String TargetCodeSize = this.projPreferences.getCodeSize(this.project);
        String TargetRamBase = this.projPreferences.getRamBase(this.project);
        String TargetRamSize = this.projPreferences.getRamSize(this.project);
        IToolChain toolchain = configuration.getToolChain();
        ITool[] OtherTools = toolchain.getToolsBySuperClassId(sCCompilerId = TOOL_CCOMPILER_ID);
        if (OtherTools != null) {
            ITool[] iToolArray = OtherTools;
            int n = OtherTools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                String sValue = CTestToolChainPropertyTab.getOptionValueFromTool(tool, Option.OPTIONID_CCOMPILER_CODEBASE);
                if (sValue != null && sValue.length() > 0) {
                    this.projPreferences.putCodeBase(sValue, this.project);
                    this.projPreferences.flush(this.project);
                    if (!sValue.equals(TargetCodeBase)) {
                        dirtyflag = true;
                    }
                    TargetCodeBase = sValue;
                }
                if ((sValue = CTestToolChainPropertyTab.getOptionValueFromTool(tool, Option.OPTIONID_CCOMPILER_CODESIZE)) != null && sValue.length() > 0) {
                    this.projPreferences.putCodeSize(sValue, this.project);
                    this.projPreferences.flush(this.project);
                    if (!sValue.equals(TargetCodeSize)) {
                        dirtyflag = true;
                    }
                    TargetCodeSize = sValue;
                }
                if ((sValue = CTestToolChainPropertyTab.getOptionValueFromTool(tool, Option.OPTIONID_CCOMPILER_RAMBASE)) != null && sValue.length() > 0) {
                    this.projPreferences.putRamBase(sValue, this.project);
                    this.projPreferences.flush(this.project);
                    if (!sValue.equals(TargetRamBase)) {
                        dirtyflag = true;
                    }
                    TargetRamBase = sValue;
                }
                if ((sValue = CTestToolChainPropertyTab.getOptionValueFromTool(tool, Option.OPTIONID_CCOMPILER_RAMSIZE)) != null && sValue.length() > 0) {
                    this.projPreferences.putRamSize(sValue, this.project);
                    this.projPreferences.flush(this.project);
                    if (!sValue.equals(TargetRamSize)) {
                        dirtyflag = true;
                    }
                    TargetRamSize = sValue;
                }
                ++n2;
            }
        }
        return dirtyflag;
    }

    protected void performOK() {
        try {
            if (!this.updateConfig(this.fConfig)) {
                return;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        this.updatePreferences();
        this.UpdataTemplateLdParameters();
        if (this.checkLinkFileUpdateNeeded(this.getCfg()).booleanValue() && !this.UpdataTemplateLdParameters().booleanValue()) {
            return;
        }
    }

    private boolean isThisPlugin() {
        IConfiguration fConfig = this.getCfg();
        String toolchainId = fConfig.getToolChain().getBaseId();
        if (!toolchainId.startsWith("com.gigadevice.mbs.riscv.toolChain.")) {
            if (com.gigadevice.mbs.riscv.Activator.getInstance().isDebugging()) {
                System.out.println("com.gigadevice.mbs.riscvCTestToolChainPropertyTab.isThisPlugin() return false");
            }
            return false;
        }
        return true;
    }

    protected void updateToolChainPrefix(String toolchainName) {
        assert (this.fConfig != null);
        String toolchainPrefix = this.projPreferences.getToolchainPrefix(this.project);
        TextToolChainPrefix.setText(toolchainPrefix);
    }

    protected void updateToolchainPath(String toolchainName) {
        assert (this.fConfig != null);
        String toolchainPath = this.projPreferences.getToolchainPath(toolchainName, this.project);
        TextToolChainPath.setText(toolchainPath);
    }

    protected void updateBuildToolsPath() {
        assert (this.fConfig != null);
        String Path2 = this.projPreferences.getBuildToolsPath(this.project);
        this.TextBuildToolPath.setText(Path2);
    }

    private void updateControlsForConfig(IConfiguration config) {
        if (com.gigadevice.mbs.riscv.Activator.getInstance().isDebugging()) {
            System.out.println("com.gigadevice.mbs.riscvCTestToolChainPropertyTab.updateControlsForConfig() for " + config.getName());
        }
        if (!this.isThisPlugin()) {
            return;
        }
        String fSelectedToolchainName = Option.getOptionStringValue((IConfiguration)config, (String)Option.OPTIONID_TOOLCHAIN_NAME);
        if (fSelectedToolchainName != null && fSelectedToolchainName.length() > 0) {
            try {
                int index = ToolchainDefinition.getToolchainIndex(fSelectedToolchainName);
                ToolchainDefinition targetToolchain = ToolchainDefinition.getToolchain(index);
                this.fConfig = config;
                if (com.gigadevice.mbs.riscv.Activator.getInstance().isDebugging()) {
                    System.out.println("arm.Toolchains.updateControlsForConfig() fConfig=" + this.fConfig);
                }
                this.fLastUpdatedConfig = config;
                this.InitInformation(config);
                if (TextToolChainPrefix.getText().length() == 0 || TextToolChainPrefix.getText().length() == 1) {
                    this.updateToolChainPrefix(targetToolchain.getToolchainPrefix().trim());
                }
                if (TextToolChainPath.getText().length() == 0) {
                    this.updateToolchainPath(targetToolchain.getToolchainPrefix().trim());
                }
                if (this.TextBuildToolPath.getText().length() == 0) {
                    this.updateBuildToolsPath();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                com.gigadevice.mbs.riscv.Activator.log("CTestToolChainPropertyTab.updateControlsForConfig():" + fSelectedToolchainName + " not found.");
                System.out.println("com.gigadevice.mbs.riscvCTestToolChainPropertyTab.updateControlsForConfig():" + fSelectedToolchainName + " not found.");
                return;
            }
        }
    }

    private void InitInformation(IConfiguration srcConfig) {
        srcConfig.getToolChain();
        String value = null;
        value = Option.getOptionStringValue((IConfiguration)srcConfig, (String)Option.OPTIONID_TOOLCHAIN_NAME);
        if (value != null && value.length() > 0) {
            value = value.trim();
            combotoolchainName.select(ToolchainDefinition.getToolchainIndex(value));
        }
        if ((value = Option.getOptionStringValue((IConfiguration)srcConfig, (String)Option.OPTIONID_TOOLCHAIN_PATH)) != null && value.length() > 0) {
            value = value.trim();
            TextToolChainPath.setText(value);
        }
        if ((value = Option.getOptionStringValue((IConfiguration)srcConfig, (String)Option.OPTIONID_TOOLCHAIN_PREFIX)) != null && value.length() > 0) {
            value = value.trim();
            TextToolChainPrefix.setText(value);
        }
        if ((value = Option.getOptionStringValue((IConfiguration)srcConfig, (String)Option.OPTIONID_BUILDTOOL_PATH)) != null && value.length() > 0) {
            value = value.trim();
            this.TextBuildToolPath.setText(value);
        }
    }

    private void updatePreferences() {
        String toolchainName = combotoolchainName.getText();
        this.projPreferences.putToolchainName(toolchainName, this.project);
        this.projPreferences.putToolchainPrefix(TextToolChainPrefix.getText(), this.project);
        this.UpdateGDB();
        this.projPreferences.putToolchainPath(toolchainName, TextToolChainPath.getText(), this.project);
        this.projPreferences.putBuildToolsPath(this.TextBuildToolPath.getText(), this.project);
        this.projPreferences.flush(this.project);
    }

    public void UpdateGDB() {
        String value;
        ILaunchConfiguration launchConfig = CTestToolChainPropertyTab.getTargetLanuchConfiguration(this.project);
        if (launchConfig == null) {
            return;
        }
        ILaunchConfigurationWorkingCopy launchConfigTemp = null;
        try {
            launchConfigTemp = launchConfig.getWorkingCopy();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (launchConfigTemp != null && (value = TextToolChainPath.getText()) != null && value.length() > 0) {
            value = value.trim();
            String AbsolutePath = Option.getAbsolutePath(value);
            launchConfigTemp.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", String.valueOf(AbsolutePath) + File.separator + TextToolChainPrefix.getText() + "gdb.exe");
            try {
                launchConfigTemp.doSave();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static ILaunchConfiguration getTargetLanuchConfiguration(IProject project) {
        ILaunchConfiguration launchConfig;
        ILaunchBarManager manager;
        block7: {
            manager = (ILaunchBarManager)Activator.getService(ILaunchBarManager.class);
            launchConfig = null;
            launchConfig = manager.getActiveLaunchConfiguration();
            if (launchConfig != null) break block7;
            return null;
        }
        try {
            String projectName = launchConfig.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (!projectName.equalsIgnoreCase(project.getName())) {
                launchConfig = null;
                ILaunchDescriptor[] descs = manager.getLaunchDescriptors();
                ILaunchConfiguration tmp = null;
                int i = 0;
                while (i < descs.length) {
                    ILaunchTarget[] targets = manager.getLaunchTargets(descs[i]);
                    tmp = manager.getLaunchConfiguration(descs[i], targets[0]);
                    String tmpName = tmp.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                    if (tmpName.equalsIgnoreCase(project.getName())) {
                        launchConfig = tmp;
                    }
                    ++i;
                }
            }
            if (launchConfig == null) {
                return null;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return launchConfig;
    }
}

