/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs.riscv;

import java.util.ArrayList;
import java.util.List;

public class ToolchainDefinition {
    private String toolchainName;
    private String toolchainPrefix;
    private String CCommander;
    private String CPPCommander;
    private String objcopyCommander;
    private String objdumpCommander;
    private String sizeCommander;
    private String arCommander;
    private String makeCommander;
    private String rmCommander;
    private static List<ToolchainDefinition> toolchainList = new ArrayList<ToolchainDefinition>();
    public static final String GME_RISCV_GCC = "GNU MCU RISC-V GCC";
    public static final String DEFAULT_TOOLCHAIN_NAME = "GNU MCU RISC-V GCC";
    public static final String NUCLEI_RISCV_GCC = "MCU RISC-V GCC";

    static {
        toolchainList.add(new ToolchainDefinition("GNU MCU RISC-V GCC", "riscv-none-embed-"));
        toolchainList.add(new ToolchainDefinition(NUCLEI_RISCV_GCC, "riscv-nuclei-elf-"));
    }

    public ToolchainDefinition(String name, String prefix) {
        this.toolchainName = name;
        this.toolchainPrefix = prefix;
        this.CCommander = String.valueOf(this.toolchainPrefix) + "gcc";
        this.CPPCommander = String.valueOf(this.toolchainPrefix) + "g++";
        this.objcopyCommander = String.valueOf(this.toolchainPrefix) + "objcopy";
        this.objdumpCommander = String.valueOf(this.toolchainPrefix) + "objdump";
        this.sizeCommander = String.valueOf(this.toolchainPrefix) + "size";
        this.arCommander = String.valueOf(this.toolchainPrefix) + "ar";
        this.makeCommander = "make";
        this.rmCommander = "rm";
    }

    public String getToolchainName() {
        return this.toolchainName;
    }

    public void setToolchainName(String toolchainName) {
        this.toolchainName = toolchainName;
    }

    public String getToolchainPrefix() {
        return this.toolchainPrefix;
    }

    public void setToolchainPrefix(String toolchainPrefix) {
        this.toolchainPrefix = toolchainPrefix;
    }

    public void updateToolchainPrefix(String toolchainPrefix) {
        this.toolchainPrefix = toolchainPrefix;
        this.CCommander = String.valueOf(toolchainPrefix) + "gcc";
        this.CPPCommander = String.valueOf(toolchainPrefix) + "g++";
        this.objcopyCommander = String.valueOf(toolchainPrefix) + "objcopy";
        this.objdumpCommander = String.valueOf(toolchainPrefix) + "objdump";
        this.sizeCommander = String.valueOf(toolchainPrefix) + "size";
        this.arCommander = String.valueOf(toolchainPrefix) + "ar";
    }

    public String getArchiverCommander() {
        return this.arCommander;
    }

    public String getCCommander() {
        return this.CCommander;
    }

    public void setCCommander(String cCommander) {
        this.CCommander = cCommander;
    }

    public String getCPPCommander() {
        return this.CPPCommander;
    }

    public void setCPPCommander(String cppCommander) {
        this.CPPCommander = cppCommander;
    }

    public String getObjcopyCommander() {
        return this.objcopyCommander;
    }

    public void setObjcopyCommander(String objcopyCommander) {
        this.objcopyCommander = objcopyCommander;
    }

    public String getObjdumpCommander() {
        return this.objdumpCommander;
    }

    public void setObjdumpCommander(String objdumpCommander) {
        this.objdumpCommander = objdumpCommander;
    }

    public String getSizeCommander() {
        return this.sizeCommander;
    }

    public void setSizeCommander(String sizeCommander) {
        this.sizeCommander = sizeCommander;
    }

    public String getMakeCommander() {
        return this.makeCommander;
    }

    public void setMakeCommander(String makeCommander) {
        this.makeCommander = makeCommander;
    }

    public String getRmCommander() {
        return this.rmCommander;
    }

    public void setRmCommander(String rmCommander) {
        this.rmCommander = rmCommander;
    }

    public static int getToolchainIndex(String targetToolchainName) {
        int index = 0;
        for (ToolchainDefinition temp : toolchainList) {
            if (temp.toolchainName.equals(targetToolchainName)) {
                return index;
            }
            ++index;
        }
        throw new IndexOutOfBoundsException();
    }

    public static int getToolchainDefaultIndex() {
        int index = 0;
        for (ToolchainDefinition temp : toolchainList) {
            if (temp.toolchainName.equals("GNU MCU RISC-V GCC")) {
                return index;
            }
            ++index;
        }
        throw new IndexOutOfBoundsException();
    }

    public static ToolchainDefinition getToolchain(int index) {
        return toolchainList.get(index);
    }

    public static List<ToolchainDefinition> getToolchainList() {
        return toolchainList;
    }
}

