/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.xmlparse;

import com.gigadevice.codegenerate.informationbasestruct.GroupStruct;
import com.gigadevice.codegenerate.informationbasestruct.InfoGroupStruct;
import com.gigadevice.codegenerate.informationbasestruct.InfoStruct;
import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class InformationXmlParse {
    private static final String XML_GROUP = "Group";
    private static final String XML_INFOGROUP = "InfoGroup";
    private static final String XML_RELATION = "Relation";
    private static final String XML_PRIVILEGEINFOS = "PrivilegeInfos";
    private static final String XML_PRIVILEGEUSER = "PrivilegeUser";
    private static final String ATTRIBUTES_NAME = "Name";
    private static final String ATTRIBUTES_TIPS = "Tips";

    public static InfoStruct parseInformationXMl(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        InfoStruct infoStructObj = new InfoStruct();
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            List InfoMapGroupList = rootElm.elements(XML_GROUP);
            InformationXmlParse.ParseRoot(infoStructObj, InfoMapGroupList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return infoStructObj;
    }

    private static void ParseRoot(InfoStruct infoStructObj, List<Element> listNode) {
        Iterator<Element> it = listNode.iterator();
        while (it.hasNext()) {
            GroupStruct groupStruct = new GroupStruct();
            Element elm = it.next();
            String GroupName = elm.attributeValue(ATTRIBUTES_NAME);
            List InfoGroupNodeList = elm.elements(XML_INFOGROUP);
            InformationXmlParse.ParseGroup(groupStruct, InfoGroupNodeList);
            infoStructObj.putGroups(GroupName, groupStruct);
        }
    }

    private static void ParseGroup(GroupStruct groupStruct, List<Element> listNode) {
        Iterator<Element> it = listNode.iterator();
        while (it.hasNext()) {
            InfoGroupStruct infoGroupStructObj = new InfoGroupStruct();
            Element elm = it.next();
            String Tips = elm.attributeValue(ATTRIBUTES_TIPS);
            infoGroupStructObj.setTips(Tips);
            List RelationNodeList = elm.elements(XML_RELATION);
            for (Element elmRelation : RelationNodeList) {
                String TypeName = elmRelation.attributeValue(ATTRIBUTES_NAME);
                ConflictGroupInfo GroupInfoObj = new ConflictGroupInfo();
                GroupInfoObj.setType(TypeName);
                InformationXmlParse.ParsePrivilegeInfosList(GroupInfoObj, elmRelation);
                infoGroupStructObj.putRelation(GroupInfoObj);
            }
            groupStruct.putInfoGroup(infoGroupStructObj);
        }
    }

    private static void ParsePrivilegeInfosList(ConflictGroupInfo GroupInfoObj, Element elmRelation) {
        List UserList = GroupInfoObj.getConditionsList();
        List PrivilegeInfosList = elmRelation.elements(XML_PRIVILEGEINFOS);
        for (Element elmPrivilegeInfos : PrivilegeInfosList) {
            List PrivilegeUserList = elmPrivilegeInfos.elements(XML_PRIVILEGEUSER);
            ArrayList<ConditionInfo> UList = new ArrayList<ConditionInfo>();
            for (Element elmPrivilegeUser : PrivilegeUserList) {
                ConditionInfo PrivilegeUserObj = new ConditionInfo();
                PrivilegeUserObj.setType("Item");
                Iterator itAttribute = elmPrivilegeUser.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    if (attributeValue.equals("")) continue;
                    PrivilegeUserObj.setAttrValue(attributeName, attributeValue);
                }
                UList.add(PrivilegeUserObj);
            }
            UserList.add(UList);
        }
        GroupInfoObj.setConditionsList(UserList);
    }
}

