/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.tool;

import com.gigadevice.codegenerate.util.SystemVarUtil;
import com.gigadevice.periconfigview.utils.GPIOConfigUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.gpio.GPIOInfoUtil;
import com.gigadevice.venustool.gpio.GPIOVariables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;

public class GPIOReflectionFunc {
    public int GetCycleNum(String strPeri) {
        int ret = 0;
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri)) {
            Map GPIOTableData = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri);
            ret = GPIOTableData.size();
        }
        return ret;
    }

    public String GetPinName(String strPeri, String strRowIndex) {
        String strRet = "";
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri)) {
            Map DataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri);
            int CycleNum = 0;
            for (String key : DataMap.keySet()) {
                if (CycleNum == Integer.valueOf(strRowIndex)) {
                    Vector RowData = (Vector)DataMap.get(key);
                    strRet = ((String)RowData.get(0)).toString();
                    break;
                }
                ++CycleNum;
            }
        }
        return strRet;
    }

    public String GetGPIOInfo(String strPeri, String strPinName, String strColIndex) {
        Vector RowData;
        String strData;
        Map DataMap;
        String strRet = "";
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri) && (DataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri)).containsKey(strPinName) && GPIOConfigUtil.GPIOXMLCodeDefineMap.containsKey(strData = ((String)(RowData = (Vector)DataMap.get(strPinName)).get(Integer.valueOf(strColIndex))).toString())) {
            strRet = (String)GPIOConfigUtil.GPIOXMLCodeDefineMap.get(strData);
        }
        return strRet;
    }

    public String GetUserLabel(String strPeri, String strPinName, String strColIndex) {
        Map DataMap;
        String strRet = "";
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri) && (DataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri)).containsKey(strPinName)) {
            Vector RowData = (Vector)DataMap.get(strPinName);
            strRet = ((String)RowData.get(Integer.valueOf(strColIndex))).toString();
        }
        return strRet;
    }

    public String GetGPIOtableSignal(String strPeri, String strPinName) {
        Vector RowData;
        Map DataMap;
        String strRet = "";
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri) && (DataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri)).containsKey(strPinName) && (strRet = ((String)(RowData = (Vector)DataMap.get(strPinName)).get(1)).toString()).toUpperCase().contains("EXTI")) {
            strRet = strRet.replaceAll("EXTI(\\d+)", "EXTI_$1");
        }
        return strRet;
    }

    public String JudgeSiganalOnPinIsGPIO(String strPeri) {
        String strRet = "false";
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri)) {
            Map DataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri);
            for (String key : DataMap.keySet()) {
                Vector RowData = (Vector)DataMap.get(key);
                String strData = ((String)RowData.get(1)).toString();
                String strMode = ((String)RowData.get(3)).toString();
                if (strData.toUpperCase().contains("EXTI") || strMode.toUpperCase().contains("N/A")) continue;
                strRet = "true";
                break;
            }
        }
        return strRet;
    }

    public String JudgeSiganalOnPinIsNoCode(String strPeri, String strSignal) {
        String strRet = "true";
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri)) {
            if (GPIOVariables.GPIONoCodeSignal.contains(strSignal)) {
                strRet = "false";
            }
        } else {
            strRet = "false";
        }
        return strRet;
    }

    public String JudgePinIsNoCode(String strPeri, String strPinName) {
        String strRet = "true";
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri)) {
            if (GPIOVariables.GPIONoCodePin.contains(strPinName)) {
                strRet = "false";
            }
        } else {
            strRet = "false";
        }
        return strRet;
    }

    public String JudgeSiganalOnPinIsEXTI(String strSignal) {
        String strRet = "false";
        if (strSignal.toUpperCase().contains("EXTI")) {
            strRet = "true";
        }
        return strRet;
    }

    public String JudgeModeIsNA(String strMode) {
        String strRet = "false";
        if (!strMode.toUpperCase().contains("N/A")) {
            strRet = "true";
        }
        return strRet;
    }

    public String JudgeModeIsNotEvent(String strMode) {
        String strRet = "true";
        if (strMode.toUpperCase().contains("N/A") || strMode.toUpperCase().contains("EVENT")) {
            strRet = "false";
        }
        return strRet;
    }

    public boolean GetConditionsAND(String strbl1, String strbl2) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3, String strbl4) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3) && Boolean.parseBoolean(strbl4);
    }

    public boolean GetConditionsAND(String ... conditions) {
        String[] stringArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            String condition = stringArray[n2];
            if (!Boolean.parseBoolean(condition)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean GetConditionsOR(String strbl1, String strbl2) {
        return Boolean.parseBoolean(strbl1) || Boolean.parseBoolean(strbl2);
    }

    public boolean GetConditionOpposite(String strbl) {
        return !Boolean.parseBoolean(strbl);
    }

    public String GetPinAFValue(String strPinName) {
        String strRet = "";
        String strAF = GlobalVariables.gd32mcuObj.GetPinAFValueByPinName(strPinName);
        if (strAF.equals("")) {
            return "";
        }
        String strBin = "";
        if (strAF.contains("AF")) {
            strBin = strAF.substring(2, strAF.length());
        } else if (strAF.contains("REMAP")) {
            strBin = strAF.substring(5, strAF.length());
        }
        int val = Integer.parseUnsignedInt(strBin);
        strRet = "HAL_GPIO_AF_" + Integer.toString(val);
        return strRet;
    }

    public String GetPinAFValueNoHAL(String strPinName) {
        String strRet = "";
        String strAF = GlobalVariables.gd32mcuObj.GetPinAFValueByPinName(strPinName);
        if (strAF.equals("")) {
            return "";
        }
        String strBin = "";
        if (strAF.contains("AF")) {
            strBin = strAF.substring(2, strAF.length());
        } else if (strAF.contains("REMAP")) {
            strBin = strAF.substring(5, strAF.length());
        }
        int val = Integer.parseUnsignedInt(strBin);
        strRet = "GPIO_AF_" + Integer.toString(val);
        return strRet;
    }

    public String GetPinPort(String strPinName, String strUserLabel) {
        String strRet = "";
        if (strUserLabel.equals("")) {
            String strPort = strPinName.substring(1, 2);
            strRet = "GPIO" + strPort;
        } else {
            String idString = strPinName.substring(1);
            strRet = String.valueOf(strUserLabel) + idString + "_GPIO_PORT";
            String strPort = strPinName.substring(1, 2);
            strPort = "GPIO" + strPort;
            SystemVarUtil.GPIOUserLabelMap.put(strRet, strPort);
        }
        return strRet;
    }

    public String GetRepeatedPinPort(String strPinName) {
        String strPort = "GPIO" + strPinName.substring(1, 2);
        for (String key : SystemVarUtil.GPIOUserLabelMap.keySet()) {
            if (!SystemVarUtil.GPIOUserLabelMap.get(key).equals(strPort)) continue;
            return key;
        }
        String strRet = "GPIO" + strPinName.substring(1, 2);
        return strRet;
    }

    public String GetPinNum(String strPinName, String strUserLabel) {
        String strRet = "";
        if (GPIOVariables.GPIOSharePin.containsKey(strPinName)) {
            strPinName = ((String)GPIOVariables.GPIOSharePin.get(strPinName)).equals("") ? this.removeSuffixIfPresent(strPinName, "_C") : (String)GPIOVariables.GPIOSharePin.get(strPinName);
        }
        if (strUserLabel.equals("")) {
            String strPinNum = strPinName.substring(2, strPinName.length());
            strRet = "GPIO_PIN_" + strPinNum;
        } else {
            String idString = strPinName.substring(1);
            strRet = String.valueOf(strUserLabel) + idString + "_PIN";
            String strPinNum = strPinName.substring(2, strPinName.length());
            strPinNum = "GPIO_PIN_" + strPinNum;
            SystemVarUtil.GPIOUserLabelMap.put(strRet, strPinNum);
        }
        return strRet;
    }

    public String GetExtiSourcePinNum(String strPinName) {
        return strPinName.replaceAll("GPIO_PIN_(\\d+)", "EXTI_SOURCE_PIN$1");
    }

    public String GetExtiSourcePinPort(String strPinPort) {
        return "EXTI_SOURCE_" + strPinPort;
    }

    public String Ismaxspeed(String strMode) {
        String strRet = "false";
        if (strMode == null || strMode.equals("")) {
            return strRet;
        }
        if (strMode.toUpperCase().contains("GPIO_OSPEED")) {
            return "true";
        }
        return strRet;
    }

    public String GetExtiSecondInfo(String strMode) {
        String[] parts;
        String strRet = "";
        if (strMode == null || strMode.equals("") || strMode.equals("NA") || !strMode.contains(",")) {
            return strRet;
        }
        String[] stringArray = parts = strMode.split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.contains("EXTI_TRIG")) {
                return part;
            }
            ++n2;
        }
        return strRet;
    }

    public String GetExtiFirstInfo(String strMode) {
        String[] parts;
        String strRet = "";
        if (strMode == null || strMode.equals("") || strMode.equals("NA") || !strMode.contains(",")) {
            return strRet;
        }
        String[] stringArray = parts = strMode.split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.contains("EXTI_INTERRUPT") || part.contains("EXTI_EVENT")) {
                return part;
            }
            ++n2;
        }
        return strRet;
    }

    public String GetGPIOTypeInfo(String strMode) {
        String[] parts;
        String strRet = "";
        if (strMode == null || strMode.equals("") || strMode.equals("NA") || !strMode.contains(",")) {
            return strRet;
        }
        String[] stringArray = parts = strMode.split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.contains("GPIO_OTYPE")) {
                return part;
            }
            ++n2;
        }
        return strRet;
    }

    public String GetGPIOModeInfo(String strMode) {
        String[] parts;
        String strRet = "";
        if (strMode == null || strMode.equals("") || strMode.equals("NA") || !strMode.contains(",")) {
            return strRet;
        }
        String[] stringArray = parts = strMode.split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.contains("GPIO_MODE")) {
                return part;
            }
            ++n2;
        }
        return strRet;
    }

    public String IsPullUpDownMode(String strMode) {
        String strRet = "false";
        if (strMode == null || strMode.equals("") || strMode.equals("NA")) {
            return strRet;
        }
        if (strMode.toUpperCase().contains("PUPD_NONE") || strMode.toUpperCase().contains("PUPD_PULLUP") || strMode.toUpperCase().contains("PUPD_PULLDOWN")) {
            return "true";
        }
        return strRet;
    }

    public String IsPullOrDrainModeNoAF(String strMode) {
        boolean isNotAF;
        String strRet = "false";
        if (strMode == null || strMode.equals("") || strMode.equals("NA")) {
            return strRet;
        }
        String upperStrMode = strMode.toUpperCase();
        boolean isOutputOrDrain = upperStrMode.contains("_OUTPUT") || upperStrMode.contains("_PP") || upperStrMode.contains("_OD");
        boolean bl = isNotAF = !upperStrMode.contains("_AF");
        if (isOutputOrDrain && isNotAF) {
            return "true";
        }
        return strRet;
    }

    public String IsPullOrDrainModeContainAF(String strMode) {
        String strRet = "false";
        if (strMode == null || strMode.equals("") || strMode.equals("NA")) {
            return strRet;
        }
        if ((strMode.toUpperCase().contains("_PP") || strMode.toUpperCase().contains("_OD")) && strMode.toUpperCase().contains("_AF")) {
            return "true";
        }
        return strRet;
    }

    public String IsAnalogMode(String strMode) {
        String strRet = "false";
        if (strMode == null || strMode.equals("") || strMode.equals("NA")) {
            return strRet;
        }
        if (strMode.toUpperCase().contains("ANALOG") || strMode.toUpperCase().equals("GPIO_MODE_AIN")) {
            return "true";
        }
        return strRet;
    }

    public String IsInputMode(String strMode) {
        String strRet = "false";
        if (strMode == null || strMode.equals("") || strMode.equals("NA")) {
            return strRet;
        }
        if (strMode.toUpperCase().contains("INPUT") || strMode.toUpperCase().equals("GPIO_MODE_IN_FLOATING") || strMode.toUpperCase().equals("GPIO_MODE_IPU") || strMode.toUpperCase().equals("GPIO_MODE_IPD")) {
            return "true";
        }
        return strRet;
    }

    public String IsInputFilter(String strMode) {
        String strRet = "false";
        if (strMode == null || strMode.equals("") || strMode.equals("NA")) {
            return strRet;
        }
        if (strMode.toUpperCase().contains("INPUT") || strMode.toUpperCase().contains("GPIO_MODE_AF")) {
            return "true";
        }
        return strRet;
    }

    public String IsOutputMode(String strMode) {
        String strRet = "false";
        if (strMode == null || strMode.equals("") || strMode.equals("NA")) {
            return strRet;
        }
        if (strMode.toUpperCase().contains("GPIO_MODE_OUTPUT") || strMode.toUpperCase().contains("GPIO_MODE_OUT_")) {
            return "true";
        }
        return strRet;
    }

    public String IsAFMode(String strMode) {
        String strRet = "false";
        if (strMode == null || strMode.equals("") || strMode.equals("NA")) {
            return strRet;
        }
        if (strMode.toUpperCase().contains("GPIO_MODE_AF") || strMode.toUpperCase().contains("GPIO_MODE_AF_")) {
            return "true";
        }
        return strRet;
    }

    public boolean JudgeOutputLevelHigh(String str) {
        boolean ret = false;
        if (str.toUpperCase().equals("HIGH")) {
            ret = true;
        }
        return ret;
    }

    public boolean JudgeOutputLevelLow(String str) {
        boolean ret = false;
        if (str.toUpperCase().equals("LOW")) {
            ret = true;
        }
        return ret;
    }

    public String GetGPIOPinRemapConfig(String str) {
        String ret = "";
        if (!GPIOInfoUtil.GPIOConfigInfoMap.containsKey(str)) {
            return ret;
        }
        ArrayList<String> retRemap = new ArrayList<String>();
        Map tableData = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(str);
        ArrayList<String> lstPinUsed = new ArrayList<String>();
        for (String keyUsed : tableData.keySet()) {
            lstPinUsed.add(keyUsed);
        }
        List lstPinRemap = new ArrayList();
        for (String key : GPIOConfigUtil.GPIOXMLRemapMap.keySet()) {
            lstPinRemap = (List)GPIOConfigUtil.GPIOXMLRemapMap.get(key);
            boolean AllPinContains = true;
            int i = 0;
            while (i < lstPinUsed.size()) {
                if (!lstPinRemap.contains(lstPinUsed.get(i))) {
                    AllPinContains = false;
                    break;
                }
                ++i;
            }
            if (!AllPinContains) continue;
            retRemap.add(key);
        }
        if (retRemap.size() == 1) {
            return "gpio_pin_remap_config(" + (String)retRemap.get(0) + ", ENABLE);";
        }
        if (retRemap.size() > 1) {
            int i = 0;
            while (i < retRemap.size()) {
                if (((String)retRemap.get(i)).contains(str)) {
                    return "gpio_pin_remap_config(" + (String)retRemap.get(0) + ", ENABLE);";
                }
                ++i;
            }
        }
        return ret;
    }

    public boolean GetGPIOPinRemapFunction(String str) {
        boolean ret = false;
        if (!GlobalVariables.gd32mcuObj.getisRemap()) {
            return ret;
        }
        if (!GPIOInfoUtil.GPIOConfigInfoMap.containsKey(str)) {
            return ret;
        }
        ArrayList<String> retRemap = new ArrayList<String>();
        Map tableData = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(str);
        ArrayList<String> lstPinUsed = new ArrayList<String>();
        for (String keyUsed : tableData.keySet()) {
            lstPinUsed.add(keyUsed);
        }
        List lstPinRemap = new ArrayList();
        for (String key : GPIOConfigUtil.GPIOXMLRemapMap.keySet()) {
            lstPinRemap = (List)GPIOConfigUtil.GPIOXMLRemapMap.get(key);
            boolean AllPinContains = true;
            int i = 0;
            while (i < lstPinUsed.size()) {
                if (!lstPinRemap.contains(lstPinUsed.get(i))) {
                    AllPinContains = false;
                    break;
                }
                ++i;
            }
            if (!AllPinContains) continue;
            retRemap.add(key);
        }
        if (retRemap.size() > 0) {
            ret = true;
        }
        return ret;
    }

    public String JudgeSharePinUsedFunction(String strPinName, String strSignal) {
        Map map = GlobalVariables.getConfigPinInfo();
        String strRet = "true";
        if (GPIOVariables.GPIOSharePin.containsKey(strPinName)) {
            String sharePin = (String)GPIOVariables.GPIOSharePin.get(strPinName);
            if (sharePin.equals("") || GlobalVariables.gd32mcuObj.GetPinIndexByPinName(sharePin) == -1) {
                return "true";
            }
            if (map.containsKey(sharePin)) {
                strRet = "false";
            } else if (strSignal.toUpperCase().contains("ADC") || strSignal.toUpperCase().contains("ANALOG MODE")) {
                strRet = "false";
            }
        }
        return strRet;
    }

    public String JudgePeriGPIOCodePin(String strPeri) {
        String strRet = "false";
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri)) {
            Map DataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri);
            for (String key : DataMap.keySet()) {
                Vector RowData = (Vector)DataMap.get(key);
                String strPinName = ((String)RowData.get(0)).toString();
                String strSignal = ((String)RowData.get(1)).toString();
                String strMode = ((String)RowData.get(3)).toString();
                if (GPIOVariables.GPIONoCodeSignal.contains(strSignal) || GPIOVariables.GPIONoCodePin.contains(strPinName) || strSignal.toUpperCase().contains("EXTI") || strMode.toUpperCase().contains("N/A")) continue;
                strRet = "true";
                break;
            }
        }
        return strRet;
    }

    public String JudgePeriGPIOCodePinWithEXTI(String strPeri) {
        String strRet = "false";
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri)) {
            Map DataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri);
            for (String key : DataMap.keySet()) {
                Vector RowData = (Vector)DataMap.get(key);
                String strPinName = ((String)RowData.get(0)).toString();
                String strSignal = ((String)RowData.get(1)).toString();
                String strMode = ((String)RowData.get(3)).toString();
                if (GPIOVariables.GPIONoCodeSignal.contains(strSignal) || GPIOVariables.GPIONoCodePin.contains(strPinName) || strMode.toUpperCase().contains("N/A")) continue;
                strRet = "true";
                break;
            }
        }
        return strRet;
    }

    public String sharePinSwitchCode(String strPinName, String strSignal) {
        Map map = GlobalVariables.getConfigPinInfo();
        String strRet = "";
        if (GPIOVariables.GPIOSharePin.containsKey(strPinName)) {
            String sharePin = (String)GPIOVariables.GPIOSharePin.get(strPinName);
            if (sharePin.equals("") || GlobalVariables.gd32mcuObj.GetPinIndexByPinName(sharePin) == -1) {
                return "";
            }
            if (map.containsKey(sharePin)) {
                String marco = GPIOReflectionFunc.formatSharePinMacro(strPinName);
                strRet = "hal_syscfg_analog_switch_disable(" + marco + ");";
            } else if (strSignal.toUpperCase().contains("ADC") || strSignal.toUpperCase().contains("ANALOG MODE")) {
                String marco = GPIOReflectionFunc.formatSharePinMacro(strPinName);
                strRet = "hal_syscfg_analog_switch_disable(" + marco + ");";
            } else {
                String marco = GPIOReflectionFunc.formatSharePinMacro(strPinName);
                strRet = "hal_syscfg_analog_switch_enable(" + marco + ");";
            }
        } else if (GPIOVariables.GPIOSharePin.values().stream().collect(Collectors.toList()).contains(strPinName)) {
            String sharePin_C = this.findKeyByValue(GPIOVariables.GPIOSharePin, strPinName);
            if (sharePin_C == null) {
                String marco = GPIOReflectionFunc.formatSharePinMacro(strPinName);
                strRet = "hal_syscfg_analog_switch_disable(" + marco + ");";
            } else if (!map.containsKey(sharePin_C)) {
                String marco = GPIOReflectionFunc.formatSharePinMacro(strPinName);
                strRet = "hal_syscfg_analog_switch_disable(" + marco + ");";
            }
        }
        return strRet;
    }

    private static String formatSharePinMacro(String input) {
        if (input.endsWith("_C")) {
            input = input.substring(0, input.length() - 2);
        }
        return "SYSCFG_" + input + "_ANALOG_SWITCH";
    }

    private String findKeyByValue(Map<String, String> map, String targetValue) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(targetValue)) continue;
            return entry.getKey();
        }
        return null;
    }

    private String removeSuffixIfPresent(String str, String suffix) {
        if (str != null && str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }
}

