/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.generatecode;

import com.gigadevice.codegenerate.baseinfo.CodeContentStruct;
import com.gigadevice.codegenerate.baseinfo.CodeFuncImpleStruct;
import com.gigadevice.codegenerate.baseinfo.CodeGlobalStruct;
import com.gigadevice.codegenerate.baseinfo.CodeStructPart;
import com.gigadevice.codegenerate.baseinfo.CodeTextStruct;
import com.gigadevice.codegenerate.baseinfo.ModuleConfigStruct;
import com.gigadevice.codegenerate.baseinfo.VarBaseVarStruct;
import com.gigadevice.codegenerate.baseinfo.VarConditionStruct;
import com.gigadevice.codegenerate.baseinfo.VarConditionVarStruct;
import com.gigadevice.codegenerate.baseinfo.VarConditionsStruct;
import com.gigadevice.codegenerate.baseinfo.VarFunctionStruct;
import com.gigadevice.codegenerate.baseinfo.VarRelationStruct;
import com.gigadevice.codegenerate.baseinfo.VarValueStruct;
import com.gigadevice.codegenerate.baseinfo.VariablesXMLInfo;
import com.gigadevice.codegenerate.systemperi.DMAPeriGenerate;
import com.gigadevice.codegenerate.systemperi.GPIOPeriGenerate;
import com.gigadevice.codegenerate.systemperi.MDMAPeriGenerate;
import com.gigadevice.codegenerate.systemperi.NVICPeriGenerate;
import com.gigadevice.codegenerate.systemperi.RCUPeriGenerate;
import com.gigadevice.codegenerate.tool.InvokeReflectionFunc;
import com.gigadevice.codegenerate.util.CodeGenerateUtil;
import com.gigadevice.codegenerate.util.FileContentUtil;
import com.gigadevice.codegenerate.util.SystemVarUtil;
import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ExtendNodeListInfo;
import com.gigadevice.conflict.baseinfo.NewRelationGroup;
import com.gigadevice.conflict.tool.ExtendNodeWork;
import com.gigadevice.periconfigview.utils.GeneralPeriConfigUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.TargetOSInfo;
import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.controlconflict.PeriParaTreeConflict;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeGenerateTool {
    private Map<String, String> VarValueMap = new HashMap<String, String>();
    private VariablesXMLInfo VarXMLInfo;
    private String PeriMaster;
    private String PeriName;
    private String FileName;
    public boolean ItFile = false;
    private String Perix;
    private String InterruptName;
    private GPIOPeriGenerate GPIOPeriGenerateObj = new GPIOPeriGenerate();
    private DMAPeriGenerate DMAPeriGenerateObj = new DMAPeriGenerate();
    private MDMAPeriGenerate mDMAPeriGenerateObj = new MDMAPeriGenerate();
    private RCUPeriGenerate RCUPeriGenerateObj = new RCUPeriGenerate();
    private NVICPeriGenerate NVICPeriGenerateObj = new NVICPeriGenerate();

    public void CodeGenerateToolInit(String PeriMaster, String mPeriName, VariablesXMLInfo mVarXMLInfo) {
        this.PeriMaster = PeriMaster;
        this.PeriName = mPeriName;
        this.VarXMLInfo = mVarXMLInfo;
        this.FileName = "init.c";
        String SystemPeri = "GPIONVICMDMADBG";
        if (!SystemPeri.contains(PeriMaster)) {
            GeneralPeriConfigUtil.InitPeriConfigInfo((String)PeriMaster);
        }
        this.UpdateVarValueMap();
    }

    public void CodeGenerateToolInit(boolean ItFile, String Perix, String InterruptName, VariablesXMLInfo mVarXMLInfo) {
        this.PeriMaster = "";
        this.PeriName = Perix;
        this.ItFile = ItFile;
        this.Perix = Perix;
        this.InterruptName = InterruptName;
        this.VarXMLInfo = mVarXMLInfo;
        this.FileName = "it.c";
        this.UpdateVarValueMap();
    }

    private void UpdateVarValueMap() {
        if (this.VarXMLInfo == null) {
            return;
        }
        List<VarBaseVarStruct> BaseVarNodeList = this.VarXMLInfo.getBaseVarNodeList();
        int i = 0;
        while (i < BaseVarNodeList.size()) {
            String VarName = BaseVarNodeList.get(i).getName();
            if (!this.VarValueMap.containsKey(VarName)) {
                this.AddBaseVarValueinMap(BaseVarNodeList.get(i));
            }
            ++i;
        }
        List<VarConditionVarStruct> ConditionVarNodeList = this.VarXMLInfo.getConditionVarNodeList();
        int i2 = 0;
        while (i2 < ConditionVarNodeList.size()) {
            String Name = ConditionVarNodeList.get(i2).getName();
            if (!this.VarValueMap.containsKey(Name)) {
                this.AddCondiVarValueinMap(ConditionVarNodeList.get(i2));
            }
            ++i2;
        }
    }

    private void AddBaseVarValueinMap(VarBaseVarStruct VarBaseVarNodeObj) {
        int CycleNum = this.GetBaseVarCycleNum(VarBaseVarNodeObj);
        int i = 0;
        while (i < CycleNum) {
            int ChildNodeType;
            String VarName = this.CycleSerialReplace(VarBaseVarNodeObj.getName(), i);
            String VarValue = VarBaseVarNodeObj.getDefaultValue();
            if (VarValue.contains("@")) {
                VarValue = this.CycleSerialReplace(VarValue, i);
                VarValue = this.GetBaseVarValue(VarValue, "0", "");
            }
            if ((ChildNodeType = VarBaseVarNodeObj.getChildNodeType()) == CodeGenerateUtil.BaseVarRelate.BaseVarRelateIsFuncNode.ordinal()) {
                VarFunctionStruct FunctionNode = VarBaseVarNodeObj.getFunctionNode();
                Object tmp = this.ReturnFunctionNodeValue(FunctionNode, i);
                if (tmp != null) {
                    VarValue = tmp.toString();
                }
            } else if (ChildNodeType == CodeGenerateUtil.BaseVarRelate.BaseVarRelateIsExtendNode.ordinal()) {
                String operType = VarBaseVarNodeObj.getOperType();
                if (operType != "") {
                    ExtendNodeListInfo extendNodeListInfo = VarBaseVarNodeObj.getExtendNodeListInfo();
                    Object result = ExtendNodeWork.getExtendNodeResult((ExtendNodeListInfo)extendNodeListInfo, (String)operType, (String)VarBaseVarNodeObj.getName());
                    if (result == null) {
                        return;
                    }
                    VarValue = result.toString();
                }
            } else if (ChildNodeType == CodeGenerateUtil.BaseVarRelate.BaseVarRelateIsValuesNode.ordinal()) {
                String Type = VarBaseVarNodeObj.getType();
                if (Type.equals("1")) {
                    if (!this.checkRelationControlIsValid(VarBaseVarNodeObj)) {
                        VarValue = "%InvalidValue%";
                    } else {
                        List<VarValueStruct> ValueNodeList = VarBaseVarNodeObj.getValueNodeList();
                        int j = 0;
                        while (j < ValueNodeList.size()) {
                            VarValueStruct VarValueNode = ValueNodeList.get(j);
                            boolean result = false;
                            if (VarValueNode.getConditionType() == 0) {
                                VarRelationStruct RelationNode = VarValueNode.getRelationNode();
                                result = this.CheckRelationNode(RelationNode);
                            } else {
                                result = this.CheckNewRelationNode(VarValueNode.getNestConditionGroupObj(), i);
                            }
                            if (result) {
                                String text = ValueNodeList.get(j).getText();
                                if ((text = this.CycleSerialReplace(text, i)).contains("@")) {
                                    VarValue = this.GetBaseVarValue(text, "0", "");
                                } else {
                                    String RelateFrom = ValueNodeList.get(j).getRelateFrom();
                                    VarValue = this.GetBaseVarValue(text, RelateFrom, "");
                                }
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (Type.equals("0")) {
                    String Value = VarBaseVarNodeObj.getValue();
                    Value = this.CycleSerialReplace(Value, i);
                    String RelateFrom = VarBaseVarNodeObj.getRelateFrom();
                    String GroupName = VarBaseVarNodeObj.getParentNode();
                    if (this.VarValueMap.containsKey(GroupName)) {
                        GroupName = this.VarValueMap.get(GroupName);
                    }
                    VarValue = this.GetBaseVarValue(Value, RelateFrom, GroupName);
                } else if (Type.equals("2")) {
                    String LogicType = VarBaseVarNodeObj.getLogicType();
                    if (!this.checkRelationControlIsValid(VarBaseVarNodeObj)) {
                        VarValue = "%InvalidValue%";
                    } else {
                        List<VarValueStruct> ValueNodeList = VarBaseVarNodeObj.getValueNodeList();
                        String logicVarValue = "";
                        boolean logicFlag = false;
                        int j = 0;
                        while (j < ValueNodeList.size()) {
                            VarValueStruct VarValueNode = ValueNodeList.get(j);
                            boolean result = false;
                            if (VarValueNode.getConditionType() == 0) {
                                VarRelationStruct RelationNode = VarValueNode.getRelationNode();
                                result = this.CheckRelationNode(RelationNode);
                            } else {
                                result = this.CheckNewRelationNode(VarValueNode.getNestConditionGroupObj(), i);
                            }
                            if (result) {
                                logicFlag = true;
                                String text = ValueNodeList.get(j).getText();
                                text = this.CycleSerialReplace(text, i);
                                String RelateFrom = ValueNodeList.get(j).getRelateFrom();
                                logicVarValue = String.valueOf(logicVarValue) + this.GetBaseVarValue(text, RelateFrom, "") + " " + LogicType + " ";
                            }
                            ++j;
                        }
                        int subLength = LogicType.length() + 2;
                        if (logicVarValue.length() > subLength) {
                            logicVarValue = logicVarValue.substring(0, logicVarValue.length() - subLength);
                        }
                        if (logicFlag) {
                            VarValue = logicVarValue;
                        }
                    }
                }
            }
            this.VarValueMap.put(VarName, VarValue);
            ++i;
        }
    }

    private void AddCondiVarValueinMap(VarConditionVarStruct VarConditionVarNodeObj) {
        String CycleVar = VarConditionVarNodeObj.getCycleValue();
        int CycleNum = 1;
        if (!CycleVar.equals("")) {
            try {
                CycleNum = Integer.parseInt(this.GetBaseVarValue(CycleVar, "0", "").replaceAll("[^0-9]", ""));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        int n = 0;
        while (n < CycleNum) {
            String Name = VarConditionVarNodeObj.getName();
            Name = this.CycleSerialReplace(Name, n);
            boolean result = false;
            if (VarConditionVarNodeObj.getChildNodeType() == 0) {
                result = VarConditionVarNodeObj.getConditionType() == 0 ? this.CheckRelationNode(VarConditionVarNodeObj.getRelationNode()) : this.CheckNewRelationNode(VarConditionVarNodeObj.getNestConditionGroupObj(), n);
            } else if (VarConditionVarNodeObj.getChildNodeType() == 1) {
                Object tmp = null;
                VarFunctionStruct FunctionNode = VarConditionVarNodeObj.getFunctionNode();
                tmp = this.ReturnFunctionNodeValue(FunctionNode, n);
                if (tmp != null) {
                    result = Boolean.parseBoolean(tmp.toString());
                }
            }
            if (result) {
                this.VarValueMap.put(Name, "true");
            } else {
                this.VarValueMap.put(Name, "false");
            }
            ++n;
        }
    }

    private int GetBaseVarCycleNum(VarBaseVarStruct VarBaseVarNodeObj) {
        String CycleVar = VarBaseVarNodeObj.getCycleValue();
        int CycleNum = 1;
        if (!CycleVar.equals("") && CycleVar.contains("@")) {
            block4: {
                if (!this.GetBaseVarValue(CycleVar, "0", VarBaseVarNodeObj.getParentNode()).equals("")) break block4;
                return 0;
            }
            try {
                CycleNum = Integer.parseInt(this.GetBaseVarValue(CycleVar, "0", VarBaseVarNodeObj.getParentNode()).replaceAll("[^0-9]", ""));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return CycleNum;
    }

    private boolean CheckRelationNode(VarRelationStruct RelationNode) {
        boolean result = false;
        String MethodName = RelationNode.getName();
        List<VarConditionsStruct> ConditionsNodeList = SystemVarUtil.cloneFrom(RelationNode.getConditionsNodeList());
        int n = 0;
        while (n < ConditionsNodeList.size()) {
            ConditionsNodeList.get(n).putReferPeri(this.PeriName);
            this.ConditionNodeStringReplace(ConditionsNodeList.get(n));
            ++n;
        }
        Object[] args = new Object[]{ConditionsNodeList};
        Object tmp = InvokeReflectionFunc.InvokeReflectionFunction(this.PeriMaster, MethodName, args);
        if (tmp != null) {
            result = Boolean.parseBoolean(tmp.toString());
        }
        return result;
    }

    private boolean CheckNewRelationNode(NewRelationGroup NestConditionGroupObj, int cycleValue) {
        boolean result = false;
        String className = "com.gigadevice.conflict.NewConflictCheck";
        String MethodName = "PrivilegeCheck";
        NewRelationGroup newCopyConditionGroupObj = SystemVarUtil.cloneFrom(NestConditionGroupObj);
        this.ConditionNodeStringReplace(newCopyConditionGroupObj, cycleValue);
        Object[] args = new Object[]{newCopyConditionGroupObj};
        Object tmp = InvokeReflectionFunc.InvokeFunctionByClassMethod(className, MethodName, args);
        if (tmp != null) {
            result = Boolean.parseBoolean(tmp.toString());
        }
        return result;
    }

    private void ConditionNodeStringReplace(VarConditionsStruct VarConditionsStructObj) {
        List<VarConditionStruct> ConditionNodeList = VarConditionsStructObj.getConditionNodeList();
        int i = 0;
        while (i < ConditionNodeList.size()) {
            VarConditionStruct VarConditionStructObj = ConditionNodeList.get(i);
            for (Map.Entry<String, String> entry : VarConditionStructObj.getNodeAttributesInfoMap().entrySet()) {
                String Value;
                String AttributeValue = entry.getValue();
                if (AttributeValue.equals(Value = this.GetBaseVarValue(AttributeValue, "0", ""))) continue;
                VarConditionStructObj.putNodeAttributesInfo(entry.getKey(), Value);
            }
            ++i;
        }
    }

    private void ConditionNodeStringReplace(NewRelationGroup NestConditionGroupObj, int cycleValue) {
        List ConditionNodeList = NestConditionGroupObj.getConditionsList();
        int i = 0;
        while (i < ConditionNodeList.size()) {
            ConditionInfo VarConditionStructObj = (ConditionInfo)ConditionNodeList.get(i);
            for (Map.Entry entry : VarConditionStructObj.getNodeAttributesInfoMap().entrySet()) {
                String Value;
                String AttributeValue = (String)entry.getValue();
                if ((AttributeValue = AttributeValue.replaceAll("%CycleNum%", String.valueOf(cycleValue))).equals(Value = this.GetBaseVarValue(AttributeValue, "0", ""))) continue;
                VarConditionStructObj.putNodeAttributesInfo((String)entry.getKey(), Value);
            }
            ++i;
        }
        List newRelationList = NestConditionGroupObj.getNestConditionGroupObj();
        int i2 = 0;
        while (i2 < newRelationList.size()) {
            NewRelationGroup newRelationObj = (NewRelationGroup)newRelationList.get(i2);
            this.ConditionNodeStringReplace(newRelationObj, cycleValue);
            ++i2;
        }
    }

    private Object ReturnFunctionNodeValue(VarFunctionStruct FunctionNodeObj, int CycleNum) {
        String MethodName = FunctionNodeObj.getInterFace();
        ArrayList<String> ParamList = new ArrayList<String>();
        int i = 0;
        while (i < FunctionNodeObj.getParamNodeList().size()) {
            String Param = FunctionNodeObj.getParamNodeList().get(i);
            String paraValue = this.GetBaseVarValue(Param = this.CycleSerialReplace(Param, CycleNum), "0", "").toString();
            if (paraValue.equals("%InvalidValue%")) {
                return paraValue;
            }
            ParamList.add(this.GetBaseVarValue(Param, "0", "").toString());
            ++i;
        }
        Object[] args = ParamList.toArray();
        Object Value = InvokeReflectionFunc.InvokeReflectionFunction(this.PeriMaster, MethodName, args);
        return Value;
    }

    private String GetBaseVarValue(String text, String RelateFrom, String GroupName) {
        String rex;
        Pattern pattern;
        Matcher matcher;
        text = this.UserStringReplace(text);
        String rex0 = "@(.*?)@";
        Pattern pattern0 = Pattern.compile(rex0);
        Matcher matcher0 = pattern0.matcher(text);
        while (matcher0.find()) {
            String VarValue;
            String Var = matcher0.group();
            if (!this.VarValueMap.containsKey(text)) {
                List<VarBaseVarStruct> BaseVarNodeList = this.VarXMLInfo.getBaseVarNodeList();
                int i = 0;
                while (i < BaseVarNodeList.size()) {
                    if (Var.equals(BaseVarNodeList.get(i).getName())) {
                        this.AddBaseVarValueinMap(BaseVarNodeList.get(i));
                    }
                    ++i;
                }
            }
            if ((VarValue = this.VarValueMap.get(Var)) == null) {
                return text;
            }
            text = text.replace(Var, VarValue);
        }
        if (!text.contains("##") && (matcher = (pattern = Pattern.compile(rex = "(?<=#).*?(?=#)")).matcher(text)).find()) {
            String Var = matcher.group();
            String VarValue = "";
            if (RelateFrom != null) {
                VarValue = GeneralPeriConfigUtil.GetVarMacro((String)RelateFrom, (String)this.PeriMaster, (String)GroupName, (String)Var);
                if (VarValue == null) {
                    text = "";
                    return text;
                }
                text = text.replace("#" + Var + "#", VarValue);
            }
        }
        return text;
    }

    private String UserStringReplace(String text) {
        if (text.contains("%lower%")) {
            text = text.replaceAll("%lower%", this.PeriName.toLowerCase());
        } else if (text.contains("%upper%")) {
            text = text.replaceAll("%upper%", this.PeriName.toUpperCase());
        } else if (text.contains("@param_variable_peri@")) {
            text = text.replaceAll("@param_variable_peri@", this.PeriName);
        } else if (text.contains("%variable_it_perix%")) {
            text = text.replaceAll("%variable_it_perix%", this.Perix);
        } else if (text.contains("%variable_irq%")) {
            text = text.replaceAll("%variable_irq%", this.InterruptName);
        } else if (text.contains("%variable_irq_f%")) {
            text = text.replaceAll("%variable_irq_f%", this.InterruptName.substring(0, this.InterruptName.length() - 1));
        } else if (text.contains("%lower_no_digital%")) {
            text = GlobalVariables.RemoveReriDigital((String)this.PeriName.toLowerCase());
        }
        return text;
    }

    private String CycleSerialReplace(String CycleStr, int CycleNum) {
        String Value = CycleStr;
        if (CycleStr.contains("%CycleNum%")) {
            String tmp = String.valueOf(CycleNum);
            Value = CycleStr.replace("%CycleNum%", tmp);
        }
        return Value;
    }

    public String ReturnGlobalStructsCode(CodeGlobalStruct GlobalStructNode) {
        String StructDef = "";
        String CycleVar = GlobalStructNode.getCycle();
        int CycleNum = 1;
        if (CycleVar.contains("@")) {
            try {
                if (this.GetBaseVarValue(CycleVar, "0", "").equals("")) {
                    return StructDef;
                }
                CycleNum = Integer.parseInt(this.GetBaseVarValue(CycleVar, "0", "").replaceAll("[^0-9]", ""));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < CycleNum) {
            List<CodeStructPart> StructNodeList = GlobalStructNode.getStructNodeList();
            int j = 0;
            while (j < StructNodeList.size()) {
                block12: {
                    CodeStructPart StructPartObj;
                    block11: {
                        StructPartObj = StructNodeList.get(j);
                        if (StructPartObj.getCondition().equals("")) break block11;
                        String Condition = StructPartObj.getCondition();
                        if (!this.ConditionValidate(Condition = Condition.replaceAll("%CycleNum%", String.valueOf(i)))) break block12;
                    }
                    String tmp = String.valueOf(StructPartObj.getPrefix()) + StructPartObj.getName() + " " + StructPartObj.getInstance() + StructPartObj.getSuffix();
                    if (!StructPartObj.isPreProcessCode()) {
                        tmp = String.valueOf(tmp) + ";";
                    }
                    tmp = String.valueOf(tmp) + System.lineSeparator();
                    tmp = this.TextReplace(tmp, i);
                    StructDef = String.valueOf(StructDef) + tmp;
                }
                ++j;
            }
            List<CodeTextStruct> TextNodeList = GlobalStructNode.getTextNodeList();
            if (TextNodeList.size() > 0) {
                String ContentCode = this.ReturnTextNodeListCode(TextNodeList, false);
                StructDef = String.valueOf(StructDef) + ContentCode;
            }
            ++i;
        }
        return StructDef;
    }

    public LinkedHashMap<String, String> ReturnGlobalStructsCodeMap(CodeGlobalStruct GlobalStructNode) {
        LinkedHashMap<String, String> globalStructsMap = new LinkedHashMap<String, String>();
        String StructDef = "";
        String CycleVar = GlobalStructNode.getCycle();
        int CycleNum = 1;
        if (CycleVar.contains("@")) {
            try {
                if (this.GetBaseVarValue(CycleVar, "0", "").equals("")) {
                    return globalStructsMap;
                }
                CycleNum = Integer.parseInt(this.GetBaseVarValue(CycleVar, "0", "").replaceAll("[^0-9]", ""));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < CycleNum) {
            List<CodeStructPart> StructNodeList = GlobalStructNode.getStructNodeList();
            int j = 0;
            while (j < StructNodeList.size()) {
                block14: {
                    CodeStructPart StructPartObj;
                    block13: {
                        StructPartObj = StructNodeList.get(j);
                        if (StructPartObj.getCondition().equals("")) break block13;
                        String Condition = StructPartObj.getCondition();
                        if (!this.ConditionValidate(Condition = Condition.replaceAll("%CycleNum%", String.valueOf(i)))) break block14;
                    }
                    String tmp = String.valueOf(StructPartObj.getPrefix()) + StructPartObj.getName() + " " + StructPartObj.getInstance() + StructPartObj.getSuffix();
                    if (!StructPartObj.isPreProcessCode()) {
                        tmp = String.valueOf(tmp) + ";";
                    }
                    tmp = String.valueOf(tmp) + System.lineSeparator();
                    tmp = this.TextReplace(tmp, i);
                    String key = StructPartObj.getGlobalStructType();
                    String value = "";
                    if (globalStructsMap.containsKey(key)) {
                        value = globalStructsMap.get(key);
                    }
                    value = String.valueOf(value) + tmp;
                    globalStructsMap.put(key, value);
                }
                ++j;
            }
            List<CodeTextStruct> TextNodeList = GlobalStructNode.getTextNodeList();
            if (TextNodeList.size() > 0) {
                String ContentCode = this.ReturnTextNodeListCode(TextNodeList, false);
                StructDef = String.valueOf(StructDef) + ContentCode;
            }
            ++i;
        }
        if (globalStructsMap.containsKey("GlobalStructs_C_PrivateVariables")) {
            StructDef = String.valueOf(StructDef) + globalStructsMap.get("GlobalStructs_C_PrivateVariables");
            globalStructsMap.put("GlobalStructs_C_PrivateVariables", StructDef);
        }
        return globalStructsMap;
    }

    public String ReturnHeadFileGlobalStructsCode(CodeGlobalStruct GlobalStructNode) {
        String StructDef = "";
        String CycleVar = GlobalStructNode.getCycle();
        int CycleNum = 1;
        if (CycleVar.contains("@")) {
            try {
                if (this.GetBaseVarValue(CycleVar, "0", "").equals("")) {
                    return StructDef;
                }
                CycleNum = Integer.parseInt(this.GetBaseVarValue(CycleVar, "0", "").replaceAll("[^0-9]", ""));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < CycleNum) {
            List<CodeStructPart> StructNodeList = GlobalStructNode.getStructNodeList();
            int j = 0;
            while (j < StructNodeList.size()) {
                block9: {
                    CodeStructPart StructPartObj;
                    block10: {
                        StructPartObj = StructNodeList.get(j);
                        if (!StructPartObj.isGenHeadFileDec()) break block9;
                        if (StructPartObj.getCondition().equals("")) break block10;
                        String Condition = StructPartObj.getCondition();
                        if (!this.ConditionValidate(Condition = Condition.replaceAll("%CycleNum%", String.valueOf(i)))) break block9;
                    }
                    String tmp = "extern " + StructPartObj.getName() + " " + StructPartObj.getInstance() + ";" + System.lineSeparator();
                    tmp = this.TextReplace(tmp, i);
                    StructDef = String.valueOf(StructDef) + tmp;
                }
                ++j;
            }
            ++i;
        }
        return StructDef;
    }

    public String ReturnSystemGlobalStructsCode() {
        String result = "";
        if (this.DMAPeriGenerateObj.ReturnGlobalStructsCode(this.PeriName) != null) {
            result = String.valueOf(result) + this.DMAPeriGenerateObj.ReturnGlobalStructsCode(this.PeriName);
        }
        if (this.mDMAPeriGenerateObj.ReturnGlobalStructsCode(this.PeriName) != null) {
            result = String.valueOf(result) + this.mDMAPeriGenerateObj.ReturnGlobalStructsCode(this.PeriName);
        }
        return result;
    }

    public String ReturnFuncImpleName(CodeFuncImpleStruct FuncImpleStructObj) {
        String FuncImpleName = "";
        String Name = FuncImpleStructObj.getName();
        Name = this.TextReplace(Name, 0);
        FuncImpleName = String.valueOf(FuncImpleName) + "void " + Name + "(void);" + System.lineSeparator();
        return FuncImpleName;
    }

    public String ReturnFuncImpleCode(CodeFuncImpleStruct FuncImpleStructObj) {
        String variableDefine;
        ModuleConfigStruct rcuGPIOModuleStructObj;
        ModuleConfigStruct gpioModuleStructObj;
        int peripheralTypeEnum = -1;
        String FwlibType = GlobalVariables.McuSeletorInfo.getFwlibType();
        String FuncImpleCode = "";
        String funcName = FuncImpleStructObj.getName();
        funcName = this.TextReplace(funcName, 0);
        FuncImpleCode = String.valueOf(FuncImpleCode) + "void " + funcName + "(void)" + System.lineSeparator() + "{" + System.lineSeparator();
        String UserCodeName = "";
        if (this.FileName.equals("init.c")) {
            String[] tmp = funcName.split("_");
            if (tmp.length > 1) {
                UserCodeName = String.valueOf(tmp[1]) + "_" + tmp[tmp.length - 1];
            }
            FuncImpleCode = String.valueOf(FuncImpleCode) + "\t/* user code [" + UserCodeName + " local 0] begin */" + System.lineSeparator();
            FuncImpleCode = String.valueOf(FuncImpleCode) + System.lineSeparator();
            FuncImpleCode = String.valueOf(FuncImpleCode) + "\t/* user code [" + UserCodeName + " local 0] end */" + System.lineSeparator();
        }
        ModuleConfigStruct GPIOModuleStructObj = new ModuleConfigStruct();
        ModuleConfigStruct DMAModuleStructObj = new ModuleConfigStruct();
        ModuleConfigStruct mDMAModuleStructObj = new ModuleConfigStruct();
        ModuleConfigStruct RCUModuleStructObj = new ModuleConfigStruct();
        ModuleConfigStruct NVICModuleStructObj = new ModuleConfigStruct();
        String funcComments = "";
        String tempPeriName = funcName;
        tempPeriName = tempPeriName.replaceAll("msd_", "");
        tempPeriName = tempPeriName.replaceAll("_init", "");
        tempPeriName = tempPeriName.replaceAll("_deinit", "");
        tempPeriName = tempPeriName.toUpperCase();
        funcComments = String.valueOf(funcComments) + System.lineSeparator();
        funcComments = String.valueOf(funcComments) + "/*!" + System.lineSeparator();
        if (funcName.contains("_init")) {
            funcComments = String.valueOf(funcComments) + "    \\brief      " + tempPeriName + " initialization function" + System.lineSeparator();
            if (this.PeriName.equals("RCU")) {
                peripheralTypeEnum = PeripheralTypeEnum.INIT_RCU.ordinal();
            } else if (this.PeriName.equals("GPIO")) {
                peripheralTypeEnum = PeripheralTypeEnum.INIT_GPIO.ordinal();
                gpioModuleStructObj = this.GPIOPeriGenerateObj.ReturnInstanceCode(this.PeriName);
                rcuGPIOModuleStructObj = this.GPIOPeriGenerateObj.ReturnInstanceCode("RCU");
                variableDefine = "";
                String moduleInit = "";
                if (rcuGPIOModuleStructObj != null) {
                    if (rcuGPIOModuleStructObj.getVariableDefine() != null) {
                        variableDefine = String.valueOf(variableDefine) + rcuGPIOModuleStructObj.getVariableDefine() + System.lineSeparator();
                    }
                    if (rcuGPIOModuleStructObj.getVariableDefine() != null) {
                        moduleInit = String.valueOf(moduleInit) + rcuGPIOModuleStructObj.getModuleInit() + System.lineSeparator();
                    }
                }
                if (gpioModuleStructObj != null) {
                    if (gpioModuleStructObj.getVariableDefine() != null) {
                        variableDefine = String.valueOf(variableDefine) + gpioModuleStructObj.getVariableDefine() + System.lineSeparator();
                    }
                    if (gpioModuleStructObj.getVariableDefine() != null) {
                        moduleInit = String.valueOf(moduleInit) + gpioModuleStructObj.getModuleInit() + System.lineSeparator();
                    }
                }
                GPIOModuleStructObj.setVariableDefine(variableDefine);
                GPIOModuleStructObj.setModuleInit(moduleInit);
            } else {
                peripheralTypeEnum = PeripheralTypeEnum.INIT_GENERALPERIPHERAL.ordinal();
                GPIOModuleStructObj = this.GPIOPeriGenerateObj.ReturnInstanceCode(this.PeriName);
            }
            DMAModuleStructObj = this.DMAPeriGenerateObj.ReturnInstanceCode(this.PeriName);
            mDMAModuleStructObj = this.mDMAPeriGenerateObj.ReturnInstanceCode(this.PeriName);
            RCUModuleStructObj = this.RCUPeriGenerateObj.ReturnInstanceCode(this.PeriName);
            NVICModuleStructObj = this.NVICPeriGenerateObj.ReturnInstanceCode(this.PeriName);
        } else if (funcName.contains("_deinit")) {
            funcComments = String.valueOf(funcComments) + "    \\brief      " + tempPeriName + " deinitialization function" + System.lineSeparator();
            if (this.PeriName.equals("RCU")) {
                peripheralTypeEnum = PeripheralTypeEnum.DEINIT_RCU.ordinal();
            } else if (this.PeriName.equals("GPIO")) {
                peripheralTypeEnum = PeripheralTypeEnum.DEINIT_GPIO.ordinal();
                gpioModuleStructObj = this.GPIOPeriGenerateObj.ReturnDeinitCode(this.PeriName);
                rcuGPIOModuleStructObj = new ModuleConfigStruct();
                rcuGPIOModuleStructObj = this.GPIOPeriGenerateObj.ReturnDeinitCode("RCU");
                variableDefine = "";
                String moduleInit = "";
                if (rcuGPIOModuleStructObj != null) {
                    if (rcuGPIOModuleStructObj.getVariableDefine() != null) {
                        variableDefine = String.valueOf(variableDefine) + rcuGPIOModuleStructObj.getVariableDefine() + System.lineSeparator();
                    }
                    if (rcuGPIOModuleStructObj.getVariableDefine() != null) {
                        moduleInit = String.valueOf(moduleInit) + rcuGPIOModuleStructObj.getModuleInit() + System.lineSeparator();
                    }
                }
                if (gpioModuleStructObj != null) {
                    if (gpioModuleStructObj.getVariableDefine() != null) {
                        variableDefine = String.valueOf(variableDefine) + gpioModuleStructObj.getVariableDefine() + System.lineSeparator();
                    }
                    if (gpioModuleStructObj.getVariableDefine() != null) {
                        moduleInit = String.valueOf(moduleInit) + gpioModuleStructObj.getModuleInit() + System.lineSeparator();
                    }
                }
                GPIOModuleStructObj.setVariableDefine(variableDefine);
                GPIOModuleStructObj.setModuleInit(moduleInit);
            } else {
                peripheralTypeEnum = PeripheralTypeEnum.DEINIT_GENERALPERIPHERAL.ordinal();
                GPIOModuleStructObj = this.GPIOPeriGenerateObj.ReturnDeinitCode(this.PeriName);
            }
            DMAModuleStructObj = this.DMAPeriGenerateObj.ReturnDeinitCode(this.PeriName);
            mDMAModuleStructObj = this.mDMAPeriGenerateObj.ReturnDeinitCode(this.PeriName);
            RCUModuleStructObj = this.RCUPeriGenerateObj.ReturnDeinitCode(this.PeriName);
            NVICModuleStructObj = this.NVICPeriGenerateObj.ReturnDeinitCode(this.PeriName);
        }
        funcComments = String.valueOf(funcComments) + "    \\param[in]  none" + System.lineSeparator();
        funcComments = String.valueOf(funcComments) + "    \\param[out] none" + System.lineSeparator();
        funcComments = String.valueOf(funcComments) + "    \\retval     none" + System.lineSeparator();
        funcComments = String.valueOf(funcComments) + "*/" + System.lineSeparator();
        FuncImpleCode = String.valueOf(funcComments) + FuncImpleCode;
        String codeStr = "";
        if (peripheralTypeEnum == PeripheralTypeEnum.DEINIT_GENERALPERIPHERAL.ordinal() && FwlibType.equals("Standard")) {
            codeStr = String.valueOf(codeStr) + this.ReturnFuncImpleContent(FuncImpleStructObj) + System.lineSeparator();
        }
        if (GPIOModuleStructObj != null && GPIOModuleStructObj.getVariableDefine() != null) {
            codeStr = String.valueOf(codeStr) + GPIOModuleStructObj.getVariableDefine() + System.lineSeparator();
        }
        if (DMAModuleStructObj != null && DMAModuleStructObj.getVariableDefine() != null) {
            codeStr = String.valueOf(codeStr) + DMAModuleStructObj.getVariableDefine() + System.lineSeparator();
        }
        if (mDMAModuleStructObj != null && mDMAModuleStructObj.getVariableDefine() != null) {
            codeStr = String.valueOf(codeStr) + mDMAModuleStructObj.getVariableDefine() + System.lineSeparator();
        }
        if (RCUModuleStructObj != null && RCUModuleStructObj.getVariableDefine() != null) {
            codeStr = String.valueOf(codeStr) + RCUModuleStructObj.getVariableDefine() + System.lineSeparator();
        }
        if (NVICModuleStructObj != null && NVICModuleStructObj.getVariableDefine() != null) {
            codeStr = String.valueOf(codeStr) + NVICModuleStructObj.getVariableDefine() + System.lineSeparator();
        }
        codeStr = String.valueOf(codeStr) + this.ReturnFuncImpleLocalVar(FuncImpleStructObj) + System.lineSeparator();
        if (RCUModuleStructObj != null && RCUModuleStructObj.getModuleInit() != null) {
            codeStr = String.valueOf(codeStr) + RCUModuleStructObj.getModuleInit() + System.lineSeparator();
        }
        if (GPIOModuleStructObj != null && GPIOModuleStructObj.getModuleInit() != null) {
            codeStr = String.valueOf(codeStr) + GPIOModuleStructObj.getModuleInit() + System.lineSeparator();
        }
        if (peripheralTypeEnum != PeripheralTypeEnum.DEINIT_GENERALPERIPHERAL.ordinal() || FwlibType.equals("HAL")) {
            String initCodeFromFTL;
            codeStr = GlobalVariables.InitCodeFromFTL.containsKey(this.PeriName) && funcName.contains("_init") ? ((initCodeFromFTL = (String)((Map)GlobalVariables.InitCodeFromFTL.get(this.PeriName)).get("InitCode")) != null ? String.valueOf(codeStr) + initCodeFromFTL + System.lineSeparator() : String.valueOf(codeStr) + this.ReturnFuncImpleContent(FuncImpleStructObj) + System.lineSeparator()) : String.valueOf(codeStr) + this.ReturnFuncImpleContent(FuncImpleStructObj) + System.lineSeparator();
        }
        if (DMAModuleStructObj != null && DMAModuleStructObj.getModuleInit() != null) {
            codeStr = String.valueOf(codeStr) + DMAModuleStructObj.getModuleInit() + System.lineSeparator();
        }
        if (mDMAModuleStructObj != null && mDMAModuleStructObj.getModuleInit() != null) {
            codeStr = String.valueOf(codeStr) + mDMAModuleStructObj.getModuleInit() + System.lineSeparator();
        }
        if (NVICModuleStructObj != null && NVICModuleStructObj.getModuleInit() != null) {
            codeStr = String.valueOf(codeStr) + NVICModuleStructObj.getModuleInit() + System.lineSeparator();
        }
        String tmpCodeStr = codeStr;
        if ((tmpCodeStr = tmpCodeStr.replace(System.lineSeparator(), "")).equals("") || tmpCodeStr.matches("^[^a-zA-Z0-9]*$")) {
            codeStr = String.valueOf(FileContentUtil.emptyCode) + System.lineSeparator();
        } else {
            String Pos2;
            if (!funcName.equals("init") && !funcName.equals("deinit")) {
                FileContentUtil.PosInitHContent = String.valueOf(FileContentUtil.PosInitHContent) + "void " + funcName + "(void);" + System.lineSeparator();
            }
            if (!(Pos2 = FuncImpleStructObj.getPos()).equals("")) {
                this.DealPosNode(String.valueOf(funcName) + "();", Pos2);
            }
        }
        FuncImpleCode = String.valueOf(FuncImpleCode) + codeStr;
        if (this.FileName.equals("init.c")) {
            FuncImpleCode = String.valueOf(FuncImpleCode) + "\t/* user code [" + UserCodeName + " local 1] begin */" + System.lineSeparator();
            FuncImpleCode = String.valueOf(FuncImpleCode) + System.lineSeparator();
            FuncImpleCode = String.valueOf(FuncImpleCode) + "\t/* user code [" + UserCodeName + " local 1] end */" + System.lineSeparator();
        }
        FuncImpleCode = String.valueOf(FuncImpleCode) + "}" + System.lineSeparator();
        if (FuncImpleStructObj.getRelateForm().equals("ftl")) {
            FuncImpleCode = "";
        }
        return FuncImpleCode;
    }

    public void ReturnSysFuncImpleCode(CodeFuncImpleStruct FuncImpleStructObj) {
        String getSysCodeTemp = "";
        String sysCodeTemp = "";
        String Name = FuncImpleStructObj.getName();
        Name = this.TextReplace(Name, 0);
        ModuleConfigStruct GPIOModuleStructObj = new ModuleConfigStruct();
        ModuleConfigStruct DMAModuleStructObj = new ModuleConfigStruct();
        ModuleConfigStruct RCUModuleStructObj = new ModuleConfigStruct();
        ModuleConfigStruct NVICModuleStructObj = new ModuleConfigStruct();
        if (Name.contains("_init")) {
            GPIOModuleStructObj = this.GPIOPeriGenerateObj.ReturnInstanceCode(this.PeriName);
            DMAModuleStructObj = this.DMAPeriGenerateObj.ReturnInstanceCode(this.PeriName);
            RCUModuleStructObj = this.RCUPeriGenerateObj.ReturnInstanceCode(this.PeriName);
            NVICModuleStructObj = this.NVICPeriGenerateObj.ReturnInstanceCode(this.PeriName);
        } else if (Name.contains("_deinit")) {
            GPIOModuleStructObj = this.GPIOPeriGenerateObj.ReturnDeinitCode(this.PeriName);
            DMAModuleStructObj = this.DMAPeriGenerateObj.ReturnDeinitCode(this.PeriName);
            RCUModuleStructObj = this.RCUPeriGenerateObj.ReturnDeinitCode(this.PeriName);
            NVICModuleStructObj = this.NVICPeriGenerateObj.ReturnDeinitCode(this.PeriName);
        }
        String getSysGPIOCodeTemp = "";
        String sysGPIOCodeTemp = "";
        String getSysDMACodeTemp = "";
        String sysDMACodeTemp = "";
        String getSysRCUCodeTemp = "";
        String sysRCUCodeTemp = "";
        String getSysNVICCodeTemp = "";
        String sysNVICCodeTemp = "";
        if (GPIOModuleStructObj != null && GPIOModuleStructObj.getVariableDefine() != null) {
            sysGPIOCodeTemp = String.valueOf(sysGPIOCodeTemp) + GPIOModuleStructObj.getVariableDefine();
            sysCodeTemp = String.valueOf(sysCodeTemp) + GPIOModuleStructObj.getVariableDefine();
        }
        if (DMAModuleStructObj != null && DMAModuleStructObj.getVariableDefine() != null) {
            sysDMACodeTemp = String.valueOf(sysDMACodeTemp) + DMAModuleStructObj.getVariableDefine();
            sysCodeTemp = String.valueOf(sysCodeTemp) + DMAModuleStructObj.getVariableDefine();
        }
        if (RCUModuleStructObj != null && RCUModuleStructObj.getVariableDefine() != null) {
            sysRCUCodeTemp = String.valueOf(sysRCUCodeTemp) + RCUModuleStructObj.getVariableDefine();
            sysCodeTemp = String.valueOf(sysCodeTemp) + RCUModuleStructObj.getVariableDefine();
        }
        if (NVICModuleStructObj != null && NVICModuleStructObj.getVariableDefine() != null) {
            sysNVICCodeTemp = String.valueOf(sysNVICCodeTemp) + NVICModuleStructObj.getVariableDefine();
            sysCodeTemp = String.valueOf(sysCodeTemp) + NVICModuleStructObj.getVariableDefine();
        }
        if (RCUModuleStructObj != null && RCUModuleStructObj.getModuleInit() != null) {
            sysRCUCodeTemp = String.valueOf(sysRCUCodeTemp) + RCUModuleStructObj.getModuleInit();
            sysCodeTemp = String.valueOf(sysCodeTemp) + RCUModuleStructObj.getModuleInit();
        }
        if (GPIOModuleStructObj != null && GPIOModuleStructObj.getModuleInit() != null) {
            sysGPIOCodeTemp = String.valueOf(sysGPIOCodeTemp) + GPIOModuleStructObj.getModuleInit();
            sysCodeTemp = String.valueOf(sysCodeTemp) + GPIOModuleStructObj.getModuleInit();
        }
        if (DMAModuleStructObj != null && DMAModuleStructObj.getModuleInit() != null) {
            sysDMACodeTemp = String.valueOf(sysDMACodeTemp) + DMAModuleStructObj.getModuleInit();
            sysCodeTemp = String.valueOf(sysCodeTemp) + DMAModuleStructObj.getModuleInit();
        }
        if (NVICModuleStructObj != null && NVICModuleStructObj.getModuleInit() != null) {
            sysNVICCodeTemp = String.valueOf(sysNVICCodeTemp) + NVICModuleStructObj.getModuleInit();
            sysCodeTemp = String.valueOf(sysCodeTemp) + NVICModuleStructObj.getModuleInit();
        }
        getSysCodeTemp = this.ReturnSysCodeFormatContentg(sysCodeTemp);
        getSysGPIOCodeTemp = this.ReturnSysCodeFormatContentg(sysGPIOCodeTemp);
        getSysRCUCodeTemp = this.ReturnSysCodeFormatContentg(sysRCUCodeTemp);
        getSysDMACodeTemp = this.ReturnSysCodeFormatContentg(sysDMACodeTemp);
        getSysNVICCodeTemp = this.ReturnSysCodeFormatContentg(sysNVICCodeTemp);
        HashMap<String, String> SysCodeMap = new HashMap<String, String>();
        SysCodeMap.put("mwGetCode", getSysCodeTemp);
        SysCodeMap.put("mwGetCode_GPIO", getSysGPIOCodeTemp);
        SysCodeMap.put("mwGetCode_RCU", getSysRCUCodeTemp);
        SysCodeMap.put("mwGetCode_DMA", getSysDMACodeTemp);
        SysCodeMap.put("mwGetCode_NVIC", getSysNVICCodeTemp);
        GlobalVariables.getSysCode.put(this.PeriName, SysCodeMap);
    }

    public String ReturnSysCodeFormatContentg(String sysCodeTemp) {
        String getSysCodeTemp = "";
        if (sysCodeTemp.equals("")) {
            return getSysCodeTemp;
        }
        String splitStr = "";
        if (TargetOSInfo.isWindows()) {
            splitStr = "\n";
        } else if (TargetOSInfo.isLinux()) {
            splitStr = System.lineSeparator();
        }
        String[] sysCodeTempArr = sysCodeTemp.split(System.lineSeparator());
        if (sysCodeTempArr.length >= 1 && !sysCodeTempArr[0].equals(splitStr)) {
            getSysCodeTemp = String.valueOf(getSysCodeTemp) + "    " + sysCodeTempArr[0] + System.lineSeparator();
        }
        int i = 1;
        while (i < sysCodeTempArr.length) {
            if (!sysCodeTempArr[i].equals("") || !sysCodeTempArr[i - 1].equals("")) {
                String[] sysCodeTempArr1 = sysCodeTempArr[i].split(splitStr);
                int j = 0;
                while (j < sysCodeTempArr1.length) {
                    getSysCodeTemp = String.valueOf(getSysCodeTemp) + "    " + sysCodeTempArr1[j] + System.lineSeparator();
                    ++j;
                }
            }
            ++i;
        }
        return getSysCodeTemp;
    }

    public String ReturnFuncImpleLocalVar(CodeFuncImpleStruct FuncImpleStructObj) {
        List<CodeContentStruct> LocalStructsContentNodeList;
        String FuncImpleCode = "";
        if (FuncImpleStructObj != null && (LocalStructsContentNodeList = FuncImpleStructObj.getLocalStructsContentNodeList()).size() > 0) {
            FuncImpleCode = String.valueOf(FuncImpleCode) + this.ReturnContentNodeListCode(LocalStructsContentNodeList);
        }
        return FuncImpleCode;
    }

    public String ReturnFuncImpleContent(CodeFuncImpleStruct FuncImpleStructObj) {
        String FuncImpleCode = "";
        if (FuncImpleStructObj == null) {
            return FuncImpleCode;
        }
        List<CodeContentStruct> ContentNodeList = FuncImpleStructObj.getContentNodeList();
        FuncImpleCode = String.valueOf(FuncImpleCode) + this.ReturnContentNodeListCode(ContentNodeList);
        return FuncImpleCode;
    }

    private String ReturnContentNodeListCode(List<CodeContentStruct> ContentNodeList) {
        String Code = "";
        int i = 0;
        while (i < ContentNodeList.size()) {
            String Condition;
            CodeContentStruct ContentStructObj = ContentNodeList.get(i);
            if (!ContentStructObj.getHasCondition() || this.ConditionValidate(Condition = ContentStructObj.getCondition())) {
                if (!ContentStructObj.getCycle().equals("")) {
                    Code = String.valueOf(Code) + this.ReturnCycleContentCode(ContentStructObj);
                } else {
                    List<CodeTextStruct> TextNodeList = ContentStructObj.getTextNodeList();
                    boolean isCodeDeDuplication = ContentStructObj.isCodeDeDuplication();
                    String ContentCode = this.ReturnTextNodeListCode(TextNodeList, isCodeDeDuplication);
                    Code = String.valueOf(Code) + ContentCode;
                }
            }
            ++i;
        }
        return Code;
    }

    private String ReturnCycleContentCode(CodeContentStruct ContentStructObj) {
        String CycleContentCode = "";
        String CycleStr = ContentStructObj.getCycle();
        String CycleNum = this.TextReplace(CycleStr, 0);
        int num = 0;
        try {
            if (CycleNum.replaceAll("[^0-9]", "").equals("")) {
                return CycleContentCode;
            }
            num = Integer.parseInt(CycleNum.replaceAll("[^0-9]", ""));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        boolean isCodeDeDuplication = ContentStructObj.isCodeDeDuplication();
        int i = 0;
        while (i < num) {
            List<CodeTextStruct> TextNodeList = ContentStructObj.getTextNodeList();
            String TextCode = this.ReturnTextNodeListCode(TextNodeList, i, isCodeDeDuplication);
            if (!(CodeGenerateUtil.filterValidCodeGen && TextCode.contains("%InvalidValue%") || TextCode.contains("gpio_deinit") && CycleContentCode.contains(TextCode) || CycleContentCode.contains(TextCode) && isCodeDeDuplication)) {
                CycleContentCode = String.valueOf(CycleContentCode) + TextCode;
                CycleContentCode = String.valueOf(CycleContentCode) + System.lineSeparator();
            }
            ++i;
        }
        return CycleContentCode;
    }

    private String ReturnTextNodeListCode(List<CodeTextStruct> TextNodeList, boolean isCodeDeDuplication) {
        String ContentCode = "";
        int i = 0;
        while (i < TextNodeList.size()) {
            String TextCode = "";
            CodeTextStruct TextStructObj = TextNodeList.get(i);
            if (TextStructObj.getHasCondition()) {
                String Condition = TextStructObj.getCondition();
                if (this.ConditionValidate(Condition)) {
                    TextCode = this.TextReplace(TextStructObj.getValue(), 0);
                }
            } else {
                TextCode = this.TextReplace(TextStructObj.getValue(), 0);
            }
            if (!(CodeGenerateUtil.filterValidCodeGen && TextCode.contains("%InvalidValue%;") || ContentCode.contains(TextCode) && isCodeDeDuplication || TextCode.equals(""))) {
                ContentCode = String.valueOf(ContentCode) + TextCode + System.lineSeparator();
            }
            ++i;
        }
        return ContentCode;
    }

    private String TextReplace(String Value, int CurrentCycleNum) {
        String str = "";
        if (Value.contains("@")) {
            str = Value;
            String rex = "@(.*?)@";
            Pattern pattern = Pattern.compile(rex);
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                String tmp = matcher.group();
                String Var = this.CycleSerialReplace(tmp, CurrentCycleNum);
                if (!this.VarValueMap.containsKey(Var)) continue;
                String VarValue = this.VarValueMap.get(Var);
                str = str.replace(tmp, VarValue);
            }
        } else {
            return Value;
        }
        return str;
    }

    private String ReturnTextNodeListCode(List<CodeTextStruct> TextNodeList, int CurrentCycleNum, boolean isCodeDeDuplication) {
        String TextCodeStr = "";
        int i = 0;
        while (i < TextNodeList.size()) {
            CodeTextStruct TextStructObj = TextNodeList.get(i);
            String Value = TextStructObj.getValue();
            String TextCode = "";
            if (TextStructObj.getHasCondition()) {
                String Condition = TextStructObj.getCondition();
                if (this.ConditionValidate(Condition = this.CycleSerialReplace(Condition, CurrentCycleNum))) {
                    TextCode = this.TextReplace(Value, CurrentCycleNum);
                }
            } else {
                TextCode = this.TextReplace(Value, CurrentCycleNum);
            }
            if (!(TextCodeStr.contains(TextCode) && isCodeDeDuplication || TextCode.equals(""))) {
                TextCodeStr = String.valueOf(TextCodeStr) + TextCode + System.lineSeparator();
            }
            ++i;
        }
        return TextCodeStr;
    }

    private boolean ConditionValidate(String Condition) {
        return this.VarValueMap.containsKey(Condition) && this.VarValueMap.get(Condition).equals("true");
    }

    private void DealPosNode(String Name, String Pos2) {
        if (Name.equals("msd_gpio_init();")) {
            FileContentUtil.PosMain = "    " + Name + System.lineSeparator() + FileContentUtil.PosMain;
            FileContentUtil.PosMain_GPIO = "    " + Name;
        } else if (Name.equals("msd_dma_init();")) {
            FileContentUtil.PosMain = String.valueOf(FileContentUtil.PosMain) + "    " + Name + System.lineSeparator();
            FileContentUtil.PosMain_DMA = "    " + Name;
        } else {
            FileContentUtil.PosMain = String.valueOf(FileContentUtil.PosMain) + "    " + Name + System.lineSeparator();
        }
    }

    private boolean checkRelationControlIsValid(VarBaseVarStruct VarBaseVarNodeObj) {
        String RelateFrom = VarBaseVarNodeObj.getRelateFrom();
        if (VarBaseVarNodeObj.getDefaultValue().equals("%InvalidValue%")) {
            return true;
        }
        String PeriName = VarBaseVarNodeObj.getPeriName();
        String GroupName = VarBaseVarNodeObj.getGroupName();
        String ControlName = VarBaseVarNodeObj.getControlName();
        if (!GroupName.equals("") && !ControlName.equals("")) {
            if (RelateFrom.equals("0")) {
                AbstractJTreeNode configNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
                if (configNode == null) {
                    return false;
                }
                if (!PeriParaTreeConflict.getNodeVisibleState((AbstractJTreeNode)configNode, (boolean)configNode.isVisible())) {
                    return false;
                }
            }
            return true;
        }
        List<VarValueStruct> ValueNodeList = VarBaseVarNodeObj.getValueNodeList();
        for (VarValueStruct ValueNode : ValueNodeList) {
            VarRelationStruct RelationNode = ValueNode.getRelationNode();
            List<VarConditionsStruct> ConditionsNodeList = SystemVarUtil.cloneFrom(RelationNode.getConditionsNodeList());
            for (VarConditionsStruct conditionsNode : ConditionsNodeList) {
                List<VarConditionStruct> ConditionNodeList = conditionsNode.getConditionNodeList();
                for (VarConditionStruct ConditionNodeObj : ConditionNodeList) {
                    String Node2;
                    String strRelateFrom = ConditionNodeObj.getNodeAttributesInfo("RelateFrom");
                    if (!strRelateFrom.equals("0")) continue;
                    String ParentNode = ConditionNodeObj.getNodeAttributesInfo("ParentNode");
                    String value = GeneralPeriConfigUtil.GetVarMacro((String)strRelateFrom, (String)this.PeriMaster, (String)ParentNode, (String)(Node2 = ConditionNodeObj.getNodeAttributesInfo("Node")));
                    return !value.equals("%InvalidValue%") || !RelationNode.getName().equals("AND");
                }
            }
        }
        return true;
    }

    public static enum PeripheralTypeEnum {
        INIT_GENERALPERIPHERAL,
        INIT_RCU,
        INIT_GPIO,
        DEINIT_GENERALPERIPHERAL,
        DEINIT_RCU,
        DEINIT_GPIO;

    }
}

