/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.filegenerate;

import com.gigadevice.codegenerate.codetemplate.GenerateTemplateCode;
import com.gigadevice.codegenerate.codetemplate.TemplateGroupStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateInfoStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateStruct;
import com.gigadevice.codegenerate.util.FileContentUtil;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.code.FileUserCodeUpdate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public class MainFileGenerate {
    private String Path;
    private String MCUPart;
    private TemplateGroupStruct codeTemplateObj;
    private TemplateStruct mainTemplateObj;
    private LinkedHashMap<String, Object> perMap;
    private String FwlibType = "";

    public MainFileGenerate(String Path2, String MCUPart, TemplateGroupStruct codeTemplateObj) {
        this.Path = Path2;
        this.MCUPart = MCUPart;
        this.codeTemplateObj = codeTemplateObj;
        this.mainTemplateObj = new TemplateStruct();
        this.perMap = new LinkedHashMap();
        this.FwlibType = GlobalVariables.McuSeletorInfo.getFwlibType();
    }

    public void GenerateCodeFile() {
        String mcuGroup = GlobalVariables.McuSeletorInfo.getPeriConfigAndCodePath();
        LinkedHashMap<String, TemplateInfoStruct> templateGroupMap = this.codeTemplateObj.getGroups();
        if (!templateGroupMap.containsKey(mcuGroup)) {
            try {
                this.InitInfo(this.MCUPart);
                this.GenerateFile(this.Path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        TemplateInfoStruct templateInfoObj = templateGroupMap.get(mcuGroup);
        LinkedHashMap<String, TemplateStruct> templateMap = templateInfoObj.getTemplate();
        for (Map.Entry<String, TemplateStruct> templateMapEntry : templateMap.entrySet()) {
            String templateName = templateMapEntry.getKey();
            TemplateStruct templateObj = templateMapEntry.getValue();
            if (!templateName.equals("main.ftl")) continue;
            this.mainTemplateObj = templateObj;
            break;
        }
        if (this.mainTemplateObj.getName() == null) {
            try {
                this.InitInfo(this.MCUPart);
                this.GenerateFile(this.Path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        this.perMap.put("MCUPart", this.MCUPart);
        this.perMap.put("PosMain", FileContentUtil.PosMain);
        this.perMap.put("PosMain_GPIO", FileContentUtil.PosMain_GPIO);
        this.perMap.put("PosMain_DMA", FileContentUtil.PosMain_DMA);
        String currentYear = GlobalVariables.getCurrentYear();
        this.perMap.put("CurrentData", currentYear);
        this.perMap.put("MCUSelect_Package", GlobalVariables.McuSeletorInfo.getPackageType());
        GenerateTemplateCode obj = new GenerateTemplateCode(this.mainTemplateObj, this.perMap);
        obj.generateCode(this.Path, this.mainTemplateObj);
    }

    private void InitInfo(String MCUPart) {
        String Code = "";
        Code = String.valueOf(Code) + "/*" + System.lineSeparator() + "    \\file  main.c" + "*/" + System.lineSeparator();
        Code = String.valueOf(Code) + FileContentUtil.ReturnCopyRight();
        if (MCUPart.toUpperCase().equals("GD32VF103")) {
            Code = String.valueOf(Code) + "#include \"" + MCUPart + "_init.h\"" + System.lineSeparator();
        } else {
            String halFlag = "";
            if (this.FwlibType.equals("HAL")) {
                halFlag = "_hal";
            }
            Code = String.valueOf(Code) + "#include \"" + MCUPart + halFlag + ".h\"" + System.lineSeparator();
            Code = String.valueOf(Code) + "#include \"" + MCUPart + halFlag + "_init.h\"" + System.lineSeparator();
        }
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCode("global 0") + System.lineSeparator();
        Code = String.valueOf(Code) + FileContentUtil.ReturnFunctionDes("main function");
        Code = String.valueOf(Code) + "int main(void)" + System.lineSeparator() + "{" + System.lineSeparator();
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCode("local 0") + System.lineSeparator();
        if (!MCUPart.toUpperCase().equals("GD32VF103")) {
            Code = String.valueOf(Code) + "    msd_system_init();" + System.lineSeparator();
        }
        Code = String.valueOf(Code) + "    msd_clock_init();" + System.lineSeparator();
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCode("local 1") + System.lineSeparator();
        Code = String.valueOf(Code) + FileContentUtil.PosMain;
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCode("local 2") + System.lineSeparator();
        Code = String.valueOf(Code) + System.lineSeparator() + "  while(1){" + System.lineSeparator();
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCode("local 3") + System.lineSeparator();
        Code = String.valueOf(Code) + "  }" + System.lineSeparator() + "}" + System.lineSeparator();
        FileContentUtil.PosMain = Code = String.valueOf(Code) + FileContentUtil.ReturnUserCode("global 1") + System.lineSeparator();
    }

    private void GenerateFile(String Path2) throws IOException {
        Object fileEdit;
        String dir = String.valueOf(Path2) + File.separator + "src" + File.separator + "main.c";
        File file = new File(dir);
        if (!file.exists()) {
            file.createNewFile();
        } else {
            fileEdit = new FileUserCodeUpdate(dir, FileContentUtil.PosMain, ConstantsUtil.FileTypeEnum.isCFile.ordinal(), true);
            FileContentUtil.PosMain = fileEdit.GetCode();
        }
        try {
            fileEdit = null;
            Object var5_7 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                writer.write(FileContentUtil.PosMain);
                writer.flush();
            }
            catch (Throwable throwable) {
                if (fileEdit == null) {
                    fileEdit = throwable;
                } else if (fileEdit != throwable) {
                    ((Throwable)fileEdit).addSuppressed(throwable);
                }
                throw fileEdit;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

