/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.filegenerate;

import com.gigadevice.codegenerate.codetemplate.GenerateTemplateCode;
import com.gigadevice.codegenerate.codetemplate.TemplateGroupStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateInfoStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateStruct;
import com.gigadevice.codegenerate.filegenerate.ItCodeGen;
import com.gigadevice.codegenerate.util.FileContentUtil;
import com.gigadevice.codegenerate.util.SystemVarUtil;
import com.gigadevice.periconfigview.utils.NVICConfigUtil;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.nvic.NVICParameterGroupNode;
import com.gigadevice.venustool.code.FileUserCodeUpdate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ItFileGenerate {
    private String MCUPart;
    private String ItHeadFileNameStr = "";
    private String ItFileNameStr = "";
    private String FwlibType = "";
    private String code = "";
    private String headCode = "";
    private TemplateGroupStruct codeTemplateObj;
    private TemplateStruct it_c_TemplateObj;
    private TemplateStruct it_h_TemplateObj;
    private LinkedHashMap<String, Object> perMap;

    public ItFileGenerate(String Path2, String MCUPart, TemplateGroupStruct CodeTemplateObj) {
        this.codeTemplateObj = CodeTemplateObj;
        this.it_c_TemplateObj = new TemplateStruct();
        this.it_h_TemplateObj = new TemplateStruct();
        this.perMap = new LinkedHashMap();
        this.ItFileNameStr = String.valueOf(Path2) + File.separator + "src" + File.separator + MCUPart;
        this.ItHeadFileNameStr = String.valueOf(Path2) + File.separator + "inc" + File.separator + MCUPart;
        this.FwlibType = GlobalVariables.McuSeletorInfo.getFwlibType();
        if (MCUPart.toUpperCase().equals("GD32VF103")) {
            this.ItFileNameStr = String.valueOf(this.ItFileNameStr) + "_it.c";
            this.ItHeadFileNameStr = String.valueOf(this.ItHeadFileNameStr) + "it.h";
        } else if (this.FwlibType.equals("Standard")) {
            this.ItFileNameStr = String.valueOf(this.ItFileNameStr) + "_it.c";
            this.ItHeadFileNameStr = String.valueOf(this.ItHeadFileNameStr) + "_it.h";
        } else if (this.FwlibType.equals("HAL")) {
            this.ItFileNameStr = String.valueOf(this.ItFileNameStr) + "_hal_it.c";
            this.ItHeadFileNameStr = String.valueOf(this.ItHeadFileNameStr) + "_hal_it.h";
        }
        this.MCUPart = MCUPart;
        String mcuGroup = GlobalVariables.McuSeletorInfo.getPeriConfigAndCodePath();
        LinkedHashMap<String, TemplateInfoStruct> templateGroupMap = this.codeTemplateObj.getGroups();
        if (!templateGroupMap.containsKey(mcuGroup)) {
            try {
                this.GenerateFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        TemplateInfoStruct templateInfoObj = templateGroupMap.get(mcuGroup);
        LinkedHashMap<String, TemplateStruct> templateMap = templateInfoObj.getTemplate();
        for (Map.Entry<String, TemplateStruct> templateMapEntry : templateMap.entrySet()) {
            String templateName = templateMapEntry.getKey();
            TemplateStruct templateObj = templateMapEntry.getValue();
            String CnameTemp = "";
            String HnameTemp = "";
            if (this.FwlibType.equals("Standard")) {
                CnameTemp = "_it_c.ftl";
                HnameTemp = "_it_h.ftl";
            } else if (this.FwlibType.equals("HAL")) {
                CnameTemp = "_hal_it_c.ftl";
                HnameTemp = "_hal_it_h.ftl";
            }
            if (templateName.equals(String.valueOf(MCUPart) + CnameTemp)) {
                this.it_c_TemplateObj = templateObj;
                continue;
            }
            if (!templateName.equals(String.valueOf(MCUPart) + HnameTemp)) continue;
            this.it_h_TemplateObj = templateObj;
        }
        if (this.it_c_TemplateObj.getName() == null || this.it_h_TemplateObj.getName() == null) {
            try {
                this.GenerateFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        this.perMap.put("MCUPart", MCUPart);
        String currentYear = GlobalVariables.getCurrentYear();
        this.perMap.put("CurrentData", currentYear);
        this.putDMAIRQInfo();
        GenerateTemplateCode obj_c = new GenerateTemplateCode(this.it_c_TemplateObj, this.perMap);
        obj_c.generateCode(Path2, this.it_c_TemplateObj);
        GenerateTemplateCode obj_h = new GenerateTemplateCode(this.it_h_TemplateObj, this.perMap);
        obj_h.generateCode(Path2, this.it_h_TemplateObj);
    }

    public void GenerateFile() throws IOException {
        Object fileEdit;
        this.GenerateCode();
        this.GenerateHeadFile();
        File file = new File(this.ItFileNameStr);
        if (!file.exists()) {
            file.createNewFile();
            this.code = GlobalVariables.formatCppCodeWithClangFormat((String)this.code);
        } else {
            fileEdit = new FileUserCodeUpdate(this.ItFileNameStr, this.code, ConstantsUtil.FileTypeEnum.isCFile.ordinal(), true);
            this.code = fileEdit.GetCode();
        }
        try {
            fileEdit = null;
            Object var3_5 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                writer.write(this.code);
                writer.flush();
            }
            catch (Throwable throwable) {
                if (fileEdit == null) {
                    fileEdit = throwable;
                } else if (fileEdit != throwable) {
                    ((Throwable)fileEdit).addSuppressed(throwable);
                }
                throw fileEdit;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void GenerateHeadFile() throws IOException {
        File file = new File(this.ItHeadFileNameStr);
        if (!file.exists()) {
            file.createNewFile();
            this.headCode = GlobalVariables.formatCppCodeWithClangFormat((String)this.headCode);
        } else {
            FileUserCodeUpdate fileEdit = new FileUserCodeUpdate(this.ItHeadFileNameStr, this.headCode, ConstantsUtil.FileTypeEnum.isHeadFile.ordinal(), true);
            this.headCode = fileEdit.GetCode();
        }
        String replaceStr0 = "#ifdef __cplusplus" + System.lineSeparator();
        replaceStr0 = String.valueOf(replaceStr0) + "extern \"C\" {" + System.lineSeparator();
        String replaceStr1 = "#ifdef __cplusplus" + System.lineSeparator();
        replaceStr1 = String.valueOf(replaceStr1) + "}" + System.lineSeparator();
        this.headCode = this.headCode.replace("#ifdef __cplusplusstart000", replaceStr0);
        this.headCode = this.headCode.replace("#ifdef __cplusplusend000", replaceStr1);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                writer.write(this.headCode);
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void GenerateCode() throws IOException {
        if (this.MCUPart.toUpperCase().equals("GD32VF103")) {
            this.code = String.valueOf(this.code) + "/*" + System.lineSeparator() + "    \\file  " + this.MCUPart + "_it.c" + System.lineSeparator();
            this.code = String.valueOf(this.code) + "*/" + System.lineSeparator();
            this.code = String.valueOf(this.code) + FileContentUtil.ReturnCopyRight();
            this.code = String.valueOf(this.code) + "#include \"" + this.MCUPart + "_it.h\"" + System.lineSeparator() + "#include \"" + this.MCUPart + ".h\"" + System.lineSeparator() + "#include \"" + this.MCUPart + "_init.h\"" + System.lineSeparator() + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + "/*" + System.lineSeparator() + "    \\file  " + this.MCUPart + "_it.h" + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + "*/" + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + FileContentUtil.ReturnCopyRight();
            this.headCode = String.valueOf(this.headCode) + "#ifndef " + this.MCUPart.toUpperCase() + "_IT_H" + System.lineSeparator() + "#define " + this.MCUPart.toUpperCase() + "_IT_H" + System.lineSeparator() + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + FileContentUtil.ReturnUserCode("global 0") + System.lineSeparator();
        } else {
            String halFlag = "";
            if (this.FwlibType.equals("HAL")) {
                halFlag = "_hal";
            }
            this.code = String.valueOf(this.code) + "/*" + System.lineSeparator() + "    \\file  " + this.MCUPart + halFlag + "_it.c" + System.lineSeparator();
            this.code = String.valueOf(this.code) + "*/" + System.lineSeparator();
            this.code = String.valueOf(this.code) + FileContentUtil.ReturnCopyRight();
            this.code = String.valueOf(this.code) + "#include \"" + this.MCUPart + halFlag + "_it.h\"" + System.lineSeparator() + "#include \"" + this.MCUPart + halFlag + ".h\"" + System.lineSeparator() + "#include \"" + this.MCUPart + halFlag + "_init.h\"" + System.lineSeparator() + System.lineSeparator();
            this.code = String.valueOf(this.code) + "/* External Includes */" + System.lineSeparator();
            this.code = String.valueOf(this.code) + FileContentUtil.ReturnUserCodeByTag("External Includes");
            this.code = String.valueOf(this.code) + "/* Private Type Definitions */" + System.lineSeparator();
            this.code = String.valueOf(this.code) + FileContentUtil.ReturnUserCodeByTag("Type Definitions");
            this.code = String.valueOf(this.code) + "/* Private Macros */" + System.lineSeparator();
            this.code = String.valueOf(this.code) + FileContentUtil.ReturnUserCodeByTag("Private Macros");
            this.code = String.valueOf(this.code) + "/* Private Variables */" + System.lineSeparator();
            this.code = String.valueOf(this.code) + FileContentUtil.ReturnUserCodeByTag("Private Variables");
            this.code = String.valueOf(this.code) + "/* Private Function Declaration */" + System.lineSeparator();
            this.code = String.valueOf(this.code) + FileContentUtil.ReturnUserCodeByTag("Private Function Declaration");
            this.code = String.valueOf(this.code) + "/* Extern Variables */" + System.lineSeparator();
            this.code = String.valueOf(this.code) + FileContentUtil.ReturnUserCodeByTag("Extern Variables");
            this.headCode = String.valueOf(this.headCode) + "/*" + System.lineSeparator() + "    \\file  " + this.MCUPart + halFlag + "_it.h" + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + "*/" + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + FileContentUtil.ReturnCopyRight();
            this.headCode = String.valueOf(this.headCode) + "#ifndef " + this.MCUPart.toUpperCase() + halFlag.toUpperCase() + "_IT_H" + System.lineSeparator() + "#define " + this.MCUPart.toUpperCase() + halFlag.toUpperCase() + "_IT_H" + System.lineSeparator() + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + "#ifdef __cplusplusstart000";
            this.headCode = String.valueOf(this.headCode) + "#endif  " + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + "/* External Includes */" + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + FileContentUtil.ReturnUserCodeByTag("External Includes");
            this.headCode = String.valueOf(this.headCode) + "/* Private Type Definitions */" + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + FileContentUtil.ReturnUserCodeByTag("Type Definitions");
            this.headCode = String.valueOf(this.headCode) + "/* Shared Macros */" + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + FileContentUtil.ReturnUserCodeByTag("Shared Macros");
            this.headCode = String.valueOf(this.headCode) + "/* External Constants */" + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + FileContentUtil.ReturnUserCodeByTag("External Constants");
            this.headCode = String.valueOf(this.headCode) + "/* External Variables */" + System.lineSeparator();
            this.headCode = String.valueOf(this.headCode) + FileContentUtil.ReturnUserCodeByTag("External Variables");
        }
        String codeStr = "";
        String NVICType = "NVIC";
        LinkedHashMap NVICEnabledConfigInfoMap = NVICConfigUtil.getEnabledInfo((String)NVICType);
        for (Map.Entry entry : NVICEnabledConfigInfoMap.entrySet()) {
            String interruptName = (String)entry.getKey();
            String interruptValue = ((NVICParameterGroupNode)entry.getValue()).getValue();
            List periList = ((NVICParameterGroupNode)entry.getValue()).getPeriNameList();
            if (periList.size() > 1) {
                String tempCode = "";
                int cycle = 0;
                int i = 0;
                while (i < periList.size()) {
                    String Peri = (String)periList.get(i);
                    if (GlobalVariables.PeripheralConfigObjMap.containsKey(Peri = Peri.trim()) || Peri.compareTo("NVIC") == 0 || Peri.compareTo("PIN") == 0) {
                        ItCodeGen Temp = new ItCodeGen(Peri, interruptValue);
                        tempCode = String.valueOf(tempCode) + Temp.ReturnCode().getItFuncCode();
                        if (cycle == 0) {
                            this.headCode = String.valueOf(this.headCode) + Temp.ReturnFuncImpleCode() + System.lineSeparator();
                            ++cycle;
                        }
                    }
                    ++i;
                }
                tempCode = this.RemoveRepetition(tempCode);
                BufferedReader rdr = new BufferedReader(new StringReader(tempCode));
                ArrayList<String> SrcList = new ArrayList<String>();
                String line = rdr.readLine();
                while (line != null) {
                    SrcList.add(line);
                    line = rdr.readLine();
                }
                ArrayList<String> DstList = new ArrayList<String>();
                ArrayList<String> endStr = new ArrayList<String>();
                int s = 0;
                while (s < SrcList.size()) {
                    if (((String)SrcList.get(s)).contains("}")) {
                        int e = s + 1;
                        while (e < SrcList.size()) {
                            endStr.add((String)SrcList.get(e));
                            ++e;
                        }
                    }
                    ++s;
                }
                int n = 0;
                while (n < SrcList.size() - endStr.size()) {
                    if (n == 3) {
                        DstList.add((String)SrcList.get(n));
                        int d = 0;
                        while (d < endStr.size()) {
                            DstList.add((String)endStr.get(d));
                            ++d;
                        }
                    } else {
                        DstList.add((String)SrcList.get(n));
                    }
                    ++n;
                }
                String DstCode = "";
                int j = 0;
                while (j < DstList.size()) {
                    DstCode = String.valueOf(DstCode) + (String)DstList.get(j) + System.lineSeparator();
                    ++j;
                }
                codeStr = String.valueOf(codeStr) + DstCode;
                continue;
            }
            if (periList.size() != 1) continue;
            String perix = (String)periList.get(0);
            if (perix.compareTo("DMA") == 0) {
                NVICParameterGroupNode InterruptInfo = NVICConfigUtil.getVisiableInterruptInfo((String)NVICType, (String)interruptName);
                if (InterruptInfo == null) continue;
                int channelMin = InterruptInfo.getMin();
                int channelMax = InterruptInfo.getMax();
                List<String> channelGlobalParaLst = SystemVarUtil.getDMAChannelGlobalParaLst("DMA", channelMax, channelMin);
                String tempCode = "";
                ItCodeGen Temp = new ItCodeGen(perix, interruptValue);
                tempCode = String.valueOf(tempCode) + Temp.ReturnCode().getItFuncCode();
                this.headCode = String.valueOf(this.headCode) + Temp.ReturnFuncImpleCode() + System.lineSeparator();
                BufferedReader rdr = new BufferedReader(new StringReader(tempCode));
                ArrayList<String> DstList = new ArrayList<String>();
                String line = rdr.readLine();
                while (line != null) {
                    if (line.contains("@dma_ch_info@")) {
                        int c = 0;
                        while (c < channelGlobalParaLst.size()) {
                            String globalPara = channelGlobalParaLst.get(c);
                            String target = line.replace("@dma_ch_info@", globalPara);
                            DstList.add(target);
                            ++c;
                        }
                    } else {
                        DstList.add(line);
                    }
                    line = rdr.readLine();
                }
                String DstCode = "";
                int j = 0;
                while (j < DstList.size()) {
                    DstCode = String.valueOf(DstCode) + (String)DstList.get(j) + System.lineSeparator();
                    ++j;
                }
                codeStr = String.valueOf(codeStr) + DstCode;
                continue;
            }
            if (!GlobalVariables.PeripheralConfigObjMap.containsKey(perix) && perix.compareTo("NVIC") != 0 && perix.compareTo("PIN") != 0) continue;
            ItCodeGen Temp = new ItCodeGen(perix, interruptValue);
            codeStr = String.valueOf(codeStr) + Temp.ReturnCode().getItFuncCode();
            this.headCode = String.valueOf(this.headCode) + Temp.ReturnFuncImpleCode() + System.lineSeparator();
        }
        FileUserCodeUpdate fileEdit = new FileUserCodeUpdate();
        codeStr = fileEdit.CodeFormat(codeStr);
        this.code = String.valueOf(this.code) + codeStr;
        this.code = String.valueOf(this.code) + FileContentUtil.ReturnUserCodeByTag("Global Functions Implementations");
        this.code = String.valueOf(this.code) + FileContentUtil.ReturnUserCodeByTag("Static Functions Implementations");
        this.headCode = String.valueOf(this.headCode) + FileContentUtil.ReturnUserCodeByTag("Public Functions");
        this.headCode = String.valueOf(this.headCode) + "#ifdef __cplusplusend000";
        this.headCode = String.valueOf(this.headCode) + "#endif  " + System.lineSeparator();
        if (this.MCUPart.toUpperCase().equals("GD32VF103")) {
            this.headCode = String.valueOf(this.headCode) + "#endif/*" + this.MCUPart.toUpperCase() + "_IT_H*/" + System.lineSeparator();
        } else {
            String halFlag = "";
            if (this.FwlibType.equals("HAL")) {
                halFlag = "_HAL";
            }
            this.headCode = String.valueOf(this.headCode) + "#endif/*" + this.MCUPart.toUpperCase() + halFlag + "_IT_H*/" + System.lineSeparator();
        }
    }

    private String RemoveRepetition(String SrcString) throws IOException {
        String DstString = "";
        BufferedReader rdr = new BufferedReader(new StringReader(SrcString));
        ArrayList<String> SrcList = new ArrayList<String>();
        String line = rdr.readLine();
        while (line != null) {
            SrcList.add(line);
            line = rdr.readLine();
        }
        ArrayList<String> DstList = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < SrcList.size()) {
            if (!((String)SrcList.get(i)).equals("") && set.add((String)SrcList.get(i))) {
                DstList.add((String)SrcList.get(i));
            }
            ++i;
        }
        int j = 0;
        while (j < DstList.size()) {
            DstString = String.valueOf(DstString) + (String)DstList.get(j) + System.lineSeparator();
            ++j;
        }
        return DstString;
    }

    private void putDMAIRQInfo() {
        LinkedHashMap NVICEnabledConfigInfoMap = NVICConfigUtil.getEnabledInfo((String)"NVIC");
        for (Map.Entry entry : NVICEnabledConfigInfoMap.entrySet()) {
            List periList = ((NVICParameterGroupNode)entry.getValue()).getPeriNameList();
            ArrayList<String> DMAName = new ArrayList<String>();
            boolean isDMAIRQ = false;
            int i = 0;
            while (i < periList.size()) {
                if (((String)periList.get(i)).contains("DMA")) {
                    DMAName.add((String)periList.get(i));
                    isDMAIRQ = true;
                    break;
                }
                ++i;
            }
            if (!isDMAIRQ) continue;
            int minNum = ((NVICParameterGroupNode)entry.getValue()).getMin();
            int maxNum = ((NVICParameterGroupNode)entry.getValue()).getMax();
            int i2 = minNum;
            while (i2 <= maxNum) {
                int c = 0;
                while (c < DMAName.size()) {
                    List<String> channelGlobalParaLst = SystemVarUtil.getDMAChannelGlobalParaLst((String)DMAName.get(c), i2, i2);
                    String perMapKey = String.valueOf((String)DMAName.get(c)) + "_CH" + String.valueOf(i2) + "_Info";
                    String perMapValue = "";
                    if (channelGlobalParaLst.size() > 0) {
                        perMapValue = channelGlobalParaLst.get(0);
                        this.perMap.put(perMapKey, perMapValue);
                    }
                    ++c;
                }
                ++i2;
            }
        }
    }
}

