/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codegenerate.filegenerate;

import com.gigadevice.codegenerate.baseinfo.PeriCodeStruct;
import com.gigadevice.codegenerate.codetemplate.GenerateTemplateCode;
import com.gigadevice.codegenerate.codetemplate.TemplateGroupStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateInfoStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateStruct;
import com.gigadevice.codegenerate.generatecode.PeriCodeGen;
import com.gigadevice.codegenerate.util.FileContentUtil;
import com.gigadevice.codegenerate.util.SystemVarUtil;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.code.FileUserCodeUpdate;
import com.gigadevice.venustool.mcubasestruct.ModuleStruct;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GenerateInitFile {
    private String Path = "";
    private String MCUPart = "";
    private String strInitFileStructDef = "";
    private String strInitFileContent = "";
    FileUserCodeUpdate fileEdit = new FileUserCodeUpdate();
    private TemplateGroupStruct codeTemplateObj;
    private TemplateStruct initTemplateObj;
    private LinkedHashMap<String, Object> perMap;
    private String FwlibType = "";
    private LinkedHashMap<String, String> globalStructsMap;

    public GenerateInitFile(String Path2, String MCUPart, TemplateGroupStruct codeTemplateObj) {
        this.Path = Path2;
        this.MCUPart = MCUPart;
        this.codeTemplateObj = codeTemplateObj;
        this.initTemplateObj = new TemplateStruct();
        this.perMap = new LinkedHashMap();
        this.FwlibType = GlobalVariables.McuSeletorInfo.getFwlibType();
        this.globalStructsMap = new LinkedHashMap();
        this.globalStructsMap.put("GlobalStructs_H_ExternalIncludes", "");
        this.globalStructsMap.put("GlobalStructs_H_PrivateTypeDefinitions", "");
        this.globalStructsMap.put("GlobalStructs_H_SharedMacros", "");
        this.globalStructsMap.put("GlobalStructs_H_ExternalConstants", "");
        this.globalStructsMap.put("GlobalStructs_H_ExternalVariables", "");
        this.globalStructsMap.put("GlobalStructs_H_PublicFunctions", "");
        this.globalStructsMap.put("GlobalStructs_C_ExternalIncludes", "");
        this.globalStructsMap.put("GlobalStructs_C_PrivateTypeDefinitions", "");
        this.globalStructsMap.put("GlobalStructs_C_PrivateMacros", "");
        this.globalStructsMap.put("GlobalStructs_C_PrivateConstants", "");
        this.globalStructsMap.put("GlobalStructs_C_PrivateVariables", "");
        this.globalStructsMap.put("GlobalStructs_C_PrivateFunctionDeclaration", "");
        this.globalStructsMap.put("GlobalStructs_C_ExternVariables", "");
        this.globalStructsMap.put("GlobalStructs_C_PublicFunctionsImplementations", "");
        this.globalStructsMap.put("GlobalStructs_C_PrivateFunctionImplementations", "");
        this.GeneratePeriTemplateCode();
        this.GeneratePeriCode();
    }

    public void GenerateOutputFile() {
        try {
            this.InitInfo();
            this.GenerateFile();
            this.InitInfoHFile();
            this.GenerateHFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void GenerateOldPeriCode() {
        String StructDef = "";
        String PeriCode = "";
        ArrayList<String> SystemPeriList = new ArrayList<String>();
        SystemPeriList.add("General");
        SystemPeriList.add("NVIC");
        SystemPeriList.add("RCU");
        SystemPeriList.add("DMA");
        SystemPeriList.add("MDMA");
        SystemPeriList.add("GPIO");
        for (String str : SystemPeriList) {
            if (!SystemVarUtil.NeedReturnInitFunction(str)) continue;
            PeriCodeGen Temp = new PeriCodeGen(str);
            PeriCodeStruct GeneralPeriCode = Temp.ReturnCode();
            if (Temp.ReturnStructDef() != null) {
                StructDef = String.valueOf(StructDef) + Temp.ReturnStructDef();
            }
            for (Map.Entry<String, String> templateMapEntry : this.globalStructsMap.entrySet()) {
                String strTagkey = templateMapEntry.getKey();
                String strStructDef = templateMapEntry.getValue();
                if (!this.getGlobalStructsFromFTL(str, strTagkey).equals("")) {
                    strStructDef = String.valueOf(strStructDef) + this.getGlobalStructsFromFTL(str, strTagkey) + System.lineSeparator();
                }
                this.globalStructsMap.replace(strTagkey, strStructDef);
            }
            boolean isEmptyCode = false;
            if (GeneralPeriCode.getInitFuncCode() != null) {
                if (GeneralPeriCode.getInitFuncCode().contains(FileContentUtil.emptyCode)) {
                    isEmptyCode = true;
                }
                if (!isEmptyCode) {
                    PeriCode = String.valueOf(PeriCode) + GeneralPeriCode.getInitFuncCode() + System.lineSeparator();
                }
            }
            if (GeneralPeriCode.getDeinitFuncCode() == null || isEmptyCode) continue;
            PeriCode = String.valueOf(PeriCode) + GeneralPeriCode.getDeinitFuncCode();
        }
        ArrayList MultiplePeriList = new ArrayList();
        ArrayList<String> configPeriList = new ArrayList<String>();
        for (String key : GlobalVariables.PeripheralConfigObjMap.keySet()) {
            if (key.equals("RCU") || MultiplePeriList.contains(key = GlobalVariables.GetMultipleTreePeriName((String)key))) continue;
            MultiplePeriList.contains(key);
            configPeriList.add(key);
        }
        Collections.sort(configPeriList);
        if (configPeriList.contains("CPDM")) {
            configPeriList.remove("CPDM");
            configPeriList.add("CPDM");
        }
        for (String key : configPeriList) {
            String moduleType;
            LinkedHashMap modules_map = GlobalVariables.MCUObj.getModules();
            if (modules_map.containsKey(key) && (moduleType = ((ModuleStruct)modules_map.get(key)).getModuleType()).equals("MiddleWare")) continue;
            PeriCodeGen Temp = new PeriCodeGen(key);
            PeriCodeStruct GeneralPeriCode = Temp.ReturnCode();
            if (Temp.ReturnStructDef() != null) {
                StructDef = String.valueOf(StructDef) + Temp.ReturnStructDef();
            }
            for (Map.Entry<String, String> templateMapEntry : this.globalStructsMap.entrySet()) {
                String strTagkey = templateMapEntry.getKey();
                String strStructDef = templateMapEntry.getValue();
                if (!this.getGlobalStructsFromFTL(key, strTagkey).equals("")) {
                    strStructDef = String.valueOf(strStructDef) + this.getGlobalStructsFromFTL(key, strTagkey) + System.lineSeparator();
                }
                this.globalStructsMap.replace(strTagkey, strStructDef);
            }
            boolean isEmptyCode = false;
            if (GeneralPeriCode.getInitFuncCode() != null) {
                if (GeneralPeriCode.getInitFuncCode().contains(FileContentUtil.emptyCode)) {
                    isEmptyCode = true;
                }
                if (!isEmptyCode) {
                    PeriCode = String.valueOf(PeriCode) + GeneralPeriCode.getInitFuncCode() + System.lineSeparator();
                }
            }
            if (GeneralPeriCode.getDeinitFuncCode() == null) continue;
            if (!isEmptyCode) {
                PeriCode = String.valueOf(PeriCode) + GeneralPeriCode.getDeinitFuncCode() + System.lineSeparator();
                continue;
            }
            List<String> deinitfuncDecList = GeneralPeriCode.getFuncDeclarationCodeList();
            for (String deinitfuncDec : deinitfuncDecList) {
                if (deinitfuncDec == null || !FileContentUtil.PosInitHContent.contains(deinitfuncDec)) continue;
                FileContentUtil.PosInitHContent = FileContentUtil.PosInitHContent.replace(deinitfuncDec, "");
            }
        }
        this.strInitFileContent = String.valueOf(this.strInitFileContent) + StructDef;
        this.strInitFileContent = String.valueOf(this.strInitFileContent) + System.lineSeparator();
        this.strInitFileContent = String.valueOf(this.strInitFileContent) + PeriCode;
        for (String key : GlobalVariables.InitCodeFromFTL.keySet()) {
            String specialCode;
            String keyUpString = key.toUpperCase();
            if (SystemPeriList.contains(key) || GlobalVariables.MCUObj.getModules().containsKey(keyUpString) || configPeriList.contains(key) || (specialCode = (String)((Map)GlobalVariables.InitCodeFromFTL.get(key)).get("InitCode")) == null) continue;
            this.strInitFileContent = String.valueOf(this.strInitFileContent) + specialCode;
        }
        this.strInitFileContent = this.fileEdit.CodeFormat(this.strInitFileContent);
    }

    private void GeneratePeriCode() {
        String StructDef = "";
        String PeriCode = "";
        ArrayList<String> SystemPeriList = new ArrayList<String>();
        SystemPeriList.add("General");
        SystemPeriList.add("NVIC");
        SystemPeriList.add("RCU");
        SystemPeriList.add("DMA");
        SystemPeriList.add("MDMA");
        SystemPeriList.add("GPIO");
        for (String str : SystemPeriList) {
            String strStructDef;
            String strTagkey;
            if (!SystemVarUtil.NeedReturnInitFunction(str)) continue;
            PeriCodeGen Temp = new PeriCodeGen(str);
            PeriCodeStruct GeneralPeriCode = Temp.ReturnCode();
            LinkedHashMap<String, String> tmpGlobalStructsMap = Temp.ReturnStructDefMap();
            for (Map.Entry<String, String> templateMapEntry : this.globalStructsMap.entrySet()) {
                strTagkey = templateMapEntry.getKey();
                strStructDef = templateMapEntry.getValue();
                if (!tmpGlobalStructsMap.containsKey(strTagkey) || (strStructDef = String.valueOf(strStructDef) + tmpGlobalStructsMap.get(strTagkey) + System.lineSeparator()).equals("") || strStructDef.matches("^[^a-zA-Z0-9]*$")) continue;
                this.globalStructsMap.replace(strTagkey, strStructDef);
            }
            for (Map.Entry<String, String> templateMapEntry : this.globalStructsMap.entrySet()) {
                strTagkey = templateMapEntry.getKey();
                strStructDef = templateMapEntry.getValue();
                if (this.getGlobalStructsFromFTL(str, strTagkey).equals("") || (strStructDef = String.valueOf(strStructDef) + this.getGlobalStructsFromFTL(str, strTagkey) + System.lineSeparator()).equals("") || strStructDef.matches("^[^a-zA-Z0-9]*$")) continue;
                this.globalStructsMap.replace(strTagkey, strStructDef);
            }
            boolean isEmptyCode = false;
            if (GeneralPeriCode.getInitFuncCode() != null) {
                if (GeneralPeriCode.getInitFuncCode().contains(FileContentUtil.emptyCode)) {
                    isEmptyCode = true;
                }
                if (!isEmptyCode) {
                    PeriCode = String.valueOf(PeriCode) + GeneralPeriCode.getInitFuncCode() + System.lineSeparator();
                }
            }
            if (GeneralPeriCode.getDeinitFuncCode() == null || isEmptyCode) continue;
            PeriCode = String.valueOf(PeriCode) + GeneralPeriCode.getDeinitFuncCode();
        }
        ArrayList MultiplePeriList = new ArrayList();
        ArrayList<String> configPeriList = new ArrayList<String>();
        for (String key : GlobalVariables.PeripheralConfigObjMap.keySet()) {
            if (key.equals("RCU") || MultiplePeriList.contains(key = GlobalVariables.GetMultipleTreePeriName((String)key))) continue;
            MultiplePeriList.contains(key);
            configPeriList.add(key);
        }
        Collections.sort(configPeriList);
        if (configPeriList.contains("CPDM")) {
            configPeriList.remove("CPDM");
            configPeriList.add("CPDM");
        }
        for (String key : configPeriList) {
            String strStructDef;
            String strTagkey;
            String moduleType;
            LinkedHashMap modules_map = GlobalVariables.MCUObj.getModules();
            if (modules_map.containsKey(key) && (moduleType = ((ModuleStruct)modules_map.get(key)).getModuleType()).equals("MiddleWare")) continue;
            PeriCodeGen Temp = new PeriCodeGen(key);
            PeriCodeStruct GeneralPeriCode = Temp.ReturnCode();
            LinkedHashMap<String, String> tmpGlobalStructsMap = Temp.ReturnStructDefMap();
            for (Map.Entry<String, String> templateMapEntry : this.globalStructsMap.entrySet()) {
                strTagkey = templateMapEntry.getKey();
                strStructDef = templateMapEntry.getValue();
                if (!tmpGlobalStructsMap.containsKey(strTagkey) || (strStructDef = String.valueOf(strStructDef) + tmpGlobalStructsMap.get(strTagkey) + System.lineSeparator()).equals("") || strStructDef.matches("^[^a-zA-Z0-9]*$")) continue;
                this.globalStructsMap.replace(strTagkey, strStructDef);
            }
            for (Map.Entry<String, String> templateMapEntry : this.globalStructsMap.entrySet()) {
                strTagkey = templateMapEntry.getKey();
                strStructDef = templateMapEntry.getValue();
                if (this.getGlobalStructsFromFTL(key, strTagkey).equals("") || (strStructDef = String.valueOf(strStructDef) + this.getGlobalStructsFromFTL(key, strTagkey) + System.lineSeparator()).equals("") || strStructDef.matches("^[^a-zA-Z0-9]*$")) continue;
                this.globalStructsMap.replace(strTagkey, strStructDef);
            }
            boolean isEmptyCode = false;
            if (GeneralPeriCode.getInitFuncCode() != null) {
                if (GeneralPeriCode.getInitFuncCode().contains(FileContentUtil.emptyCode)) {
                    isEmptyCode = true;
                }
                if (!isEmptyCode) {
                    PeriCode = String.valueOf(PeriCode) + GeneralPeriCode.getInitFuncCode() + System.lineSeparator();
                }
            }
            if (GeneralPeriCode.getDeinitFuncCode() == null) continue;
            if (!isEmptyCode && !GeneralPeriCode.getDeinitFuncCode().contains(FileContentUtil.emptyCode)) {
                PeriCode = String.valueOf(PeriCode) + GeneralPeriCode.getDeinitFuncCode() + System.lineSeparator();
                continue;
            }
            List<String> deinitfuncDecList = GeneralPeriCode.getFuncDeclarationCodeList();
            for (String deinitfuncDec : deinitfuncDecList) {
                if (deinitfuncDec == null || !FileContentUtil.PosInitHContent.contains(deinitfuncDec)) continue;
                FileContentUtil.PosInitHContent = FileContentUtil.PosInitHContent.replace(deinitfuncDec, "");
            }
        }
        this.strInitFileStructDef = String.valueOf(this.strInitFileStructDef) + StructDef;
        this.strInitFileContent = String.valueOf(this.strInitFileContent) + System.lineSeparator();
        this.strInitFileContent = String.valueOf(this.strInitFileContent) + PeriCode;
        for (String key : GlobalVariables.InitCodeFromFTL.keySet()) {
            String specialCode;
            String keyUpString = key.toUpperCase();
            if (SystemPeriList.contains(key) || GlobalVariables.MCUObj.getModules().containsKey(keyUpString) || configPeriList.contains(key) || (specialCode = (String)((Map)GlobalVariables.InitCodeFromFTL.get(key)).get("InitCode")) == null) continue;
            this.strInitFileContent = String.valueOf(this.strInitFileContent) + specialCode;
        }
        this.strInitFileStructDef = this.fileEdit.CodeFormat(this.strInitFileStructDef);
        this.strInitFileContent = this.fileEdit.CodeFormat(this.strInitFileContent);
    }

    private void InitInfo() {
        String Code = "";
        String halFlag = "";
        if (this.FwlibType.equals("HAL")) {
            halFlag = "_hal";
        }
        Code = String.valueOf(Code) + "/*" + System.lineSeparator() + "    \\file  " + this.MCUPart + halFlag + "_init.c" + System.lineSeparator();
        Code = String.valueOf(Code) + "*/" + System.lineSeparator();
        Code = String.valueOf(Code) + FileContentUtil.ReturnCopyRight() + System.lineSeparator();
        Code = String.valueOf(Code) + "#include \"" + this.MCUPart + halFlag + "_init.h\"" + System.lineSeparator();
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "/* External Includes*/" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_C_ExternalIncludes");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("External Includes");
        Code = String.valueOf(Code) + "/* Private Type Definitions */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_C_PrivateTypeDefinitions");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Private Type Definitions");
        Code = String.valueOf(Code) + "/* Private Macros */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_C_PrivateMacros");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Private Macros");
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "/* Private Constants */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_C_PrivateConstants");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Private Constants");
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "/* Private Variables */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_C_PrivateVariables");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Private Variables");
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "/* Private Function Declaration */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_C_PrivateFunctionDeclaration");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Private Function Declaration");
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "/* Extern Variables */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_C_ExternVariables");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Extern Variables");
        Code = String.valueOf(Code) + this.strInitFileContent + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_C_PublicFunctionsImplementations");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Public Functions Implementations");
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_C_PrivateFunctionImplementations");
        FileContentUtil.PosInitC = Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Private Functions Implementations");
    }

    private void GenerateFile() throws IOException {
        Object fileEdit;
        String dir = String.valueOf(this.Path) + File.separator + "src" + File.separator + this.MCUPart;
        if (this.MCUPart.toUpperCase().equals("GD32VF103")) {
            dir = String.valueOf(dir) + "_init.c";
        } else {
            String halFlag = "";
            if (this.FwlibType.equals("HAL")) {
                halFlag = "_hal";
            }
            dir = String.valueOf(dir) + halFlag + "_init.c";
        }
        File file = new File(dir);
        if (!file.exists()) {
            file.createNewFile();
            FileContentUtil.PosInitC = GlobalVariables.formatCppCodeWithClangFormat((String)FileContentUtil.PosInitC);
        } else {
            fileEdit = new FileUserCodeUpdate(dir, FileContentUtil.PosInitC, ConstantsUtil.FileTypeEnum.isCFile.ordinal(), true);
            FileContentUtil.PosInitC = fileEdit.GetCode();
        }
        try {
            fileEdit = null;
            Object var4_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                writer.write(FileContentUtil.PosInitC);
                writer.flush();
            }
            catch (Throwable throwable) {
                if (fileEdit == null) {
                    fileEdit = throwable;
                } else if (fileEdit != throwable) {
                    ((Throwable)fileEdit).addSuppressed(throwable);
                }
                throw fileEdit;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void InitInfoHFile() {
        String Code = "";
        String halFlag = "";
        if (this.FwlibType.equals("HAL")) {
            halFlag = "_hal";
        }
        Code = String.valueOf(Code) + "/*" + System.lineSeparator() + "    \\file  " + this.MCUPart + halFlag + "_init.h" + System.lineSeparator();
        Code = String.valueOf(Code) + "*/" + System.lineSeparator();
        Code = String.valueOf(Code) + FileContentUtil.ReturnCopyRight();
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "#ifndef  " + this.MCUPart.toUpperCase() + halFlag.toUpperCase() + "_INIT_H" + System.lineSeparator();
        Code = String.valueOf(Code) + "#define  " + this.MCUPart.toUpperCase() + halFlag.toUpperCase() + "_INIT_H" + System.lineSeparator();
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "#include \"" + this.MCUPart + halFlag + ".h\"" + System.lineSeparator();
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "#ifdef __cplusplusstart000";
        Code = String.valueOf(Code) + "#endif  " + System.lineSeparator();
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "/* External Includes*/" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_H_ExternalIncludes");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("External Includes");
        Code = String.valueOf(Code) + "/* Private Type Definitions */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_H_PrivateTypeDefinitions");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Type Definitions");
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "/* Shared Macros */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_H_SharedMacros");
        for (String UserLabel : SystemVarUtil.GPIOUserLabelMap.keySet()) {
            String sPinOrinInfo = SystemVarUtil.GPIOUserLabelMap.get(UserLabel);
            Code = String.valueOf(Code) + "#define  " + UserLabel + "    " + sPinOrinInfo + System.lineSeparator();
        }
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Shared Macros");
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "/* External Constants  */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_H_ExternalConstants");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("External Constants");
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "/* External Variables */" + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_H_ExternalVariables");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("External Variables");
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + FileContentUtil.PosInitHContent + System.lineSeparator();
        for (String key : GlobalVariables.InitCodeFromFTL.keySet()) {
            String[] keyArr;
            String specialCode;
            if (key.equals("NVIC") || key.equals("RCU") || key.equals("DMA") || key.equals("MDMA") || key.equals("GPIO") || (specialCode = (String)((Map)GlobalVariables.InitCodeFromFTL.get(key)).get("InitCode")) == null) continue;
            String returnTypeStr = "";
            String functionName = "";
            String formalParameterStr = "";
            if (key.contains("##") && (keyArr = key.split("##")).length == 3) {
                String secondPart;
                returnTypeStr = keyArr[0];
                String functionNameTemp = keyArr[1];
                int index = functionNameTemp.indexOf(95);
                if (index == -1) break;
                functionName = secondPart = functionNameTemp.substring(index + 1);
                formalParameterStr = keyArr[2];
            }
            if (specialCode.equals("") || returnTypeStr.equals("") || formalParameterStr.equals("") || functionName.equals("")) continue;
            Code = String.valueOf(Code) + returnTypeStr + " " + functionName + "(" + formalParameterStr + ");" + System.lineSeparator();
        }
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + this.getGlobalStructsContent("GlobalStructs_H_PublicFunctions");
        Code = String.valueOf(Code) + FileContentUtil.ReturnUserCodeByTag("Public Functions");
        Code = String.valueOf(Code) + System.lineSeparator();
        Code = String.valueOf(Code) + "#ifdef __cplusplusend000";
        Code = String.valueOf(Code) + "#endif  " + System.lineSeparator();
        Code = String.valueOf(Code) + System.lineSeparator();
        FileContentUtil.PosInitH = Code = String.valueOf(Code) + "#endif  /*" + this.MCUPart.toUpperCase() + halFlag.toUpperCase() + "_INIT_H */" + System.lineSeparator();
    }

    private void GenerateHFile() throws IOException {
        String dir = String.valueOf(this.Path) + File.separator + "inc" + File.separator + this.MCUPart;
        if (this.MCUPart.toUpperCase().equals("GD32VF103")) {
            dir = String.valueOf(dir) + "_init.h";
        } else {
            String halFlag = "";
            if (this.FwlibType.equals("HAL")) {
                halFlag = "_hal";
            }
            dir = String.valueOf(dir) + halFlag + "_init.h";
        }
        File file = new File(dir);
        if (!file.exists()) {
            file.createNewFile();
            FileContentUtil.PosInitH = GlobalVariables.formatCppCodeWithClangFormat((String)FileContentUtil.PosInitH);
        } else {
            FileUserCodeUpdate fileEdit = new FileUserCodeUpdate(dir, FileContentUtil.PosInitH, ConstantsUtil.FileTypeEnum.isHeadFile.ordinal(), true);
            FileContentUtil.PosInitH = fileEdit.GetCode();
        }
        String replaceStr0 = "#ifdef __cplusplus" + System.lineSeparator();
        replaceStr0 = String.valueOf(replaceStr0) + "extern \"C\" {" + System.lineSeparator();
        String replaceStr1 = "#ifdef __cplusplus" + System.lineSeparator();
        replaceStr1 = String.valueOf(replaceStr1) + "}" + System.lineSeparator();
        FileContentUtil.PosInitH = FileContentUtil.PosInitH.replace("#ifdef __cplusplusstart000", replaceStr0);
        FileContentUtil.PosInitH = FileContentUtil.PosInitH.replace("#ifdef __cplusplusend000", replaceStr1);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                writer.write(FileContentUtil.PosInitH);
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void GeneratePeriTemplateCode() {
        String mcuGroup = GlobalVariables.McuSeletorInfo.getPeriConfigAndCodePath();
        LinkedHashMap<String, TemplateInfoStruct> templateGroupMap = this.codeTemplateObj.getGroups();
        if (templateGroupMap.containsKey(mcuGroup)) {
            TemplateInfoStruct templateInfoObj = templateGroupMap.get(mcuGroup);
            LinkedHashMap<String, TemplateStruct> templateMap = templateInfoObj.getTemplate();
            for (Map.Entry<String, TemplateStruct> templateMapEntry : templateMap.entrySet()) {
                String templateName = templateMapEntry.getKey();
                TemplateStruct templateObj = templateMapEntry.getValue();
                if (!templateName.contains("init")) continue;
                this.initTemplateObj = templateObj;
                GenerateTemplateCode obj = new GenerateTemplateCode(this.initTemplateObj, this.perMap);
                obj.generateCode(this.Path, this.initTemplateObj);
            }
        }
    }

    private String getGlobalStructsFromFTL(String periName, String codeType) {
        Map initCodeTypeMap;
        String StructDef;
        String StructDefFromFTL = "";
        if (GlobalVariables.InitCodeFromFTL.containsKey(periName) && (StructDef = (String)(initCodeTypeMap = (Map)GlobalVariables.InitCodeFromFTL.get(periName)).get(codeType)) != null) {
            StructDefFromFTL = String.valueOf(StructDefFromFTL) + StructDef;
        }
        return StructDefFromFTL;
    }

    private String getGlobalStructsContent(String key) {
        String codeContent = this.globalStructsMap.get(key);
        if (codeContent != null && !codeContent.isEmpty()) {
            String[] lines = codeContent.split(System.lineSeparator());
            StringBuilder processedContent = new StringBuilder();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.trim().isEmpty()) {
                    processedContent.append(line).append(System.lineSeparator());
                }
                ++n2;
            }
            return processedContent.toString();
        }
        return codeContent;
    }
}

