/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.conflict.xmlparse;

import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ConflictBitInfo;
import com.gigadevice.conflict.baseinfo.ConflictControlInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.PeriConflictInfo;
import com.gigadevice.conflict.util.ConflictUtil;
import com.gigadevice.conflict.xmlparse.NewConditionXmlParse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ConflictXmlParse {
    public static String groupName = "Group";

    public static boolean ParseConflictXml(String filePath, String relateFrom) {
        List PerisList;
        boolean flag;
        block9: {
            String versionStr;
            File f;
            SAXReader saxReader;
            block8: {
                saxReader = new SAXReader();
                f = new File(filePath);
                if (f.exists()) break block8;
                return false;
            }
            Document document = saxReader.read(f);
            Element rootElm = document.getRootElement();
            flag = false;
            if (rootElm.attributeCount() > 0 && (versionStr = rootElm.attributeValue("Version")) != null && versionStr.equals("V2.0")) {
                flag = true;
            }
            if ((PerisList = rootElm.elements("Peris")).size() != 0) break block9;
            return false;
        }
        try {
            int Num = 0;
            for (Element elmPeris : PerisList) {
                if (flag) {
                    NewConditionXmlParse.ParseNestConflictGroupNode(Num, elmPeris, relateFrom);
                } else {
                    ConflictXmlParse.ParseConflictGroupNode(Num, elmPeris, relateFrom);
                }
                ++Num;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean ParseConflictBitXml(String filePath, Map<String, ConflictBitInfo> ConflictBitInfos) {
        List ConflictBitList;
        block7: {
            File f;
            SAXReader saxReader;
            block6: {
                saxReader = new SAXReader();
                f = new File(filePath);
                if (f.exists()) break block6;
                return false;
            }
            Document document = saxReader.read(f);
            Element rootElm = document.getRootElement();
            ConflictBitList = rootElm.elements("ConflictBit");
            if (ConflictBitList.size() != 0) break block7;
            return false;
        }
        try {
            for (Element elmConflictBit : ConflictBitList) {
                ConflictBitInfo ConflictBitObj = new ConflictBitInfo();
                Iterator itAttribute = elmConflictBit.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    ConflictBitObj.setAttrValue(attributeName, attributeValue);
                }
                ConflictBitInfos.put(ConflictBitObj.getName(), ConflictBitObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void ParseConflictGroupNode(int Num, Element elmPeris, String relateFrom) {
        String PeriStr = elmPeris.attributeValue("Name");
        String[] Peris = PeriStr.split(",");
        int i = 0;
        while (i < Peris.length) {
            String PeriName = Peris[i];
            ArrayList<String> ConflictGroupKeys = new ArrayList();
            List<Object> GroupNodeConflictKeys = new ArrayList();
            Map<Object, Object> groupAndChildsConflictMap = new HashMap();
            if (ConflictUtil.PeriConflictInfos.containsKey(PeriName)) {
                ConflictGroupKeys = ConflictUtil.PeriConflictInfos.get(PeriName).getConflictGroupKeys();
            }
            if (ConflictUtil.periAndConfigGroupTypeConflictMap.containsKey(PeriName)) {
                GroupNodeConflictKeys = ConflictUtil.periAndConfigGroupTypeConflictMap.get(PeriName);
            }
            if (ConflictUtil.periGroupAndChildsConflictMap.containsKey(PeriName)) {
                groupAndChildsConflictMap = ConflictUtil.periGroupAndChildsConflictMap.get(PeriName);
            }
            List ConflictGroupList = elmPeris.elements("ConflictGroup");
            int num = 0;
            for (Element elmConflictGroup : ConflictGroupList) {
                ConflictControlInfo PrivilegeControlObj = new ConflictControlInfo();
                Iterator itAttribute = elmConflictGroup.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    if (attributeValue.equals("")) continue;
                    PrivilegeControlObj.setAttrValue(attributeName, attributeValue);
                }
                PrivilegeControlObj.setPeriName(PeriName);
                PrivilegeControlObj.setRelateFrom(relateFrom);
                Element elmRelation = elmConflictGroup.element("Relation");
                String TypeName = elmRelation.attributeValue("Name");
                String ControlUserGroup = String.valueOf(relateFrom) + PeriName + groupName + String.valueOf(Num) + String.valueOf(num++);
                List<List<ConditionInfo>> PrivilegeUserList = ConflictXmlParse.ParsePrivilegeInfosList(PeriName, elmRelation, ControlUserGroup);
                ConflictGroupInfo GroupInfoObj = new ConflictGroupInfo();
                GroupInfoObj.setControledControl(PrivilegeControlObj);
                GroupInfoObj.setType(TypeName);
                GroupInfoObj.setConditionType(0);
                GroupInfoObj.setConditionsList(PrivilegeUserList);
                if (relateFrom.equals("0")) {
                    if (PrivilegeControlObj.getControlType().equals("Group")) {
                        if (!GroupNodeConflictKeys.contains(ControlUserGroup)) {
                            GroupNodeConflictKeys.add(ControlUserGroup);
                        }
                    } else {
                        String groupNodeName = String.valueOf(PrivilegeControlObj.getPeriName()) + "##" + PrivilegeControlObj.getGroupName();
                        List<String> childList = new ArrayList();
                        if (groupAndChildsConflictMap.containsKey(groupNodeName)) {
                            childList = (List)groupAndChildsConflictMap.get(groupNodeName);
                        }
                        if (!childList.contains(ControlUserGroup)) {
                            childList.add(ControlUserGroup);
                            groupAndChildsConflictMap.put(groupNodeName, childList);
                        }
                    }
                }
                ConflictUtil.ConflictGroupInfos.put(ControlUserGroup, GroupInfoObj);
                if (ConflictGroupKeys.contains(ControlUserGroup)) continue;
                ConflictGroupKeys.add(ControlUserGroup);
            }
            PeriConflictInfo PeriPrivilegeInfoObj = new PeriConflictInfo();
            if (ConflictUtil.PeriConflictInfos.containsKey(PeriName)) {
                PeriPrivilegeInfoObj = ConflictUtil.PeriConflictInfos.get(PeriName);
            }
            if (relateFrom.equals("0")) {
                PeriPrivilegeInfoObj.setPeriConfig(true);
            } else {
                PeriPrivilegeInfoObj.setPeriTree(true);
            }
            PeriPrivilegeInfoObj.setConflictGroupKeys(ConflictGroupKeys);
            ConflictUtil.PeriConflictInfos.put(PeriName, PeriPrivilegeInfoObj);
            ConflictUtil.periAndConfigGroupTypeConflictMap.put(PeriName, GroupNodeConflictKeys);
            ConflictUtil.periGroupAndChildsConflictMap.put(PeriName, groupAndChildsConflictMap);
            ++i;
        }
    }

    private static List<List<ConditionInfo>> ParsePrivilegeInfosList(String PeriName, Element elmRelation, String UserGroup) {
        ArrayList<List<ConditionInfo>> UserList = new ArrayList<List<ConditionInfo>>();
        List PrivilegeInfosList = elmRelation.elements("PrivilegeInfos");
        for (Element elmPrivilegeInfos : PrivilegeInfosList) {
            List PrivilegeUserList = elmPrivilegeInfos.elements("PrivilegeUser");
            ArrayList<ConditionInfo> UList = new ArrayList<ConditionInfo>();
            for (Element elmPrivilegeUser : PrivilegeUserList) {
                ConditionInfo PrivilegeUserObj = new ConditionInfo();
                PrivilegeUserObj.setPeriName(PeriName);
                PrivilegeUserObj.setType("Item");
                Iterator itAttribute = elmPrivilegeUser.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    if (attributeValue.equals("")) continue;
                    PrivilegeUserObj.setAttrValue(attributeName, attributeValue);
                }
                String User = ConflictUtil.returnUserString(PrivilegeUserObj);
                if (User == null) continue;
                if (ConflictUtil.UserAndConflictGroupInfo.containsKey(User)) {
                    if (!ConflictUtil.UserAndConflictGroupInfo.get(User).contains(UserGroup)) {
                        ConflictUtil.UserAndConflictGroupInfo.get(User).add(UserGroup);
                    }
                } else {
                    ArrayList<String> tmp = new ArrayList<String>();
                    tmp.add(UserGroup);
                    ConflictUtil.UserAndConflictGroupInfo.put(User, tmp);
                }
                UList.add(PrivilegeUserObj);
            }
            UserList.add(UList);
        }
        return UserList;
    }
}

