/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.conflict.util;

import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ConflictBitInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.PeriConflictInfo;
import com.gigadevice.conflict.xmlparse.ConflictXmlParse;
import com.gigadevice.conflict.xmlparse.NewConditionXmlParse;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConflictUtil {
    public static final String CONFLICT_OPERTYPE_COMMON = "";
    public static final String CONFLICT_OPERTYPE_FUNCTION = "F";
    public static final String CONFLICT_OPERTYPE_EXPRESSION = "E";
    public static final String CONFLICT_SELECTED_PARAM = "SP";
    public static boolean disableConflict = false;
    public static boolean conflictIsSetValue = true;
    public static boolean conflictIsSetDefaultValueInPinout = true;
    public static boolean conflictIsTempPeriConfigSource = false;
    public static boolean excuteCrossPeriConflict = false;
    public static String crossPeriSource = "";
    public static boolean conflictIsNVICSource = false;
    public static boolean conflictIsDeSerialize = false;
    public static boolean conflictIsCheckItem = false;
    public static Map<String, PeriConflictInfo> PeriConflictInfos = new HashMap<String, PeriConflictInfo>();
    public static Map<String, ConflictBitInfo> ConflictBitInfos = new HashMap<String, ConflictBitInfo>();
    public static Map<String, List<String>> UserAndConflictGroupInfo = new HashMap<String, List<String>>();
    public static Map<String, List<String>> periAndConfigGroupTypeConflictMap = new HashMap<String, List<String>>();
    public static Map<String, Map<String, List<String>>> periGroupAndChildsConflictMap = new HashMap<String, Map<String, List<String>>>();
    public static Map<String, ConflictGroupInfo> ConflictGroupInfos = new HashMap<String, ConflictGroupInfo>();
    public static Map<String, String> DMAConfigInfo = new HashMap<String, String>();
    public static Map<String, String> MDMAConfigInfo = new HashMap<String, String>();
    public static List<Integer> pinUpdateList = new ArrayList<Integer>();

    public static void ClearAllGlobalVars() {
        PeriConflictInfos.clear();
        ConflictBitInfos.clear();
        UserAndConflictGroupInfo.clear();
        ConflictGroupInfos.clear();
        periAndConfigGroupTypeConflictMap.clear();
        periGroupAndChildsConflictMap.clear();
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(PeriConflictInfos);
            out.writeObject(ConflictBitInfos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        switch (version) {
            case "1.1": {
                ConflictUtil.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            Map tmpPeriConflictInfos = new HashMap();
            Map tmpConflictBitInfos = new HashMap();
            tmpPeriConflictInfos = (Map)ins.readObject();
            tmpConflictBitInfos = (Map)ins.readObject();
            tmpPeriConflictInfos.clear();
            tmpConflictBitInfos.clear();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void InitConflictBitXmlInfo() {
        boolean flag = false;
        if (ConflictBitInfos == null) {
            flag = true;
        } else if (ConflictBitInfos.size() == 0) {
            flag = true;
        }
        if (flag) {
            GlobalPathUtil.GlobalXmlPaths globalXmlPathsObj = GlobalPathUtil.getGlobalXmlPaths();
            String ConflictBitPath = globalXmlPathsObj.ConflictBitXmlPath;
            ConflictXmlParse.ParseConflictBitXml(ConflictBitPath, ConflictBitInfos);
        }
    }

    public static void InitAllGlobalVars() {
        ConflictUtil.InitConflictBitXmlInfo();
        LinkedHashMap tableInfoMap = GlobalVariables.MCUObj.getModules();
        for (String key : tableInfoMap.keySet()) {
            ConflictUtil.InitPrivilegeXmlInfo(key);
        }
        ConflictUtil.InitPinPrivilegeXmlInfo();
    }

    public static void InitPrivilegeXmlInfo(String PeriName) {
        PeriConflictInfo PeriConflictInfoObj;
        String PerisRelatePath;
        PeriName = GlobalVariables.GetMultipleTreePeriName((String)PeriName);
        GlobalVariables.RemoveReriDigital((String)PeriName);
        String strPerisRelatePath = GlobalVariables.McuSeletorInfo.getPerisRelationFilePath();
        String PeriTreeConflictXml = PerisRelatePath = String.valueOf(GeneralPathUtil.ResourcePath) + strPerisRelatePath;
        if (PeriConflictInfos.size() <= 0) {
            ConflictXmlParse.groupName = "Group";
            NewConditionXmlParse.groupName = "Group";
            ConflictXmlParse.ParseConflictXml(PeriTreeConflictXml, "1");
            if (!GlobalVariables.isCubeRoverTest) {
                String addInfoXmlPath = PeriTreeConflictXml.replace(".xml", "AddInfo.xml");
                ConflictXmlParse.groupName = "AddGroup";
                NewConditionXmlParse.groupName = "AddGroup";
                ConflictXmlParse.ParseConflictXml(addInfoXmlPath, "1");
            }
        }
        boolean periConfigflag = false;
        if (PeriConflictInfos.containsKey(PeriName)) {
            PeriConflictInfoObj = PeriConflictInfos.get(PeriName);
            if (!PeriConflictInfoObj.getPeriConfig()) {
                periConfigflag = true;
            }
        } else {
            periConfigflag = true;
        }
        if (periConfigflag) {
            System.currentTimeMillis();
            GlobalPathUtil.PeriConfigXmlPaths xmlPathsObj = GlobalPathUtil.getPeriConfigXmlPaths((String)PeriName);
            String PeriConfigConflictXml = xmlPathsObj.PeriConflictXmlPath;
            ConflictXmlParse.groupName = "Group";
            NewConditionXmlParse.groupName = "Group";
            ConflictXmlParse.ParseConflictXml(PeriConfigConflictXml, "0");
            if (!GlobalVariables.isCubeRoverTest) {
                String addInfoXmlPath = xmlPathsObj.PeriConflictAddInfoXmlPath;
                ConflictXmlParse.groupName = "AddGroup";
                NewConditionXmlParse.groupName = "AddGroup";
                ConflictXmlParse.ParseConflictXml(addInfoXmlPath, "0");
            }
        }
        if (!PeriConflictInfos.containsKey(PeriName)) {
            PeriConflictInfoObj = new PeriConflictInfo();
            PeriConflictInfoObj.setPeriConfig(true);
            PeriConflictInfoObj.setPeriTree(true);
            PeriConflictInfos.put(PeriName, PeriConflictInfoObj);
        }
    }

    public static void InitPinPrivilegeXmlInfo() {
        String PerisRelatePath;
        String strPerisRelatePath = GlobalVariables.McuSeletorInfo.getPerisRelationFilePath();
        String pinInfoXmlPath = PerisRelatePath = String.valueOf(GeneralPathUtil.ResourcePath) + strPerisRelatePath;
        pinInfoXmlPath = pinInfoXmlPath.replace(".xml", "PinConflict.xml");
        pinInfoXmlPath = pinInfoXmlPath.replace(String.valueOf(File.separator) + "PerisRelation", String.valueOf(File.separator) + "PerisRelation" + File.separator + "PinConflict");
        ConflictXmlParse.groupName = "PinGroup";
        NewConditionXmlParse.groupName = "PinGroup";
        ConflictXmlParse.ParseConflictXml(pinInfoXmlPath, "5");
    }

    public static List<String> GetConditionSourceList(String SourceType, String PeriName, String GroupName, String ControlName, String ItemName) {
        ArrayList<String> ConditionList = new ArrayList<String>();
        String ConditionSource = SourceType;
        ArrayList<String> strList = new ArrayList<String>();
        strList.add(PeriName);
        strList.add(GroupName);
        strList.add(ControlName);
        int i = 0;
        while (i < strList.size()) {
            if (strList.get(i) != null && !((String)strList.get(i)).equals(CONFLICT_OPERTYPE_COMMON)) {
                if (((String)strList.get(i)).contains("##")) {
                    List<String> controlList = Arrays.asList(((String)strList.get(i)).split("##"));
                    for (String control : controlList) {
                        if (ConditionList.contains(ConditionSource = String.valueOf(ConditionSource) + "##" + control)) continue;
                        ConditionList.add(ConditionSource);
                    }
                } else {
                    ConditionSource = String.join((CharSequence)"##", ConditionSource, (CharSequence)strList.get(i));
                    if (!ConditionList.contains(ConditionSource = ConditionSource.replace("####", "##"))) {
                        ConditionList.add(ConditionSource);
                    }
                }
            }
            ++i;
        }
        return ConditionList;
    }

    public static String returnUserString(ConditionInfo PrivilegeUserObj) {
        String controlName;
        String PeriName = PrivilegeUserObj.getPeriName();
        String User = null;
        if (PrivilegeUserObj.getRelateFrom().equals("1") && (controlName = PrivilegeUserObj.getControlName()).contains("##*")) {
            int index = controlName.indexOf("##*");
            controlName = controlName.substring(0, index);
            User = "1##" + PeriName + "##" + controlName;
            return User;
        }
        if (PrivilegeUserObj.getRelateFrom().equals("3")) {
            User = String.valueOf(PrivilegeUserObj.getRelateFrom()) + "##" + "DMA";
            return User;
        }
        if (PrivilegeUserObj.getRelateFrom().equals("2")) {
            User = String.valueOf(PrivilegeUserObj.getRelateFrom()) + "##" + PrivilegeUserObj.getControlName();
            return User;
        }
        if (PrivilegeUserObj.getRelateFrom().equals("5")) {
            User = String.valueOf(PrivilegeUserObj.getRelateFrom()) + "##PIN##" + PrivilegeUserObj.getGroupName();
            if (PrivilegeUserObj.getGroupName().equals(CONFLICT_OPERTYPE_COMMON)) {
                User = String.valueOf(PrivilegeUserObj.getRelateFrom()) + "##PIN";
            }
            return User;
        }
        User = String.join((CharSequence)"##", PrivilegeUserObj.getRelateFrom(), PeriName, PrivilegeUserObj.getGroupName(), PrivilegeUserObj.getControlName());
        while (User.contains("####")) {
            User = User.replace("####", "##");
        }
        if (User.endsWith("##")) {
            User = User.substring(0, User.length() - 2);
        }
        return User;
    }

    public static int getNodeState(int bitNo, int newState, int currentState) {
        return newState << bitNo | (currentState &= ~(1 << bitNo));
    }

    public static int getPeriTreeEnableState(int bitNo, int newState, int currentState) {
        currentState = newState == 1 ? (currentState |= 1 << bitNo) : (currentState &= ~(1 << bitNo));
        int enableState = currentState & 0x30;
        currentState = enableState == 0 ? ConflictUtil.getNodeState(0, 0, currentState) : ConflictUtil.getNodeState(0, 1, currentState);
        return currentState;
    }

    public static <T> T cloneFrom(T src) throws RuntimeException {
        ByteArrayOutputStream memoryBuffer = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object dist = null;
        try {
            try {
                out = new ObjectOutputStream(memoryBuffer);
                out.writeObject(src);
                out.flush();
                in = new ObjectInputStream(new ByteArrayInputStream(memoryBuffer.toByteArray()));
                dist = in.readObject();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return (T)dist;
    }

    public static void openUpdateValuePrivilege(boolean flag) {
        conflictIsSetValue = flag;
    }

    public static int getNodeState(String priviligeStr, boolean condiResult, int currentState) {
        ConflictBitInfo conflictBitObj = ConflictBitInfos.get(priviligeStr);
        int bitNo = conflictBitObj.getBit();
        int value = conflictBitObj.getValue();
        if (!condiResult) {
            if (bitNo != 0 && bitNo != 1) {
                return currentState;
            }
            value ^= 1;
        }
        int newState = ConflictUtil.getNodeState(bitNo, value, currentState);
        return newState;
    }
}

