/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.conflict.tool;

import com.gigadevice.conflict.tool.CalculatorFunctions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Pattern;

public class ReflectionFunc {
    public String CheckCRCPolynomialInput(String str) {
        String strRet = "true";
        String[] strSrc = new String[]{"X0", "X1", "X2", "X3", "X4", "X5", "X6", "X7", "X8", "X9", "X10", "X11", "X12", "X13", "X14", "X15"};
        String[] strArray = str.split("\\+");
        int i = 0;
        while (i < strArray.length) {
            String strItem = strArray[i];
            if (!Arrays.asList(strSrc).contains(strItem)) {
                strRet = "false";
                break;
            }
            ++i;
        }
        return strRet;
    }

    public String GetCRCPolynomialCode(String str) {
        String strRet = "";
        int Sum = 0;
        List lstIndex = this.SearchAllIndex(str, "X");
        List lstNum = this.GetAllNum(str, lstIndex);
        int i = 0;
        while (i < lstNum.size()) {
            double a = 2.0;
            int b = (Integer)lstNum.get(i);
            Sum = (int)((double)Sum + Math.pow(a, b));
            ++i;
        }
        strRet = Integer.toString(Sum);
        return strRet;
    }

    public String Multiply(String a, String b) {
        String result = "";
        try {
            int aa = Integer.parseInt(a);
            int bb = Integer.parseInt(b);
            result = String.valueOf(aa * bb);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List SearchAllIndex(String str, String key) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int index = str.indexOf(key);
        while (index != -1) {
            lst.add(index);
            index = str.indexOf(key, index + 1);
        }
        return lst;
    }

    private List GetAllNum(String str, List allIndex) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int i = 0;
        while (i < allIndex.size()) {
            int Pos2;
            int tempPos = Pos2 = (Integer)allIndex.get(i) + 1;
            int len = 0;
            String strNum = "";
            while (tempPos <= str.length() - 1) {
                char c = str.charAt(tempPos);
                if (c < '0' || c > '9') break;
                ++len;
                ++tempPos;
            }
            strNum = str.substring(Pos2, Pos2 + len);
            lst.add(Integer.valueOf(strNum));
            ++i;
        }
        return lst;
    }

    public String GetBaudRate(String strPBxClock, String strPrescaler) {
        String strRet = "";
        if (strPBxClock.equals("") || strPrescaler.equals("")) {
            return strRet;
        }
        strPBxClock = strPBxClock.replaceAll("MHz", "");
        double douClock = Double.parseDouble(strPBxClock);
        double douPrescaler = Double.parseDouble(strPrescaler);
        double BaudRate = douClock / douPrescaler;
        strRet = String.format("%6f", BaudRate);
        strRet = String.valueOf(strRet) + " MBits/s";
        return strRet;
    }

    public String GetClock(String strClock) {
        return strClock;
    }

    public String ParityCheck(String str) {
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch < '0' || ch > '9') {
                return "false";
            }
            ++i;
        }
        long n = Long.parseLong(str);
        if (n % 2L != 0L) {
            return "false";
        }
        return "true";
    }

    public String HostPopup(String str) {
        if (str.equals("ENABLE")) {
            return "true";
        }
        return "false";
    }

    public String HostPopup(String str1, String str2) {
        if (str1.equals("ENABLE")) {
            return str2;
        }
        return "false";
    }

    public String AddCheck(String str1, String str2, String str3, String str4, String str5, String str6) {
        long n6;
        long n5;
        long n4;
        long n3;
        long n2;
        int i = 0;
        while (i < str1.length()) {
            char ch = str1.charAt(i);
            if (ch < '0' || ch > '9') {
                return "false";
            }
            ++i;
        }
        long n1 = Long.parseLong(str1);
        long res = n1 + (n2 = Long.parseLong(str2)) + (n3 = Long.parseLong(str3)) + (n4 = Long.parseLong(str4)) + (n5 = Long.parseLong(str5));
        if (res > (n6 = Long.parseLong(str6))) {
            return "false";
        }
        return "true";
    }

    public String AddCheck(String str1, String str2, String str3, String str4) {
        long n4;
        long n3;
        long n2;
        int i = 0;
        while (i < str1.length()) {
            char ch = str1.charAt(i);
            if (ch < '0' || ch > '9') {
                return "false";
            }
            ++i;
        }
        long n1 = Long.parseLong(str1);
        long res = n1 + (n2 = Long.parseLong(str2)) + (n3 = Long.parseLong(str3));
        if (res > (n4 = Long.parseLong(str4))) {
            return "false";
        }
        return "true";
    }

    public String GetTimeQuantum(String strPCLK1, String strPrescaler) {
        String strRet = "";
        if (strPCLK1.equals("") || strPrescaler.equals("")) {
            return strRet;
        }
        double PCLK1 = Double.parseDouble(strPCLK1) * 1000000.0;
        double Prescaler = Double.parseDouble(strPrescaler) * 1.0E9;
        double TimeQuantum = Prescaler / PCLK1;
        strRet = String.format("%.1f", TimeQuantum);
        strRet = String.valueOf(strRet) + " ns";
        return strRet;
    }

    public String GetTimeForOneBit(String strPCLK1, String strPrescaler, String strBTS1, String strBTS2) {
        String strRet = "";
        if (strPCLK1.equals("") || strPrescaler.equals("") || strBTS1.equals("") || strBTS2.equals("")) {
            return strRet;
        }
        double PCLK1 = Double.parseDouble(strPCLK1) * 1000000.0;
        double Prescaler = Double.parseDouble(strPrescaler) * 1.0E9;
        double BTS1 = Double.parseDouble(strBTS1.split(" ")[0]);
        double BTS2 = Double.parseDouble(strBTS2.split(" ")[0]);
        double TimeForOneBit = Prescaler / PCLK1 + BTS1 * Prescaler / PCLK1 + BTS2 * Prescaler / PCLK1;
        strRet = String.format("%.2f", TimeForOneBit);
        strRet = String.valueOf(strRet) + " ns";
        return strRet;
    }

    public String GetCanBaudRate(String strPCLK1, String strPrescaler, String strBTS1, String strBTS2) {
        String strRet = "";
        if (strPCLK1.equals("") || strPrescaler.equals("") || strBTS1.equals("") || strBTS2.equals("")) {
            return strRet;
        }
        double PCLK1 = Double.parseDouble(strPCLK1) * 1000000.0;
        double Prescaler = Double.parseDouble(strPrescaler) * 1.0E9;
        double BTS1 = Double.parseDouble(strBTS1.split(" ")[0]);
        double BTS2 = Double.parseDouble(strBTS2.split(" ")[0]);
        double TimeForOneBit = Prescaler / PCLK1 + BTS1 * Prescaler / PCLK1 + BTS2 * Prescaler / PCLK1;
        double CanBaudRate = 1.0 / TimeForOneBit * 1.0E9;
        strRet = String.format("%.0f", Math.floor(CanBaudRate));
        strRet = String.valueOf(strRet) + " bit/s";
        return strRet;
    }

    public String StringJudge(String strDefaultValue, String strInput) {
        String strRet = "";
        if ((strInput = strInput.replaceAll("+", "")).contains("X")) {
            String[] strArray = strInput.split("X");
            int i = 0;
            while (i < strArray.length) {
                String strItem = strArray[i];
                int Num = 0;
                try {
                    Num = Integer.parseInt(strItem);
                }
                catch (Exception exception) {
                    strRet = strDefaultValue;
                    break;
                }
                if (Num > 15 || Num < 0) {
                    strRet = strDefaultValue;
                    break;
                }
                ++i;
            }
        } else {
            strRet = strDefaultValue;
        }
        return strRet;
    }

    public boolean GetConditionsAND(String ... conditions) {
        String[] stringArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            String condition = stringArray[n2];
            if (!Boolean.parseBoolean(condition)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean GetConditionsAND(String strbl1, String strbl2) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3, String strbl4) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3) && Boolean.parseBoolean(strbl4);
    }

    public boolean GetConditionsOR(String strbl1, String strbl2) {
        return Boolean.parseBoolean(strbl1) || Boolean.parseBoolean(strbl2);
    }

    public boolean GetConditionsOR(String strbl1, String strbl2, String strbl3, String strbl4) {
        return Boolean.parseBoolean(strbl1) || Boolean.parseBoolean(strbl2) || Boolean.parseBoolean(strbl3) || Boolean.parseBoolean(strbl4);
    }

    public boolean GetConditionOpposite(String strbl) {
        return !Boolean.parseBoolean(strbl);
    }

    public String GetAlarmMaskValue(String Alarm0DateMask, String Alarm0HoursMask, String Alarm0MinutesMask, String Alarm0SecondsMask) {
        String value = "";
        if (Alarm0DateMask.equals("Enable") && Alarm0HoursMask.equals("Enable") && Alarm0MinutesMask.equals("Enable") && Alarm0SecondsMask.equals("Enable")) {
            value = "HAL_RTC_ALARM_ALL_MASK";
        } else if (Alarm0DateMask.equals("Disable") && Alarm0HoursMask.equals("Disable") && Alarm0MinutesMask.equals("Disable") && Alarm0SecondsMask.equals("Disable")) {
            value = "HAL_RTC_ALARM_NONE_MASK";
        } else {
            if (Alarm0DateMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_DATE_MASK | ";
            }
            if (Alarm0HoursMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_HOUR_MASK | ";
            }
            if (Alarm0MinutesMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_MINUTE_MASK | ";
            }
            if (Alarm0SecondsMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_SECOND_MASK | ";
            }
        }
        int i = value.length() - 1;
        while (i >= 0) {
            char v = value.charAt(i);
            if (v >= 'a' && v <= 'z' || v >= 'A' && v <= 'Z') {
                value = value.substring(0, i + 1);
                break;
            }
            --i;
        }
        return value;
    }

    public String TimeRegulate(String strY, String strM, String strD, String strHH, String strMM, String strSS) {
        String value = "";
        int month = 0;
        List<String> monthlist = Arrays.asList("HAL_RTC_JAN", "HAL_RTC_FEB", "HAL_RTC_MAR", "HAL_RTC_APR", "HAL_RTC_MAY", "HAL_RTC_JUN", "HAL_RTC_JUL", "HAL_RTC_AUG", "HAL_RTC_SEP", "HAL_RTC_OCT", "HAL_RTC_NOV", "HAL_RTC_DEC");
        int i = 0;
        while (i < monthlist.size()) {
            if (monthlist.get(i).compareTo(strM) == 0) {
                month = i;
                break;
            }
            ++i;
        }
        int year = Integer.parseInt(strY);
        int date = Integer.parseInt(strD);
        int hour = Integer.parseInt(strHH);
        int minute = Integer.parseInt(strMM);
        int second = Integer.parseInt(strSS);
        long unix_TimeStamp = 0L;
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        nArrayArray[1] = nArray2;
        int[][] Day_Count = nArrayArray;
        if (month > 0) {
            unix_TimeStamp = 10957 + year * 365 + (year + 3) / 4;
            unix_TimeStamp += (long)Day_Count[0][month - 1];
            if (year % 4 == 0 && month > 2) {
                ++unix_TimeStamp;
            }
            unix_TimeStamp = (unix_TimeStamp + (long)(date - 1)) * 24L;
            unix_TimeStamp = (unix_TimeStamp + (long)hour - 8L) * 3600L + (long)(minute * 60) + (long)second;
        } else {
            unix_TimeStamp = 1514779200L;
        }
        value = String.valueOf(unix_TimeStamp);
        return value;
    }

    public String[] SplitEdit(String str1, String str2, String str3) {
        if (str2.equals(".")) {
            str2 = "\\.";
        }
        String[] stringList = str1.split(str2);
        String[] stringList1 = new String[stringList.length];
        int i = 0;
        while (i < stringList.length) {
            String str = stringList[i];
            String strRep = "";
            if (str != null && !str.isEmpty()) {
                strRep = str.replaceFirst(str3, "");
            }
            if (strRep.isEmpty()) {
                strRep = "0";
            }
            stringList1[i] = strRep;
            ++i;
        }
        return stringList1;
    }

    public String addTest(String a, String b) {
        String result = "";
        try {
            int aa = Integer.parseInt(a);
            int bb = Integer.parseInt(b);
            result = String.valueOf(aa + bb);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String multiplicationTest(String a, String b) {
        String result = "";
        try {
            int aa = Integer.parseInt(a);
            int bb = Integer.parseInt(b);
            result = String.valueOf(aa * bb);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Boolean isOddNumber(String a) {
        try {
            int aa = Integer.parseInt(a);
            if (aa % 2 != 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isEvenNumber(String a) {
        try {
            int aa = Integer.parseInt(a);
            if (aa % 2 == 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String extractNumber(String input, String type) {
        boolean isNegative;
        if (input == null || input.isEmpty()) {
            return "";
        }
        if (!(type = type.toUpperCase()).equals("HEX") && !type.equals("DEC")) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean hasDecimalPoint = false;
        int startIndex = 0;
        while (startIndex < input.length() && Character.isWhitespace(input.charAt(startIndex))) {
            ++startIndex;
        }
        boolean bl = isNegative = startIndex < input.length() && input.charAt(startIndex) == '-';
        if (isNegative) {
            result.append('-');
            ++startIndex;
        }
        int i = startIndex;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (type.equals("DEC")) {
                if (Character.isDigit(c)) {
                    result.append(c);
                } else if (c == '.' && !hasDecimalPoint) {
                    result.append(c);
                    hasDecimalPoint = true;
                }
            } else if (Character.isDigit(c) || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
                result.append(c);
            } else if (c == '.' && !hasDecimalPoint) {
                result.append(c);
                hasDecimalPoint = true;
            }
            ++i;
        }
        return result.toString();
    }

    public String getAbsValue(String a) {
        String result = "";
        try {
            int aa = Integer.parseInt(a);
            if (aa < 0) {
                aa = 0 - aa;
            }
            result = String.valueOf(aa);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Boolean checkIsEqualorGreaterThan(String a, String b) {
        try {
            int aa = Integer.parseInt(a);
            int bb = Integer.parseInt(b);
            if (aa >= bb) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean checkIsGreaterThan(String a, String b) {
        try {
            BigDecimal aa = this.parseStringToBigDecimal(a);
            BigDecimal bb = this.parseStringToBigDecimal(b);
            if (aa.compareTo(bb) > 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean checkIsEqual(String a, String b) {
        if (a.equals(b)) {
            return true;
        }
        return false;
    }

    public Boolean getDoubleCheckValueAndResult(String a, String b) {
        try {
            if (a.toUpperCase().equals("FALSE") || b.toUpperCase().equals("FALSE")) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return true;
    }

    public Boolean getDoubleCheckValueOrResult(String a, String b) {
        try {
            if (a.toUpperCase().equals("TRUE") || b.toUpperCase().equals("TRUE")) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isNotMoreThanSum(String a, String b) {
        try {
            BigDecimal bb;
            if (a == null || b == null || a.isEmpty() || b.isEmpty()) {
                return false;
            }
            BigDecimal aa = a.toLowerCase().startsWith("0x") ? new BigDecimal(new BigInteger(a.substring(2), 16)) : new BigDecimal(a);
            if (aa.compareTo(bb = b.toLowerCase().startsWith("0x") ? new BigDecimal(new BigInteger(b.substring(2), 16)) : new BigDecimal(b)) <= 0) {
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String isMoreThanAndEqual(String a, String b) {
        try {
            BigDecimal aa = this.parseStringToBigDecimal(a);
            BigDecimal bb = this.parseStringToBigDecimal(b);
            if (aa.compareTo(bb) >= 0) {
                return "true";
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return "false";
    }

    private Long parseStringToInteger(String value) throws NumberFormatException {
        if (value.startsWith("0x") || value.startsWith("0X")) {
            return Long.parseLong(value.substring(2), 16);
        }
        if (value.contains(".")) {
            BigDecimal decimalValue = new BigDecimal(value.trim());
            return decimalValue.longValue();
        }
        return Long.parseLong(value);
    }

    public BigDecimal parseStringToBigDecimal(String value) throws NumberFormatException {
        if (value.startsWith("0x") || value.startsWith("0X")) {
            return new BigDecimal(new BigInteger(value.substring(2), 16));
        }
        if (value.contains(".")) {
            BigDecimal decimalValue = new BigDecimal(value.trim());
            return decimalValue;
        }
        return new BigDecimal(value);
    }

    public Boolean isLength(String a, String b) {
        try {
            if (a.startsWith("0x") || a.startsWith("0X")) {
                a = a.substring(2);
            }
            int actualbitlength = a.length() * 4;
            int bb = Integer.parseInt(b);
            if (bb <= 0) {
                return false;
            }
            if (actualbitlength == bb) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isLengthBetween(String a, String b, String c) {
        try {
            if (a.startsWith("0x") || a.startsWith("0X")) {
                a = a.substring(2);
            }
            int actualbitlength = a.length() * 4;
            int bb = Integer.parseInt(b);
            int cc = Integer.parseInt(c);
            if (bb <= 0 || cc <= 0 || bb > cc) {
                return false;
            }
            if (actualbitlength >= bb && actualbitlength <= cc) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String GetValueArray(String arrayStr, String type, String ... parameters) {
        String valueArray = "";
        if (type.equals("ASCII")) {
            arrayStr = this.ASCIItoHEX(arrayStr);
        }
        arrayStr = arrayStr.replaceAll(" ", "");
        String regex16 = "[A-Fa-f0-9]+$";
        if ((arrayStr = arrayStr.substring(2)).matches(regex16)) {
            int len = arrayStr.length();
            if (arrayStr.length() % 2 != 0) {
                ++len;
                StringBuffer temp = new StringBuffer();
                temp.append("0").append(arrayStr);
                arrayStr = temp.toString();
            }
            int targetLength = -1;
            if (parameters != null && parameters.length > 0) {
                try {
                    targetLength = Integer.parseInt(parameters[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    targetLength = -1;
                }
            }
            if (targetLength > 0 && len / 2 < targetLength) {
                int paddingBytes = targetLength - len / 2;
                StringBuffer temp = new StringBuffer();
                int i = 0;
                while (i < paddingBytes) {
                    temp.append("00");
                    ++i;
                }
                temp.append(arrayStr);
                arrayStr = temp.toString();
                len = arrayStr.length();
            }
            int pos = 0;
            int i = 0;
            while (i < len / 2) {
                valueArray = i == len / 2 - 1 ? String.valueOf(valueArray) + "0x" + arrayStr.substring(pos, pos + 2) : String.valueOf(valueArray) + "0x" + arrayStr.substring(pos, pos + 2) + ",";
                pos += 2;
                ++i;
            }
            StringBuffer temp = new StringBuffer();
            temp.append("{").append(valueArray).append("}");
            valueArray = temp.toString();
        }
        return valueArray;
    }

    public String ASCIItoHEX(String ascii) {
        String ret = "";
        String value = ascii;
        StringBuilder hex = new StringBuilder();
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            hex.append(String.format("%02X", ch));
            String hexStr = hex.toString();
            ret = "0x" + hexStr;
            ++n2;
        }
        return ret;
    }

    public String GetArrayLength(String arrayStr, String type) {
        String length = "";
        if (type.equals("ASCII")) {
            length = Integer.toString(arrayStr.length());
        } else if (type.equals("HEX")) {
            arrayStr.replaceAll(" ", "");
            String regex16 = "[A-Fa-f0-9]+$";
            arrayStr = arrayStr.substring(2);
            if (arrayStr.matches(regex16)) {
                int len = arrayStr.length();
                if (arrayStr.length() % 2 != 0) {
                    ++len;
                }
                length = Integer.toString(len / 2);
            }
        }
        return length;
    }

    public String I2CTimingCalculator(String SpeedMode, String BusSpeed, String CK_I2C, String RiseTime, String FallTime, String DigitalNoiseFilter, String DigitalNoiseFilterConfiguration, String AnalogNoiseFiltery) {
        String result = "";
        try {
            String Timing_Reg_Str;
            int m_SpeedMode = -1;
            if (SpeedMode.equals("Standard")) {
                m_SpeedMode = 0;
            } else if (SpeedMode.equals("Fast")) {
                m_SpeedMode = 1;
            } else if (SpeedMode.equals("Fast-Mode-Plus")) {
                m_SpeedMode = 2;
            } else {
                return result;
            }
            double m_SpeedFreq = Double.parseDouble(BusSpeed) * 1000.0;
            double m_ClockFreq = Double.parseDouble(CK_I2C) * 1000000.0;
            double m_RiseTime = Double.parseDouble(RiseTime) * Math.pow(10.0, -9.0);
            double m_FallTime = Double.parseDouble(FallTime) * Math.pow(10.0, -9.0);
            int m_DigitalCoefficient = -1;
            if (DigitalNoiseFilter.equals("Disable")) {
                m_DigitalCoefficient = 0;
            } else if (DigitalNoiseFilterConfiguration.contains("TI2CCLK")) {
                m_DigitalCoefficient = Integer.parseInt(DigitalNoiseFilterConfiguration.replace("TI2CCLK", "").replace(" ", ""));
            } else {
                return result;
            }
            if (!DigitalNoiseFilterConfiguration.contains("TI2CCLK")) {
                return result;
            }
            m_DigitalCoefficient = Integer.parseInt(DigitalNoiseFilterConfiguration.replace("TI2CCLK", "").replace(" ", ""));
            if (!AnalogNoiseFiltery.equals("Disable") && !AnalogNoiseFiltery.equals("Enable")) {
                return result;
            }
            int SDADELY = 0;
            int SCLDELY = 0;
            int PSC = 0;
            int SCLL = 0;
            int SCLH = 0;
            double Time_I2CCLK = 0.0;
            double Time_SCL = 0.0;
            double Time_SCL_Max_Const = 0.0;
            double Time_SCLH_Min_Const = 0.0;
            double Time_Fall_Max = 0.0;
            double Time_Rise_Max = 0.0;
            double Time_SU_DAT_Min_Const = 0.0;
            Time_I2CCLK = 1.0 / m_ClockFreq;
            Time_SCL = 1.0 / m_SpeedFreq;
            Time_SCL_Max_Const = Time_SCL / Time_I2CCLK;
            double TIME_LOW_STANDARD_MODE_MIN = 4.7 * Math.pow(10.0, -6.0);
            double TIME_HIGH_STANDARD_MODE_MIN = 4.0 * Math.pow(10.0, -6.0);
            double TIME_LOW_FAST_MODE_MIN = 1.3 * Math.pow(10.0, -6.0);
            double TIME_HIGH_FAST_MODE_MIN = 0.6 * Math.pow(10.0, -6.0);
            double TIME_LOW_FAST_MODE_PLUS_MIN = 0.5 * Math.pow(10.0, -6.0);
            double TIME_HIGH_FAST_MODE_PLUS_MIN = 0.26 * Math.pow(10.0, -6.0);
            Math.pow(10.0, -9.0);
            Math.pow(10.0, -9.0);
            Math.pow(10.0, -9.0);
            Math.pow(10.0, -9.0);
            Math.pow(10.0, -9.0);
            Math.pow(10.0, -9.0);
            double TIME_HD_DAT_MIN = 0.0;
            double TIME_HD_DAT_STANDARD_MODE_MAX = 3.45 * Math.pow(10.0, -6.0);
            double TIME_HD_DAT_FAST_MODE_MAX = 0.9 * Math.pow(10.0, -6.0);
            double TIME_HD_DAT_FAST_MODE_PLUS_MAX = 0.45 * Math.pow(10.0, -6.0);
            double TIME_SU_DAT_STANDARD_MODE_MIN = 250.0 * Math.pow(10.0, -9.0);
            double TIME_SU_DAT_FAST_MODE_MIN = 100.0 * Math.pow(10.0, -9.0);
            double TIME_SU_DAT_FAST_MODE_PLUS_MIN = 50.0 * Math.pow(10.0, -9.0);
            double TIME_AF_MIN = 50.0 * Math.pow(10.0, -9.0);
            Math.pow(10.0, -9.0);
            switch (m_SpeedMode) {
                case 0: {
                    double cfr_ignored_0 = TIME_LOW_STANDARD_MODE_MIN / Time_I2CCLK;
                    Time_SCLH_Min_Const = TIME_HIGH_STANDARD_MODE_MIN / Time_I2CCLK;
                    double cfr_ignored_1 = (TIME_LOW_STANDARD_MODE_MIN + TIME_HIGH_STANDARD_MODE_MIN) / Time_I2CCLK;
                    Time_SU_DAT_Min_Const = TIME_SU_DAT_STANDARD_MODE_MIN;
                    break;
                }
                case 1: {
                    double cfr_ignored_2 = TIME_LOW_FAST_MODE_MIN / Time_I2CCLK;
                    Time_SCLH_Min_Const = TIME_HIGH_FAST_MODE_MIN / Time_I2CCLK;
                    double cfr_ignored_3 = (TIME_LOW_FAST_MODE_MIN + TIME_HIGH_FAST_MODE_MIN) / Time_I2CCLK;
                    Time_SU_DAT_Min_Const = TIME_SU_DAT_FAST_MODE_MIN;
                    break;
                }
                case 2: {
                    double cfr_ignored_4 = TIME_LOW_FAST_MODE_PLUS_MIN / Time_I2CCLK;
                    Time_SCLH_Min_Const = TIME_HIGH_FAST_MODE_PLUS_MIN / Time_I2CCLK;
                    double cfr_ignored_5 = (TIME_LOW_FAST_MODE_PLUS_MIN + TIME_HIGH_FAST_MODE_PLUS_MIN) / Time_I2CCLK;
                    Time_SU_DAT_Min_Const = TIME_SU_DAT_FAST_MODE_PLUS_MIN;
                }
            }
            Time_Fall_Max = m_FallTime;
            int ClockFreqConst_Max = (int)(m_ClockFreq / 1000.0);
            int i = 0;
            while (i < 15) {
                int PSC_Const = i + 1;
                if (ClockFreqConst_Max % PSC_Const == 0 && (SCLH = (int)(Time_SCLH_Min_Const / (double)PSC_Const)) <= 255 && (SCLL = (int)(Time_SCL_Max_Const / (double)PSC_Const - (double)SCLH - 2.0 - 5.0)) <= 255) {
                    if (SCLL < 0) {
                        SCLL = 1;
                    }
                    PSC = i;
                    break;
                }
                ++i;
            }
            double SDADELY_Min = Time_Fall_Max + TIME_HD_DAT_MIN - TIME_AF_MIN - (double)(m_DigitalCoefficient + 3) * Time_I2CCLK;
            SDADELY = SDADELY_Min < 0.0 ? 0 : (int)(SDADELY_Min + 1.0);
            Time_Rise_Max = m_RiseTime;
            int SCLDEL_Min = (int)((Time_Rise_Max + Time_SU_DAT_Min_Const) / ((double)(PSC + 1) * Time_I2CCLK) - 1.0);
            SCLDELY = SCLDEL_Min + 1;
            Integer.toHexString(PSC);
            Integer.toHexString(SCLDELY);
            Integer.toHexString(SDADELY);
            Integer.toHexString(SCLH);
            Integer.toHexString(SCLL);
            long Timing_Reg_Val = 0L;
            Timing_Reg_Val = ((long)PSC & 0xFL) << 28 | ((long)SCLDELY & 0xFL) << 20 | ((long)SDADELY & 0xFL) << 16 | ((long)SCLH & 0xFFL) << 8 | (long)SCLL & 0xFFL;
            StringBuilder timingHexToUpper = new StringBuilder();
            char[] cArray = Long.toHexString(Timing_Reg_Val).toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                timingHexToUpper.append(Character.toUpperCase(c));
                ++n2;
            }
            result = Timing_Reg_Str = "0x" + timingHexToUpper;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String GetI2C_smbus_timeout(String ExtendedClockTimeoutDetection, String TimeoutB, String ClockTimeoutDetection, String IdleClockTimeoutDetection, String TimeoutA) {
        long extendedClock = "Enable".equalsIgnoreCase(ExtendedClockTimeoutDetection) ? 1L : 0L;
        long clockTimeout = "Enable".equalsIgnoreCase(ClockTimeoutDetection) ? 1L : 0L;
        long idleClock = "Enable".equalsIgnoreCase(IdleClockTimeoutDetection) ? 1L : 0L;
        long timeoutB = Long.parseLong(TimeoutB.substring(2), 16);
        long timeoutA = Long.parseLong(TimeoutA.substring(2), 16);
        long smbus_timeout = extendedClock << 31 | (timeoutB &= 0xFFFL) << 16 | clockTimeout << 15 | idleClock << 12 | (timeoutA &= 0xFFFL);
        return "0x" + Long.toHexString(smbus_timeout).toUpperCase();
    }

    public String GetI2C_BUSTOB(String BusTimeoutB, String CK_I2C) {
        double m_CK_I2C;
        double m_Bustimeout_B;
        String ret = "";
        try {
            m_Bustimeout_B = Double.parseDouble(BusTimeoutB);
            m_CK_I2C = Double.parseDouble(CK_I2C);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid input value: " + BusTimeoutB + " or " + CK_I2C, e);
        }
        double InitResult = m_Bustimeout_B / (2048.0 * (1000.0 / m_CK_I2C)) - 1.0;
        double result = Math.floor(Math.max(InitResult, 0.0));
        int m_result = (int)result;
        StringBuilder bustobHexToUpper = new StringBuilder();
        char[] cArray = Integer.toHexString(m_result).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            bustobHexToUpper.append(Character.toUpperCase(c));
            ++n2;
        }
        ret = "0x" + bustobHexToUpper;
        return ret;
    }

    public String GetI2C_BUSTOA(String Time, String CK_I2C, String flag) {
        double InitResult;
        double m_CK_I2C;
        String ret = "";
        double m_Idle_timeout = Double.parseDouble(Time);
        try {
            m_CK_I2C = Double.parseDouble(CK_I2C);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid CK_I2C value: " + CK_I2C, e);
        }
        switch (flag.toLowerCase()) {
            case "timeout": {
                InitResult = m_Idle_timeout / (2048.0 * (1000.0 / m_CK_I2C)) - 1.0;
                break;
            }
            case "idletime": {
                InitResult = m_Idle_timeout / (4.0 * (1000.0 / m_CK_I2C)) - 1.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flag value: " + flag);
            }
        }
        double result = Math.max(Math.ceil(InitResult), 0.0);
        int m_result = (int)result;
        StringBuilder bustoaHexToUpper = new StringBuilder();
        char[] cArray = Integer.toHexString(m_result).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            bustoaHexToUpper.append(Character.toUpperCase(c));
            ++n2;
        }
        ret = "0x" + bustoaHexToUpper;
        return ret;
    }

    public String forceNonNegative(String value) {
        try {
            BigDecimal bigValue = new BigDecimal(value);
            BigDecimal result = bigValue.max(BigDecimal.ZERO);
            return result.toPlainString();
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            throw new IllegalArgumentException("Invalid input: not a valid number");
        }
    }

    public String floorDecimal(String value) {
        try {
            double doubleValue = Double.parseDouble(value);
            int flooredValue = (int)Math.floor(doubleValue);
            return String.valueOf(flooredValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid input: not a valid decimal number");
        }
    }

    public String ceilDecimal(String value) {
        try {
            double doubleValue = Double.parseDouble(value);
            int ceiledValue = (int)Math.ceil(doubleValue);
            return String.valueOf(ceiledValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid input: not a valid decimal number");
        }
    }

    public String GetI2CBitsTiming(String timing, String start, String end) {
        int endInt;
        int startInt;
        long timingLong;
        if (timing == null || start == null || end == null || !timing.startsWith("0x")) {
            throw new IllegalArgumentException("Invalid timing format");
        }
        String hexValue = timing.substring(2);
        try {
            timingLong = Long.parseLong(hexValue, 16);
            startInt = Integer.parseInt(start);
            endInt = Integer.parseInt(end);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u6748\u64b3\u53c6\u9428\u52eb\u5f2c\u93c1\u677f\u7e40\u6924\u7ed8\u69f8\u93c8\u590b\u6665\u9428\u52ec\u66a3\u93c1\u7248\u7278\u5bee\u5fcb\ufffd\ufffd", e);
        }
        if (startInt < 0 || endInt > 31 || startInt > endInt) {
            throw new IllegalArgumentException("\u5bee\ufffd\u6fee\u5b29\u7d85\u935c\u5c80\u7ca8\u93c9\u71b6\u7d85\u8e47\u5474\u300f\u9366\u25570, 31]\u6d94\u5b2e\u68ff\u951b\u5c7d\u82df\u6d93\u65bf\u7d11\u6fee\u5b29\u7d85\u6d93\u5d88\u5158\u6fb6\u0442\u7c2c\u7f01\u64b4\u6f6b\u6d63\u5d83\ufffd\ufffd");
        }
        long mask = (1 << endInt - startInt + 1) - 1;
        long extractedValue = timingLong >> startInt & mask;
        String Timing_Reg_Str = "0x" + String.format("%02X", extractedValue).toUpperCase();
        return Timing_Reg_Str;
    }

    public Boolean isMultipleofTwo(String a) {
        try {
            int aa = Integer.parseInt(a);
            if (aa > 0 && aa % 2 == 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isMultipleofFour(String a) {
        try {
            int aa = Integer.parseInt(a);
            if (aa > 0 && aa % 4 == 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isMultipleofN(String a, String n) {
        try {
            Long aa = this.parseStringToInteger(a);
            Long nn = this.parseStringToInteger(n);
            if (nn != 0L && aa % nn == 0L) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isPowerOfTwo(String a) {
        try {
            int aa = Integer.parseInt(a);
            if (aa >= 2 && (aa & aa - 1) == 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Boolean isPowerOfTwoAndOffset(String a, String offset) {
        try {
            int aa = Integer.parseInt(a);
            int off = Integer.parseInt(offset);
            if (aa >= 1 && aa - off > 0 && (aa - off & aa - off - 1) == 0 && (aa - off) % 2 == 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isExponentiation(String a, String n) {
        try {
            double roundedBase;
            double base = Double.parseDouble(a);
            int exponent = Integer.parseInt(n);
            if (base < 1.0) {
                throw new IllegalArgumentException("\u9359\u509b\u669f a \u8e47\u5474\u300f\u6fb6\u0442\u7c2c\u93b4\u682b\u74d1\u6d5c\ufffd 1");
            }
            if (exponent <= 0) {
                throw new IllegalArgumentException("\u93b8\u56e8\u669f n \u8e47\u5474\u300f\u6d93\u70d8\ue11c\u93c1\u5b58\u669f");
            }
            double possibleBase = Math.pow(base, 1.0 / (double)exponent);
            return Math.abs(possibleBase - (roundedBase = (double)Math.round(possibleBase))) < 1.0E-9;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("\u9359\u509b\u669f a \u935c\ufffd n \u8e47\u5474\u300f\u6d93\u70d8\u6e41\u93c1\u5822\u6b91\u93c1\u677f\u74e7\u701b\u6943\ue0c1\u6d93\ufffd");
        }
    }

    public String getControlValue(String a) {
        return a;
    }

    public String UpdateRealAudioFrequencyValue(String F_getDIVValue, String E_RealAudioFrequency) {
        if (Integer.parseInt(F_getDIVValue) > 255 || Integer.parseInt(F_getDIVValue) < 2) {
            return "-";
        }
        return E_RealAudioFrequency;
    }

    public String getDIVValue(String str1_CK_I2S0, String constant, String str2_AudioSamplingFrequency, String OFValue) {
        int ret = (int)(Double.parseDouble(str1_CK_I2S0) * 1000.0 / (double)Integer.parseInt(constant));
        ret *= 10;
        ret = Double.parseDouble(str2_AudioSamplingFrequency) <= 192.0 ? (int)((double)ret / Double.parseDouble(str2_AudioSamplingFrequency)) : (int)((double)ret / (Double.parseDouble(str2_AudioSamplingFrequency) / 1000.0));
        ret += 5;
        ret /= 10;
        ret -= Integer.parseInt(OFValue);
        return String.valueOf(ret /= 2);
    }

    public String getOFValue(String str1_CK_I2S0, String constant, String str2_AudioSamplingFrequency) {
        int ret = (int)(Double.parseDouble(str1_CK_I2S0) * 1000.0 / (double)Integer.parseInt(constant));
        ret *= 10;
        ret = Double.parseDouble(str2_AudioSamplingFrequency) <= 192.0 ? (int)((double)ret / Double.parseDouble(str2_AudioSamplingFrequency)) : (int)((double)ret / (Double.parseDouble(str2_AudioSamplingFrequency) / 1000.0));
        ret += 5;
        ret /= 10;
        return String.valueOf(ret &= 1);
    }

    public Boolean JudgeDIVValueIsValid(String str1_CK_I2S0, String constant, String str2_AudioSamplingFrequency, String OFValue) {
        String ret = this.getDIVValue(str1_CK_I2S0, constant, str2_AudioSamplingFrequency, OFValue);
        if (Integer.parseInt(ret) > 255 || Integer.parseInt(ret) < 2) {
            return false;
        }
        return true;
    }

    public boolean CheckParity(String str) {
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch < '0' || ch > '9') {
                return false;
            }
            ++i;
        }
        long n = Long.parseLong(str);
        return n % 2L == 0L;
    }

    public boolean HostPopUp(String str) {
        return str.equals("Enable");
    }

    public boolean isValidCIdentifier(String name) {
        String[] keywords;
        Pattern VALID_IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
        HashSet<String> C_KEYWORDS = new HashSet<String>();
        String[] stringArray = keywords = new String[]{"auto", "break", "case", "char", "const", "continue", "default", "do", "double", "else", "enum", "extern", "float", "for", "goto", "if", "inline", "int", "long", "register", "restrict", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "void", "volatile", "while", "_Alignas", "_Alignof", "_Atomic", "_Bool", "_Complex", "_Generic", "_Imaginary", "_Noreturn", "_Static_assert", "_Thread_local"};
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            C_KEYWORDS.add(keyword);
            ++n2;
        }
        if (!VALID_IDENTIFIER_PATTERN.matcher(name).matches()) {
            return false;
        }
        return !C_KEYWORDS.contains(name);
    }

    public boolean isAndTrue(String input) {
        String[] conditions;
        input = input.trim();
        String[] stringArray = conditions = input.split("##");
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            String condition = stringArray[n2];
            if (!(condition = condition.trim()).equals("true")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isNotEqual(String a, String b) {
        return !a.equals(b);
    }

    public String isEqual(String a, String b) {
        long valueB;
        long valueA;
        if (a.toLowerCase().startsWith("0x")) {
            a = a.substring(2);
            valueA = Long.parseLong(a, 16);
        } else {
            valueA = Long.parseLong(a, 10);
        }
        if (b.toLowerCase().startsWith("0x")) {
            b = b.substring(2);
            valueB = Long.parseLong(b, 16);
        } else {
            valueB = Long.parseLong(b, 10);
        }
        return valueA == valueB ? "true" : "false";
    }

    public String DECToBCD(String decimalStr, String content) {
        int decimal;
        block6: {
            if (decimalStr == null || decimalStr.isEmpty()) {
                return "";
            }
            try {
                decimal = Integer.parseInt(decimalStr);
                if (decimal >= 0 && decimal < 100) break block6;
                return "";
            }
            catch (NumberFormatException numberFormatException) {
                return "";
            }
        }
        decimal = decimal / 10 * 16 + decimal % 10;
        if (content.equals("DEC")) {
            return String.valueOf(decimal);
        }
        if (content.equals("HEX")) {
            String hex = Integer.toHexString(decimal);
            return "0x" + hex.toUpperCase();
        }
        return "";
    }

    public String HexStringConcat(String highBitStr, String LowBitStr) {
        if (highBitStr.toUpperCase().startsWith("0X") && LowBitStr.toUpperCase().startsWith("0X")) {
            String highHex = highBitStr.substring(2);
            String LowHex = LowBitStr.substring(2);
            String result = String.valueOf(highHex) + LowHex;
            String finalResult = "0x" + result;
            return finalResult;
        }
        return "";
    }

    public boolean HexStringCompare(String a, String b) {
        try {
            String bb;
            BigInteger bigbbb;
            String aa;
            BigInteger bigaaa;
            int result;
            if (a.toUpperCase().startsWith("0X") && b.toUpperCase().startsWith("0X") && ((result = (bigaaa = new BigInteger(aa = a.substring(2), 16)).compareTo(bigbbb = new BigInteger(bb = b.substring(2), 16))) == 0 || result == -1)) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String withinRangeUpdateValue(String range, String checkValue, String value0, String value1) {
        if (this.checkValueWithinRange(range, checkValue)) {
            return value0;
        }
        return value1;
    }

    public boolean checkValueWithinRange(String range, String value) {
        Long intValue;
        range = range.trim();
        boolean inclusiveStart = range.startsWith("[");
        boolean inclusiveEnd = range.endsWith("]");
        String[] bounds = range.substring(1, range.length() - 1).split(",");
        Long lowerBound = this.parseStringToInteger(bounds[0].trim());
        Long upperBound = this.parseStringToInteger(bounds[1].trim());
        try {
            intValue = this.parseStringToInteger(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        boolean inRange = (inclusiveStart ? intValue >= lowerBound : intValue > lowerBound) && (inclusiveEnd ? intValue <= upperBound : intValue < upperBound);
        return inRange;
    }

    public String andOperation(String a, String b) {
        String result = "";
        try {
            Long aa = this.parseStringToInteger(a);
            Long bb = this.parseStringToInteger(b);
            result = String.valueOf(aa & bb);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String orOperation(String a, String b) {
        String result = "";
        try {
            Long aa = this.parseStringToInteger(a);
            Long bb = this.parseStringToInteger(b);
            result = String.valueOf(aa | bb);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String calculator(String expression, String format, String ... parameters) {
        double resultDouble;
        String result;
        block8: {
            result = "";
            String expressionStr = expression;
            int i = 0;
            while (i < parameters.length) {
                String parameter = parameters[i];
                String replaceStr = "[p" + String.valueOf(i) + "]";
                if (parameter == null || parameter.equals("") || !parameter.matches("-?\\d+(\\.\\d+)?")) {
                    return "%InvalidValue%";
                }
                expressionStr = expressionStr.replace(replaceStr, parameter);
                ++i;
            }
            CalculatorFunctions calFuncObj = new CalculatorFunctions();
            resultDouble = calFuncObj.calculate(expressionStr);
            if (format.contains("%")) break block8;
            return "%InvalidValue%";
        }
        try {
            if (format.contains("f")) {
                result = String.format(format, resultDouble);
            } else {
                long resultInt = (long)resultDouble;
                result = String.format(format, resultInt);
            }
        }
        catch (IllegalFormatException illegalFormatException) {
            return "%InvalidValue%";
        }
        catch (Exception exception) {
            return "%InvalidValue%";
        }
        return result;
    }

    public String getMaxDaysOfMonth_DEC(String year, String month, String baseYear, String months) {
        int monthInt;
        int yearInt;
        block10: {
            block9: {
                block8: {
                    if (months != null && !months.isEmpty() && months.split(",").length == 12) break block8;
                    return "31";
                }
                if (year.contains("0x") || year.contains("0X")) {
                    year = this.BCDToDEC(year);
                }
                if (baseYear.contains("0x") || baseYear.contains("0X")) {
                    baseYear = this.BCDToDEC(baseYear);
                }
                if (year.matches("\\d+") && baseYear.matches("\\d+")) break block9;
                return "31";
            }
            int baseYearInt = Integer.parseInt(baseYear);
            yearInt = Integer.parseInt(year) + baseYearInt;
            String[] monthArr = months.split(",");
            monthInt = Arrays.asList(monthArr).indexOf(month) + 1;
            if (monthInt > 0 && monthInt <= 12) break block10;
            return "31";
        }
        try {
            YearMonth yearMonth = YearMonth.of(yearInt, monthInt);
            return String.valueOf(yearMonth.lengthOfMonth());
        }
        catch (NumberFormatException numberFormatException) {
            return "31";
        }
        catch (Exception exception) {
            return "31";
        }
    }

    public String getMaxDaysOfMonth_BCDHEX(String year, String month, String baseYear, String months) {
        String res = this.DECToBCD(this.getMaxDaysOfMonth_DEC(year, month, baseYear, months), "HEX");
        return res;
    }

    public String getDayOfWeek(String year, String month, String day, String baseYear, String months, String weeks) {
        int monthInt;
        String[] weekArr;
        block14: {
            block13: {
                block12: {
                    block11: {
                        if (months != null && !months.isEmpty() && months.split(",").length == 12) break block11;
                        return "";
                    }
                    if (weeks != null && !weeks.isEmpty() && weeks.split(",").length == 7) break block12;
                    return "";
                }
                if (year.contains("0x") || year.contains("0X")) {
                    year = this.BCDToDEC(year);
                }
                if (day.contains("0x") || day.contains("0X")) {
                    day = this.BCDToDEC(day);
                }
                if (baseYear.contains("0x") || baseYear.contains("0X")) {
                    baseYear = this.BCDToDEC(baseYear);
                }
                if (year.matches("\\d+") && day.matches("\\d+") && baseYear.matches("\\d+")) break block13;
                return "";
            }
            String[] monthArr = months.split(",");
            weekArr = weeks.split(",");
            monthInt = Arrays.asList(monthArr).indexOf(month) + 1;
            if (monthInt > 0 && monthInt <= 12) break block14;
            return "";
        }
        try {
            int baseYearInt = Integer.parseInt(baseYear);
            int yearInt = Integer.parseInt(year) + baseYearInt;
            int dayInt = Integer.parseInt(day);
            LocalDate date = LocalDate.of(yearInt, monthInt, dayInt);
            DayOfWeek dayOfWeek = date.getDayOfWeek();
            int weekIndex = dayOfWeek.getValue() - 1;
            String resultWeekStr = "";
            if (weekIndex >= 0 && weekIndex < weekArr.length) {
                resultWeekStr = weekArr[weekIndex];
            }
            return resultWeekStr;
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String BCDToDEC(String BCDStr) {
        int bcd;
        if (BCDStr == null || BCDStr.isEmpty()) {
            return "";
        }
        try {
            bcd = BCDStr.startsWith("0x") || BCDStr.startsWith("0X") ? Integer.parseInt(BCDStr.substring(2), 16) : Integer.parseInt(BCDStr);
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
        int dec = 0;
        int multiplier = 1;
        while (bcd > 0) {
            int digit = bcd & 0xF;
            if (digit > 9) {
                return "";
            }
            dec += digit * multiplier;
            multiplier *= 10;
            bcd >>= 4;
        }
        return String.valueOf(dec);
    }

    public String leftShift(String a, String b) {
        String result = "";
        try {
            Long aa = this.parseStringToInteger(a);
            Long bb = this.parseStringToInteger(b);
            long shifted = aa << (int)bb.longValue();
            result = "0x" + Long.toHexString(shifted).toUpperCase();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String rightShift(String a, String b) {
        String result = "";
        try {
            Long aa = this.parseStringToInteger(a);
            Long bb = this.parseStringToInteger(b);
            long shifted = aa >> (int)bb.longValue();
            result = "0x" + Long.toHexString(shifted).toUpperCase();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String GetBitMacrosByValue(String bitMacroList, String configValue, String relationStr) {
        String ret = "";
        if (relationStr.toUpperCase().equals("AND")) {
            relationStr = " & ";
        } else if (relationStr.toUpperCase().equals("OR")) {
            relationStr = " | ";
        }
        if (bitMacroList == null || bitMacroList.isEmpty() || configValue == null || configValue.isEmpty()) {
            return ret;
        }
        try {
            String[] macros = bitMacroList.split(",");
            Long value = this.parseStringToInteger(configValue);
            ArrayList<String> resultList = new ArrayList<String>();
            int i = 0;
            while (i < macros.length) {
                if ((value & (long)(1 << i)) != 0L) {
                    resultList.add(macros[i].trim());
                }
                ++i;
            }
            if (!resultList.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                int i2 = 0;
                while (i2 < resultList.size()) {
                    sb.append((String)resultList.get(i2));
                    if (i2 < resultList.size() - 1) {
                        sb.append(relationStr);
                    }
                    ++i2;
                }
                ret = sb.toString();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private float roundToThreeDecimals(float value) {
        return (float)Math.round(value * 1000.0f) / 1000.0f;
    }

    public String floatStr2Hex_1_2_8(String floatString) {
        String ret = "";
        if (floatString == null || floatString.isEmpty()) {
            return ret;
        }
        try {
            float number = Float.parseFloat(floatString);
            number = this.roundToThreeDecimals(number * 256.0f);
            int tmp = (int)(number < 0.0f ? number + 2048.0f : number);
            ret = String.format("0x%03X", tmp);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public String floatStr2Hex_1_8_0(String inputString) {
        String ret = "";
        if (inputString == null || inputString.isEmpty()) {
            return ret;
        }
        try {
            int number = Integer.parseInt(inputString);
            int signBit = number < 0 ? 1 : 0;
            int Val = Math.abs(number) & 0xFF;
            if (signBit == 1) {
                Val = ~Val + 1 & 0xFF;
            }
            int result = signBit << 8 | Val;
            ret = String.format("0x%03X", result);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }
}

