/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.conflict.tool;

import com.gigadevice.conflict.NewConflictCheck;
import com.gigadevice.conflict.baseinfo.ExpressionEvaluationInfo;
import com.gigadevice.conflict.baseinfo.ExtendFunctionNodeInfo;
import com.gigadevice.conflict.baseinfo.ExtendNodeListInfo;
import com.gigadevice.conflict.baseinfo.NewRelationGroup;
import com.gigadevice.conflict.baseinfo.ParamNodeInfo;
import com.gigadevice.conflict.tool.ExpressionWork;
import com.gigadevice.conflict.tool.ParamNodeWork;
import com.gigadevice.conflict.tool.ReflectionFunctionWork;
import java.util.List;

public class ExtendNodeWork {
    public static Object getExtendNodeResult(ExtendNodeListInfo extendNodeListInfo, String operType, String operName) {
        Object result = "";
        if (operType.equals("F")) {
            ExtendFunctionNodeInfo funcObj = extendNodeListInfo.getFunctionNode(operName);
            if (funcObj == null) {
                return result;
            }
            result = ReflectionFunctionWork.getFunctionResult(funcObj, extendNodeListInfo);
        } else if (operType.equals("E")) {
            ExpressionEvaluationInfo expressionEvaObj = extendNodeListInfo.getExpressionNode(operName);
            if (expressionEvaObj == null) {
                return result;
            }
            result = ExpressionWork.expressEvaluation(expressionEvaObj, extendNodeListInfo);
        } else if (operType.equals("SP")) {
            List<ParamNodeInfo> paramList = extendNodeListInfo.getSelectedParamNodeList(operName);
            if (paramList == null) {
                return result;
            }
            result = "%InvalidValue%";
            for (ParamNodeInfo paramObj : paramList) {
                NewRelationGroup NestConditionGroupObj = paramObj.getNestConditionGroupObj();
                if (!NewConflictCheck.PrivilegeCheck(NestConditionGroupObj)) continue;
                String Param = ParamNodeWork.GetParaValue(paramObj);
                if (Param.contains("@Ref_")) {
                    Object tmpResult = ExtendNodeWork.getRefExtendNodeResult(Param, extendNodeListInfo);
                    Param = tmpResult.toString();
                }
                result = Param;
                break;
            }
        }
        return result;
    }

    public static Object getRefExtendNodeResult(String refNodeName, ExtendNodeListInfo extendNodeListInfo) {
        Object result = "";
        if (refNodeName.contains("@Ref_")) {
            String[] strList = refNodeName.split("_");
            if (strList.length < 3) {
                return result;
            }
            String operType = strList[1];
            result = ExtendNodeWork.getExtendNodeResult(extendNodeListInfo, operType, refNodeName);
            return result;
        }
        return "";
    }
}

