/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.conflict;

import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.ConflictExecute;
import com.gigadevice.conflict.baseinfo.ConflictBitInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.util.ConflictUtil;
import com.gigadevice.conflict.xmlparse.ConflictXmlParse;
import com.gigadevice.conflict.xmlparse.NewConditionXmlParse;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.baseinfo.nvic.NVICParameterGroupNode;
import com.gigadevice.venustool.baseinfo.nvic.ParameterNode;
import com.gigadevice.venustool.controlconflict.NVICConfigConflict;
import com.gigadevice.venustool.periconfigbasestruct.GeneralPariParaNodeItemStruct;
import java.util.List;

public class NVICConflictExecute {
    public static void initNVICConflictXmlInfo() {
        if (!ConflictUtil.PeriConflictInfos.containsKey("NVIC")) {
            GlobalPathUtil.SysPeriXmlPaths sysPeriXmlPathsObj = GlobalPathUtil.getSysPeriXmlPaths();
            String NvicConflictXmlPath = sysPeriXmlPathsObj.NVICConflictXmlPath;
            ConflictXmlParse.groupName = "Group";
            NewConditionXmlParse.groupName = "Group";
            ConflictXmlParse.ParseConflictXml(NvicConflictXmlPath, "4");
            String addInfoXMLPath = NvicConflictXmlPath.replace(".xml", "AddInfo.xml");
            ConflictXmlParse.groupName = "AddGroup";
            NewConditionXmlParse.groupName = "AddGroup";
            ConflictXmlParse.ParseConflictXml(addInfoXMLPath, "4");
        }
    }

    public static void initNVICConflictByRank(String Type2) {
        if (!ConflictUtil.PeriConflictInfos.containsKey("NVIC")) {
            return;
        }
        ConflictCheck.checkControlVisble = false;
        List<String> ConflictGroupKeys = ConflictUtil.PeriConflictInfos.get("NVIC").getConflictGroupKeys();
        for (String key : ConflictGroupKeys) {
            ConflictGroupInfo conflictGroupObj;
            if (!ConflictUtil.ConflictGroupInfos.containsKey(key) || !(conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(key)).getControledControl().getRelateFrom().equals("4") || !conflictGroupObj.getNvicConflictType().equals(Type2)) continue;
            ConflictExecute.ExecuteSingleConflict(conflictGroupObj);
        }
        ConflictCheck.checkControlVisble = true;
    }

    public static void ConflictExecuteByNVIC(String periName, String groupName, String nodeName, String nodeValue) {
        ConflictUtil.conflictIsNVICSource = true;
        ConflictExecute.ExecuteConflictBySource("4", periName, groupName, nodeName, nodeValue);
        ConflictUtil.conflictIsNVICSource = false;
    }

    public static void NVICConflictExecuteByDMA() {
        String dmaConditionStr = "3##DMA";
        ConflictExecute.ExecuteConflictBySourceStr(dmaConditionStr);
    }

    public static void NVICConflictExecuteByMDMA() {
        String dmaConditionStr = "6##MDMA";
        ConflictExecute.ExecuteConflictBySourceStr(dmaConditionStr);
    }

    public static void NVICConflictExecuteByPin(String pinName) {
        String pinConditionStr = "5##PIN";
        ConflictExecute.ExecuteConflictBySourceStr(pinConditionStr);
    }

    public static void UpdateNVICState(String PeriName, String GroupName, String ControlName, String ItemName, String ControlType2, String Privilege, boolean type, boolean isApply) {
        ParameterNode controlObj;
        Object object;
        if (!ConflictUtil.ConflictBitInfos.containsKey(Privilege)) {
            return;
        }
        ConflictBitInfo conflictBitObj = ConflictUtil.ConflictBitInfos.get(Privilege);
        int bitNo = conflictBitObj.getBit();
        int value = conflictBitObj.getValue();
        if (!type) {
            value ^= 1;
        }
        if (Privilege.equals("UpdateValue") || Privilege.equals("SetDefaultValue")) {
            object = null;
            object = isApply ? NVICConfigConflict.getApplyConfigNode((String)PeriName, (String)GroupName, (String)ControlName, (String)"") : NVICConfigConflict.getConfigNode((String)PeriName, (String)GroupName, (String)ControlName, (String)"");
            if (object == null) {
                return;
            }
            if (ControlType2.equals("Control")) {
                controlObj = (ParameterNode)object;
                if (Privilege.equals("UpdateValue")) {
                    if (type && ConflictUtil.conflictIsSetValue) {
                        controlObj.setValue(ItemName);
                    }
                    return;
                }
                if (Privilege.equals("SetDefaultValue") && type) {
                    if (type) {
                        controlObj.setDefaultValue(ItemName);
                    }
                    return;
                }
            }
        }
        object = null;
        object = isApply ? NVICConfigConflict.getApplyConfigNode((String)PeriName, (String)GroupName, (String)ControlName, (String)ItemName) : NVICConfigConflict.getConfigNode((String)PeriName, (String)GroupName, (String)ControlName, (String)ItemName);
        if (object == null) {
            return;
        }
        if (ControlType2.equals("Group")) {
            NVICParameterGroupNode nodeObj = (NVICParameterGroupNode)object;
            int currentState = nodeObj.getState();
            int newState = ConflictUtil.getNodeState(bitNo, value, currentState);
            nodeObj.setState(newState);
        } else if (ControlType2.equals("Control")) {
            controlObj = (ParameterNode)object;
            int currentState = controlObj.getState();
            int newState = ConflictUtil.getNodeState(bitNo, value, currentState);
            controlObj.setState(newState);
        } else if (ControlType2.equals("Item")) {
            GeneralPariParaNodeItemStruct itemObj = (GeneralPariParaNodeItemStruct)object;
            int currentState = itemObj.getState();
            int newState = ConflictUtil.getNodeState(bitNo, value, currentState);
            itemObj.setState(newState);
        }
    }

    public static void UpdateStateInNVIC(String PeriName, String GroupName, String ControlName, String ItemName, String ControlType2, String Privilege, boolean type) {
        NVICConflictExecute.UpdateNVICState(PeriName, GroupName, ControlName, ItemName, ControlType2, Privilege, type, false);
    }

    public static void UpdateStateInNVICApply(String PeriName, String GroupName, String ControlName, String ItemName, String ControlType2, String Privilege, boolean type) {
        NVICConflictExecute.UpdateNVICState(PeriName, GroupName, ControlName, ItemName, ControlType2, Privilege, type, true);
    }
}

