/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.xmlparse;

import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.baseinfo.PerisRelateInfo;
import com.gigadevice.venustool.baseinfo.PinNamesStruct;
import com.gigadevice.venustool.baseinfo.PinStruct;
import com.gigadevice.venustool.baseinfo.RelateNodeStruct;
import com.gigadevice.venustool.baseinfo.SpecialPeri2FunctionStruct;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlParseUtil {
    private static String G_PerisName = "";
    private static String G_NodeName = "";

    public static String parsePackageTypeXML(String mcuPartNumber, String filePath) {
        String Type2 = "";
        try {
            File f = new File(filePath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            NodeList mcuPartList = doc.getElementsByTagName("mcuPart");
            if (mcuPartList == null) {
                return Type2;
            }
            int i = 0;
            while (i < mcuPartList.getLength()) {
                String mcuPart;
                Node mcuPartNode = mcuPartList.item(i);
                if (mcuPartNode != null && mcuPartNode.getNodeType() == 1 && (mcuPart = mcuPartNode.getAttributes().getNamedItem("Name").getNodeValue()).equals(mcuPartNumber)) {
                    Type2 = mcuPartNode.getAttributes().getNamedItem("Type").getNodeValue();
                    return Type2;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Type2;
    }

    public static String GetDatasheetPath(String mcuPartNumber, String filePath) {
        String tmp;
        String DatasheetPath = "";
        String mcuSeries = "";
        switch (tmp = mcuPartNumber.substring(0, 6)) {
            case "GD32E2": {
                if (mcuPartNumber.substring(0, 8).equals("GD32E230")) {
                    mcuSeries = "GD32E230";
                    break;
                }
                if (!mcuPartNumber.substring(0, 8).equals("GD32E231")) break;
                mcuSeries = "GD32E231";
                break;
            }
            case "GD32F3": {
                if (mcuPartNumber.substring(0, 7).equals("GD32F30")) {
                    mcuSeries = "GD32F30x";
                    break;
                }
                mcuSeries = "GD32F3x0";
                break;
            }
            case "GD32F4": {
                mcuSeries = "GD32F4xx";
                break;
            }
            case "GD32F1": {
                mcuSeries = "GD32F10x";
            }
        }
        String xmlName = "";
        switch (mcuSeries) {
            case "GD32E230": 
            case "GD32E231": {
                xmlName = String.valueOf(mcuPartNumber.substring(4, 11)) + "Datasheet.xml";
                break;
            }
            case "GD32F10x": 
            case "GD32F30x": 
            case "GD32F3x0": 
            case "GD32F4xx": {
                xmlName = String.valueOf(mcuPartNumber.substring(5, 8)) + "xxDatasheet.xml";
            }
        }
        DatasheetPath = String.valueOf(File.separator) + "DataSheet" + File.separator + mcuSeries + File.separator + xmlName;
        return DatasheetPath;
    }

    public static void parseDatasheetXML(String filePath, List<GD32PinPad> GD32PinPads, String PackageType) {
        File f = new File(filePath);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            Element root = doc.getDocumentElement();
            if (root == null) {
                return;
            }
            NodeList PinPadNodes = doc.getElementsByTagName("PinPad");
            if (PinPadNodes == null) {
                return;
            }
            int Index = 0;
            int i = 0;
            while (i < PinPadNodes.getLength()) {
                Node PinPadNode = PinPadNodes.item(i);
                if (PinPadNode != null && PinPadNode.getNodeType() == 1) {
                    String PinName = "";
                    String Type2 = "";
                    String I_O_Level = "";
                    String MainFunction = "";
                    String AlternateFunctions = "";
                    String AdditionalFunctions = "";
                    String Alternate1Functions = "";
                    String Alternate2Functions = "";
                    int Attributeslength = PinPadNode.getAttributes().getLength();
                    int j = 0;
                    while (j < Attributeslength) {
                        if (PinPadNode.getAttributes().item(j).getNodeName().equals("Name")) {
                            PinName = PinPadNode.getAttributes().getNamedItem("Name").getNodeValue();
                            if (PinName.equals("PI0")) {
                                PinName = "PI0";
                            }
                        } else if (PinPadNode.getAttributes().item(j).getNodeName().equals("Type")) {
                            Type2 = PinPadNode.getAttributes().getNamedItem("Type").getNodeValue();
                        } else if (PinPadNode.getAttributes().item(j).getNodeName().equals("I_O_Level")) {
                            I_O_Level = PinPadNode.getAttributes().getNamedItem("I_O_Level").getNodeValue();
                        } else if (PinPadNode.getAttributes().item(j).getNodeName().equals("MainFunction")) {
                            MainFunction = PinPadNode.getAttributes().getNamedItem("MainFunction").getNodeValue();
                        } else if (PinPadNode.getAttributes().item(j).getNodeName().equals("AlternateFunctions")) {
                            AlternateFunctions = PinPadNode.getAttributes().getNamedItem("AlternateFunctions").getNodeValue();
                        } else if (PinPadNode.getAttributes().item(j).getNodeName().equals("AdditionalFunctions")) {
                            AdditionalFunctions = PinPadNode.getAttributes().getNamedItem("AdditionalFunctions").getNodeValue();
                        } else if (PinPadNode.getAttributes().item(j).getNodeName().equals("Alternate1Functions")) {
                            Alternate1Functions = PinPadNode.getAttributes().getNamedItem("Alternate1Functions").getNodeValue();
                        } else if (PinPadNode.getAttributes().item(j).getNodeName().equals("Alternate2Functions")) {
                            Alternate2Functions = PinPadNode.getAttributes().getNamedItem("Alternate2Functions").getNodeValue();
                        }
                        ++j;
                    }
                    String xmlPackageType = "Package_" + PackageType;
                    NodeList PackageNodes = PinPadNode.getChildNodes();
                    if (PackageNodes != null) {
                        int k = 0;
                        while (k < PackageNodes.getLength()) {
                            String parsePackageType;
                            Node PackageNode = PackageNodes.item(k);
                            if (PackageNode != null && PackageNode.getNodeType() == 1 && (parsePackageType = PackageNode.getNodeName()).equals(xmlPackageType)) {
                                String parseNumer = PackageNode.getAttributes().getNamedItem("Number").getNodeValue();
                                if (parseNumer.equals("-")) break;
                                GD32PinPad gd32PinPad = new GD32PinPad();
                                if (PackageType.replaceAll("[^a-zA-Z]", "").equals("BGA")) {
                                    gd32PinPad.putPinIndex(Index);
                                } else {
                                    try {
                                        Index = Integer.parseInt(parseNumer) - 1;
                                        gd32PinPad.putPinIndex(Index + 1);
                                    }
                                    catch (NumberFormatException e) {
                                        e.printStackTrace();
                                    }
                                }
                                gd32PinPad.putPinName(PinName);
                                if (Type2.equals("I/O")) {
                                    gd32PinPad.putPinType(0);
                                } else {
                                    gd32PinPad.putPinType(1);
                                }
                                gd32PinPad.putPinIOLevel(I_O_Level);
                                gd32PinPad.putPinNumberStr(parseNumer);
                                gd32PinPad.putPinUsedFunctionStr("");
                                gd32PinPad.putPinUsedType(0);
                                gd32PinPad.putPinFunctionList(MainFunction, "MainFunction");
                                gd32PinPad.putPinFunctionList(AlternateFunctions, "AlternateFunctions");
                                gd32PinPad.putPinFunctionList(AdditionalFunctions, "AdditionalFunctions");
                                gd32PinPad.putPinFunctionList(Alternate1Functions, "Alternate1Functions");
                                gd32PinPad.putPinFunctionList(Alternate2Functions, "Alternate2Functions");
                                GD32PinPads.add(gd32PinPad);
                                if (++Index == 108) {
                                    Index = 108;
                                }
                            }
                            ++k;
                        }
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, List<PerisRelateInfo>> parsePerisRelateXML(String filePath) {
        HashMap<String, List<PerisRelateInfo>> map = new HashMap<String, List<PerisRelateInfo>>();
        try {
            File f = new File(filePath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            Element root = doc.getDocumentElement();
            NodeList PeripheralList = root.getElementsByTagName("Peri");
            if (PeripheralList == null) {
                return map;
            }
            int PeripheralNum = PeripheralList.getLength();
            int i = 0;
            while (i < PeripheralNum) {
                Node Peri = PeripheralList.item(i);
                if (Peri != null) {
                    XmlParseUtil.removeTextNode(Peri);
                    if (Peri != null && Peri.getNodeType() == 1) {
                        String strPeriNodeName = Peri.getAttributes().getNamedItem("PeriNodeName").getNodeValue();
                        ArrayList<PerisRelateInfo> lstPerisRelateInfo = new ArrayList<PerisRelateInfo>();
                        NodeList lstChildNode = Peri.getChildNodes();
                        int ChildNodesNum = lstChildNode.getLength();
                        int j = 0;
                        while (j < ChildNodesNum) {
                            Node ChildNode = lstChildNode.item(j);
                            if (ChildNode != null) {
                                XmlParseUtil.removeTextNode(ChildNode);
                                if (ChildNode != null && ChildNode.getNodeType() == 1) {
                                    PerisRelateInfo tempPerisRelateInfo = new PerisRelateInfo();
                                    int AttributesNum = ChildNode.getAttributes().getLength();
                                    int n = 0;
                                    while (n < AttributesNum) {
                                        if (ChildNode.getAttributes().item(n).getNodeName().equals("Name")) {
                                            String strName = ChildNode.getAttributes().getNamedItem("Name").getNodeValue();
                                            tempPerisRelateInfo.setNodeName(strName);
                                        } else if (ChildNode.getAttributes().item(n).getNodeName().equals("Type")) {
                                            String strType = ChildNode.getAttributes().getNamedItem("Type").getNodeValue();
                                            tempPerisRelateInfo.setType(strType);
                                        } else if (ChildNode.getAttributes().item(n).getNodeName().equals("Item")) {
                                            String strItem = ChildNode.getAttributes().getNamedItem("Item").getNodeValue();
                                            tempPerisRelateInfo.setItem(strItem);
                                        }
                                        ++n;
                                    }
                                    NodeList lstRelateNodes = ChildNode.getChildNodes();
                                    int RelateNodesNum = lstRelateNodes.getLength();
                                    int k = 0;
                                    while (k < RelateNodesNum) {
                                        Node RelateNodes = lstRelateNodes.item(k);
                                        if (RelateNodes != null) {
                                            XmlParseUtil.removeTextNode(RelateNodes);
                                            if (RelateNodes != null && RelateNodes.getNodeType() == 1) {
                                                int l;
                                                String strRelate = RelateNodes.getAttributes().getNamedItem("Relate").getNodeValue();
                                                String strEnable = RelateNodes.getAttributes().getNamedItem("Enable").getNodeValue();
                                                tempPerisRelateInfo.setRelate(strRelate);
                                                tempPerisRelateInfo.setEnable(strEnable);
                                                tempPerisRelateInfo.setChange(strEnable);
                                                NodeList lstRelateNode = RelateNodes.getChildNodes();
                                                int RelateNodeNum = lstRelateNode.getLength();
                                                if (strRelate.length() > 3) {
                                                    l = 0;
                                                    while (l < RelateNodeNum) {
                                                        Node Condition = lstRelateNode.item(l);
                                                        if (Condition != null) {
                                                            XmlParseUtil.removeTextNode(Condition);
                                                            if (Condition != null && Condition.getNodeType() == 1) {
                                                                NodeList lstCondition = Condition.getChildNodes();
                                                                int ConditionNum = lstCondition.getLength();
                                                                ArrayList<RelateNodeStruct> templstRelateNodeInfo = new ArrayList<RelateNodeStruct>();
                                                                int m = 0;
                                                                while (m < ConditionNum) {
                                                                    Node RelateNode = lstCondition.item(m);
                                                                    if (RelateNode != null && RelateNode.getNodeType() == 1) {
                                                                        String strPeriName = RelateNode.getAttributes().getNamedItem("PeriName").getNodeValue();
                                                                        String strNode = RelateNode.getAttributes().getNamedItem("Node").getNodeValue();
                                                                        String strValue = RelateNode.getTextContent();
                                                                        RelateNodeStruct tempRelateNodeStruct = new RelateNodeStruct();
                                                                        tempRelateNodeStruct.setPeris(strPeriName);
                                                                        tempRelateNodeStruct.setNode(strNode);
                                                                        tempRelateNodeStruct.setValue(strValue);
                                                                        templstRelateNodeInfo.add(tempRelateNodeStruct);
                                                                    }
                                                                    ++m;
                                                                }
                                                                tempPerisRelateInfo.addlstRelateInfos(templstRelateNodeInfo);
                                                            }
                                                        }
                                                        ++l;
                                                    }
                                                } else {
                                                    l = 0;
                                                    while (l < RelateNodeNum) {
                                                        Node RelateNode = lstRelateNode.item(l);
                                                        if (RelateNode != null && RelateNode.getNodeType() == 1) {
                                                            String strPeriName = RelateNode.getAttributes().getNamedItem("PeriName").getNodeValue();
                                                            String strNode = RelateNode.getAttributes().getNamedItem("Node").getNodeValue();
                                                            String strValue = RelateNode.getTextContent();
                                                            RelateNodeStruct tempRelateNodeStruct = new RelateNodeStruct();
                                                            tempRelateNodeStruct.setPeris(strPeriName);
                                                            tempRelateNodeStruct.setNode(strNode);
                                                            tempRelateNodeStruct.setValue(strValue);
                                                            tempPerisRelateInfo.addRelateNode(tempRelateNodeStruct);
                                                        }
                                                        ++l;
                                                    }
                                                }
                                            }
                                        }
                                        ++k;
                                    }
                                    lstPerisRelateInfo.add(tempPerisRelateInfo);
                                }
                            }
                            ++j;
                        }
                        map.put(strPeriNodeName, lstPerisRelateInfo);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void removeTextNode(Node root) {
        if (root.hasChildNodes()) {
            NodeList children = root.getChildNodes();
            int count = children.getLength();
            int i = count - 1;
            while (i >= 0) {
                Node child = children.item(i);
                if (child.getNodeType() == 3) {
                    child.getParentNode().removeChild(child);
                }
                --i;
            }
        }
    }

    public static boolean parseAFIOXML(String filePath, Map<String, Map<String, List<PinNamesStruct>>> AFIORemapMap) {
        Node NodeAFIOPin;
        Document doc;
        boolean isRemap;
        block26: {
            isRemap = false;
            File f = new File(filePath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(f);
            NodeList AFIOPinsList = doc.getElementsByTagName("AFIOPins");
            NodeAFIOPin = AFIOPinsList.item(0);
            if (NodeAFIOPin != null) break block26;
            return false;
        }
        try {
            NodeList AFIOPinItemList;
            String RemapStr;
            XmlParseUtil.removeTextNode(NodeAFIOPin);
            if (NodeAFIOPin != null && NodeAFIOPin.getNodeType() == 1 && (RemapStr = NodeAFIOPin.getAttributes().getNamedItem("Remap").getNodeValue()).equals("true")) {
                isRemap = true;
            }
            if ((AFIOPinItemList = doc.getElementsByTagName("AFIOPinItem")) == null) {
                return isRemap;
            }
            int AFIOPinNum = AFIOPinItemList.getLength();
            int i = 0;
            while (i < AFIOPinNum) {
                Node NodeAFIOPinItem = AFIOPinItemList.item(i);
                if (NodeAFIOPinItem != null && NodeAFIOPinItem.getNodeType() == 1) {
                    String PeriNameStr = NodeAFIOPinItem.getAttributes().getNamedItem("name").getNodeValue();
                    HashMap<String, List> mapPinNames = new HashMap<String, List>();
                    NodeList PinNamesList = NodeAFIOPinItem.getChildNodes();
                    if (PinNamesList == null) {
                        return isRemap;
                    }
                    int PinNamesListNum = PinNamesList.getLength();
                    int k = 0;
                    while (k < PinNamesListNum) {
                        Node PinNamesItem = PinNamesList.item(k);
                        if (PinNamesItem != null && PinNamesItem.getNodeType() == 1) {
                            ArrayList<PinNamesStruct> PinNamesStructList = new ArrayList<PinNamesStruct>();
                            PinNamesStruct pinNames = new PinNamesStruct();
                            String FunctionGroupName = PinNamesItem.getAttributes().getNamedItem("FunctionGroupName").getNodeValue();
                            pinNames.setFunctionGroupName(FunctionGroupName);
                            pinNames.setRemapAFValue(PinNamesItem.getAttributes().getNamedItem("RemapAFValue").getNodeValue());
                            NodeList PinList = PinNamesItem.getChildNodes();
                            if (PinList != null) {
                                int PinNum = PinList.getLength();
                                int n = 0;
                                while (n < PinNum) {
                                    PinStruct pinStruct = new PinStruct();
                                    Node PinItem = PinList.item(n);
                                    if (PinItem != null) {
                                        XmlParseUtil.removeTextNode(PinItem);
                                        if (PinItem != null && PinItem.getNodeType() == 1) {
                                            Node PinChildrenNode = PinItem.getFirstChild();
                                            while (PinChildrenNode != null) {
                                                if (PinChildrenNode.getNodeName().equals("PinUsedFunction")) {
                                                    String PinUsedFunction = PinChildrenNode.getTextContent();
                                                    pinStruct.setPinUsedFunction(PinUsedFunction);
                                                } else if (PinChildrenNode.getNodeName().equals("PinName")) {
                                                    String PinName = PinChildrenNode.getTextContent();
                                                    pinStruct.setPinName(PinName);
                                                    int AttributesNum = PinChildrenNode.getAttributes().getLength();
                                                    if (AttributesNum != 0) {
                                                        String FlashSizeType = "";
                                                        if (PinChildrenNode.getAttributes().item(AttributesNum - 1).getNodeName().equals("FlashSize")) {
                                                            FlashSizeType = "FlashSize";
                                                        } else if (PinChildrenNode.getAttributes().item(AttributesNum - 1).getNodeName().equals("FlashSizeMin")) {
                                                            FlashSizeType = "FlashSizeMin";
                                                        } else if (PinChildrenNode.getAttributes().item(AttributesNum - 1).getNodeName().equals("FlashSizeMax")) {
                                                            FlashSizeType = "FlashSizeMax";
                                                        }
                                                        pinStruct.setFlashSizeType(FlashSizeType);
                                                        pinStruct.setFlashSize(PinChildrenNode.getAttributes().getNamedItem(FlashSizeType).getNodeValue());
                                                    }
                                                }
                                                PinChildrenNode = PinChildrenNode.getNextSibling();
                                            }
                                            pinNames.putPinStructList(pinStruct);
                                        }
                                    }
                                    ++n;
                                }
                                PinNamesStructList.add(pinNames);
                                if (!mapPinNames.containsKey(FunctionGroupName)) {
                                    mapPinNames.put(FunctionGroupName, PinNamesStructList);
                                } else {
                                    List tmp = (List)mapPinNames.get(FunctionGroupName);
                                    mapPinNames.remove(FunctionGroupName);
                                    tmp.add(pinNames);
                                    mapPinNames.put(FunctionGroupName, tmp);
                                }
                            }
                        }
                        ++k;
                    }
                    AFIORemapMap.put(PeriNameStr, mapPinNames);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isRemap;
    }

    public static boolean parseSpecialPeri2FunctionXML(String filePath) {
        NodeList PerisList;
        block17: {
            File f;
            block16: {
                ConstantsUtil.SpecialPeri2FunctionMap = new HashMap<String, Set<SpecialPeri2FunctionStruct>>();
                f = new File(filePath);
                if (f.exists()) break block16;
                return false;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            PerisList = doc.getElementsByTagName("Peri");
            if (PerisList != null) break block17;
            return false;
        }
        try {
            int Peri2FunctionsNum = PerisList.getLength();
            int i = 0;
            while (i < Peri2FunctionsNum) {
                block18: {
                    SpecialPeri2FunctionStruct tempObj;
                    block19: {
                        NodeList ItemsList;
                        tempObj = new SpecialPeri2FunctionStruct();
                        Node PeriNode = PerisList.item(i);
                        if (PeriNode == null) break block18;
                        XmlParseUtil.removeTextNode(PeriNode);
                        if (PeriNode == null || PeriNode.getNodeType() != 1) break block18;
                        String PeriName = PeriNode.getAttributes().getNamedItem("Name").getNodeValue();
                        tempObj.setPeriName(PeriName);
                        String RelatePeri = PeriNode.getFirstChild().getTextContent();
                        ArrayList<String> list = new ArrayList<String>(Arrays.asList(RelatePeri.split(",")));
                        tempObj.setRelatedPeriList(list);
                        String RelateFuncsUse = PeriNode.getAttributes().getNamedItem("Use").getNodeValue();
                        tempObj.setUseName(RelateFuncsUse);
                        String RelateFuncsNodeName = PeriNode.getFirstChild().getNextSibling().getNodeName();
                        if (RelateFuncsNodeName != "RelateFuncs") break block19;
                        Node RelateFuncNode = PeriNode.getFirstChild().getNextSibling();
                        XmlParseUtil.removeTextNode(RelateFuncNode);
                        String NodeType2 = RelateFuncNode.getAttributes().getNamedItem("NodeType").getNodeValue();
                        tempObj.setRelateFunc_NodeType(NodeType2);
                        if (RelateFuncNode.getAttributes().getNamedItem("ControlType") != null) {
                            String ControlType2 = RelateFuncNode.getAttributes().getNamedItem("ControlType").getNodeValue();
                            tempObj.setControlType(ControlType2);
                        }
                        if (RelateFuncNode.getAttributes().getNamedItem("NodeName") != null) {
                            String NodeName = RelateFuncNode.getAttributes().getNamedItem("NodeName").getNodeValue();
                            tempObj.setNodeName(NodeName);
                        }
                        if (RelateFuncNode.getAttributes().getNamedItem("PinUsedType") != null) {
                            String PinUsedType = RelateFuncNode.getAttributes().getNamedItem("PinUsedType").getNodeValue();
                            tempObj.setPinUsedType(PinUsedType);
                        }
                        if ((ItemsList = RelateFuncNode.getChildNodes()) == null) break block18;
                        int ItemsNum = ItemsList.getLength();
                        ArrayList<String> TempList = new ArrayList<String>();
                        int k = 0;
                        while (k < ItemsNum) {
                            Node Item = ItemsList.item(k);
                            if (Item != null && Item.getNodeType() == 1) {
                                String RelateFuncName = Item.getFirstChild().getTextContent();
                                TempList.add(RelateFuncName);
                            }
                            ++k;
                        }
                        if (TempList.size() > 0) {
                            tempObj.setRelatedFuncList(TempList);
                        }
                    }
                    Set<Object> set = new HashSet<SpecialPeri2FunctionStruct>();
                    if (ConstantsUtil.SpecialPeri2FunctionMap.containsKey(tempObj.getPeriName())) {
                        set = ConstantsUtil.SpecialPeri2FunctionMap.get(tempObj.getPeriName());
                        set.add(tempObj);
                    } else {
                        set.add(tempObj);
                        ConstantsUtil.SpecialPeri2FunctionMap.put(tempObj.getPeriName(), set);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

