/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.xmlparse;

import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.mcubasestruct.ControlStruct;
import com.gigadevice.venustool.mcubasestruct.ItemStruct;
import com.gigadevice.venustool.mcubasestruct.MCUStruct;
import com.gigadevice.venustool.mcubasestruct.ModuleStruct;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import com.gigadevice.venustool.mcubasestruct.WidgetNodeStruct;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MCUXMLParse {
    public static final String PERIPHERAL = "Peripheral";
    public static final String MIDDLEWARE = "MiddleWare";
    private static final String XML_MODULENODE = "Module";
    private static final String XML_ITEMNODE = "Item";
    private static final String XML_NODE = "Node";
    private static final String ATTRIBUTES_NODENAME = "NodeName";
    private static final String ATTRIBUTES_MODULETYPE = "ModuleType";
    private static final String ATTRIBUTES_TYPE = "Type";
    private static final String ATTRIBUTES_FUNC = "Function";
    private static final String ATTRIBUTES_GROUP = "Group";
    private static final String ATTRIBUTES_GROUPType = "GroupType";
    private static final String ATTRIBUTES_DEFAULTVAL = "DefaultValue";
    private static final String ATTRIBUTES_PARENT = "Parent";
    private static final String ATTRIBUTES_ACTION = "Action";
    private static final String ATTRIBUTES_STATE = "State";

    public static MCUStruct parseMCUXML(String filePath) {
        MCUStruct mcuObj = new MCUStruct();
        if (filePath.isEmpty()) {
            return mcuObj;
        }
        SAXReader saxReader = new SAXReader();
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                return mcuObj;
            }
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            String strAttribute = rootElm.attributeValue(ATTRIBUTES_GROUP);
            if (strAttribute != null) {
                mcuObj.setGroup(strAttribute);
            }
            if ((strAttribute = rootElm.attributeValue(ATTRIBUTES_GROUPType)) != null) {
                mcuObj.setGroupType(strAttribute);
            }
            List ModuleNodeList = rootElm.elements(XML_MODULENODE);
            MCUXMLParse.PraseModule(mcuObj, ModuleNodeList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mcuObj;
    }

    private static void PraseModule(MCUStruct mcuObj, List<Element> lstNode) {
        Iterator<Element> it = lstNode.iterator();
        while (it.hasNext()) {
            String ModuleType;
            Element elm;
            ModuleStruct moduleObj;
            block14: {
                String moduleType;
                block13: {
                    moduleObj = new ModuleStruct();
                    elm = it.next();
                    moduleType = elm.attributeValue(ATTRIBUTES_MODULETYPE);
                    if (moduleType != null) break block13;
                    ModuleType = PERIPHERAL;
                    break block14;
                }
                switch (moduleType) {
                    case "1": {
                        ModuleType = PERIPHERAL;
                        break;
                    }
                    case "2": {
                        ModuleType = MIDDLEWARE;
                        break;
                    }
                    default: {
                        ModuleType = PERIPHERAL;
                    }
                }
            }
            String NodeName = elm.attributeValue(ATTRIBUTES_NODENAME);
            boolean Parent = MCUXMLParse.GetExpandEnable(elm);
            String strState = elm.attributeValue(ATTRIBUTES_STATE);
            if (strState != null) {
                moduleObj.setState(Integer.parseInt(strState));
            }
            moduleObj.setNodeName(NodeName);
            moduleObj.setParent(Parent);
            moduleObj.setModuleType(ModuleType);
            if (Parent) {
                List WidgetNodeList = elm.elements();
                MCUXMLParse.PraseWidget(moduleObj, WidgetNodeList);
            }
            mcuObj.putModules(moduleObj);
        }
    }

    private static void PraseWidget(ModuleStruct moduleObj, List<Element> lstNode) {
        for (Element elm : lstNode) {
            List ItemNodeList;
            WidgetNodeStruct widgetNodeObj;
            String peri;
            String nodeType = elm.getName();
            String nodeName = elm.attributeValue(ATTRIBUTES_NODENAME);
            String strType = elm.attributeValue(ATTRIBUTES_TYPE);
            int type = 0;
            if (strType != null) {
                type = Integer.parseInt(strType);
            }
            String function = elm.attributeValue(ATTRIBUTES_FUNC);
            if (moduleObj != null && (peri = moduleObj.getNodeName()) != null && peri.contains("ADC") && function != null && !function.equals("")) {
                String[] functionArry = function.split(",");
                int i = 0;
                while (i < functionArry.length) {
                    if (!functionArry[i].equals("")) {
                        String newPinFunction = GlobalVariables.getModifiedPinFunction(functionArry[i], peri);
                        function = function.replace(functionArry[i], newPinFunction);
                    }
                    ++i;
                }
            }
            if (nodeType.equals("Control")) {
                widgetNodeObj = new ControlStruct();
                widgetNodeObj.setNodeName(nodeName);
                widgetNodeObj.setType(type);
                widgetNodeObj.setFunction(function);
                widgetNodeObj.setNodeType(nodeType);
                widgetNodeObj.setModule(moduleObj);
                String defaultVal = elm.attributeValue(ATTRIBUTES_DEFAULTVAL);
                ((ControlStruct)widgetNodeObj).setDefaultValue(defaultVal);
                String strState = elm.attributeValue(ATTRIBUTES_STATE);
                if (strState != null) {
                    widgetNodeObj.setState(Integer.parseInt(strState));
                }
                if (!MCUXMLParse.PraseItem(widgetNodeObj, ItemNodeList = elm.elements(XML_ITEMNODE))) {
                    widgetNodeObj.setValue("false");
                }
                moduleObj.putWidgetNodes(widgetNodeObj);
                continue;
            }
            if (!nodeType.equals(XML_NODE)) continue;
            widgetNodeObj = new NodeStruct();
            String strState = elm.attributeValue(ATTRIBUTES_STATE);
            if (strState != null) {
                widgetNodeObj.setState(Integer.parseInt(strState));
            }
            widgetNodeObj.setNodeName(nodeName);
            widgetNodeObj.setType(type);
            widgetNodeObj.setFunction(function);
            widgetNodeObj.setNodeType(nodeType);
            widgetNodeObj.setModule(moduleObj);
            boolean Parent = MCUXMLParse.GetExpandEnable(elm);
            ((NodeStruct)widgetNodeObj).setParent(Parent);
            if (Parent) {
                MCUXMLParse.PraseNode((NodeStruct)widgetNodeObj, elm);
                moduleObj.setMultiNodeFlag(true);
            } else {
                ItemNodeList = elm.elements(XML_ITEMNODE);
                if (type == 0) {
                    widgetNodeObj.setValue("");
                } else if (!MCUXMLParse.PraseItem(widgetNodeObj, ItemNodeList)) {
                    widgetNodeObj.setValue("false");
                }
            }
            moduleObj.putWidgetNodes(widgetNodeObj);
        }
    }

    private static void PraseNode(NodeStruct parentWidgetNodeObj, Element elm) {
        List nodeList = elm.elements(XML_NODE);
        for (Element elmNode : nodeList) {
            String strState;
            NodeStruct childWidgetNodeObj = new NodeStruct();
            String nodeType = elmNode.getName();
            String nodeName = elmNode.attributeValue(ATTRIBUTES_NODENAME);
            int type = 0;
            if (elmNode.attributeValue(ATTRIBUTES_TYPE) != null && !elmNode.attributeValue(ATTRIBUTES_TYPE).equals("")) {
                type = Integer.parseInt(elmNode.attributeValue(ATTRIBUTES_TYPE));
            }
            if ((strState = elmNode.attributeValue(ATTRIBUTES_STATE)) != null) {
                childWidgetNodeObj.setState(Integer.parseInt(strState));
            }
            String function = elmNode.attributeValue(ATTRIBUTES_FUNC);
            boolean Parent = MCUXMLParse.GetExpandEnable(elmNode);
            childWidgetNodeObj.setNodeType(nodeType);
            childWidgetNodeObj.setNodeName(nodeName);
            childWidgetNodeObj.setType(type);
            childWidgetNodeObj.setFunction(function);
            childWidgetNodeObj.setParent(Parent);
            if (Parent) {
                MCUXMLParse.PraseNode(childWidgetNodeObj, elmNode);
            } else {
                List ItemNodeList = elmNode.elements(XML_ITEMNODE);
                if (!MCUXMLParse.PraseItem(childWidgetNodeObj, ItemNodeList)) {
                    childWidgetNodeObj.setValue("false");
                }
            }
            childWidgetNodeObj.setParentNode(parentWidgetNodeObj);
            parentWidgetNodeObj.putChildNodes(childWidgetNodeObj);
        }
    }

    private static boolean PraseItem(WidgetNodeStruct widgetNodeObj, List<Element> lstNode) {
        LinkedHashMap<String, ItemStruct> mapItems;
        Iterator<String> iterator;
        boolean isItemFlag = false;
        Iterator<Element> it = lstNode.iterator();
        while (it.hasNext()) {
            ItemStruct itemObj = new ItemStruct();
            Element elm = it.next();
            String function = elm.attributeValue(ATTRIBUTES_FUNC);
            String action = elm.attributeValue(ATTRIBUTES_ACTION);
            String strState = elm.attributeValue(ATTRIBUTES_STATE);
            if (strState != null) {
                itemObj.setState(Integer.parseInt(strState));
            }
            itemObj.setFunction(function);
            itemObj.setAction(action);
            itemObj.setParentNode(widgetNodeObj);
            String itemText = elm.getText();
            if (itemText != null) {
                itemObj.setValue(itemText);
                itemObj.setNodeName(itemText);
            }
            widgetNodeObj.putItems(itemObj);
            isItemFlag = true;
        }
        if (isItemFlag && widgetNodeObj.getItems().size() > 0 && (iterator = (mapItems = widgetNodeObj.getItems()).keySet().iterator()).hasNext()) {
            String itemName = iterator.next();
            widgetNodeObj.setValue(mapItems.get(itemName).getValue());
        }
        return isItemFlag;
    }

    private static boolean GetExpandEnable(Element elm) {
        boolean bl = false;
        String strAttributes = elm.attributeValue(ATTRIBUTES_PARENT);
        if (strAttributes != null && strAttributes.equals("Y")) {
            bl = true;
        }
        return bl;
    }
}

