/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class FolderProcess {
    public List<String> allFiles = new ArrayList<String>();
    public List<String> foldersWithHFiles = new ArrayList<String>();

    public void createFolder(String folderPath) {
        File folder = new File(folderPath);
        if (folder.exists()) {
            Path path = Paths.get(folderPath, new String[0]);
            try {
                this.DeleteDir(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            folder.mkdirs();
        }
    }

    private void DeleteDir(Path path) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).forEach(FolderProcess::deleteDirectoyStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void deleteDirectoyStream(Path path) {
        try {
            Files.delete(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyFolderAndFiles(String srcPath, String desPath) {
        Path src = Paths.get(srcPath, new String[0]);
        Path des = Paths.get(desPath, new String[0]);
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(sourceFile -> {
                try {
                    Path desFile = des.resolve(src.relativize((Path)sourceFile));
                    if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                        Files.createDirectories(desFile, new FileAttribute[0]);
                    } else {
                        Files.copy(sourceFile, desFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyFolderAndFiles(String srcPath, String desPath, List<String> lstFiles) {
        Path src = Paths.get(srcPath, new String[0]);
        Path des = Paths.get(desPath, new String[0]);
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(sourceFile -> {
                try {
                    Path desFile = des.resolve(src.relativize((Path)sourceFile));
                    if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                        Files.createDirectories(desFile, new FileAttribute[0]);
                    } else if (!lstFiles.contains(sourceFile.getFileName().toString())) {
                        Files.copy(sourceFile, desFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> copyTargetFile(String srcPath, String desPath, String fileExtension) throws IOException {
        File[] filesToCopy;
        ArrayList<String> filePathList = new ArrayList<String>();
        File src = new File(srcPath);
        File des = new File(desPath);
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("Source path is not a folder:" + src);
        }
        if (!des.exists()) {
            des.mkdirs();
        }
        if ((filesToCopy = src.listFiles((dir, name) -> name.endsWith(fileExtension))) == null) {
            throw new IOException("Failed to read source folder: " + src);
        }
        File[] fileArray = filesToCopy;
        int n = filesToCopy.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Path sourcePath = file.toPath();
            Path targetPath = Paths.get(desPath, file.getName());
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            filePathList.add(file.getName());
            filePathList.add(sourcePath.toString());
            ++n2;
        }
        return filePathList;
    }

    public void scanFolder(File folder) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            boolean hasHFile = false;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    this.allFiles.add(file.getAbsolutePath());
                    if (file.getName().endsWith(".h")) {
                        hasHFile = true;
                    }
                } else if (file.isDirectory()) {
                    this.scanFolder(file);
                }
                ++n2;
            }
            if (hasHFile) {
                this.foldersWithHFiles.add(folder.getAbsolutePath());
            }
        }
    }

    public boolean containsFilename(List<String> lstFiles, String filename) {
        for (String filePath : lstFiles) {
            if (!filePath.endsWith(String.valueOf(File.separator) + filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean copyFile(String sourcePath, String destinationPath) {
        Path destination;
        Path source;
        block6: {
            block5: {
                try {
                    source = Paths.get(sourcePath, new String[0]);
                    destination = Paths.get(destinationPath, new String[0]);
                    if (Files.exists(source, new LinkOption[0])) break block5;
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (Files.isRegularFile(source, new LinkOption[0])) break block6;
            return false;
        }
        Path parent = destination.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    public static boolean copyFileOrDirectory(String sourcePath, String destinationPath) {
        block11: {
            Path destination;
            Path source;
            block13: {
                block12: {
                    block10: {
                        Path parent;
                        block9: {
                            try {
                                source = Paths.get(sourcePath, new String[0]);
                                destination = Paths.get(destinationPath, new String[0]);
                                if (Files.exists(source, new LinkOption[0])) break block9;
                                System.err.println("Error: Source path does not exist: " + sourcePath);
                                return false;
                            }
                            catch (IOException e) {
                                System.err.println("Copy operation failed: " + e.getMessage());
                                e.printStackTrace();
                                return false;
                            }
                        }
                        if (!Files.isRegularFile(source, new LinkOption[0])) break block10;
                        Path targetFile = destination;
                        if (Files.exists(destination, new LinkOption[0]) && Files.isDirectory(destination, new LinkOption[0])) {
                            targetFile = destination.resolve(source.getFileName());
                        }
                        if ((parent = targetFile.getParent()) != null) {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        Files.copy(source, targetFile, StandardCopyOption.REPLACE_EXISTING);
                        return true;
                    }
                    if (!Files.isDirectory(source, new LinkOption[0])) break block11;
                    if (!destination.toAbsolutePath().startsWith(source.toAbsolutePath())) break block12;
                    System.err.println("Error: Cannot copy a directory into itself");
                    return false;
                }
                if (!Files.exists(destination, new LinkOption[0]) || Files.isDirectory(destination, new LinkOption[0])) break block13;
                System.err.println("Error: Destination exists but is not a directory: " + destinationPath);
                return false;
            }
            Files.createDirectories(destination, new FileAttribute[0]);
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path targetDir = destination.resolve(source.relativize(dir));
                    Files.createDirectories(targetDir, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path targetFile = destination.resolve(source.relativize(file));
                    Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    System.err.println("Unable to access file: " + file + " - " + exc.getMessage());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        System.err.println("Error processing directory: " + dir + " - " + exc.getMessage());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return true;
        }
        System.err.println("Error: Source is neither a file nor a directory: " + sourcePath);
        return false;
    }

    public static boolean deleteFolder(Path folderPath) {
        block3: {
            try {
                if (Files.exists(folderPath, new LinkOption[0])) break block3;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        Files.walkFileTree(folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return true;
    }
}

