/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool;

import java.util.regex.Matcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class TargetOSInfo {
    private static String TargetOSName;
    private static OSFamilyType TargetOSFamily;
    private static Boolean isdirty;

    static {
        isdirty = true;
    }

    private static void UpdateTargetOSInfo() {
        if (isdirty.booleanValue()) {
            TargetOSName = System.getProperty("os.name");
            TargetOSFamily = TargetOSInfo.getOSFamily(TargetOSName);
            isdirty = false;
        }
    }

    private static OSFamilyType getOSFamily(String OSName) {
        if ((OSName = OSName.toLowerCase()).startsWith("win")) {
            return OSFamilyType.WINDOWS;
        }
        if (OSName.startsWith("linux")) {
            return OSFamilyType.LINUX;
        }
        if (OSName.startsWith("mac")) {
            return OSFamilyType.MACOSX;
        }
        return OSFamilyType.UNKNOWN;
    }

    private static String getTargetOSName() {
        return TargetOSName;
    }

    private static OSFamilyType getTargetOSFamily() {
        return TargetOSFamily;
    }

    public static String getTargetOSFamilyName() {
        TargetOSInfo.UpdateTargetOSInfo();
        return TargetOSFamily.toString();
    }

    public static String getSystemPathSeparator() {
        TargetOSInfo.UpdateTargetOSInfo();
        if (TargetOSInfo.isWindows()) {
            return ";";
        }
        return ":";
    }

    public static boolean isWindows() {
        TargetOSInfo.UpdateTargetOSInfo();
        return TargetOSFamily.equals((Object)OSFamilyType.WINDOWS);
    }

    public static boolean isLinux() {
        TargetOSInfo.UpdateTargetOSInfo();
        return TargetOSFamily.equals((Object)OSFamilyType.LINUX);
    }

    public static boolean isMacOSX() {
        TargetOSInfo.UpdateTargetOSInfo();
        return TargetOSFamily.equals((Object)OSFamilyType.MACOSX);
    }

    public static String performStringSubstitution(String expression) {
        if (expression == null || expression.isEmpty()) {
            return null;
        }
        String result = expression;
        if (result.indexOf("${user.home}") >= 0) {
            String userHome = new Path(System.getProperty("user.home")).toString();
            userHome = Matcher.quoteReplacement(userHome);
            result = result.replaceAll("\\$\\{user.home\\}", userHome);
        }
        if (result.indexOf("${") >= 0) {
            IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                result = variableManager.performStringSubstitution(result, false);
            }
            catch (CoreException coreException) {
                result = null;
            }
        }
        return result;
    }

    public static enum OSFamilyType {
        WINDOWS,
        LINUX,
        MACOSX,
        UNKNOWN;

    }
}

