/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.venustool;

import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.venustool.ClangUtil;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.baseinfo.PeriTreeColumnInfoStruct;
import com.gigadevice.venustool.baseinfo.PerisItemsStruct;
import com.gigadevice.venustool.baseinfo.PerisRelateInfo;
import com.gigadevice.venustool.baseinfo.PerisTreeStruct;
import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.baseinfo.nvic.NVICConfigStruct;
import com.gigadevice.venustool.controlconflict.ControlConflict;
import com.gigadevice.venustool.gd32mcu.GD32MCU;
import com.gigadevice.venustool.mcubasestruct.ControlStruct;
import com.gigadevice.venustool.mcubasestruct.ItemStruct;
import com.gigadevice.venustool.mcubasestruct.MCUStruct;
import com.gigadevice.venustool.mcubasestruct.ModuleStruct;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import com.gigadevice.venustool.mcubasestruct.WidgetNodeStruct;
import com.gigadevice.venustool.periconfigbasestruct.PeriConfigGroupStruct;
import com.gigadevice.venustool.periconfigbasestruct.PeriConfigViewNodeStruct;
import com.gigadevice.venustool.periconfigbasestruct.PeriConfigViewStruct;
import com.gigadevice.venustool.periconfigbasestruct.PeriConfigViewTabStruct;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class GlobalVariables {
    public static PerisTreeStruct PeripheralTree;
    public static MCUStruct MCUObj;
    public static MCUStruct MCUObjCopy;
    public static Map<String, List<ItemStruct>> FunctionPosInItem;
    public static Map<String, List<WidgetNodeStruct>> FunctionPosInWidget;
    public static Map<String, Map<String, PerisItemsStruct>> PeripheralTreeMap;
    public static Map<String, Map<String, NodeStruct>> PeripheralConfigObjMap;
    public static Map<String, Map<String, ControlStruct>> PeriCtrlConfigObjMap;
    public static Map<String, List<String>> PeripheralMultipleTreeMap;
    public static List<PeriTreeColumnInfoStruct> PeriTreeColInfos;
    public transient Map<String, List<PerisRelateInfo>> PeriParaConflictList = new HashMap<String, List<PerisRelateInfo>>();
    public static List<NodeStruct> relationUpdateNode;
    public static boolean isRelationPinUpdate;
    public static Map<Integer, List<Object>> periTreeUpdateNodeMap;
    public static boolean isInitProject;
    public static GD32MCU gd32mcuObj;
    public static MCUSeletorInfo McuSeletorInfo;
    public static String ProjectName;
    public static String SeriesPath;
    public static PeriConfigViewStruct PeriConfigViewObj;
    public static Map<String, AbstractJTreeNode> PeriParaTreeObj;
    public static Map<String, Map<String, String>> getSysCode;
    public static boolean isAnalogMode;
    public static List<String> AnalogModePins;
    public static Map<String, Map<String, String>> InitCodeFromFTL;
    public static boolean isCubeRoverTest;
    public static Map<String, String> UserCodeTagUpdate;
    public static boolean isAllowChangePinPlace;
    public static boolean isShowUserLabel;
    public static LinkedHashMap<String, NVICConfigStruct> NVICConfigTempObj;
    public static final String STR_PINSERIALIZE = "PIN";
    public static final String SERIALIZE_PINSIGNAL = "Signal";
    public static final String SERIALIZE_PINTYPE = "Type";
    public static final String SERIALIZE_PINPERI = "Peri";
    public static final String STR_SERIALIZE = "PINOUT";
    public static final String SERIALIZE_PERINODE = "PERIPHERAL.NODE";
    public static final String SERIALIZE_PERICTRL = "PERIPHERAL.CTRL";
    public static final String STR_TARGET = "\\.";
    public static final String STR_REPLACE = "@2E@";
    private static Map<String, Map<String, String>> pinDeSerializeMap;
    static Map<String, Map<String, String>> mapPeriNodeInfo;
    static Map<String, Map<String, String>> mapPeriCtrlInfo;
    public static int lastIncludePathsCount;
    public static int periIncludePathsCount;
    public static boolean isDirtyFlag;
    public static boolean isCodeGenFlag;
    public static boolean openGDCFileFlag;
    public static Map<String, String> lastSelectedMiddleWare;
    public static List<String> selectSeriesList;
    public static List<MCUSeletorInfo> MCUSeletorInfoList;
    public static String strCompareMsg;
    public static final String FWLIBTYPE_HAL = "HAL";
    public static final String FWLIBTYPE_STANDARD = "Standard";
    public static boolean checkClockTree;
    public static String ControlItem_UserModify;
    public static boolean ClockTree_IfUserModify;

    static {
        MCUObj = new MCUStruct();
        MCUObjCopy = new MCUStruct();
        FunctionPosInItem = new HashMap<String, List<ItemStruct>>();
        FunctionPosInWidget = new HashMap<String, List<WidgetNodeStruct>>();
        PeripheralTreeMap = new HashMap<String, Map<String, PerisItemsStruct>>();
        PeripheralConfigObjMap = new HashMap<String, Map<String, NodeStruct>>();
        PeriCtrlConfigObjMap = new HashMap<String, Map<String, ControlStruct>>();
        PeripheralMultipleTreeMap = new HashMap<String, List<String>>();
        PeriTreeColInfos = new ArrayList<PeriTreeColumnInfoStruct>();
        relationUpdateNode = new ArrayList<NodeStruct>();
        isRelationPinUpdate = false;
        periTreeUpdateNodeMap = new HashMap<Integer, List<Object>>();
        isInitProject = false;
        gd32mcuObj = new GD32MCU();
        McuSeletorInfo = new MCUSeletorInfo();
        ProjectName = null;
        SeriesPath = null;
        PeriParaTreeObj = new HashMap<String, AbstractJTreeNode>();
        getSysCode = new HashMap<String, Map<String, String>>();
        isAnalogMode = false;
        AnalogModePins = new ArrayList<String>();
        InitCodeFromFTL = new HashMap<String, Map<String, String>>();
        isCubeRoverTest = false;
        UserCodeTagUpdate = new HashMap<String, String>();
        isAllowChangePinPlace = true;
        isShowUserLabel = true;
        NVICConfigTempObj = new LinkedHashMap();
        pinDeSerializeMap = new HashMap<String, Map<String, String>>();
        mapPeriNodeInfo = new HashMap<String, Map<String, String>>();
        mapPeriCtrlInfo = new HashMap<String, Map<String, String>>();
        lastIncludePathsCount = 0;
        periIncludePathsCount = 0;
        isDirtyFlag = false;
        isCodeGenFlag = false;
        openGDCFileFlag = false;
        lastSelectedMiddleWare = new HashMap<String, String>();
        selectSeriesList = new ArrayList<String>();
        MCUSeletorInfoList = new ArrayList<MCUSeletorInfo>();
        strCompareMsg = "";
        checkClockTree = false;
        ControlItem_UserModify = "";
        ClockTree_IfUserModify = false;
    }

    public static void ClearUserConfigVars() {
        PeripheralConfigObjMap.clear();
        PeriCtrlConfigObjMap.clear();
        mapPeriNodeInfo.clear();
        mapPeriCtrlInfo.clear();
        MCUObj = GlobalVariables.cloneFrom(MCUObjCopy);
        gd32mcuObj = new GD32MCU();
        gd32mcuObj.InitMcuObj(SeriesPath, McuSeletorInfo.getMCUPart(), McuSeletorInfo.getPackageType());
        lastSelectedMiddleWare.clear();
    }

    public static void ClearAllGlobalVars() {
        PeripheralTreeMap.clear();
        PeripheralMultipleTreeMap.clear();
        PeripheralConfigObjMap.clear();
        FunctionPosInItem.clear();
        FunctionPosInWidget.clear();
        MCUObj = new MCUStruct();
        InitCodeFromFTL.clear();
        AnalogModePins.clear();
        gd32mcuObj = new GD32MCU();
        mapPeriNodeInfo.clear();
        mapPeriCtrlInfo.clear();
    }

    public static void InitAllGlobalVars() {
        GlobalVariables.UpdateSeriesPath();
        gd32mcuObj = new GD32MCU();
        gd32mcuObj.InitMcuObj(SeriesPath, McuSeletorInfo.getMCUPart(), McuSeletorInfo.getPackageType());
    }

    public static void LoadAllGlobalVars() {
        GlobalVariables.periNodeConfigDecodingV1();
        GlobalVariables.periCtrlConfigDecodingV1();
        GlobalVariables.LoadMiddleWareGlobalVars();
    }

    public static void LoadPINGlobalVars() {
        GlobalVariables.LoadPinInfoBySerializeMap();
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(McuSeletorInfo);
            out.writeObject(gd32mcuObj);
            out.writeObject(PeripheralTreeMap);
            out.writeObject(PeripheralMultipleTreeMap);
            out.writeObject(MCUObj);
            out.writeObject(FunctionPosInItem);
            out.writeObject(FunctionPosInWidget);
            out.writeObject(PeripheralConfigObjMap);
            out.writeObject(getSysCode);
            out.writeObject(InitCodeFromFTL);
            out.writeObject(selectSeriesList);
            out.writeObject(MCUSeletorInfoList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        switch (version) {
            case "1.1": {
                GlobalVariables.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            McuSeletorInfo = (MCUSeletorInfo)ins.readObject();
            gd32mcuObj = (GD32MCU)ins.readObject();
            PeripheralTreeMap = (Map)ins.readObject();
            PeripheralMultipleTreeMap = (Map)ins.readObject();
            MCUObj = (MCUStruct)ins.readObject();
            FunctionPosInItem = (Map)ins.readObject();
            FunctionPosInWidget = (Map)ins.readObject();
            PeripheralConfigObjMap = (Map)ins.readObject();
            getSysCode = (Map)ins.readObject();
            InitCodeFromFTL = (Map)ins.readObject();
            selectSeriesList = (List)ins.readObject();
            MCUSeletorInfoList = (List)ins.readObject();
            GlobalVariables.CompatibleOldVersionGdc();
            GlobalVariables.UpdateSeriesPath();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void CompatibleOldVersionGdc() {
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(i);
            if (pinPadObj.getPinUsedType() == 1) {
                pinPadObj.putPinUsedType(2);
            } else if (pinPadObj.getPinUsedType() == 2) {
                pinPadObj.putPinUsedType(1);
            }
            ++i;
        }
    }

    public static String Serialize() {
        String output = "";
        output = String.valueOf(output) + GlobalVariables.getPeriSerializeStr();
        output = String.valueOf(output) + GlobalVariables.getPinSerializeStr();
        return output;
    }

    public static void DeSerialize(String input, int version) {
        switch (version) {
            case 1: {
                GlobalVariables.DeSerializeV1(input, version);
            }
        }
    }

    private static void DeSerializeV1(String input, int version) {
        GlobalVariables.addPeriInfoBySerializeStr(input, version);
        GlobalVariables.addPinInfoBySerializeStr(input, version);
    }

    private static String getPeriSerializeStr() {
        String output = "";
        output = String.valueOf(output) + GlobalVariables.periConfigEncodingV1();
        output = String.valueOf(output) + GlobalVariables.ctrlConfigEncodingV1();
        return output;
    }

    private static void addPeriInfoBySerializeStr(String input, int version) {
        switch (version) {
            case 1: {
                mapPeriNodeInfo = GlobalVariables.serializeStrClassification(input, String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_PERINODE));
                mapPeriCtrlInfo = GlobalVariables.serializeStrClassification(input, String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_PERICTRL));
            }
        }
    }

    private static String periConfigEncodingV1() {
        String output = "";
        for (String strPeri : PeripheralConfigObjMap.keySet()) {
            Map<String, NodeStruct> mapNodeInfo = PeripheralConfigObjMap.get(strPeri);
            for (String strNode : mapNodeInfo.keySet()) {
                NodeStruct nodeStruct = mapNodeInfo.get(strNode);
                String strPath = ControlConflict.getNodePath(nodeStruct, "");
                strPeri = strPeri.replaceAll(STR_TARGET, STR_REPLACE);
                strPath = strPath.replaceAll(STR_TARGET, STR_REPLACE);
                String str = String.valueOf(String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_PERINODE, strPeri, strPath)) + "=" + nodeStruct.getValue() + System.getProperty("line.separator");
                output = String.valueOf(output) + str;
            }
        }
        return output;
    }

    private static void periNodeConfigDecodingV1() {
        for (String strPeri : mapPeriNodeInfo.keySet()) {
            Map<String, String> mapNodeInfo = mapPeriNodeInfo.get(strPeri);
            for (String strNodeName : mapNodeInfo.keySet()) {
                String strVal = mapNodeInfo.get(strNodeName);
                String strPeriNoPrefix = strPeri.replace(String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_PERINODE, ""), "");
                ModuleStruct moduleStruct = MCUObj.getModules().get(strPeriNoPrefix);
                if (moduleStruct == null) {
                    LogManager.getInstance().error("<PeriandPinContent>", "Detected non-existent peripheral. Serialize Error: " + strPeriNoPrefix);
                    return;
                }
                if (McuSeletorInfo.getMCUGroup().equals("GD32F3x0") && strNodeName.equals("BKIN pin enable")) {
                    strNodeName = "BRKIN pin enable";
                }
                LinkedHashMap<String, WidgetNodeStruct> mapWidgetNodeStruct = moduleStruct.getWidgetNodes();
                if (strNodeName.contains("##")) {
                    String lastPath;
                    String strWidgetName = strNodeName.substring(0, strNodeName.indexOf("##"));
                    WidgetNodeStruct widgetNodeStruct = mapWidgetNodeStruct.get(strWidgetName);
                    NodeStruct nodeStruct = ControlConflict.getLeafNode((NodeStruct)widgetNodeStruct, lastPath = strNodeName.substring(strNodeName.indexOf("##") + 2, strNodeName.length()));
                    if (nodeStruct == null) {
                        return;
                    }
                    nodeStruct.setValue(strVal);
                    GlobalVariables.addPeripheralConfigObjMap(strPeriNoPrefix, nodeStruct);
                    continue;
                }
                WidgetNodeStruct widgetNodeStruct = mapWidgetNodeStruct.get(strNodeName);
                ((NodeStruct)widgetNodeStruct).setValue(strVal);
                GlobalVariables.addPeripheralConfigObjMap(strPeriNoPrefix, (NodeStruct)widgetNodeStruct);
            }
        }
    }

    private static String ctrlConfigEncodingV1() {
        String output = "";
        for (String strPeri : PeriCtrlConfigObjMap.keySet()) {
            Map<String, ControlStruct> mapCtrlConfig = PeriCtrlConfigObjMap.get(strPeri);
            for (String strCtrl : mapCtrlConfig.keySet()) {
                ControlStruct controlStruct = mapCtrlConfig.get(strCtrl);
                strPeri = strPeri.replaceAll(STR_TARGET, STR_REPLACE);
                strCtrl = strCtrl.replaceAll(STR_TARGET, STR_REPLACE);
                String str = String.valueOf(String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_PERICTRL, strPeri, strCtrl)) + "=" + controlStruct.getValue() + System.getProperty("line.separator");
                output = String.valueOf(output) + str;
            }
        }
        return output;
    }

    private static void periCtrlConfigDecodingV1() {
        for (String strPeri : mapPeriCtrlInfo.keySet()) {
            Map<String, String> mapCtrlInfo = mapPeriCtrlInfo.get(strPeri);
            for (String strCtrlName : mapCtrlInfo.keySet()) {
                String strVal = mapCtrlInfo.get(strCtrlName);
                String strPeriNoPrefix = strPeri.replace(String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_PERICTRL, ""), "");
                ModuleStruct moduleStruct = MCUObj.getModules().get(strPeriNoPrefix);
                if (moduleStruct == null) {
                    return;
                }
                LinkedHashMap<String, WidgetNodeStruct> mapWidgetNodeStruct = moduleStruct.getWidgetNodes();
                WidgetNodeStruct widgetNodeStruct = mapWidgetNodeStruct.get(strCtrlName);
                ((ControlStruct)widgetNodeStruct).setValue(strVal);
                GlobalVariables.addPeripheralConfigObjMap(strPeriNoPrefix, (ControlStruct)widgetNodeStruct);
            }
        }
    }

    private static void addPeripheralConfigObjMap(String strPeriNoPrefix, NodeStruct nodeStruct) {
        String NodeName = nodeStruct.getNodeName();
        if (nodeStruct.getParentNode() != null) {
            NodeName = ControlConflict.getNodePath(nodeStruct, "");
        }
        if (PeripheralConfigObjMap.containsKey(strPeriNoPrefix)) {
            Map<String, NodeStruct> mapNode = PeripheralConfigObjMap.get(strPeriNoPrefix);
            if (mapNode.containsKey(NodeName)) {
                mapNode.get(NodeName).setValue(nodeStruct.getValue());
            } else {
                mapNode.put(NodeName, nodeStruct);
            }
        } else {
            HashMap<String, NodeStruct> mapNode = new HashMap<String, NodeStruct>();
            mapNode.put(NodeName, nodeStruct);
            PeripheralConfigObjMap.put(strPeriNoPrefix, mapNode);
        }
    }

    private static void addPeripheralConfigObjMap(String strPeriNoPrefix, ControlStruct controlStruct) {
        String CtrlName = controlStruct.getNodeName();
        if (PeriCtrlConfigObjMap.containsKey(strPeriNoPrefix)) {
            Map<String, ControlStruct> mapCtrl = PeriCtrlConfigObjMap.get(strPeriNoPrefix);
            if (mapCtrl.containsKey(CtrlName)) {
                mapCtrl.get(CtrlName).setValue(controlStruct.getValue());
            } else {
                mapCtrl.put(CtrlName, controlStruct);
            }
        } else {
            HashMap<String, ControlStruct> mapCtrl = new HashMap<String, ControlStruct>();
            mapCtrl.put(CtrlName, controlStruct);
            PeriCtrlConfigObjMap.put(strPeriNoPrefix, mapCtrl);
        }
    }

    private static String getPinSerializeStr() {
        String output = System.getProperty("line.separator");
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(i);
            if (pinPadObj.getPinUsedType() != 0) {
                String pinName = pinPadObj.getPinName();
                String pinPrefix = String.join((CharSequence)".", STR_PINSERIALIZE, pinName, "");
                String usedFunction = "";
                String usedType = "";
                String periName = "";
                String splitStr = "##";
                if (pinPadObj.getGPIOModel() == 1 && pinPadObj.getPinUsedType() != 4) {
                    for (GD32PinPad child : pinPadObj.getChildGD32PinPads()) {
                        usedFunction = String.valueOf(usedFunction) + child.getPinUsedFunctionStr() + splitStr;
                        usedType = String.valueOf(usedType) + GlobalVariables.getUsedTypeStr(child.getPinUsedType()) + splitStr;
                        periName = String.valueOf(periName) + child.getPinUsedPeri() + splitStr;
                    }
                    usedFunction = usedFunction.substring(0, usedFunction.length() - splitStr.length());
                    usedType = usedType.substring(0, usedType.length() - splitStr.length());
                    periName = periName.substring(0, periName.length() - splitStr.length());
                } else {
                    usedFunction = pinPadObj.getPinUsedFunctionStr();
                    usedType = GlobalVariables.getUsedTypeStr(pinPadObj.getPinUsedType());
                    periName = pinPadObj.getPinUsedPeri();
                }
                output = String.valueOf(output) + pinPrefix + SERIALIZE_PINSIGNAL + "=" + usedFunction + System.getProperty("line.separator");
                output = String.valueOf(output) + pinPrefix + SERIALIZE_PINTYPE + "=" + usedType + System.getProperty("line.separator");
                output = String.valueOf(output) + pinPrefix + SERIALIZE_PINPERI + "=" + periName + System.getProperty("line.separator");
            }
            ++i;
        }
        return output;
    }

    private static void addPinInfoBySerializeStr(String input, int version) {
        pinDeSerializeMap.clear();
        switch (version) {
            case 1: {
                pinDeSerializeMap = GlobalVariables.serializeStrClassification(input, STR_PINSERIALIZE);
            }
        }
    }

    private static void LoadPinInfoBySerializeMap() {
        for (Map.Entry<String, Map<String, String>> entry : pinDeSerializeMap.entrySet()) {
            String key = entry.getKey();
            ArrayList<String> strList = new ArrayList<String>(Arrays.asList(key.split(STR_TARGET)));
            if (strList.size() < 2) continue;
            String pinName = (String)strList.get(1);
            int pinIndex = gd32mcuObj.GetPinIndexByPinName(pinName);
            if (pinIndex < 0) {
                LogManager.getInstance().error(STR_PINSERIALIZE, "The format of the pin information is incorrect, the gdc file may have been manually modified. Error: " + pinName);
                continue;
            }
            String usedFunctionStr = "";
            String usedTypeStr = "";
            String usedPeriStr = "";
            Map<String, String> map = entry.getValue();
            for (Map.Entry<String, String> entry1 : map.entrySet()) {
                if (entry1.getKey().equals(SERIALIZE_PINSIGNAL)) {
                    usedFunctionStr = entry1.getValue();
                    if (!McuSeletorInfo.getMCUGroup().equals("GD32F3x0") || !usedFunctionStr.contains("_BKIN")) continue;
                    usedFunctionStr = usedFunctionStr.replaceAll("_BKIN", "_BRKIN");
                    continue;
                }
                if (entry1.getKey().equals(SERIALIZE_PINTYPE)) {
                    usedTypeStr = entry1.getValue();
                    continue;
                }
                if (!entry1.getKey().equals(SERIALIZE_PINPERI)) continue;
                usedPeriStr = entry1.getValue();
            }
            GlobalVariables.UpdatePinInfoBySerializeStr(pinIndex, usedFunctionStr, usedTypeStr, usedPeriStr);
        }
        pinDeSerializeMap.clear();
    }

    private static void UpdatePinInfoBySerializeStr(int index, String usedFunctionStr, String usedTypeStr, String usedPeriStr) {
        if (index < 0) {
            return;
        }
        GD32PinPad pinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(index);
        if (usedFunctionStr.contains("##")) {
            pinPadObj.setGPIOModel(1);
            ArrayList<String> funcList = new ArrayList<String>(Arrays.asList(usedFunctionStr.split("##")));
            ArrayList<String> usedTypeList = new ArrayList<String>(Arrays.asList(usedTypeStr.split("##")));
            ArrayList<String> usedPeriList = new ArrayList<String>(Arrays.asList(usedPeriStr.split("##")));
            if (funcList.size() != usedTypeList.size() || funcList.size() != usedPeriList.size()) {
                return;
            }
            int i = 0;
            while (i < funcList.size()) {
                String usedFunction = (String)funcList.get(i);
                int usedType = GlobalVariables.getUsedTypeInt((String)usedTypeList.get(i));
                String usedPeri = (String)usedPeriList.get(i);
                String AF_Value = gd32mcuObj.GetGPIOAFValue(pinPadObj.getPinName(), usedFunction);
                GlobalVariables.UpdatePinInfo(index, (String)funcList.get(i), AF_Value, usedType, usedPeri);
                ++i;
            }
            return;
        }
        if (isAnalogMode && GlobalVariables.checkFunctionIsAnalogMode(usedFunctionStr)) {
            pinPadObj.setGPIOModel(1);
        }
        String AF_Value = gd32mcuObj.GetGPIOAFValue(pinPadObj.getPinName(), usedFunctionStr);
        int usedType = GlobalVariables.getUsedTypeInt(usedTypeStr);
        GlobalVariables.UpdatePinInfo(index, usedFunctionStr, AF_Value, usedType, usedPeriStr);
    }

    public static void UpdatePinInfo(int index, String UsedFunction, String AF_Value, int UsedType, String UsedPeri) {
        if (GlobalVariables.gd32mcuObj.GD32PinPads.get(index).getGPIOModel() == 1) {
            if (UsedType == 0) {
                if (GlobalVariables.gd32mcuObj.GD32PinPads.get(index).getPinUsedFunctionStr().contains(UsedFunction)) {
                    GlobalVariables.gd32mcuObj.GD32PinPads.get(index).removeChildGD32PinPadByFunction(UsedFunction, UsedPeri);
                }
                GlobalVariables.gd32mcuObj.GD32PinPads.get(index).updateGD32PinPadInfo();
            } else {
                GD32PinPad GD32PinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(index).getChildGD32PinPadByFunction(UsedFunction, "");
                boolean isNewChild = false;
                if (GD32PinPadObj == null) {
                    isNewChild = true;
                } else if (!GD32PinPadObj.getPinUsedPeri().contains(UsedPeri)) {
                    isNewChild = true;
                }
                if (isNewChild) {
                    GD32PinPadObj = new GD32PinPad();
                }
                GD32PinPadObj.putPinName(GlobalVariables.gd32mcuObj.GD32PinPads.get(index).getPinName());
                GD32PinPadObj.putPinUsedFunctionStr(UsedFunction);
                GD32PinPadObj.putRemapAF_Value(AF_Value);
                GD32PinPadObj.putPinUsedType(UsedType);
                GD32PinPadObj.putPinUsedPeri(UsedPeri);
                GD32PinPadObj.setGPIOModel(GlobalVariables.gd32mcuObj.GD32PinPads.get(index).getGPIOModel());
                if (isNewChild) {
                    GlobalVariables.gd32mcuObj.GD32PinPads.get(index).addChildGD32PinPad(GD32PinPadObj);
                }
                GlobalVariables.gd32mcuObj.GD32PinPads.get(index).putPinUsedPeri(UsedPeri);
                GlobalVariables.gd32mcuObj.GD32PinPads.get(index).updateGD32PinPadInfo();
            }
        } else {
            GlobalVariables.gd32mcuObj.GD32PinPads.get(index).putPinUsedFunctionStr(UsedFunction);
            GlobalVariables.gd32mcuObj.GD32PinPads.get(index).putRemapAF_Value(AF_Value);
            GlobalVariables.gd32mcuObj.GD32PinPads.get(index).putPinUsedType(UsedType);
            GlobalVariables.gd32mcuObj.GD32PinPads.get(index).putPinUsedPeri(UsedPeri);
        }
    }

    public static void UpdatePinPadInfo(int index, String UsedFunction, String AF_Value, int UsedType, String UsedPeri) {
        GlobalVariables.gd32mcuObj.GD32PinPads.get(index).putPinUsedFunctionStr(UsedFunction);
        GlobalVariables.gd32mcuObj.GD32PinPads.get(index).putRemapAF_Value(AF_Value);
        GlobalVariables.gd32mcuObj.GD32PinPads.get(index).putPinUsedType(UsedType);
        GlobalVariables.gd32mcuObj.GD32PinPads.get(index).putPinUsedPeri(UsedPeri);
        GlobalVariables.gd32mcuObj.GD32PinPads.get(index).updateGD32PinPadInfo();
    }

    public static GD32PinPad GetPinInfo(int index) {
        if (index < 0 || index >= GlobalVariables.gd32mcuObj.GD32PinPads.size()) {
            return null;
        }
        return GlobalVariables.gd32mcuObj.GD32PinPads.get(index);
    }

    public static GD32PinPad GetPinInfoByPinName(String pinName) {
        int index = gd32mcuObj.GetPinIndexByPinName(pinName);
        if (index < 0) {
            return null;
        }
        return GlobalVariables.gd32mcuObj.GD32PinPads.get(index);
    }

    public static GD32PinPad GetDisablePinInfoByPinName(String pinName) {
        int index = gd32mcuObj.GetPinIndexByPinName(pinName);
        if (index < 0) {
            return null;
        }
        return GlobalVariables.gd32mcuObj.GD32PinPads.get(index);
    }

    public static GD32PinPad GetPinInfoByPinNumStr(String PinNumStr) {
        int index = gd32mcuObj.GetPinIndexByPinNumStr(PinNumStr);
        if (index < 0) {
            return null;
        }
        return GlobalVariables.gd32mcuObj.GD32PinPads.get(index);
    }

    public static int GetPinPackageNum() {
        return GlobalVariables.gd32mcuObj.MCUPackage;
    }

    public static int GetBGAPinPackageRowNum() {
        int maxRow = 0;
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(i);
            String pinNumberStr = pinPadObj.getPinNumberStr();
            int pinRowNumber = Integer.valueOf(pinNumberStr = pinNumberStr.replaceAll("[^0-9]", ""));
            if (maxRow < pinRowNumber) {
                maxRow = pinRowNumber;
            }
            ++i;
        }
        return maxRow;
    }

    public static boolean checkFunctionIsAnalogMode(String functionName) {
        for (String analogPin : AnalogModePins) {
            if (!functionName.contains(analogPin)) continue;
            return true;
        }
        return false;
    }

    public static String GetMultipleTreePeriName(String PeriName) {
        List<String> MultipleTree;
        if (PeripheralMultipleTreeMap.containsKey(PeriName) && (MultipleTree = PeripheralMultipleTreeMap.get(PeriName)).size() > 0) {
            PeriName = MultipleTree.get(0);
        }
        return PeriName;
    }

    public static boolean isSupportCodeGen() {
        return McuSeletorInfo.getSupportCodeGen();
    }

    public static void UpdateSeriesPath() {
        if (McuSeletorInfo.getSeries() != null) {
            SeriesPath = McuSeletorInfo.getSeries().equals("GD32VF103") ? "GD32VF103" : McuSeletorInfo.getMCUGroup();
        }
    }

    public static boolean HaveExisted(String strPeri, String strModule, String strItem) {
        boolean ret = false;
        if (PeripheralConfigObjMap.containsKey(strPeri)) {
            Map<String, NodeStruct> Map2 = PeripheralConfigObjMap.get(strPeri);
            if (strModule.equals("")) {
                ret = true;
            }
            if (strItem.equals("")) {
                ret = true;
            } else {
                NodeStruct temp;
                Map2.get(strModule);
                if (Map2.containsKey(strModule) && (temp = Map2.get(strModule)).getValue().equals(strItem)) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static String RemoveReriDigital(String PeriName) {
        String Peri = PeriName;
        int i = Peri.length() - 1;
        while (i >= 0) {
            if (!Character.isDigit(Peri.charAt(i))) {
                Peri = Peri.substring(0, i + 1);
                break;
            }
            --i;
        }
        return Peri;
    }

    public static boolean copyFolder(String oldPath, String newPath) {
        File temp;
        String[] file;
        block7: {
            new File(newPath).mkdirs();
            File filelist = new File(oldPath);
            file = filelist.list();
            temp = null;
            if (file != null) break block7;
            return false;
        }
        try {
            int i = 0;
            while (i < file.length) {
                temp = oldPath.endsWith(File.separator) ? new File(String.valueOf(oldPath) + file[i]) : new File(String.valueOf(oldPath) + File.separator + file[i]);
                if (temp.isFile()) {
                    int prereadlength;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(String.valueOf(newPath) + File.separator + temp.getName().toString());
                    byte[] bufferarray = new byte[65536];
                    while ((prereadlength = input.read(bufferarray)) != -1) {
                        output.write(bufferarray, 0, prereadlength);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (temp.isDirectory()) {
                    GlobalVariables.copyFolder(String.valueOf(oldPath) + File.separator + file[i], String.valueOf(newPath) + File.separator + file[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getPeriTreeControlValue(String periName, String controlName) {
        Object object = ControlConflict.getPeriTreeNode(periName, controlName, "", "");
        if (object == null) {
            return null;
        }
        ControlStruct controlObj = (ControlStruct)object;
        String configValue = controlObj.getValue();
        return configValue;
    }

    public static List<String> getCoreList() {
        return GlobalVariables.getPeriTreeColList("Core");
    }

    public static String getInitializeValue(String periName) {
        int i = 0;
        while (i < PeriTreeColInfos.size()) {
            PeriTreeColumnInfoStruct columnInfoObj = PeriTreeColInfos.get(i);
            if (columnInfoObj.getNodeType().equals("Initialize")) {
                String controlName = columnInfoObj.getNodeName();
                return GlobalVariables.getPeriTreeControlValue(periName, controlName);
            }
            ++i;
        }
        return null;
    }

    public static List<String> getPeriTreeColList(String NodeType2) {
        ArrayList<String> colInfoList = new ArrayList<String>();
        for (PeriTreeColumnInfoStruct colInfoObj : PeriTreeColInfos) {
            if (!colInfoObj.getNodeType().equals(NodeType2)) continue;
            colInfoList.add(colInfoObj.getNodeName());
        }
        return colInfoList;
    }

    public static String getCurrentYear() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String currentData = simpleDateFormat.format(date);
        return currentData;
    }

    public static LinkedHashMap<String, Map<String, String>> serializeStrClassification(String input, String prefix) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        Scanner scanner = new Scanner(input);
        while (scanner.hasNextLine()) {
            int indexEqual;
            String linePrefix;
            String line = scanner.nextLine();
            if (!prefix.equals("") && (line.length() < prefix.length() + 1 || !(linePrefix = line.substring(0, prefix.length() + 1)).equals(String.valueOf(prefix) + ".")) || (indexEqual = line.indexOf("=")) == -1) continue;
            String equalLeftStr = line.substring(0, indexEqual);
            String equalRightStr = line.substring(indexEqual + 1, line.length());
            int index = equalLeftStr.lastIndexOf(".");
            if (index == -1) continue;
            String spotLeftStr = equalLeftStr.substring(0, index);
            String spotRightStr = equalLeftStr.substring(index + 1, equalLeftStr.length());
            spotLeftStr = spotLeftStr.replaceAll(STR_REPLACE, STR_TARGET);
            spotRightStr = spotRightStr.replaceAll(STR_REPLACE, STR_TARGET);
            Map<String, String> map0 = new HashMap<String, String>();
            if (result.containsKey(spotLeftStr)) {
                map0 = result.get(spotLeftStr);
            }
            map0.put(spotRightStr, equalRightStr);
            result.put(spotLeftStr, map0);
        }
        return result;
    }

    private static String getUsedTypeStr(int type) {
        if (type == 0) {
            return "UNUSED";
        }
        if (type == 1) {
            return "MANUAL";
        }
        if (type == 2) {
            return "AUTOMATIC";
        }
        if (type == 3) {
            return "MANUAL_AUTO";
        }
        if (type == 4) {
            return "BATCH_AUTO";
        }
        return "";
    }

    private static int getUsedTypeInt(String type) {
        if (type.equals("UNUSED")) {
            return 0;
        }
        if (type.equals("MANUAL")) {
            return 1;
        }
        if (type.equals("AUTOMATIC")) {
            return 2;
        }
        if (type.equals("MANUAL_AUTO")) {
            return 3;
        }
        if (type.equals("BATCH_AUTO")) {
            return 4;
        }
        return -1;
    }

    public static Map<String, String> getConfigPinInfo() {
        HashMap<String, String> configPinInfo = new HashMap<String, String>();
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(i);
            if (pinPadObj.getPinUsedType() != 0) {
                configPinInfo.put(pinPadObj.getPinName(), pinPadObj.getPinUsedFunctionStr());
            }
            ++i;
        }
        return configPinInfo;
    }

    public static <T> T cloneFrom(T src) throws RuntimeException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ObjectOutputStream outObject = null;
        ObjectInputStream inObject = null;
        Object dst = null;
        try {
            try {
                outObject = new ObjectOutputStream(outStream);
                outObject.writeObject(src);
                outObject.flush();
                ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
                inObject = new ObjectInputStream(inStream);
                dst = inObject.readObject();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (outObject != null) {
                try {
                    outObject.close();
                    outObject = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (inObject != null) {
                try {
                    inObject.close();
                    inObject = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return (T)dst;
    }

    public static String getModifiedPinFunction(String oldPinFunction, String periName) {
        if (!oldPinFunction.toUpperCase().contains("ADC")) {
            return oldPinFunction;
        }
        if (GlobalVariables.gd32mcuObj.pinAllFunctionList == null) {
            return oldPinFunction;
        }
        if (GlobalVariables.gd32mcuObj.pinAllFunctionList.contains(oldPinFunction)) {
            return oldPinFunction;
        }
        String[] functionNameList = oldPinFunction.split("_");
        if (functionNameList.length < 2) {
            return oldPinFunction;
        }
        for (String key : GlobalVariables.gd32mcuObj.pinAllFunctionList) {
            String[] keyStrList;
            if (!key.contains("ADC") || (keyStrList = key.split("_")).length < 2 || !functionNameList[1].equals(keyStrList[1])) continue;
            String tmpKey = key.split("_")[0];
            tmpKey = tmpKey.replace("ADC", "");
            String periNumber = periName;
            if (!tmpKey.contains(periNumber = periNumber.replace("ADC", ""))) continue;
            return key;
        }
        return oldPinFunction;
    }

    public static String formatCppCodeWithClangFormat(String code) {
        try {
            String line;
            File customDirectory;
            if (code.contains("\t")) {
                code = code.replaceAll("\t", "");
            }
            String toolsPathString = ClangUtil.getToolsPath();
            File toolsPath = new File(toolsPathString);
            File toolsDirectory = new File(toolsPath, "Tools");
            File llvmDirectory = new File(toolsDirectory, "LLVM");
            String subDirectory = "bin";
            if (llvmDirectory.exists() && llvmDirectory.isDirectory()) {
                customDirectory = new File(llvmDirectory, subDirectory);
            } else {
                customDirectory = new File(llvmDirectory, subDirectory);
                if (!customDirectory.mkdirs()) {
                    System.err.println("Failed to create directory: " + customDirectory);
                    return code;
                }
            }
            if (!customDirectory.exists() && !customDirectory.mkdirs()) {
                System.err.println("Failed to create directory: " + customDirectory);
                return code;
            }
            File tempCodeFile = File.createTempFile("code", ".c", customDirectory);
            FileWriter writer = new FileWriter(tempCodeFile);
            writer.write(code);
            writer.close();
            String filePath = tempCodeFile.getAbsolutePath();
            File parentDir = tempCodeFile.getParentFile();
            File clangFormatExecutable = new File(parentDir, "clang-format.exe");
            if (!clangFormatExecutable.exists()) {
                throw new IOException("Cannot find clang-format executable in " + parentDir.getAbsolutePath());
            }
            ProcessBuilder pb = new ProcessBuilder(clangFormatExecutable.getAbsolutePath(), "-style=file", filePath);
            pb.directory(parentDir);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder formattedCode = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                formattedCode.append(line).append("\n");
            }
            reader.close();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                System.err.println("clang-format failed with return code: " + exitCode);
            }
            if (!tempCodeFile.delete()) {
                System.err.println("Failed to delete temporary code file");
            }
            return formattedCode.toString();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return code;
        }
    }

    public static void LoadMiddleWareGlobalVars() {
        lastSelectedMiddleWare.clear();
        LinkedHashMap<String, ModuleStruct> modules_map = MCUObj.getModules();
        for (String key : MCUObj.getModules().keySet()) {
            Map<String, NodeStruct> nodeStructMap;
            String moduleType = modules_map.get(key).getModuleType();
            int state = modules_map.get(key).getState();
            int res = state >> 6 & 1;
            if (!moduleType.equals("MiddleWare") || res == 1 || !PeripheralConfigObjMap.containsKey(key) || (nodeStructMap = PeripheralConfigObjMap.get(key)) == null) continue;
            Iterator<String> iterator = nodeStructMap.keySet().iterator();
            while (iterator.hasNext()) {
                String keyTemp;
                String strKeyTemp = keyTemp = iterator.next();
                WidgetNodeStruct valueTemp = nodeStructMap.get(keyTemp);
                String getValue = valueTemp.getValue();
                int getType = valueTemp.getType();
                lastSelectedMiddleWare.put(String.valueOf(key) + "##" + strKeyTemp, getValue);
                if (getType == 2) continue;
            }
        }
    }

    public static void DisablePinInfoByPinName(String PinName, String PinNumStr) {
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(i);
            if (pinPadObj.getPinNameOrigin().equals(PinName) && !pinPadObj.getPinNumberStr().equals(PinNumStr)) {
                if (pinPadObj.isDisablePin()) {
                    return;
                }
                pinPadObj.setDisablePin(true);
                pinPadObj.putPinName(String.valueOf(pinPadObj.getPinName()) + "*");
                return;
            }
            ++i;
        }
    }

    public static void DisablePinFunctionByPinNumStr(String PinNumStr) {
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(i);
            if (pinPadObj.getPinNumberStr().equals(PinNumStr)) {
                if (pinPadObj.isDisablePin()) {
                    return;
                }
                pinPadObj.setDisablePin(true);
                pinPadObj.putPinName(String.valueOf(pinPadObj.getPinName()) + "*");
                return;
            }
            ++i;
        }
    }

    public static void EnablePinFunctionByPinNumStr(String PinNumStr) {
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(i);
            if (pinPadObj.getPinNumberStr().equals(PinNumStr)) {
                pinPadObj.setDisablePin(false);
                pinPadObj.putPinName(pinPadObj.getPinNameOrigin());
                return;
            }
            ++i;
        }
    }

    public static void EnablePinInfoByOriginPinName(String PinName) {
        int i = 0;
        while (i < GlobalVariables.gd32mcuObj.MCUPackage) {
            GD32PinPad pinPadObj = GlobalVariables.gd32mcuObj.GD32PinPads.get(i);
            if (pinPadObj.getPinNameOrigin().equals(PinName) && pinPadObj.getPinName().contains("*") && pinPadObj.isDisablePin()) {
                pinPadObj.setDisablePin(false);
                pinPadObj.putPinName(pinPadObj.getPinNameOrigin());
                return;
            }
            ++i;
        }
    }

    public static String getPinNameStrInAssignmentPin(String AssignmentPinStr) {
        String pinNameStr = AssignmentPinStr;
        if (AssignmentPinStr.contains("#[")) {
            String[] tmp = AssignmentPinStr.split("#\\[");
            pinNameStr = tmp[0];
        }
        return pinNameStr;
    }

    public static String getMwPeriName(String mwTabName) {
        String getMwPeriName = mwTabName;
        if (PeriConfigViewObj == null) {
            return getMwPeriName;
        }
        LinkedHashMap<String, PeriConfigGroupStruct> periTypeGroupMap = PeriConfigViewObj.getPeriTypeGroupMap();
        if (periTypeGroupMap == null) {
            return getMwPeriName;
        }
        PeriConfigGroupStruct periConfigGroupStruct = periTypeGroupMap.get("MiddleWare");
        if (periConfigGroupStruct == null) {
            return getMwPeriName;
        }
        LinkedHashMap<String, PeriConfigViewNodeStruct> NodeList = periConfigGroupStruct.getNodeList();
        if (NodeList == null) {
            return getMwPeriName;
        }
        for (String keyPeri : NodeList.keySet()) {
            LinkedHashMap<String, PeriConfigViewTabStruct> TabList;
            PeriConfigViewNodeStruct periConfigViewNodeStruct = NodeList.get(keyPeri);
            if (periConfigViewNodeStruct == null || (TabList = periConfigViewNodeStruct.getTabList()) == null) continue;
            for (String key : TabList.keySet()) {
                if (!key.equals(mwTabName)) continue;
                return keyPeri;
            }
        }
        return getMwPeriName;
    }

    public static boolean deleteEmptyFolder(String folderPath) {
        block5: {
            File[] files;
            File folder;
            block6: {
                folder = new File(folderPath);
                if (!folder.exists() || !folder.isDirectory()) break block5;
                files = folder.listFiles();
                if (files != null) break block6;
                return false;
            }
            try {
                if (files.length == 0) {
                    return folder.delete();
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isMiddleWarePeri(String PerName) {
        String moduleType;
        ModuleStruct moduleStruct;
        if (MCUObj == null) {
            return false;
        }
        LinkedHashMap<String, ModuleStruct> modules_map = MCUObj.getModules();
        return modules_map != null && (moduleStruct = modules_map.get(PerName)) != null && (moduleType = moduleStruct.getModuleType()).equals("MiddleWare");
    }

    public static void UpdatePinPadUserLabel(String pinName, String value) {
        int index = gd32mcuObj.GetPinIndexByPinName(pinName);
        if (index < 0) {
            return;
        }
        GlobalVariables.gd32mcuObj.GD32PinPads.get(index).setPinUseLabel(value);
    }

    public static LinkedHashMap<String, PeriConfigViewTabStruct> getMiddleWareTabList(String PeriName) {
        LinkedHashMap<String, PeriConfigViewTabStruct> TabList = new LinkedHashMap<String, PeriConfigViewTabStruct>();
        LinkedHashMap<String, PeriConfigGroupStruct> periTypeGroupMap = PeriConfigViewObj.getPeriTypeGroupMap();
        if (periTypeGroupMap == null) {
            return TabList;
        }
        PeriConfigGroupStruct periConfigGroupStruct = periTypeGroupMap.get("MiddleWare");
        if (periConfigGroupStruct == null) {
            return TabList;
        }
        LinkedHashMap<String, PeriConfigViewNodeStruct> NodeList = periConfigGroupStruct.getNodeList();
        if (NodeList == null) {
            return TabList;
        }
        PeriConfigViewNodeStruct periConfigViewNodeStruct = NodeList.get(PeriName);
        if (periConfigViewNodeStruct == null) {
            return TabList;
        }
        TabList = periConfigViewNodeStruct.getTabList();
        return TabList;
    }

    static enum PinAttr {
        PinUsedFunction,
        RemapAF_Value,
        PinUsedType,
        PinUsedPeri;

    }
}

