/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.customui.gdui;

import com.gigadevice.customui.tools.UiUtilityClass;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class GDScrollBarUI
extends BasicScrollBarUI {
    private static final int SCROLL_BAR_WIDTH = 6;

    @Override
    protected void configureScrollBarColors() {
        this.thumbColor = new Color(UiUtilityClass.GDColor_Primary.getRed(), UiUtilityClass.GDColor_Primary.getGreen(), UiUtilityClass.GDColor_Primary.getBlue(), 100);
        this.thumbDarkShadowColor = new Color(0, 0, 0, 0);
        this.thumbHighlightColor = new Color(255, 255, 255, 100);
        this.thumbLightShadowColor = new Color(0, 0, 0, 0);
        this.trackColor = new Color(255, 255, 255, 100);
        this.trackHighlightColor = new Color(0, 0, 0, 0);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return this.createZeroButton();
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.createZeroButton();
    }

    private JButton createZeroButton() {
        JButton button = new JButton();
        button.setPreferredSize(new Dimension(0, 0));
        button.setMinimumSize(new Dimension(0, 0));
        button.setMaximumSize(new Dimension(0, 0));
        return button;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(6, this.scrollbar.getHeight());
        }
        return new Dimension(this.scrollbar.getWidth(), 6);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(thumbBounds.x, thumbBounds.y);
        int newWidth = this.scrollbar.getOrientation() == 1 ? 6 : thumbBounds.width;
        int newHeight = this.scrollbar.getOrientation() == 0 ? 6 : thumbBounds.height;
        int x = this.scrollbar.getOrientation() == 1 ? (w - newWidth) / 2 : 0;
        int y = this.scrollbar.getOrientation() == 0 ? (h - newHeight) / 2 : 0;
        g2.setColor(this.thumbColor);
        g2.fillRoundRect(x, y, newWidth, newHeight, 5, 5);
        g2.dispose();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JScrollBar scrollBar = (JScrollBar)c;
        if (scrollBar.getOrientation() == 1) {
            scrollBar.setPreferredSize(new Dimension(6, scrollBar.getHeight()));
        } else {
            scrollBar.setPreferredSize(new Dimension(scrollBar.getWidth(), 6));
        }
    }
}

