/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class CircularProgress
extends Canvas {
    private static final String PERCENT_SIGN = "%";
    private static final String PERCENT_TEXT = "100%";
    private static final int PROGRESS_WIDTH = 8;
    private static final int PROGRESS_MARGIN = 2;
    private static final int PROGRESS_ARC = 15;
    protected final int[] fBufferProgressMeasure = new int[1];

    public CircularProgress(Composite parent, int flags) {
        super(parent, flags);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CircularProgress.this.onPaint(e);
            }
        });
        GC gc = new GC((Drawable)this);
        Point e = gc.textExtent(PERCENT_TEXT);
        int size = e.x + 16 + 16;
        this.setBounds(0, 0, size, size);
    }

    public void setProgress(int progress) {
        this.fBufferProgressMeasure[0] = progress;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.computeSize(wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.getBounds().width, this.getBounds().height);
    }

    private void onPaint(PaintEvent e) {
        String progress;
        Rectangle clientArea = this.getClientArea();
        int margin = 2;
        int width = 8;
        e.gc.setBackground(this.getParent().getBackground());
        e.gc.fillRectangle(0, 0, clientArea.width, clientArea.height);
        e.gc.setBackground(this.getParent().getDisplay().getSystemColor(15));
        e.gc.fillOval(margin, margin, clientArea.width - 2 * margin, clientArea.height - 2 * margin);
        e.gc.setBackground(this.getParent().getBackground());
        e.gc.fillOval(margin + width, margin + width, clientArea.width - 2 * (margin + width), clientArea.height - 2 * (margin + width));
        e.gc.setBackground(this.getParent().getDisplay().getSystemColor(26));
        if (this.fBufferProgressMeasure[0] >= 0 && this.fBufferProgressMeasure[0] <= 100) {
            progress = String.valueOf(this.fBufferProgressMeasure[0]) + PERCENT_SIGN;
            n = (int)((double)this.fBufferProgressMeasure[0] * 3.6);
            e.gc.fillArc(margin, margin, clientArea.width - 2 * margin, clientArea.height - 2 * margin, 90, -n);
        } else {
            progress = PERCENT_TEXT;
            n = (int)((double)(this.fBufferProgressMeasure[0] % 100) * 3.6);
            e.gc.fillOval(margin, margin, clientArea.width - 2 * margin, clientArea.height - 2 * margin);
            e.gc.setBackground(this.getParent().getDisplay().getSystemColor(16));
            e.gc.fillArc(margin, margin, clientArea.width - 2 * margin, clientArea.height - 2 * margin, 90 - n - 15, -15);
        }
        e.gc.setBackground(this.getParent().getBackground());
        e.gc.fillOval(margin + width, margin + width, clientArea.width - 2 * (margin + width), clientArea.width - 2 * (margin + width));
        e.gc.setForeground(this.getParent().getDisplay().getSystemColor(24));
        e.gc.setFont(this.getParent().getDisplay().getSystemFont());
        Point p = e.gc.textExtent(progress);
        e.gc.drawText(progress, (clientArea.width - p.x) / 2 + 1, (clientArea.height - p.y) / 2);
    }
}

