/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.conflict.tool;

import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ConflictControlInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.NewRelationGroup;
import com.gigadevice.venustool.clockconfiginfo.RCUCondition;
import com.gigadevice.venustool.clockconfiginfo.RCUConfigControlGroup;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class Privilege2Sentences {
    static final String FIRST_STR = "To enable it:";
    static final String AND_STR = "All the following condition(s) must be met:";
    static final String OR_STR = "Only one of the following condition(s) needs to be met:";
    static final String EQUAL_STR = " should to be configured as ";
    static final String NOTEQUAL_STR = " should not to be configured as ";
    static final String CONTAIN_STR = " should to be configured to contain ";
    static final String NOTCONTAIN_STR = " should not to be configured to contain ";
    static final String GREATEQUAL_STR = " should to be configured as greater than or equal to ";
    static final String GREATTHAN_STR = " should to be configured as greater than ";
    static final String LESSEQUAL_STR = " should to be configured as less than or equal to ";
    static final String LESSTHAN_STR = " should to be configured as less than ";
    static final String PINOUT_TAB_STR = " from the Pinout Tab: ";
    static final String CONFIGURATION_TAB_STR = " from the Configuration Tab: ";
    static final String CLOCKCONFIGURATION_TAB_STR = " from the Clock Configuration Tab: ";
    static final String SPACE = "             ";

    public static String getPrivilege2Sentence(ConflictGroupInfo conflictGroupObj) {
        if (conflictGroupObj == null) {
            return "";
        }
        StringBuilder resSentences = new StringBuilder();
        boolean disable2EnableFlag = false;
        if (conflictGroupObj.getConditionType() == 0) {
            return "";
        }
        if (conflictGroupObj.getConditionType() == 1) {
            ConflictControlInfo conflictControlInfo = conflictGroupObj.getControledControl();
            if (conflictControlInfo == null) {
                return "";
            }
            String privilege = conflictControlInfo.getPrivilege();
            if (privilege.equals("Disable")) {
                disable2EnableFlag = true;
                resSentences.append(FIRST_STR).append(System.lineSeparator());
            } else if (privilege.equals("Enable")) {
                resSentences.append(FIRST_STR).append(System.lineSeparator());
            } else {
                return "";
            }
            NewRelationGroup newRelationGroup = conflictGroupObj.getNestConditionGroupObj();
            if (newRelationGroup == null) {
                return "";
            }
            String relationType = newRelationGroup.getRelationType();
            if (relationType.equals("OR")) {
                resSentences.append(disable2EnableFlag ? AND_STR : OR_STR).append(System.lineSeparator());
            } else if (relationType.equals("AND")) {
                resSentences.append(disable2EnableFlag ? OR_STR : AND_STR).append(System.lineSeparator());
            }
            Privilege2Sentences.parseRelation(conflictGroupObj.getNestConditionGroupObj(), 1, resSentences, disable2EnableFlag, null);
        }
        return resSentences.toString();
    }

    public static void parseRelation(NewRelationGroup NestConditionGroupObj, int level, StringBuilder resSentences, boolean disable2EnableFlag, String parentIndex) {
        if (NestConditionGroupObj == null) {
            return;
        }
        int nextIndex = 1;
        List<ConditionInfo> conditionInfoList = NestConditionGroupObj.getConditionsList();
        if (conditionInfoList == null) {
            return;
        }
        String spaces = "";
        if (level != 1) {
            spaces = SPACE.repeat(level - 1);
        }
        String RelationType = NestConditionGroupObj.getRelationType();
        HashMap<String, Vector<String>> relateFrom0PrivilegeMap = new HashMap<String, Vector<String>>();
        HashMap<String, Vector<String>> relateFrom1PrivilegeMap = new HashMap<String, Vector<String>>();
        HashMap<String, Vector<String>> relateFrom2PrivilegeMap_Selector = new HashMap<String, Vector<String>>();
        HashMap<String, Vector<String>> relateFrom2PrivilegeMap_NonSelector = new HashMap<String, Vector<String>>();
        int i = 0;
        while (i < conditionInfoList.size()) {
            Vector vectorTemp;
            ConditionInfo conditionInfo = conditionInfoList.get(i);
            if (conditionInfo == null) {
                return;
            }
            String RelateFrom = conditionInfo.getRelateFrom();
            String PeriName = conditionInfo.getPeriName();
            String sentenceRes = Privilege2Sentences.condition2Sentence(conditionInfo, disable2EnableFlag);
            if (RelateFrom.equals("0")) {
                vectorTemp = new Vector();
                if (relateFrom0PrivilegeMap.containsKey(sentenceRes)) {
                    vectorTemp = (Vector)relateFrom0PrivilegeMap.get(sentenceRes);
                }
                vectorTemp.add(PeriName);
                relateFrom0PrivilegeMap.put(sentenceRes, vectorTemp);
            } else if (RelateFrom.equals("1")) {
                vectorTemp = new Vector();
                if (relateFrom1PrivilegeMap.containsKey(sentenceRes)) {
                    vectorTemp = (Vector)relateFrom1PrivilegeMap.get(sentenceRes);
                }
                vectorTemp.add(PeriName);
                relateFrom1PrivilegeMap.put(sentenceRes, vectorTemp);
            } else if (RelateFrom.equals("2")) {
                Privilege2Sentences.getRelateFrom2Info(conditionInfo, relateFrom2PrivilegeMap_Selector, relateFrom2PrivilegeMap_NonSelector, sentenceRes);
            }
            ++i;
        }
        nextIndex = Privilege2Sentences.getRelateFrom01Sentence(relateFrom0PrivilegeMap, spaces, nextIndex, resSentences, parentIndex);
        nextIndex = Privilege2Sentences.getRelateFrom01Sentence(relateFrom1PrivilegeMap, spaces, nextIndex, resSentences, parentIndex);
        nextIndex = Privilege2Sentences.getRelateFrom2Sentence(relateFrom2PrivilegeMap_Selector, relateFrom2PrivilegeMap_NonSelector, spaces, RelationType, nextIndex, resSentences, parentIndex);
        for (NewRelationGroup childObj : NestConditionGroupObj.getNestConditionGroupObj()) {
            String childIndexStr;
            String relationType = childObj.getRelationType();
            String string = childIndexStr = parentIndex != null ? String.valueOf(parentIndex) + "." + nextIndex : String.valueOf(nextIndex);
            if (relationType.equals("OR")) {
                resSentences.append(spaces).append("[Condition ").append(childIndexStr).append("] ").append(disable2EnableFlag ? AND_STR : OR_STR).append(System.lineSeparator());
            } else if (relationType.equals("AND")) {
                resSentences.append(spaces).append("[Condition ").append(childIndexStr).append("] ").append(disable2EnableFlag ? OR_STR : AND_STR).append(System.lineSeparator());
            }
            ++nextIndex;
            Privilege2Sentences.parseRelation(childObj, level + 1, resSentences, disable2EnableFlag, childIndexStr);
        }
    }

    public static String condition2Sentence(ConditionInfo conditionInfo, boolean disable2EnableFlag) {
        String res = "";
        String RelateFrom = conditionInfo.getRelateFrom();
        String Oper = conditionInfo.getOper();
        String GroupName = conditionInfo.getGroupName();
        String ControlName = conditionInfo.getControlName();
        String ItemName = conditionInfo.getItemName();
        String s_GroupName = GroupName;
        String s_ControlName = ControlName;
        if (!s_GroupName.equals("") && !s_ControlName.equals("")) {
            s_ControlName = "##" + s_ControlName;
        }
        String s_Oper = "";
        switch (Oper) {
            case "Equal": {
                s_Oper = disable2EnableFlag ? NOTEQUAL_STR : EQUAL_STR;
                break;
            }
            case "NotEqual": {
                s_Oper = disable2EnableFlag ? EQUAL_STR : NOTEQUAL_STR;
                break;
            }
            case "Contain": {
                s_Oper = disable2EnableFlag ? NOTCONTAIN_STR : CONTAIN_STR;
                break;
            }
            case "NotContain": {
                s_Oper = disable2EnableFlag ? CONTAIN_STR : NOTCONTAIN_STR;
                break;
            }
            case "GreatEqual": {
                s_Oper = disable2EnableFlag ? LESSTHAN_STR : GREATEQUAL_STR;
                break;
            }
            case "GreatThan": {
                s_Oper = disable2EnableFlag ? LESSEQUAL_STR : GREATTHAN_STR;
                break;
            }
            case "LessEqual": {
                s_Oper = disable2EnableFlag ? GREATTHAN_STR : LESSEQUAL_STR;
                break;
            }
            case "LessThan": {
                s_Oper = disable2EnableFlag ? GREATEQUAL_STR : LESSTHAN_STR;
                break;
            }
        }
        String s_RelateFrom = "";
        switch (RelateFrom) {
            case "0": {
                s_RelateFrom = CONFIGURATION_TAB_STR;
                break;
            }
            case "1": {
                s_RelateFrom = PINOUT_TAB_STR;
                break;
            }
            case "2": {
                s_RelateFrom = CLOCKCONFIGURATION_TAB_STR;
                break;
            }
        }
        ItemName = ItemName.equals("") ? "" : "\"" + ItemName + "\"";
        String s1 = String.valueOf(s_GroupName) + s_ControlName;
        res = s1.equals("") ? "The following peripheral(s)" + s_Oper + ItemName + s_RelateFrom : (RelateFrom.equals("2") ? "The \"" + s_GroupName + s_ControlName + "\"" + " of the following 'Clock Source'" + s_Oper + ItemName + s_RelateFrom : "The \"" + s_GroupName + s_ControlName + "\"" + " of the following peripheral(s)" + s_Oper + ItemName + s_RelateFrom);
        return res;
    }

    public static int getRelateFrom01Sentence(Map<String, Vector<String>> relateFrom01PrivilegeMap, String spaces, int nextIndex, StringBuilder resSentences, String parentIndex) {
        for (Map.Entry<String, Vector<String>> entry : relateFrom01PrivilegeMap.entrySet()) {
            String keyTemp = entry.getKey();
            Vector<String> valueTemp = entry.getValue();
            String indexStr = parentIndex != null ? String.valueOf(parentIndex) + "." + nextIndex : String.valueOf(nextIndex);
            String s = String.valueOf(spaces) + "[Condition " + indexStr + "] ";
            HashMap<String, Vector> mapTemp = new HashMap<String, Vector>();
            int i = 0;
            while (i < valueTemp.size()) {
                boolean hasDigit;
                String value = valueTemp.get(i);
                boolean bl = hasDigit = value != null && value.matches(".*\\d.*");
                if (hasDigit) {
                    String periNameNoIndex = value.replaceAll("\\d+$", "");
                    String periNameIndexStr = value.replaceAll(".*\\D", "");
                    int periNameIndex = -1;
                    if (!periNameIndexStr.isEmpty()) {
                        periNameIndex = Integer.parseInt(periNameIndexStr);
                    }
                    Vector vectorTemp = new Vector();
                    if (mapTemp.containsKey(periNameNoIndex)) {
                        vectorTemp = (Vector)mapTemp.get(periNameNoIndex);
                    }
                    if (periNameIndex != -1) {
                        vectorTemp.add(periNameIndex);
                    }
                    mapTemp.put(periNameNoIndex, vectorTemp);
                } else {
                    mapTemp.put(value, null);
                }
                ++i;
            }
            String periNameStr = "";
            for (Map.Entry entry1 : mapTemp.entrySet()) {
                String key = (String)entry1.getKey();
                Vector vector = (Vector)entry1.getValue();
                if (vector == null || vector.isEmpty()) {
                    periNameStr = String.valueOf(periNameStr) + (periNameStr.equals("") ? key : "," + key);
                    continue;
                }
                String resStr = Privilege2Sentences.getPerinameIndex(vector);
                String keyTempString = "";
                keyTempString = !resStr.contains(",") && !resStr.contains("-") ? String.valueOf(key) + resStr : String.valueOf(key) + "x" + "(x=" + resStr + ")";
                periNameStr = String.valueOf(periNameStr) + (periNameStr.equals("") ? keyTempString : "," + keyTempString);
            }
            resSentences.append(s).append(keyTemp).append(periNameStr).append(System.lineSeparator());
            ++nextIndex;
        }
        return nextIndex;
    }

    public static String getPerinameIndex(Vector<Integer> vector) {
        int start;
        Collections.sort(vector);
        StringBuilder stringBuilder = new StringBuilder();
        int prev = start = vector.get(0).intValue();
        int i = 1;
        while (i < vector.size()) {
            int current = vector.get(i);
            if (current == prev + 1) {
                prev = current;
            } else {
                if (start == prev) {
                    stringBuilder.append(start).append(",");
                } else {
                    stringBuilder.append(start).append("-").append(prev).append(",");
                }
                start = current;
                prev = current;
            }
            ++i;
        }
        if (start == prev) {
            stringBuilder.append(start);
        } else {
            stringBuilder.append(start).append("-").append(prev);
        }
        String res = stringBuilder.toString();
        return res;
    }

    public static void getRelateFrom2Info(ConditionInfo conditionInfo, Map<String, Vector<String>> relateFrom2PrivilegeMap_Selector, Map<String, Vector<String>> relateFrom2PrivilegeMap_NonSelector, String sentenceRes) {
        String ControlName = conditionInfo.getControlName();
        String ItemName = conditionInfo.getItemName();
        Privilege2Sentences.parseClockMap_NonSelector(RCUCondition.RCUClockSourceMap, ControlName, sentenceRes, relateFrom2PrivilegeMap_NonSelector);
        Privilege2Sentences.parseClockMap_NonSelector(RCUCondition.RCUConfigControlMap, ControlName, sentenceRes, relateFrom2PrivilegeMap_NonSelector);
        Privilege2Sentences.parseClockMap_Selector(RCUCondition.RCUConfigControlGroupMap, ControlName, ItemName, relateFrom2PrivilegeMap_Selector);
    }

    public static void parseClockMap_NonSelector(Map<String, ?> clockMap, String controlName, String sentenceRes, Map<String, Vector<String>> privilegeMap) {
        if (clockMap.size() > 0) {
            for (Map.Entry<String, ?> entry : clockMap.entrySet()) {
                if (entry.getValue() == null || !controlName.equals(entry.getKey())) continue;
                Vector<String> vectorTemp = privilegeMap.getOrDefault(sentenceRes, new Vector());
                vectorTemp.add(controlName);
                privilegeMap.put(sentenceRes, vectorTemp);
            }
        }
    }

    public static void parseClockMap_Selector(Map<String, RCUConfigControlGroup> clockMap, String controlName, String itemName, Map<String, Vector<String>> privilegeMap) {
        if (clockMap.size() > 0) {
            for (Map.Entry<String, RCUConfigControlGroup> entry : clockMap.entrySet()) {
                TreeSet controlSet;
                String type;
                if (entry.getValue() == null || !controlName.equals(entry.getKey()) || !(type = entry.getValue().getType()).toUpperCase().equals("SELECTOR") || (controlSet = entry.getValue().GetControlSet()).isEmpty()) continue;
                for (String selectorItemName : controlSet) {
                    if (!itemName.equals(selectorItemName)) continue;
                    String clockInputName = entry.getValue().getClockInputName(selectorItemName);
                    Vector<String> vectorTemp = privilegeMap.getOrDefault(clockInputName, new Vector());
                    vectorTemp.add(controlName);
                    privilegeMap.put(clockInputName, vectorTemp);
                }
            }
        }
    }

    public static int getRelateFrom2Sentence(Map<String, Vector<String>> relateFrom2PrivilegeMap_Selector, Map<String, Vector<String>> relateFrom2PrivilegeMap_NonSelector, String spaces, String RelationType, int nextIndex, StringBuilder resSentences, String parentIndex) {
        Vector<String> valueTemp;
        String keyTemp;
        for (Map.Entry<String, Vector<String>> entry : relateFrom2PrivilegeMap_NonSelector.entrySet()) {
            keyTemp = entry.getKey();
            valueTemp = entry.getValue();
            String indexStr = parentIndex != null ? String.valueOf(parentIndex) + "." + nextIndex : String.valueOf(nextIndex);
            String s = String.valueOf(spaces) + "[Condition " + indexStr + "] ";
            String s1 = "";
            int i = 0;
            while (i < valueTemp.size()) {
                String valueTempValue = valueTemp.get(i);
                s1 = String.valueOf(s1) + (i == 0 ? valueTempValue : "," + valueTempValue);
                ++i;
            }
            resSentences.append(s).append(keyTemp).append(s1).append(System.lineSeparator());
            ++nextIndex;
        }
        for (Map.Entry<String, Vector<String>> entry : relateFrom2PrivilegeMap_Selector.entrySet()) {
            keyTemp = entry.getKey();
            valueTemp = entry.getValue();
            String selectorName = "\"";
            int j = 0;
            while (j < valueTemp.size()) {
                String selectorNameTemp = valueTemp.get(j);
                selectorName = String.valueOf(selectorName) + (j == 0 ? selectorNameTemp : "," + selectorNameTemp);
                ++j;
            }
            selectorName = String.valueOf(selectorName) + "\"";
            String indexStr = parentIndex != null ? String.valueOf(parentIndex) + "." + nextIndex : String.valueOf(nextIndex);
            String s = String.valueOf(spaces) + "[Condition " + indexStr + "] ";
            String s1 = "";
            if (RelationType.equals("OR")) {
                s1 = valueTemp.size() == 1 ? "The " + selectorName + " selector should to be selected " + "\"" + keyTemp + "\"" + "." : "One of the " + selectorName + " selectors should to be selected " + "\"" + keyTemp + "\"" + ".";
            } else if (RelationType.equals("AND")) {
                s1 = valueTemp.size() == 1 ? "The " + selectorName + " selector should to be selected " + "\"" + keyTemp + "\"" + "." : "All of the " + selectorName + " selectors should to be selected " + "\"" + keyTemp + "\"" + ".";
            }
            resSentences.append(s).append(s1).append(System.lineSeparator());
            ++nextIndex;
        }
        return nextIndex;
    }

    public static String getFIRST_STR() {
        return FIRST_STR;
    }

    public static String getAND_STR() {
        return AND_STR;
    }

    public static String getOR_STR() {
        return OR_STR;
    }
}

