/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.conflict;

import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.NVICConflictExecute;
import com.gigadevice.conflict.baseinfo.ConflictBitInfo;
import com.gigadevice.conflict.baseinfo.ConflictControlInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.ExtendFunctionNodeInfo;
import com.gigadevice.conflict.baseinfo.ExtendNodeListInfo;
import com.gigadevice.conflict.reflectionfunction.PeriParaTreeFunctionExecute;
import com.gigadevice.conflict.tool.ExtendNodeWork;
import com.gigadevice.conflict.util.ConflictUtil;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.baseinfo.jtreenode.JTreeComboxNode;
import com.gigadevice.venustool.baseinfo.jtreenode.JTreeTextNode;
import com.gigadevice.venustool.controlconflict.ControlConflict;
import com.gigadevice.venustool.controlconflict.PeriParaTreeConflict;
import com.gigadevice.venustool.mcubasestruct.ControlStruct;
import com.gigadevice.venustool.mcubasestruct.ItemStruct;
import com.gigadevice.venustool.mcubasestruct.ModuleStruct;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import com.gigadevice.venustool.mcubasestruct.WidgetNodeStruct;
import com.gigadevice.venustool.periconfigbasestruct.GeneralPariParaNodeItemStruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConflictExecute {
    public static void initPeriTreeConflict(String PeriName) {
        if (ConflictUtil.disableConflict) {
            return;
        }
        ConflictUtil.conflictIsSetDefaultValueInPinout = false;
        ConflictExecute.initControlConflictInfo(PeriName, "1");
        ConflictUtil.conflictIsSetDefaultValueInPinout = true;
    }

    public static void initPeriConfigConflict(String PeriName) {
        if (ConflictUtil.disableConflict) {
            return;
        }
        ConflictExecute.initControlConflictInfo(PeriName, "0");
    }

    public static void initAllControlConflictInfo(String PeriName) {
        if (!ConflictUtil.PeriConflictInfos.containsKey(PeriName)) {
            return;
        }
        List<String> ConflictGroupKeys = ConflictUtil.PeriConflictInfos.get(PeriName).getConflictGroupKeys();
        for (String key : ConflictGroupKeys) {
            ConflictGroupInfo conflictGroupObj;
            if (!ConflictUtil.ConflictGroupInfos.containsKey(key) || !(conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(key)).getControledControl().getRelateFrom().equals("0")) continue;
            ConflictExecute.ExecuteSingleConflict(conflictGroupObj);
        }
    }

    public static void initControlConflictInfo(String PeriName, String relateForm) {
        if (!ConflictUtil.PeriConflictInfos.containsKey(PeriName)) {
            return;
        }
        if (relateForm.equals("0")) {
            ConflictExecute.initPeriConfigAllGroupConflict(PeriName);
        } else {
            List<String> ConflictGroupKeys = ConflictUtil.PeriConflictInfos.get(PeriName).getConflictGroupKeys();
            for (String key : ConflictGroupKeys) {
                ConflictGroupInfo conflictGroupObj;
                if (!ConflictUtil.ConflictGroupInfos.containsKey(key) || !(conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(key)).getControledControl().getRelateFrom().equals(relateForm)) continue;
                ConflictExecute.ExecuteSingleConflict(conflictGroupObj);
            }
        }
    }

    private static void initPeriConfigAllGroupConflict(String PeriName) {
        List<Object> GroupNodeConflictKeys = new ArrayList();
        if (ConflictUtil.periAndConfigGroupTypeConflictMap.containsKey(PeriName)) {
            GroupNodeConflictKeys = ConflictUtil.periAndConfigGroupTypeConflictMap.get(PeriName);
            for (String string : GroupNodeConflictKeys) {
                if (!ConflictUtil.ConflictGroupInfos.containsKey(string)) continue;
                ConflictGroupInfo conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(string);
                ConflictExecute.ExecuteSingleConflict(conflictGroupObj);
            }
        }
        if (ConflictUtil.periGroupAndChildsConflictMap.containsKey(PeriName)) {
            Map<String, List<String>> map = ConflictUtil.periGroupAndChildsConflictMap.get(PeriName);
            block1: for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                List<String> childConditionList = entry.getValue();
                for (String key : childConditionList) {
                    if (!ConflictUtil.ConflictGroupInfos.containsKey(key)) continue;
                    ConflictGroupInfo conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(key);
                    String tmpGroupName = conflictGroupObj.getControledControl().getGroupName();
                    AbstractJTreeNode controlNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)tmpGroupName, (String)"");
                    if (controlNode == null || !controlNode.isVisible()) continue block1;
                    ConflictExecute.ExecuteSingleConflict(conflictGroupObj);
                }
            }
        }
    }

    private static void initAllNonGroupConflictByInGroup(String periName, String groupNameKey) {
        Map<String, List<String>> groupAndChildsConflictMap;
        if (ConflictUtil.periGroupAndChildsConflictMap.containsKey(periName) && (groupAndChildsConflictMap = ConflictUtil.periGroupAndChildsConflictMap.get(periName)).containsKey(groupNameKey)) {
            List<String> childConditionList = groupAndChildsConflictMap.get(groupNameKey);
            for (String key : childConditionList) {
                if (!ConflictUtil.ConflictGroupInfos.containsKey(key)) continue;
                ConflictGroupInfo conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(key);
                ConflictExecute.ExecuteSingleConflict(conflictGroupObj);
            }
        }
    }

    public static void ConflictExecuteByPeriTree(String PeriName, String ControlName, String ItemName, boolean OperType) {
        if (!OperType) {
            return;
        }
        ConflictExecute.ExecuteConflictBySource("1", PeriName, "", ControlName, ItemName);
    }

    public static void ConflictExecuteByPeriConfig(String PeriName, String GroupName, String ControlName, String ItemName, boolean OperType) {
        if (!OperType) {
            return;
        }
        ConflictExecute.ExecuteConflictBySource("0", PeriName, GroupName, ControlName, ItemName);
        if (PeriName != null && GroupName != null && ControlName != null && PeriName.equals("TRIGSEL") && GroupName.equals("TRIGSELConfiguration") && ControlName.equals("Group")) {
            ConflictExecute.initPeriConfigConflict("TRIGSEL");
        }
    }

    public static void ConflictExecuteByPeriConfigTemp(String PeriName, String GroupName, String ControlName, String ItemName, boolean OperType) {
        if (!OperType) {
            return;
        }
        ConflictUtil.conflictIsTempPeriConfigSource = true;
        ConflictExecute.ConflictExecuteByPeriConfig(PeriName, GroupName, ControlName, ItemName, OperType);
        ConflictUtil.conflictIsTempPeriConfigSource = false;
    }

    public static void crossPeriConflictExecuteByPeriConfig(String PeriName, String GroupName, String ControlName, String ItemName, boolean OperType) {
        if (!OperType) {
            return;
        }
        ConflictUtil.excuteCrossPeriConflict = true;
        ConflictUtil.crossPeriSource = PeriName;
        ConflictExecute.ConflictExecuteByPeriConfig(PeriName, GroupName, ControlName, ItemName, OperType);
        ConflictUtil.excuteCrossPeriConflict = false;
    }

    public static void ConflictExecuteByPin() {
    }

    public static void ConflictExecuteByGPIO() {
        NVICConflictExecute.NVICConflictExecuteByPin("");
    }

    public static void ConflictExecuteByClock() {
        if (ConflictUtil.UserAndConflictGroupInfo == null) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : ConflictUtil.UserAndConflictGroupInfo.entrySet()) {
            String conditionSource = entry.getKey();
            String str = conditionSource;
            if (str.length() > 3) {
                str = str.substring(0, 3);
            }
            if (!str.contains("2##")) continue;
            ConflictExecute.ExecuteConflictBySourceStr(conditionSource);
        }
    }

    public static void ConflictExecuteByClockControl(String ClockControlName) {
        if (ConflictUtil.UserAndConflictGroupInfo == null) {
            return;
        }
        String conditionSource = "2##" + ClockControlName;
        if (!ConflictUtil.UserAndConflictGroupInfo.containsKey(conditionSource)) {
            return;
        }
        ConflictExecute.ExecuteConflictBySourceStr(conditionSource);
    }

    public static void ExecuteConflictBySource(String Relateform, String PeriName, String GroupName, String ControlName, String ItemName) {
        if (ConflictUtil.disableConflict) {
            return;
        }
        if (ConflictUtil.UserAndConflictGroupInfo == null) {
            return;
        }
        List<String> ConditionList = ConflictUtil.GetConditionSourceList(Relateform, PeriName, GroupName, ControlName, ItemName);
        int i = 0;
        while (i < ConditionList.size()) {
            String Condition = ConditionList.get(i);
            if (Relateform.equals("0")) {
                ConflictExecute.ExecuteConflictByPeriConfigSourceStr(PeriName, Condition);
            } else {
                ConflictExecute.ExecuteConflictBySourceStr(Condition);
            }
            ++i;
        }
    }

    public static void ExecuteConflictBySourceStr(String Condition) {
        if (ConflictUtil.UserAndConflictGroupInfo == null) {
            return;
        }
        if (ConflictUtil.UserAndConflictGroupInfo.containsKey(Condition)) {
            List<String> UserGroup = ConflictUtil.UserAndConflictGroupInfo.get(Condition);
            for (String key : UserGroup) {
                if (!ConflictUtil.ConflictGroupInfos.containsKey(key)) continue;
                ConflictGroupInfo conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(key);
                ConflictExecute.ExecuteSingleConflict(conflictGroupObj);
            }
        }
    }

    public static void ExecuteConflictByPeriConfigSourceStr(String sourcePeriName, String Condition) {
        if (ConflictUtil.UserAndConflictGroupInfo == null) {
            return;
        }
        if (ConflictUtil.UserAndConflictGroupInfo.containsKey(Condition)) {
            List<String> UserGroup = ConflictUtil.UserAndConflictGroupInfo.get(Condition);
            for (String key : UserGroup) {
                String PeriName;
                if (!ConflictUtil.ConflictGroupInfos.containsKey(key)) continue;
                ConflictGroupInfo conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(key);
                if (ConflictUtil.conflictIsTempPeriConfigSource && !(PeriName = conflictGroupObj.getControledControl().getPeriName()).equals("NVIC") && !sourcePeriName.equals(PeriName) && !GlobalVariables.getMwPeriName((String)sourcePeriName).equals(GlobalVariables.getMwPeriName((String)PeriName)) || ConflictUtil.excuteCrossPeriConflict && ConflictUtil.crossPeriSource.equals(PeriName = conflictGroupObj.getControledControl().getPeriName())) continue;
                ConflictExecute.ExecuteSingleConflict(conflictGroupObj);
            }
        }
    }

    public static void ExecuteSingleConflict(ConflictGroupInfo conflictGroupObj) {
        ConflictControlInfo ConflictControlObj = conflictGroupObj.getControledControl();
        String Privilege = ConflictControlObj.getPrivilege();
        String Relateform = ConflictControlObj.getRelateFrom();
        String PeriName = ConflictControlObj.getPeriName();
        String GroupName = ConflictControlObj.getGroupName();
        String ControlName = ConflictControlObj.getControlName();
        String ControlType2 = ConflictControlObj.getControlType();
        String ItemName = ConflictControlObj.getItemName();
        if (!ConflictCheck.checkIsExecute(conflictGroupObj)) {
            return;
        }
        boolean type = true;
        if (!ConflictCheck.ConditionCheck(conflictGroupObj)) {
            type = false;
        }
        if (Relateform.equals("1")) {
            ConflictExecute.UpdateStateInPeriTree(PeriName, ControlName, ItemName, ControlType2, Privilege, type);
            ConflictExecute.checkRelatePeriTreeControlList(PeriName, ControlName, ItemName, ControlType2, Privilege, type);
        } else if (Relateform.equals("0")) {
            if (ControlType2.equals("Item")) {
                boolean conflictIsPeriConfigSource = ConflictUtil.conflictIsTempPeriConfigSource;
                ConflictExecute.UpdateItemInPeriConfig(PeriName, GroupName, ControlName, ItemName, Privilege, type, false);
                ConflictUtil.conflictIsTempPeriConfigSource = conflictIsPeriConfigSource;
                if (!ConflictUtil.conflictIsTempPeriConfigSource && !ConflictUtil.conflictIsDeSerialize || GlobalVariables.isCubeRoverTest) {
                    ConflictExecute.UpdateItemInPeriConfig(PeriName, GroupName, ControlName, ItemName, Privilege, type, true);
                    ConflictUtil.conflictIsTempPeriConfigSource = conflictIsPeriConfigSource;
                }
            } else {
                boolean conflictIsPeriConfigSource = ConflictUtil.conflictIsTempPeriConfigSource;
                ConflictExecute.UpdateControlInPeriConfig(ConflictControlObj, type, false);
                ConflictUtil.conflictIsTempPeriConfigSource = conflictIsPeriConfigSource;
                if (!ConflictUtil.conflictIsTempPeriConfigSource && !ConflictUtil.conflictIsDeSerialize || GlobalVariables.isCubeRoverTest) {
                    ConflictExecute.UpdateControlInPeriConfig(ConflictControlObj, type, true);
                    ConflictUtil.conflictIsTempPeriConfigSource = conflictIsPeriConfigSource;
                }
            }
        } else if (Relateform.equals("4")) {
            NVICConflictExecute.UpdateStateInNVIC(PeriName, GroupName, ControlName, ItemName, ControlType2, Privilege, type);
            if (!ConflictUtil.conflictIsNVICSource) {
                NVICConflictExecute.UpdateStateInNVICApply(PeriName, GroupName, ControlName, ItemName, ControlType2, Privilege, type);
            }
        } else if (Relateform.equals("5")) {
            ConflictExecute.UpdatePINState(PeriName, GroupName, ControlName, ItemName, ControlType2, Privilege, type);
        }
    }

    private static void UpdateStateInPeriTree(String PeriName, String ControlName, String ItemName, String ControlType2, String Privilege, boolean type) {
        Object object;
        if (!ConflictUtil.ConflictBitInfos.containsKey(Privilege)) {
            return;
        }
        ConflictBitInfo conflictBitObj = ConflictUtil.ConflictBitInfos.get(Privilege);
        int bitNo = conflictBitObj.getBit();
        int value = conflictBitObj.getValue();
        if (!type) {
            value ^= 1;
        }
        if (ControlName.toUpperCase().equals("ALL") || ControlType2.equals("Module")) {
            if (GlobalVariables.MCUObj.getModules().containsKey(PeriName)) {
                int newState;
                ModuleStruct moduleObj = (ModuleStruct)GlobalVariables.MCUObj.getModules().get(PeriName);
                int currentState = moduleObj.getState();
                if (currentState == (newState = ConflictUtil.getNodeState(bitNo, value, currentState))) {
                    return;
                }
                moduleObj.setState(newState);
            }
            return;
        }
        String itemStr = ItemName;
        if (itemStr.toUpperCase().equals("TRUE") || itemStr.toUpperCase().equals("FALSE") || Privilege.equals("UpdateValue") || Privilege.equals("SetDefaultValue")) {
            itemStr = "";
        }
        if ((object = ControlConflict.getPeriTreeNode((String)PeriName, (String)ControlName, (String)itemStr, (String)ControlType2)) == null) {
            return;
        }
        if (ControlType2.equals("Node")) {
            int currentState;
            NodeStruct nodeObj = (NodeStruct)object;
            if (Privilege.equals("UpdateValue") && type) {
                if (nodeObj.getValue().equals(ItemName)) {
                    return;
                }
                nodeObj.setValue(ItemName);
                ConflictExecute.PeriTreeMapUpdate(PeriName, nodeObj);
                ConflictExecute.ConflictExecuteByPeriTree(PeriName, ControlName, ItemName, true);
                return;
            }
            if (Privilege.equals("SetDefaultValue") && type) {
                if (!ConflictUtil.conflictIsSetDefaultValueInPinout) {
                    return;
                }
                nodeObj.setDefaultvalue(ItemName);
                String configValue = nodeObj.getValue();
                if (nodeObj.getValue().equals(ItemName)) {
                    return;
                }
                GlobalVariables.relationUpdateNode.add(nodeObj);
                nodeObj.setValue(ItemName);
                ConflictExecute.ConflictExecuteByPeriTree(PeriName, ControlName, ItemName, true);
                nodeObj.setValue(configValue);
                return;
            }
            int newState = currentState = nodeObj.getState();
            newState = bitNo == 0 ? ConflictUtil.getPeriTreeEnableState(5, value, currentState) : ConflictUtil.getNodeState(bitNo, value, currentState);
            if (currentState == newState) {
                return;
            }
            nodeObj.setState(newState);
        } else if (ControlType2.equals("Control")) {
            int newState;
            ControlStruct controlObj = (ControlStruct)object;
            int currentState = controlObj.getState();
            if (currentState == (newState = ConflictUtil.getNodeState(bitNo, value, currentState))) {
                return;
            }
            controlObj.setState(newState);
        } else if (ControlType2.equals("Item")) {
            int currentState;
            ItemStruct itemObj = (ItemStruct)object;
            int newState = currentState = itemObj.getState();
            newState = bitNo == 0 ? ConflictUtil.getPeriTreeEnableState(5, value, currentState) : ConflictUtil.getNodeState(bitNo, value, currentState);
            if (currentState == newState) {
                return;
            }
            itemObj.setState(newState);
        }
    }

    private static void UpdateItemInPeriConfig(String PeriName, String GroupName, String ControlName, String ItemContent, String Privilege, boolean type, boolean isApplyNode) {
        JTreeComboxNode comBox;
        Map itemList;
        AbstractJTreeNode controlNode = null;
        controlNode = isApplyNode ? (AbstractJTreeNode)PeriParaTreeConflict.getPeriApplyConfigNode((String)PeriName, (String)GroupName, (String)ControlName) : (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
        if (controlNode == null) {
            return;
        }
        if (!ConflictUtil.ConflictBitInfos.containsKey(Privilege)) {
            return;
        }
        if (Privilege.equals("UpdateValue") && type) {
            ConflictExecute.excuteUpdateValue(controlNode, ItemContent, PeriName, GroupName, ControlName);
            return;
        }
        if (Privilege.equals("SetDefaultValue") && type) {
            controlNode.setDefaultValue(ItemContent);
            return;
        }
        if (controlNode.getType() != 2) {
            return;
        }
        ConflictBitInfo conflictBitObj = ConflictUtil.ConflictBitInfos.get(Privilege);
        int bitNo = conflictBitObj.getBit();
        int value = conflictBitObj.getValue();
        if (!type) {
            value ^= 1;
        }
        if (!(itemList = (comBox = (JTreeComboxNode)controlNode).getPossibleValueList()).containsKey(ItemContent)) {
            return;
        }
        GeneralPariParaNodeItemStruct itemNode = (GeneralPariParaNodeItemStruct)itemList.get(ItemContent);
        int currentState = itemNode.getState();
        int newState = ConflictUtil.getNodeState(bitNo, value, currentState);
        itemNode.setState(newState);
        if (ConflictUtil.conflictIsCheckItem) {
            return;
        }
        GeneralPariParaNodeItemStruct configItemNode = (GeneralPariParaNodeItemStruct)itemList.get(controlNode.getValue());
        if (configItemNode == null) {
            return;
        }
        if (!configItemNode.isVisible() || !configItemNode.isEnable()) {
            ConflictExecute.UpdateControlConfigValidValue(PeriName, GroupName, ControlName, isApplyNode);
        }
    }

    private static void UpdateControlInPeriConfig(ConflictControlInfo ConflictControlObj, boolean type, boolean isApplyNode) {
        String PeriName = ConflictControlObj.getPeriName();
        String GroupName = ConflictControlObj.getGroupName();
        String ControlName = ConflictControlObj.getControlName();
        String Privilege = ConflictControlObj.getPrivilege();
        String ItemName = ConflictControlObj.getItemName();
        AbstractJTreeNode controlNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
        controlNode = isApplyNode ? (AbstractJTreeNode)PeriParaTreeConflict.getPeriApplyConfigNode((String)PeriName, (String)GroupName, (String)ControlName) : (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
        if (controlNode == null) {
            return;
        }
        if (!ConflictUtil.ConflictBitInfos.containsKey(Privilege)) {
            return;
        }
        if (Privilege.equals("UpdateValue")) {
            if (!type) {
                return;
            }
            if (controlNode.ifHasFunction()) {
                if (controlNode.getFuntion().getType().equals("retString")) {
                    Object result = PeriParaTreeFunctionExecute.ReturnFunctionNodeValue(controlNode.getFuntion());
                    if (result != null) {
                        ConflictExecute.excuteUpdateValue(controlNode, result.toString(), PeriName, GroupName, ControlName);
                    }
                } else if (controlNode.getFuntion().getType().equals("Execute")) {
                    PeriParaTreeFunctionExecute.ExecuteFuction(controlNode.getFuntion().getInterFace());
                }
            } else if (!ConflictControlObj.getOperType().equals("")) {
                ExtendNodeListInfo extendNodeListInfo = ConflictControlObj.getExtendNodeListInfo();
                Object result = ExtendNodeWork.getExtendNodeResult(extendNodeListInfo, ConflictControlObj.getOperType(), "UpdateValue");
                if (result == null) {
                    return;
                }
                ConflictExecute.excuteUpdateValue(controlNode, result.toString(), PeriName, GroupName, ControlName);
            } else {
                ConflictExecute.excuteUpdateValue(controlNode, ItemName, PeriName, GroupName, ControlName);
            }
            return;
        }
        if (Privilege.contains("SET_")) {
            if (!type) {
                return;
            }
            String updateValue = ConflictControlObj.getItemName();
            String updateKey = Privilege.replace("SET_", "");
            ((JTreeTextNode)controlNode).setNodeinfoValue(updateKey, updateValue);
            return;
        }
        if (Privilege.equals("SetDefaultValue") && type) {
            controlNode.setDefaultValue(ItemName);
            return;
        }
        if (Privilege.equals("SetMinMax")) {
            String[] operType;
            if (!type) {
                return;
            }
            String minValue = ConflictControlObj.getMinValue();
            String maxValue = ConflictControlObj.getMaxValue();
            String operTypeStr = ConflictControlObj.getOperType();
            if (!operTypeStr.equals("") && (operType = operTypeStr.split("_")).length >= 2) {
                int i = 0;
                while (i < 2) {
                    String cOperType = operType[i];
                    if (!cOperType.equals("*")) {
                        ExtendNodeListInfo extendNodeListInfo;
                        Object result;
                        String operName = "SetMin";
                        if (i == 1) {
                            operName = "SetMax";
                        }
                        if ((result = ExtendNodeWork.getExtendNodeResult(extendNodeListInfo = ConflictControlObj.getExtendNodeListInfo(), cOperType, operName)) != null) {
                            if (operName.equals("SetMin")) {
                                minValue = result.toString();
                            } else if (operName.equals("SetMax")) {
                                maxValue = result.toString();
                            }
                        }
                    }
                    ++i;
                }
            }
            ((JTreeTextNode)controlNode).setMinStr(minValue);
            ((JTreeTextNode)controlNode).setMaxStr(maxValue);
            return;
        }
        if (Privilege.equals("CheckValue")) {
            if (!type) {
                return;
            }
            String operTypeStr = ConflictControlObj.getOperType();
            if (operTypeStr.equals("F")) {
                ExtendNodeListInfo extendNodeListInfo = ConflictControlObj.getExtendNodeListInfo();
                Object result = ExtendNodeWork.getExtendNodeResult(extendNodeListInfo, ConflictControlObj.getOperType(), "CheckValue");
                if (result == null) {
                    return;
                }
                ExtendFunctionNodeInfo funcObj = ConflictControlObj.getExtendNodeListInfo().getFunctionNode("CheckValue");
                Boolean resultBoolean = (Boolean)result;
                if (!resultBoolean.booleanValue()) {
                    controlNode.setError(true);
                    controlNode.setAddMessage(funcObj.getTips());
                    return;
                }
                controlNode.setError(false);
                controlNode.setAddMessage(funcObj.getTips());
                return;
            }
            return;
        }
        ConflictBitInfo conflictBitObj = ConflictUtil.ConflictBitInfos.get(Privilege);
        int bitNo = conflictBitObj.getBit();
        int value = conflictBitObj.getValue();
        if (!type) {
            value ^= 1;
        }
        int currentState = controlNode.getState();
        boolean isVisibleOld = controlNode.isVisible();
        String oldValue = controlNode.getValue();
        int newState = ConflictUtil.getNodeState(bitNo, value, currentState);
        if (currentState == newState) {
            if (controlNode.getType() == 0 && currentState == 0 && newState == 0 && controlNode.isInitState()) {
                controlNode.setInitState(false);
                ConflictExecute.ConflictExecuteByPeriConfig(PeriName, GroupName, ControlName, "", true);
            }
            return;
        }
        controlNode.setState(newState);
        List valueChangeList = null;
        if (!GlobalVariables.isCubeRoverTest && ConflictUtil.conflictIsSetValue && !controlNode.isVisible()) {
            valueChangeList = controlNode.updateValueToDefaultValue();
        }
        boolean isVisibleNew = controlNode.isVisible();
        if (controlNode.getType() == 0) {
            ConflictExecute.ConflictExecuteByPeriConfig(PeriName, GroupName, "", "", true);
            if (!isVisibleOld && isVisibleNew) {
                ConflictExecute.initAllNonGroupConflictByInGroup(PeriName, String.valueOf(PeriName) + "##" + GroupName);
            }
            if (valueChangeList != null) {
                for (String conditionStr : valueChangeList) {
                    ConflictExecute.ExecuteConflictBySourceStr("0##" + conditionStr);
                }
            }
            ConflictExecute.ExecuteGroupAllChildrenPrivilege(PeriName, GroupName, isVisibleNew);
        } else {
            boolean flag = false;
            String newValue = controlNode.getValue();
            if (!oldValue.equals(newValue) || isVisibleOld != isVisibleNew) {
                flag = true;
            }
            if (flag) {
                ConflictExecute.ConflictExecuteByPeriConfig(PeriName, GroupName, ControlName, controlNode.getValue(), true);
            }
        }
    }

    private static void checkRelatePeriTreeControlList(String PeriName, String ControlName, String ItemName, String ControlType2, String Privilege, boolean type) {
        if (GlobalVariables.isCubeRoverTest) {
            return;
        }
        if (!ControlType2.equals("Node")) {
            ConflictExecute.checkRelatePeriTreeItem(PeriName, ControlName, ItemName, ControlType2, Privilege, type);
            return;
        }
        Object object = ControlConflict.getPeriTreeNode((String)PeriName, (String)ControlName, (String)"", (String)"Node");
        if (object == null) {
            return;
        }
        NodeStruct nodeObj = (NodeStruct)object;
        int state = nodeObj.getState();
        int enable = state & 1;
        int visable = state >> 1 & 1;
        if (enable == 0 && visable == 0) {
            return;
        }
        String configValue = nodeObj.getValue();
        String defaultValue = "";
        defaultValue = nodeObj.getType() == ConstantsUtil.ControlType.CheckBox.ordinal() ? "false" : ControlConflict.getNodeFirstItem((WidgetNodeStruct)nodeObj);
        if (!defaultValue.equals(configValue) && !GlobalVariables.relationUpdateNode.contains(nodeObj)) {
            GlobalVariables.relationUpdateNode.add(nodeObj);
            nodeObj.setValue(defaultValue);
            ConflictExecute.ConflictExecuteByPeriTree(PeriName, ControlName, defaultValue, true);
            nodeObj.setValue(configValue);
        }
    }

    private static void checkRelatePeriTreeItem(String PeriName, String ControlName, String ItemName, String ControlType2, String Privilege, boolean type) {
        if (!ControlType2.equals("Item")) {
            return;
        }
        Object object = ControlConflict.getPeriTreeNode((String)PeriName, (String)ControlName, (String)"", (String)"Node");
        if (object == null) {
            return;
        }
        NodeStruct nodeObj = (NodeStruct)object;
        String configValue = nodeObj.getValue();
        if (ItemName.equals(configValue) && (Privilege.equals("Disable") && type || Privilege.equals("Enable") && !type)) {
            String defaultValue = "";
            if (nodeObj.getType() == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                defaultValue = "false";
            } else if (nodeObj.getType() == ConstantsUtil.ControlType.Combox.ordinal()) {
                defaultValue = ControlConflict.getNodeDefaultItem((WidgetNodeStruct)nodeObj);
            }
            if (!defaultValue.equals(configValue) && !GlobalVariables.relationUpdateNode.contains(nodeObj)) {
                GlobalVariables.relationUpdateNode.add(nodeObj);
                nodeObj.setValue(defaultValue);
                ConflictExecute.ConflictExecuteByPeriTree(PeriName, ControlName, defaultValue, true);
                nodeObj.setValue(configValue);
            }
        }
    }

    public static boolean getPeriConfigControlCheckValueResult(String PeriName, String GroupName, String ControlName) {
        if (ConflictUtil.disableConflict) {
            return true;
        }
        if (ConflictUtil.UserAndConflictGroupInfo == null) {
            return true;
        }
        String Condition = "0##" + PeriName + "##" + GroupName + "##" + ControlName;
        if (ConflictUtil.UserAndConflictGroupInfo.containsKey(Condition)) {
            List<String> UserGroup = ConflictUtil.UserAndConflictGroupInfo.get(Condition);
            for (String key : UserGroup) {
                String operTypeStr;
                ConflictGroupInfo conflictGroupObj;
                if (!ConflictUtil.ConflictGroupInfos.containsKey(key) || !ConflictCheck.ConditionCheck(conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(key))) continue;
                ConflictControlInfo ConflictControlObj = conflictGroupObj.getControledControl();
                String Privilege = ConflictControlObj.getPrivilege();
                String ControlType2 = ConflictControlObj.getControlType();
                if (!Privilege.equals("CheckValue") || !ControlType2.equals("Control")) continue;
                String strPeriName = ConflictControlObj.getPeriName();
                String strGroupName = ConflictControlObj.getGroupName();
                String strControlName = ConflictControlObj.getControlName();
                if (!strPeriName.equals(PeriName) || !strGroupName.equals(GroupName) || !strControlName.equals(ControlName) || !(operTypeStr = ConflictControlObj.getOperType()).equals("F")) continue;
                ExtendNodeListInfo extendNodeListInfo = ConflictControlObj.getExtendNodeListInfo();
                Object result = ExtendNodeWork.getExtendNodeResult(extendNodeListInfo, ConflictControlObj.getOperType(), "CheckValue");
                if (result == null) {
                    return true;
                }
                AbstractJTreeNode controlNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
                ExtendFunctionNodeInfo funcObj = ConflictControlObj.getExtendNodeListInfo().getFunctionNode("CheckValue");
                controlNode.setAddMessage(funcObj.getTips());
                Boolean resultBoolean = (Boolean)result;
                if (resultBoolean.booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static void ExecuteSpecialGroupPrivilege(String PeriName, String GroupName, String ControlName, String ItemName, boolean OperType) {
        if (!OperType) {
            return;
        }
        boolean isSpecialCondition = false;
        if (PeriName != null && GroupName != null && ControlName != null && ItemName != null && GroupName.equals("GeneralConfiguration") && PeriName.contains("USBHS") && ControlName.equals("InternalDMA") && ItemName.equals("Disable")) {
            isSpecialCondition = true;
        }
        if (!isSpecialCondition) {
            return;
        }
        boolean result = true;
        int i = 0;
        while (i < 2) {
            String value;
            String usbfsPeriName = "USBHS" + String.valueOf(i);
            AbstractJTreeNode controlNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)usbfsPeriName, (String)GroupName, (String)ControlName);
            if (controlNode != null && (value = controlNode.getValue()).equals("Enable")) {
                result = false;
                break;
            }
            ++i;
        }
        if (result) {
            ConflictExecute.UpdateStateInPeriTree("SYS", "CPU D Cache Disable", "false", "Node", "UpdateValue", true);
        }
    }

    private static void PeriTreeMapUpdate(String strPeripheral, NodeStruct node) {
        String defaultValue = ControlConflict.getNodeDefaultItem((WidgetNodeStruct)node);
        if (!defaultValue.equals(node.getValue())) {
            ConflictExecute.PeriTreeMapInsert(strPeripheral, node);
        } else {
            ConflictExecute.PeriTreeMapDelete(strPeripheral, node);
        }
    }

    public static void PeriTreeMapInsert(String strPeripheral, NodeStruct node) {
        HashMap<String, NodeStruct> map = new HashMap<String, NodeStruct>();
        String nodeName = node.getNodeName();
        if (node.getParentNode() != null) {
            nodeName = ControlConflict.getNodePath((NodeStruct)node, (String)"");
        }
        if (GlobalVariables.PeripheralConfigObjMap.containsKey(strPeripheral)) {
            ((Map)GlobalVariables.PeripheralConfigObjMap.get(strPeripheral)).put(nodeName, node);
        } else {
            map.put(nodeName, node);
            GlobalVariables.PeripheralConfigObjMap.put(strPeripheral, map);
            ConflictExecute.initPeriConfigConflict(strPeripheral);
        }
    }

    private static void PeriTreeMapDelete(String strPeripheral, NodeStruct node) {
        String nodeName = node.getNodeName();
        if (node.getParentNode() != null) {
            nodeName = ControlConflict.getNodePath((NodeStruct)node, (String)"");
        }
        if (GlobalVariables.PeripheralConfigObjMap.containsKey(strPeripheral)) {
            if (((Map)GlobalVariables.PeripheralConfigObjMap.get(strPeripheral)).size() > 0) {
                ((Map)GlobalVariables.PeripheralConfigObjMap.get(strPeripheral)).remove(nodeName);
                if (((Map)GlobalVariables.PeripheralConfigObjMap.get(strPeripheral)).size() == 0) {
                    GlobalVariables.PeripheralConfigObjMap.remove(strPeripheral);
                }
            } else {
                GlobalVariables.PeripheralConfigObjMap.remove(strPeripheral);
            }
        }
    }

    public static void UpdateAllItemsStateInPeriConfig(String Relateform, String PeriName, String GroupName, String ControlName) {
        String groupNameKey;
        Map<String, List<String>> groupAndChildsConflictMap;
        if (!ConflictUtil.PeriConflictInfos.containsKey(PeriName)) {
            return;
        }
        ConflictUtil.conflictIsCheckItem = true;
        if (ConflictUtil.periGroupAndChildsConflictMap.containsKey(PeriName) && (groupAndChildsConflictMap = ConflictUtil.periGroupAndChildsConflictMap.get(PeriName)).containsKey(groupNameKey = String.valueOf(PeriName) + "##" + GroupName)) {
            List<String> childConditionList = groupAndChildsConflictMap.get(groupNameKey);
            for (String key : childConditionList) {
                ConflictGroupInfo conflictGroupObj;
                ConflictControlInfo controlObj;
                if (!ConflictUtil.ConflictGroupInfos.containsKey(key) || !(controlObj = (conflictGroupObj = ConflictUtil.ConflictGroupInfos.get(key)).getControledControl()).getRelateFrom().equals(Relateform) || !controlObj.getControlType().equals("Item") || PeriName == null || GroupName == null || ControlName == null || !PeriName.equals(controlObj.getPeriName()) || !GroupName.equals(controlObj.getGroupName()) || !ControlName.equals(controlObj.getControlName())) continue;
                ConflictExecute.ExecuteSingleConflict(conflictGroupObj);
            }
        }
        ConflictUtil.conflictIsCheckItem = false;
    }

    private static void UpdateControlConfigValidValue(String PeriName, String GroupName, String ControlName, boolean isApplyNode) {
        AbstractJTreeNode controlNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
        controlNode = isApplyNode ? (AbstractJTreeNode)PeriParaTreeConflict.getPeriApplyConfigNode((String)PeriName, (String)GroupName, (String)ControlName) : (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
        if (controlNode == null) {
            return;
        }
        if (GlobalVariables.isCubeRoverTest) {
            return;
        }
        if (ConflictUtil.conflictIsSetValue) {
            String oldValue = controlNode.getValue();
            ((JTreeComboxNode)controlNode).getVisibleAndEnableItem();
            ConflictExecute.UpdateAllItemsStateInPeriConfig("0", PeriName, GroupName, ControlName);
            controlNode.setValue(((JTreeComboxNode)controlNode).getVisibleAndEnableItem());
            if (oldValue.equals(controlNode.getValue())) {
                return;
            }
            ConflictExecute.ConflictExecuteByPeriConfig(PeriName, GroupName, ControlName, controlNode.getValue(), true);
        }
    }

    private static void excuteUpdateValue(AbstractJTreeNode controlNode, String configValue, String PeriName, String GroupName, String ControlName) {
        if (ConflictUtil.conflictIsSetValue || GlobalVariables.isCubeRoverTest) {
            if (controlNode.getValue().equals(configValue)) {
                return;
            }
            controlNode.setDefaultValue(configValue);
            controlNode.setValue(configValue);
            ConflictExecute.ConflictExecuteByPeriConfig(PeriName, GroupName, ControlName, configValue, true);
        }
    }

    private static void UpdateControlNotVisble(ConflictControlInfo ConflictControlObj, boolean isApplyNode) {
        int newState;
        String PeriName = ConflictControlObj.getPeriName();
        String GroupName = ConflictControlObj.getGroupName();
        String ControlName = ConflictControlObj.getControlName();
        AbstractJTreeNode controlNode = (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
        controlNode = isApplyNode ? (AbstractJTreeNode)PeriParaTreeConflict.getPeriApplyConfigNode((String)PeriName, (String)GroupName, (String)ControlName) : (AbstractJTreeNode)PeriParaTreeConflict.getPeriConfigNode((String)PeriName, (String)GroupName, (String)ControlName);
        if (controlNode == null) {
            return;
        }
        int currentState = controlNode.getState();
        if (currentState == (newState = ConflictUtil.getNodeState(1, 1, currentState))) {
            return;
        }
        controlNode.setState(newState);
    }

    public static void ExecuteGroupAllChildrenPrivilege(String PeriName, String GroupName, boolean visibleState) {
        if (!PeriName.contains("ADC") && !PeriName.contains("EXMC")) {
            return;
        }
        if (ConflictUtil.disableConflict) {
            return;
        }
        if (ConflictUtil.UserAndConflictGroupInfo == null) {
            return;
        }
        String Condition = "0##" + PeriName + "##" + GroupName + "##";
        if (ConflictUtil.UserAndConflictGroupInfo == null) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : ConflictUtil.UserAndConflictGroupInfo.entrySet()) {
            String key = entry.getKey();
            if (!key.contains(Condition)) continue;
            ConflictExecute.ExecuteConflictByPeriConfigSourceStr(PeriName, key);
        }
    }

    private static void UpdatePINState(String PeriName, String GroupName, String ControlName, String ItemName, String ControlType2, String Privilege, boolean type) {
        GD32PinPad pinPadObj;
        String pinNumStr;
        if (Privilege.equals("UpdatePinName") && type) {
            pinNumStr = GroupName;
            pinPadObj = GlobalVariables.GetPinInfoByPinNumStr((String)pinNumStr);
            if (pinPadObj == null) {
                return;
            }
            if (pinPadObj.getPinUsedType() != 0) {
                return;
            }
            GlobalVariables.EnablePinInfoByOriginPinName((String)pinPadObj.getPinName());
            GlobalVariables.DisablePinInfoByPinName((String)ItemName, (String)pinNumStr);
            pinPadObj.updatePinInfoByRemap(ItemName);
            GlobalVariables.isRelationPinUpdate = true;
        }
        if (Privilege.equals("Disable")) {
            pinNumStr = GroupName;
            pinPadObj = GlobalVariables.GetPinInfoByPinNumStr((String)pinNumStr);
            if (pinPadObj.getPinUsedType() != 0) {
                return;
            }
            if (type) {
                if (!pinPadObj.getPinName().equals(ItemName)) {
                    return;
                }
                GlobalVariables.DisablePinFunctionByPinNumStr((String)pinNumStr);
            } else {
                GlobalVariables.EnablePinFunctionByPinNumStr((String)pinNumStr);
            }
            GlobalVariables.isRelationPinUpdate = true;
        }
    }

    public static void initPINConflict() {
        if (ConflictUtil.disableConflict) {
            return;
        }
        ConflictExecute.initControlConflictInfo("PIN", "5");
    }
}

