/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.jlink;

import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.adapter.jlink.JLinkOperation;
import com.gigadevice.debug.AbstractDebugServer;
import com.gigadevice.debug.jlink.Messages;
import com.gigadevice.debug.ui.DebugTab;
import com.gigadevice.utils.constants.DebugConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class JlinkDebug
extends AbstractDebugServer {
    private Text fResetType;
    private Composite fSettingsComp;
    private Text fGdbServerOtherOptions;

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration, TargetAdapter.MbsType clientTool, String GdbServer, String ServerArgs) {
        configuration.setAttribute("com.gigadevice.debug.launch.resetCommands.indebug", this.getResetCommands(true, clientTool));
        configuration.setAttribute("com.gigadevice.debug.launch.runCommands.indebug", this.getRunCommands(true));
        configuration.setAttribute("com.gigadevice.debug.launch.resetCommands.inrun", this.getResetCommands(false, clientTool));
        configuration.setAttribute("com.gigadevice.debug.launch.runCommands.inrun", this.getRunCommands(false));
        configuration.setAttribute("com.gigadevice.debug.launch.remoteCommand", "target remote");
        if (clientTool == TargetAdapter.MbsType.RISCV) {
            configuration.setAttribute("com.gigadevice.debug.launch.resettype", "1");
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration, TargetAdapter.MbsType clientTool, String GdbServer, String ServerArgs) {
        if (clientTool == TargetAdapter.MbsType.ARM) {
            this.fResetType.setEnabled(false);
            this.fResetType.setText("");
            return;
        }
        String resetType = "";
        try {
            resetType = configuration.getAttribute("com.gigadevice.debug.launch.resettype", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.fResetType.setText(resetType);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration, TargetAdapter.MbsType clientTool) {
        configuration.setAttribute("com.gigadevice.debug.launch.resettype", this.fResetType.getText());
        configuration.setAttribute("com.gigadevice.debug.launch.remoteCommand", "target remote");
        String stringValue = this.fGdbServerOtherOptions.getText();
        configuration.setAttribute("com.gigadevice.debug.launch.serverParam", stringValue);
    }

    public Composite getControl() {
        return this.fSettingsComp;
    }

    public void UpdateGroup(ILaunchConfigurationWorkingCopy configuration, String GdbServer, String Interface, String McuNo, String speed) {
        String text = null;
        try {
            text = configuration.getAttribute("com.gigadevice.debug.launch.serverParam", this.fGdbServerOtherOptions.getText());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (GdbServer.contains(DebugConstants.GDLinkDebuggerServerEnum.JGDBServer.toString())) {
            String jlinkMcuNo = McuNo;
            jlinkMcuNo = JLinkOperation.getJlinkMCUPart((String)jlinkMcuNo);
            String defaultConfig = this.debuggerTab.getJlinkServerStartupArgs();
            text = defaultConfig;
            if (!text.toLowerCase().contains(Interface)) {
                if (text.toLowerCase().contains("jtag")) {
                    text = text.replace("jtag", Interface);
                } else if (text.toLowerCase().contains("swd")) {
                    text = text.replace("swd", Interface);
                }
            }
            if (speed != null && text.toLowerCase().contains("-speed")) {
                int startIndex = text.indexOf("-speed");
                int endIndex = text.length() - 1;
                int index = text.indexOf(" -", startIndex += 6);
                if (index > 0) {
                    endIndex = index;
                }
                if (endIndex > startIndex) {
                    String replaceStr = text.substring(startIndex, endIndex);
                    replaceStr = replaceStr.trim();
                    text = text.replace(replaceStr, speed);
                }
            }
            this.fGdbServerOtherOptions.setText(text);
        }
    }

    public void createControl(Composite parent, DebugTab dt) {
        super.createControl(parent, dt);
        this.fSettingsComp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.fSettingsComp);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this.fSettingsComp);
        Label label0 = new Label(this.fSettingsComp, 0);
        label0.setText(Messages.JlinkDebug_ConfigOptions);
        GridDataFactory.swtDefaults().applyTo((Control)label0);
        this.fGdbServerOtherOptions = new Text(this.fSettingsComp, 2626);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)this.fGdbServerOtherOptions);
        this.fGdbServerOtherOptions.setEditable(true);
        Label label = new Label(this.fSettingsComp, 0);
        label.setText(Messages.JlinkDebug_ResetType);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        this.fResetType = new Text(this.fSettingsComp, 2052);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)this.fResetType);
        this.fResetType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JlinkDebug.this.updateLaunchDialog();
            }
        });
    }

    public String getDefaultPortNumber() {
        return "2331";
    }

    public int getSleepTime() {
        return 4;
    }

    public String getServerLocation(TargetAdapter.MbsType type, String McuNo, String Server, String Location) {
        return AdapterUtils.getJlinkServerCLPath();
    }

    public String getRunCommands(boolean isDebugging) {
        if (isDebugging) {
            return "monitor reset" + System.lineSeparator() + "tbreak main" + System.lineSeparator() + "continue" + System.lineSeparator();
        }
        return "monitor reset" + System.lineSeparator() + "continue" + System.lineSeparator() + "continue" + System.lineSeparator();
    }

    public String getResetCommands(boolean isDebugging, TargetAdapter.MbsType coreType) {
        if (isDebugging) {
            if (coreType == TargetAdapter.MbsType.RISCV) {
                return "monitor speed 30" + System.lineSeparator() + "monitor endian little" + System.lineSeparator() + "monitor reset" + System.lineSeparator() + "monitor speed 500" + System.lineSeparator() + "monitor flash download = 1" + System.lineSeparator() + "monitor reset 1" + System.lineSeparator() + "load" + System.lineSeparator();
            }
            if (coreType == TargetAdapter.MbsType.ARM) {
                return "monitor speed 30" + System.lineSeparator() + "monitor endian little" + System.lineSeparator() + "monitor reset" + System.lineSeparator() + "monitor speed 500" + System.lineSeparator() + "monitor flash download = 1" + System.lineSeparator() + "load" + System.lineSeparator();
            }
        } else {
            if (coreType == TargetAdapter.MbsType.RISCV) {
                return "monitor speed 30" + System.lineSeparator() + "monitor endian little" + System.lineSeparator() + "monitor reset" + System.lineSeparator() + "monitor speed 500" + System.lineSeparator() + "monitor flash download = 1" + System.lineSeparator() + "monitor reset 1" + System.lineSeparator() + "load" + System.lineSeparator();
            }
            if (coreType == TargetAdapter.MbsType.ARM) {
                return "monitor speed 30" + System.lineSeparator() + "monitor endian little" + System.lineSeparator() + "monitor reset" + System.lineSeparator() + "monitor speed 500" + System.lineSeparator() + "monitor flash download = 1" + System.lineSeparator() + "load" + System.lineSeparator();
            }
        }
        return "";
    }
}

