/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.ui.tool;

import com.gigadevice.ui.baseinfo.FilesStruct;
import com.gigadevice.ui.baseinfo.GroupStruct;
import com.gigadevice.ui.baseinfo.TargetInfoStruct;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class IARProjParse {
    private final String ELE_CONFIGURATION = "configuration";
    private final String ELE_NAME = "name";
    private final String ELE_TOOLCHAIN = "toolchain";
    private final String ELE_GENERAL = "General";
    private final String ELE_SETTINGS = "settings";
    private final String ELE_ICCARM = "ICCARM";
    private final String ELE_ICCRISCV = "ICCRISCV";
    private final String ELE_DATA = "data";
    private final String ELE_OPTION = "option";
    private final String ELE_STATE = "state";
    private final String ELE_CHIP_SELECT_ARM = "OGChipSelectEditMenu";
    private final String ELE_CHIP_SELECT_RISCV = "GDeviceSelect";
    private final String ELE_TRUSTZONE = "TrustZone";
    private final String ELE_CCDEFINES = "CCDefines";
    private final String ELE_INCLUDE_PATH = "CCIncludePath2";
    private final String ELE_GROUP = "group";
    private final String ELE_FILE = "file";
    private final String ELE_EXCLUDED = "excluded";
    private final String PROJ_DIR = "$PROJ_DIR$\\";
    private final String ENV_IAR = "env_IAR";
    private final String ENV_ECLIPSE = "env_Eclipse";
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NO_DEVICE = 1;
    public static final int ERROR_NO_INCLUDE_PATH = 2;
    public static final int ERROR_NO_VALID_CONFIG = 3;
    public static final int ERROR_INVALID_DEVICE_FORMAT = 4;
    private int errorCode = 0;
    private List<String> invalidConfigurations = new ArrayList<String>();
    private List<String> errorMessages = new ArrayList<String>();
    private static Map<String, TargetInfoStruct> mapTarget = new HashMap<String, TargetInfoStruct>();
    private File ewpDir;
    private String toolChainName = "";
    private boolean isMultiConf = false;

    public Boolean parseIARProj(String IARProjFilePath) {
        mapTarget.clear();
        this.invalidConfigurations.clear();
        this.errorMessages.clear();
        SAXReader saxReader = new SAXReader();
        try {
            File ewpFile = new File(IARProjFilePath);
            this.ewpDir = ewpFile.getParentFile();
            Document document = saxReader.read(ewpFile);
            Element projectElm = document.getRootElement();
            List configurationList = projectElm.elements("configuration");
            if (configurationList.isEmpty()) {
                this.errorCode = 3;
                this.errorMessages.add("No <configuration> nodes found");
                return false;
            }
            if (configurationList.size() > 1) {
                this.isMultiConf = true;
            }
            int validConfigCount = 0;
            for (Element configuration : configurationList) {
                if (!this.processConfiguration(configuration).booleanValue()) continue;
                ++validConfigCount;
            }
            if (validConfigCount == 0) {
                this.errorCode = 3;
                this.errorMessages.add("All <configuration> nodes are missing critical information");
                return false;
            }
            List groupList = projectElm.elements("group");
            for (String targetName : mapTarget.keySet()) {
                TargetInfoStruct targetInfo = mapTarget.get(targetName);
                ArrayList<GroupStruct> lstGroups = new ArrayList<GroupStruct>();
                for (Element group : groupList) {
                    GroupStruct groupStruct = this.processGroup(group, targetName);
                    if (groupStruct == null) continue;
                    lstGroups.add(groupStruct);
                }
                targetInfo.setLstGroups(lstGroups);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorCode = 3;
            this.errorMessages.add("Exception occurred while parsing IAR project file: " + e.getMessage());
            return false;
        }
    }

    private GroupStruct processGroup(Element groupElm, String targetName) {
        GroupStruct groupStruct = new GroupStruct();
        Element nameElm = groupElm.element("name");
        if (nameElm == null) {
            return null;
        }
        String groupName = nameElm.getText();
        groupStruct.setGroupName(groupName);
        ArrayList<FilesStruct> lstFiles = new ArrayList<FilesStruct>();
        List fileElmList = groupElm.elements("file");
        for (Element fileElm : fileElmList) {
            FilesStruct fileStruct = this.processFile(fileElm, targetName);
            if (fileStruct == null) continue;
            lstFiles.add(fileStruct);
        }
        groupStruct.setLstFiles(lstFiles);
        ArrayList<GroupStruct> subGroups = new ArrayList<GroupStruct>();
        List subGroupElmList = groupElm.elements("group");
        for (Element subGroupElm : subGroupElmList) {
            GroupStruct subGroupStruct = this.processGroup(subGroupElm, targetName);
            if (subGroupStruct == null) continue;
            subGroups.add(subGroupStruct);
        }
        groupStruct.setSubGroups(subGroups);
        return groupStruct;
    }

    private String extractEnvEclipsePath(String filePath, String dirName) {
        int envIndex = filePath.indexOf(dirName);
        if (envIndex < 0) {
            return null;
        }
        String envPath = filePath.substring(0, envIndex + dirName.length());
        if (!envPath.endsWith(File.separator)) {
            envPath = String.valueOf(envPath) + File.separator;
        }
        return envPath;
    }

    private void processEnvEclipseFiles(GroupStruct groupStruct, String envEclipsePath, String fileRelativePath) {
        ArrayList<FilesStruct> envFiles = new ArrayList<FilesStruct>();
        try {
            File envEclipseDir = new File(envEclipsePath);
            File[] files = envEclipseDir.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        FilesStruct fileStruct = new FilesStruct();
                        String envEclipseFileName = file.getName();
                        fileStruct.setFileName(envEclipseFileName);
                        fileStruct.setFilePath(String.valueOf(fileRelativePath) + envEclipseFileName);
                        String ext = this.getFileExtension(file.getName()).toLowerCase();
                        if (ext.equals("c") || ext.equals("cpp")) {
                            fileStruct.setFileType("1");
                        } else if (ext.equals("h") || ext.equals("hpp")) {
                            fileStruct.setFileType("2");
                        } else if (ext.equals("s") || ext.equals("asm")) {
                            fileStruct.setFileType("3");
                        } else {
                            fileStruct.setFileType("4");
                        }
                        envFiles.add(fileStruct);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        groupStruct.setLstFiles(envFiles);
    }

    private FilesStruct processFile(Element fileElm, String targetName) {
        FilesStruct fileStruct = new FilesStruct();
        Element FileNameElm = fileElm.element("name");
        if (FileNameElm == null) {
            return null;
        }
        String filePath = FileNameElm.getText();
        filePath = this.resolveIARMacro(filePath, "");
        File file = new File(filePath);
        String fileName = file.getName();
        fileStruct.setFileName(fileName);
        fileStruct.setFilePath(filePath);
        String ext = this.getFileExtension(fileName).toLowerCase();
        if (ext.equals("c") || ext.equals("cpp")) {
            fileStruct.setFileType("1");
        } else if (ext.equals("h") || ext.equals("hpp")) {
            fileStruct.setFileType("2");
        } else if (ext.equals("s") || ext.equals("asm")) {
            fileStruct.setFileType("3");
        } else {
            fileStruct.setFileType("4");
        }
        Element excludedElm = fileElm.element("excluded");
        if (excludedElm != null) {
            List configElms = excludedElm.elements("configuration");
            for (Element cfg : configElms) {
                if (!cfg.getText().equals(targetName)) continue;
                fileStruct.setFileOption(true);
                break;
            }
        }
        return fileStruct;
    }

    private Boolean processConfiguration(Element configurationElm) {
        Element toolChainNameElm;
        TargetInfoStruct targetInfo = new TargetInfoStruct();
        Element configNameElm = configurationElm.element("name");
        if (configNameElm == null) {
            this.invalidConfigurations.add("Unnamed configuration");
            return false;
        }
        String targetName = configNameElm.getText();
        targetInfo.setStrTargetName(targetName);
        boolean foundDevice = false;
        boolean foundIncludePath = false;
        Element toolChainElm = configurationElm.element("toolchain");
        if (toolChainElm != null && (toolChainNameElm = toolChainElm.element("name")) != null) {
            this.toolChainName = toolChainNameElm.getText();
        }
        List settingsList = configurationElm.elements("settings");
        for (Element settings : settingsList) {
            String optionName;
            Element nameOptElm;
            Element option;
            Iterator it;
            Element dataElm;
            Element nameElm2 = settings.element("name");
            if (nameElm2 != null && nameElm2.getText().equals("General")) {
                dataElm = settings.element("data");
                if (dataElm == null) continue;
                it = dataElm.elementIterator("option");
                while (it.hasNext()) {
                    Element stateElm;
                    option = (Element)it.next();
                    nameOptElm = option.element("name");
                    if (nameOptElm == null) continue;
                    optionName = nameOptElm.getText();
                    if (optionName.equals("OGChipSelectEditMenu") || optionName.equals("GDeviceSelect")) {
                        stateElm = option.element("state");
                        if (stateElm == null || stateElm.getText().trim().isEmpty()) continue;
                        String chipName = stateElm.getText().split("\\s+")[0];
                        targetInfo.setStrDevice(chipName);
                        foundDevice = true;
                        continue;
                    }
                    if (!optionName.equals("TrustZone")) continue;
                    stateElm = option.element("state");
                    if (stateElm != null && stateElm.getText().trim().equals("1")) {
                        targetInfo.setStrnSecure("1");
                        continue;
                    }
                    targetInfo.setStrnSecure("0");
                }
                continue;
            }
            if (nameElm2 == null || !nameElm2.getText().equals("ICCARM") && !nameElm2.getText().equals("ICCRISCV") || (dataElm = settings.element("data")) == null) continue;
            it = dataElm.elementIterator("option");
            while (it.hasNext()) {
                Element stateElm;
                Iterator stateIt;
                option = (Element)it.next();
                nameOptElm = option.element("name");
                if (nameOptElm == null) continue;
                optionName = nameOptElm.getText();
                if (optionName.equals("CCDefines")) {
                    ArrayList<String> SymbolsList = new ArrayList<String>();
                    stateIt = option.elementIterator("state");
                    while (stateIt.hasNext()) {
                        stateElm = (Element)stateIt.next();
                        String symbol = stateElm.getText();
                        if (symbol == null || symbol.isEmpty()) continue;
                        SymbolsList.add(symbol.trim());
                    }
                    if (SymbolsList.isEmpty()) continue;
                    targetInfo.setStrDefine(String.join((CharSequence)",", SymbolsList));
                    System.out.println("111");
                    continue;
                }
                if (!optionName.equals("CCIncludePath2")) continue;
                ArrayList<String> includePaths = new ArrayList<String>();
                stateIt = option.elementIterator("state");
                while (stateIt.hasNext()) {
                    stateElm = (Element)stateIt.next();
                    String includePath = stateElm.getText();
                    includePath = this.resolveIARMacro(includePath, "");
                    includePaths.add(includePath);
                }
                if (!includePaths.isEmpty()) {
                    foundIncludePath = true;
                }
                ArrayList<Path> pathList = new ArrayList<Path>();
                for (String inc : includePaths) {
                    try {
                        File pathFile = new File(inc);
                        if (pathFile.isAbsolute()) {
                            if (!pathFile.exists()) continue;
                            pathList.add(Paths.get(inc, new String[0]));
                            continue;
                        }
                        pathList.add(Paths.get(this.ewpDir.getAbsolutePath(), inc).normalize());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                targetInfo.setLstIncludePath(pathList);
            }
        }
        if (!foundDevice) {
            this.invalidConfigurations.add(String.valueOf(targetName) + " - Missing device information");
            this.errorCode = 1;
            return false;
        }
        String deviceName = targetInfo.getStrDevice();
        if (!this.isValidDeviceFormat(deviceName)) {
            this.invalidConfigurations.add(String.valueOf(targetName) + " - Invalid device format: " + deviceName);
            this.errorCode = 4;
            return false;
        }
        if (!foundIncludePath) {
            this.invalidConfigurations.add(String.valueOf(targetName) + " - Missing include path information");
            this.errorCode = 2;
            return false;
        }
        mapTarget.put(targetName, targetInfo);
        return true;
    }

    private String resolveIARMacro(String path, String projDir) {
        if (path.contains("$PROJ_DIR$\\")) {
            return path.replace("$PROJ_DIR$\\", projDir);
        }
        return path;
    }

    private String getFileExtension(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        return dotIndex == -1 ? "" : filename.substring(dotIndex + 1);
    }

    public boolean isMultiConf() {
        return this.isMultiConf;
    }

    public Map<String, TargetInfoStruct> getMapTarget() {
        return mapTarget;
    }

    public String getToolChainName() {
        return this.toolChainName;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public List<String> getInvalidConfigurations() {
        return this.invalidConfigurations;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidDeviceFormat(String deviceName) {
        int middleLength;
        if (deviceName == null || deviceName.length() < 8 || !deviceName.startsWith("GD32")) {
            return false;
        }
        if (!Character.isLetter(deviceName.charAt(4))) {
            return false;
        }
        if (Character.isDigit(deviceName.charAt(5))) {
            middleLength = 4;
            return deviceName.length() >= 4 + middleLength;
        } else {
            if (!Character.isLetter(deviceName.charAt(5))) return false;
            if (Character.isLetter(deviceName.charAt(6))) {
                middleLength = 4;
                return deviceName.length() >= 4 + middleLength;
            } else {
                if (!Character.isDigit(deviceName.charAt(6))) return false;
                middleLength = 5;
                if (deviceName.length() >= 9) return deviceName.length() >= 4 + middleLength;
                return false;
            }
        }
    }

    public String getErrorCodeDescription() {
        switch (this.errorCode) {
            case 0: {
                return "No errors";
            }
            case 1: {
                return "Missing device information";
            }
            case 2: {
                return "Missing include path information";
            }
            case 3: {
                return "No valid configuration nodes found";
            }
            case 4: {
                return "Invalid device format";
            }
        }
        return "Unknown error";
    }
}

