/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs.arm.ui;

import com.gigadevice.mbs.ProjectUpdateFile;
import com.gigadevice.mbs.arm.Activator;
import com.gigadevice.mbs.arm.Option;
import com.gigadevice.mbs.arm.ui.Messages;
import com.gigadevice.templates.core.TreeContentProvider;
import com.gigadevice.templates.core.TreeLabelProvider;
import com.gigadevice.utils.ProjectUtils;
import com.gigadevice.utils.preferences.EclipsePreferences;
import com.gigadevice.venustool.mcuxmlinfo.IMcuTree;
import com.gigadevice.venustool.mcuxmlinfo.MCUs;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import com.gigadevice.venustool.mcuxmlinfo.McuGroup;
import com.gigadevice.venustool.mcuxmlinfo.McuSubGroup;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.ui.newui.ICPropertyTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class CTargetPropertyTab
extends AbstractCBuildPropertyTab
implements ICPropertyTab {
    private TreeViewer treeviewer;
    private Text targetMCU;
    private Text flashSize;
    private Text ramSize;
    private MCUs selMCU;
    private String mcuType = "mcu_arm";
    private String[] symbols;
    private String TOOLCHAIN_ID = "com.gigadevice.mbs.arm.toolChain";
    private EclipsePreferences projPreferences = Activator.getInstance().getProjectPreferences();
    private IConfiguration fConfig;
    private IProject project;
    public static List<String> filegdcList = new ArrayList<String>();
    public static List<String> gdcList = new ArrayList<String>();
    private LinkedHashMap<String, List<String>> PreSelMcuGroupNameMap = new LinkedHashMap();
    private boolean updateLdFileFlag;
    public static String ARMLdSuffix = "_flash.ld";
    public String beginTargetMCU = "";
    public boolean updateAllConfigurationFlag = false;
    public boolean defaultUpdateAllConfigurationFlag = true;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.fConfig = this.getCfg();
        this.project = this.page.getProject();
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        this.usercomp.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        this.usercomp.setLayoutData((Object)layoutData);
        gdcList = ProjectUtils.getGDCList((IProject)this.project);
        if (gdcList.size() == 0) {
            Composite treeComposite = new Composite(this.usercomp, 0);
            this.treeviewer = new TreeViewer(treeComposite, 2052);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.heightHint = 200;
            gridData.horizontalSpan = 6;
            treeComposite.setLayoutData((Object)gridData);
            Tree treev = this.treeviewer.getTree();
            treev.setHeaderVisible(true);
            treev.setLinesVisible(true);
            TreeColumnLayout layoutt = new TreeColumnLayout();
            treeComposite.setLayout((Layout)layoutt);
            TreeColumn nameColumn = new TreeColumn(treev, 0);
            nameColumn.setText("Device");
            layoutt.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnPixelData(200));
            TreeColumn descriptionColumn = new TreeColumn(treev, 0);
            descriptionColumn.setAlignment(16384);
            descriptionColumn.setText("Description");
            descriptionColumn.setWidth(450);
            layoutt.setColumnData((Widget)descriptionColumn, (ColumnLayoutData)new ColumnPixelData(400));
            this.treeviewer.setContentProvider((IContentProvider)new TreeContentProvider());
            this.treeviewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
            this.treeviewer.setInput((Object)McuFactory.getMcuTree((String)this.mcuType));
            this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent e) {
                    if (e.getSelection() != null) {
                        IStructuredSelection is = (IStructuredSelection)e.getSelection();
                        Object selectNode = is.getFirstElement();
                        List childrenNodeList = new ArrayList();
                        if (selectNode instanceof IMcuTree) {
                            IMcuTree node = (IMcuTree)selectNode;
                            childrenNodeList = node.getChildren();
                        }
                        if (childrenNodeList.size() == 0) {
                            CTargetPropertyTab.this.selMCU = (MCUs)is.getFirstElement();
                            CTargetPropertyTab.this.targetMCU.setText(CTargetPropertyTab.this.selMCU.getName());
                            CTargetPropertyTab.this.flashSize.setText(CTargetPropertyTab.this.selMCU.getFlashSize());
                            CTargetPropertyTab.this.ramSize.setText(CTargetPropertyTab.this.selMCU.getRamSize());
                            CTargetPropertyTab.this.projPreferences.putTargetMCU(CTargetPropertyTab.this.selMCU.getName(), CTargetPropertyTab.this.project);
                            CTargetPropertyTab.this.projPreferences.flush(CTargetPropertyTab.this.project);
                        } else {
                            CTargetPropertyTab.this.targetMCU.setText("");
                            CTargetPropertyTab.this.flashSize.setText("");
                            CTargetPropertyTab.this.ramSize.setText("");
                        }
                    }
                }
            });
        }
        Label LblMCU = new Label(this.usercomp, 0);
        LblMCU.setText("MCU: ");
        this.targetMCU = new Text(this.usercomp, 2060);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.targetMCU.setLayoutData((Object)layoutData);
        Label LblFlash = new Label(this.usercomp, 0);
        LblFlash.setText("FLASH(KB): ");
        this.flashSize = new Text(this.usercomp, 2060);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.flashSize.setLayoutData((Object)layoutData);
        Label LblRam = new Label(this.usercomp, 0);
        LblRam.setText("RAM(KB): ");
        this.ramSize = new Text(this.usercomp, 2060);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.ramSize.setLayoutData((Object)layoutData);
        this.updateControlsForConfig(this.fConfig);
    }

    public void handleTabEvent(int kind, Object data) {
        try {
            IConfiguration newConfig;
            ICResourceDescription resDesc;
            ICConfigurationDescription configDesc;
            super.handleTabEvent(kind, data);
            if (data instanceof ICResourceDescription && (configDesc = (resDesc = (ICResourceDescription)data).getConfiguration()) != null && (newConfig = CTargetPropertyTab.getCfg((ICConfigurationDescription)configDesc)) != null) {
                this.fConfig = newConfig;
                this.beginTargetMCU = Option.getOptionStringValue((IConfiguration)newConfig, (String)Option.OPTIONID_TARGETMCU_PARTNO);
                this.targetMCU.setText(this.beginTargetMCU);
                if (this.beginTargetMCU.equals("")) {
                    this.flashSize.setText("");
                    this.ramSize.setText("");
                    return;
                }
                this.PreSelMcuGroupNameMap.clear();
                this.updateMCUAttribute(this.beginTargetMCU);
            }
        }
        catch (Exception exception) {}
    }

    public boolean canBeVisible() {
        return this.isThisPlugin();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.updateMCUAttribute(this.targetMCU.getText());
        try {
            this.updateConfig(CTargetPropertyTab.getCfg((ICConfigurationDescription)src.getConfiguration()));
            this.updateConfig(CTargetPropertyTab.getCfg((ICConfigurationDescription)dst.getConfiguration()));
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        this.projPreferences.putTargetMCU(this.targetMCU.getText(), this.project);
        this.projPreferences.flush(this.project);
        if (!this.targetMCU.getText().isEmpty() && !this.beginTargetMCU.equals(this.targetMCU.getText())) {
            this.updateAllConfigurationFlag = false;
            boolean yesFlag = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CTargetPropertyTab_Message, (String)Messages.CTargetPropertyTab_askUpdateAllConfigurations);
            if (yesFlag) {
                try {
                    this.updateAllConfigurationFlag = true;
                    this.updateAllConfigurationsCoreModel();
                    this.updateAllConfigurations();
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
            } else {
                this.defaultUpdateAllConfigurationFlag = false;
            }
        }
    }

    protected void performCancel() {
        if (this.updateAllConfigurationFlag) {
            try {
                this.updateAllConfigurations();
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
        }
    }

    protected void performOK() {
        if (this.beginTargetMCU.equals(this.targetMCU.getText())) {
            return;
        }
        this.updateMCUAttribute(this.targetMCU.getText());
        try {
            this.updateConfig(this.fConfig);
            if (!this.targetMCU.getText().isEmpty() && !this.beginTargetMCU.equals(this.targetMCU.getText())) {
                boolean yesFlag;
                if (this.updateAllConfigurationFlag) {
                    this.updateAllConfigurations();
                } else if (this.defaultUpdateAllConfigurationFlag && (yesFlag = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CTargetPropertyTab_Message, (String)Messages.CTargetPropertyTab_askUpdateAllConfigurations))) {
                    this.updateAllConfigurations();
                }
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        this.projPreferences.putTargetMCU(this.targetMCU.getText(), this.project);
        this.projPreferences.flush(this.project);
    }

    public static void setOption(IConfiguration config, IHoldsOptions holder, String optId, String optValue) {
        try {
            IOption optionTmp = holder.getOptionById(optId);
            IOption option = holder.getOptionToSet(optionTmp, false);
            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)option.getOptionHolder(), (IOption)option, (String)optValue);
        }
        catch (BuildException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.gigadevice.mbs.arm", "Error setting String option.", (Throwable)ex));
        }
    }

    private void updateConfig(IConfiguration srcConfig) throws BuildException {
        String fTargetMCUPartNo;
        IToolChain toolchain = srcConfig.getToolChain();
        String targetMCUPartNo = this.targetMCU.getText();
        if (!targetMCUPartNo.equals(fTargetMCUPartNo = Option.getOptionStringValue((IConfiguration)srcConfig, (String)Option.OPTIONID_TARGETMCU_PARTNO))) {
            IOption option = toolchain.getOptionById(Option.OPTIONID_TARGETMCU_PARTNO);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetMCUPartNo);
            IOption option3 = toolchain.getOptionById(Option.OPTIONID_TARGET_ARMFAMILY);
            if (this.selMCU != null) {
                String MCUCore = ((McuSubGroup)this.selMCU.getParent()).getCPUCore();
                srcConfig.setOption((IHoldsOptions)toolchain, option3, MCUCore);
            }
        }
    }

    protected void performDefaults() {
        this.targetMCU.setText("");
        this.flashSize.setText("");
        this.ramSize.setText("");
    }

    protected void updateData(ICResourceDescription cfg) {
    }

    protected void updateButtons() {
    }

    private boolean isThisPlugin() {
        IToolChain toolchain;
        String sToolchainId;
        IConfiguration fConfig;
        block4: {
            try {
                fConfig = this.getCfg();
                if (fConfig != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("arm.Toolchains.isThisPlugin() fConfig=" + fConfig);
        }
        return (sToolchainId = (toolchain = fConfig.getToolChain()).getBaseId()).startsWith(String.valueOf(this.TOOLCHAIN_ID) + ".");
    }

    protected void updateMCUAttribute(String targetMCUNumber) {
        boolean flag;
        boolean yesFlag;
        if (targetMCUNumber.isEmpty()) {
            this.updateLdFileFlag = false;
            return;
        }
        String McuGroupName = this.GetMCUGroupName(targetMCUNumber);
        if (this.PreSelMcuGroupNameMap.size() != 0 && !this.PreSelMcuGroupNameMap.containsKey(McuGroupName) && !(yesFlag = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CTargetPropertyTab_Message, (String)Messages.CTargetPropertyTab_CrossSeriesSwitching))) {
            for (String PreMcuGroupName : this.PreSelMcuGroupNameMap.keySet()) {
                List<String> McuSubGroupInfo = this.PreSelMcuGroupNameMap.get(PreMcuGroupName);
                this.targetMCU.setText(McuSubGroupInfo.get(0));
                this.flashSize.setText(McuSubGroupInfo.get(1));
                this.ramSize.setText(McuSubGroupInfo.get(2));
            }
            return;
        }
        this.updateLdFileFlag = this.checkLinkFileUpdateNeeded(targetMCUNumber);
        String chipGroupName = "";
        Object[] MCUList = McuFactory.getMcuTree((String)this.mcuType).toArray();
        MCUs mcuObj = null;
        int i = 0;
        while (i < MCUList.length) {
            McuGroup McuGroupObj = (McuGroup)MCUList[i];
            List McuSubGroupList = McuGroupObj.getChildren();
            int j = 0;
            while (j < McuSubGroupList.size()) {
                McuSubGroup McuSubGroupObj = (McuSubGroup)McuSubGroupList.get(j);
                List McuList = McuSubGroupObj.getChildren();
                int n = 0;
                while (n < McuList.size()) {
                    MCUs mcuobj = (MCUs)McuList.get(n);
                    if (mcuobj.getName().equals(targetMCUNumber)) {
                        chipGroupName = McuGroupObj.getName();
                        mcuObj = mcuobj;
                        this.flashSize.setText(mcuObj.getFlashSize());
                        this.ramSize.setText(mcuObj.getRamSize());
                        this.projPreferences.putLinkFileFlashlength(mcuObj.getFlashSize(), this.project);
                        String ldramSize = mcuObj.getldRamSize();
                        if (!ldramSize.equals("")) {
                            this.projPreferences.putLinkFileRamLength(mcuObj.getldRamSize(), this.project);
                        } else {
                            this.projPreferences.putLinkFileRamLength(mcuObj.getRamSize(), this.project);
                        }
                        String CurMcuGroupName = McuGroupObj.getName();
                        this.PreSelMcuGroupNameMap.clear();
                        ArrayList<String> MCUInfo = new ArrayList<String>();
                        MCUInfo.add(targetMCUNumber);
                        MCUInfo.add(mcuObj.getFlashSize());
                        MCUInfo.add(mcuObj.getRamSize());
                        this.PreSelMcuGroupNameMap.put(CurMcuGroupName, MCUInfo);
                        this.projPreferences.flush(this.project);
                    }
                    ++n;
                }
                ++j;
            }
            ++i;
        }
        if (mcuObj != null) {
            int len = mcuObj.getSymbols().size();
            this.symbols = new String[len];
            int i2 = 0;
            while (i2 < len) {
                this.symbols[i2] = (String)mcuObj.getSymbols().get(i2);
                ++i2;
            }
        }
        if (this.updateLdFileFlag && (flag = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CTargetPropertyTab_Message, (String)Messages.CTargetPropertyTab_PartNoSwitched))) {
            String[] LdFileList = ProjectUpdateFile.getLdFileListFormProjectConfig((IProject)this.project, (String)"com.gigadevice.mbs.arm.tool.linker", (String)Option.TOOLID_GENERAL_SCRIPTFILE);
            String LdFileName = ProjectUpdateFile.getFirstLdFileNameFromLdList((String[])LdFileList);
            String srcLdFilePath = String.valueOf(McuFactory.getFirmwarePath((String)this.mcuType.toUpperCase(), (String)chipGroupName.toLowerCase())) + chipGroupName.toLowerCase() + ARMLdSuffix;
            String dstLdFilePath = ProjectUtils.parseFilePath((String)this.project.getLocation().toOSString(), (String)LdFileName);
            boolean updateSuccessFlag = false;
            if (!dstLdFilePath.equals("")) {
                this.projPreferences.putLinkFileSrcPath(srcLdFilePath, this.project);
                this.projPreferences.putLinkFileTargetPath(dstLdFilePath, this.project);
                updateSuccessFlag = ProjectUpdateFile.updateLinkFile((IProject)this.project, (EclipsePreferences)this.projPreferences);
            }
            if (!updateSuccessFlag) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CTargetPropertyTab_Warning, (String)MessageFormat.format(Messages.CTargetPropertyTab_FailedUpdateLdFile, LdFileName));
            }
        }
    }

    private Boolean checkLinkFileUpdateNeeded(String targetMCUNumber) {
        String preSelMcuSubGroupName = "";
        for (String PreMcuGroupName : this.PreSelMcuGroupNameMap.keySet()) {
            List<String> McuSubGroupInfo = this.PreSelMcuGroupNameMap.get(PreMcuGroupName);
            preSelMcuSubGroupName = McuSubGroupInfo.get(0);
        }
        if (targetMCUNumber.equals(preSelMcuSubGroupName) || preSelMcuSubGroupName.equals("")) {
            return false;
        }
        return true;
    }

    private void updateControlsForConfig(IConfiguration config) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("arm.Toolchains.updateControlsForConfig() " + config.getName());
        }
        if (!this.isThisPlugin()) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("not this plugin");
            }
            return;
        }
        this.beginTargetMCU = Option.getOptionStringValue((IConfiguration)config, (String)Option.OPTIONID_TARGETMCU_PARTNO);
        this.targetMCU.setText(this.beginTargetMCU);
        this.updateMCUAttribute(this.beginTargetMCU);
    }

    private String GetMCUGroupName(String MCUSubGroupName) {
        String McuGroupName = "";
        Object[] MCUList = McuFactory.getMcuTree((String)this.mcuType).toArray();
        int i = 0;
        while (i < MCUList.length) {
            McuGroup McuGroupObj = (McuGroup)MCUList[i];
            List McuSubGroupList = McuGroupObj.getChildren();
            int j = 0;
            while (j < McuSubGroupList.size()) {
                McuSubGroup McuSubGroupObj = (McuSubGroup)McuSubGroupList.get(j);
                List McuList = McuSubGroupObj.getChildren();
                int n = 0;
                while (n < McuList.size()) {
                    MCUs mcuobj = (MCUs)McuList.get(n);
                    if (mcuobj.getName().equals(MCUSubGroupName)) {
                        McuGroupName = McuGroupObj.getName();
                    }
                    ++n;
                }
                ++j;
            }
            ++i;
        }
        return McuGroupName;
    }

    public String getCurPartNoMinStackSize(String lable) {
        String minStackSize = "1";
        if (lable.equals("4") || lable.equals("6")) {
            minStackSize = "1";
        } else if (lable.equals("8") || lable.equals("B")) {
            minStackSize = "2";
        }
        return minStackSize;
    }

    private void updateAllConfigurations() throws BuildException {
        try {
            ICConfigurationDescription[] configDescs = this.page.getCfgsEditable();
            IConfiguration[] configs = new IConfiguration[configDescs.length];
            String targetMCUPartNo = this.targetMCU.getText();
            int i = 0;
            while (i < configDescs.length) {
                configs[i] = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescs[i]);
                ++i;
            }
            IConfiguration[] iConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                if (config != null) {
                    IOption armFamilyOption;
                    IToolChain toolchain = config.getToolChain();
                    IOption partNoOption = toolchain.getOptionById(Option.OPTIONID_TARGETMCU_PARTNO);
                    if (partNoOption != null) {
                        IOption optionToSet = config.getToolChain().getOptionToSet(partNoOption, false);
                        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionToSet.getOptionHolder(), (IOption)optionToSet, (String)targetMCUPartNo);
                        this.beginTargetMCU = targetMCUPartNo;
                    }
                    if ((armFamilyOption = toolchain.getOptionById(Option.OPTIONID_TARGET_ARMFAMILY)) != null && this.selMCU != null) {
                        String MCUCore = ((McuSubGroup)this.selMCU.getParent()).getCPUCore();
                        IOption optionToSet = config.getToolChain().getOptionToSet(armFamilyOption, false);
                        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionToSet.getOptionHolder(), (IOption)optionToSet, (String)MCUCore);
                    }
                }
                ++n2;
            }
            ManagedBuildManager.saveBuildInfo((IProject)this.project, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("\u93c7\u5b58\u67ca\u93b5\ufffd\u93c8\u5910\u53a4\u7f03\ue1bd\u6902\u9359\u6220\u6553\u95bf\u6b12\ue1e4: " + e.getMessage());
        }
    }

    private void updateAllConfigurationsCoreModel() throws BuildException {
        try {
            ICConfigurationDescription[] allConfigDescs;
            String targetMCUPartNo = this.targetMCU.getText();
            ICProjectDescription projectDesc = CoreModel.getDefault().getProjectDescription(this.project, true);
            if (projectDesc == null) {
                throw new BuildException("\u93c3\u72b3\u7876\u947e\u5cf0\u5f47\u6924\u572d\u6d30\u93bb\u5fda\u582a");
            }
            ICConfigurationDescription[] iCConfigurationDescriptionArray = allConfigDescs = projectDesc.getConfigurations();
            int n = allConfigDescs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription configDesc = iCConfigurationDescriptionArray[n2];
                IConfiguration config = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDesc);
                if (config == null) {
                    System.out.println("  \u7480\ufe40\u61a1: \u93c3\u72b3\u7876\u947e\u5cf0\u5f47\u95b0\u5d87\u7586\u7035\u7845\u8584\u951b\u5c83\u70e6\u6769\ufffd");
                } else {
                    IOption armFamilyOption;
                    IToolChain toolchain = config.getToolChain();
                    IOption partNoOption = toolchain.getOptionById(Option.OPTIONID_TARGETMCU_PARTNO);
                    if (partNoOption != null) {
                        IOption optionToSet = config.getToolChain().getOptionToSet(partNoOption, false);
                        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionToSet.getOptionHolder(), (IOption)optionToSet, (String)targetMCUPartNo);
                        this.beginTargetMCU = targetMCUPartNo;
                    }
                    if ((armFamilyOption = toolchain.getOptionById(Option.OPTIONID_TARGET_ARMFAMILY)) != null && this.selMCU != null) {
                        String MCUCore = ((McuSubGroup)this.selMCU.getParent()).getCPUCore();
                        IOption optionToSet = config.getToolChain().getOptionToSet(armFamilyOption, false);
                        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionToSet.getOptionHolder(), (IOption)optionToSet, (String)MCUCore);
                    }
                }
                ++n2;
            }
            ManagedBuildManager.saveBuildInfo((IProject)this.project, (boolean)true);
            CoreModel.getDefault().setProjectDescription(this.project, projectDesc);
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new BuildException("CoreModel\u95b0\u5d87\u7586\u93c7\u5b58\u67ca\u6fb6\u8fab\u89e6: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("CoreModel\u95b0\u5d87\u7586\u93c7\u5b58\u67ca\u9351\u8679\u5e47\u93c8\ue046\u7161\u95bf\u6b12\ue1e4: " + e.getMessage());
        }
    }
}

