/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.gdconfig.ui.editor;

import com.formdev.flatlaf.FlatLightLaf;
import com.gigadevice.gdconfig.ui.GdConfigPage;
import com.gigadevice.gdconfig.ui.access.SerializeAccess;
import com.gigadevice.gdconfig.ui.access.SerializeAccess_Template;
import com.gigadevice.gdconfig.ui.editor.Messages;
import com.gigadevice.gdconfig.ui.utils.ProjectConfigUtil;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.venustool.GlobalVariables;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class GDCEditor
extends EditorPart {
    String strGDCTitle;
    String currentProjectName;
    Composite container;
    private boolean dirty = false;
    private static Timer timer;
    private boolean timerFlag = false;
    int deserializeRet;

    public void doSave(IProgressMonitor monitor) {
        if (GlobalVariables.ProjectName != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project = root.getProject(this.currentProjectName);
            SerializeAccess_Template.SerializeSave(project);
        }
        GlobalVariables.isDirtyFlag = false;
        this.timerFlag = false;
        this.setDirty(false);
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.strGDCTitle = input.getName();
        IFile file = (IFile)Adapters.adapt((Object)input, IFile.class);
        if (file != null) {
            IProject project = file.getProject();
            if (project != null && project.exists()) {
                this.currentProjectName = project.getName();
                System.out.println("Current file belongs to project: " + project.getName());
            } else {
                System.out.println("The file is not associated with a project.");
            }
        } else {
            System.out.println("The editor input does not adapt to an IFile.");
        }
        GDCEditor activeGDCEditor = GDCEditor.getActiveGDCEditor(this.strGDCTitle);
        if (activeGDCEditor != null && activeGDCEditor.isDirty()) {
            String activeGDCEditorName = activeGDCEditor.getEditorInput().getName();
            boolean res = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GdcSave_SavePrompt, (String)("'" + activeGDCEditorName + "'" + Messages.GdcSave_UnsavedInfo + "\n" + Messages.GdcSave_SaveOrNot));
            if (res) {
                activeGDCEditor.doSave(null);
            } else {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)activeGDCEditor, false);
            }
        }
        GlobalVariables.isDirtyFlag = false;
        GlobalVariables.isCodeGenFlag = false;
        this.timerFlag = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
            UIManager.put("ScrollBar.thumb", new ColorUIResource(new Color(0, 104, 179, 100)));
            UIManager.put("ScrollBar.track", new ColorUIResource(new Color(255, 255, 255, 100)));
            UIManager.put("ScrollBar.thumbInsets", new InsetsUIResource(2, 2, 2, 2));
            UIManager.put("ScrollBar.thumbSpeedFactor", Float.valueOf(6.0f));
            UIManager.put("SplitPane.dividerSize", 8);
            UIManager.put("TabbedPane.hoverColor", new ColorUIResource(new Color(0, 104, 179, 100)));
            UIManager.put("TabbedPane.selectedBackground", new ColorUIResource(new Color(0, 104, 179, 50)));
        }
        catch (Exception exception) {
            System.out.print("UI Error!!!");
        }
        IEditorPart[] iEditParts = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditors();
        int i = 0;
        while (i < iEditParts.length) {
            String strEditorTitle = iEditParts[i].getTitle();
            if (strEditorTitle != null && strEditorTitle.contains(".gdc") && !strEditorTitle.equals(this.strGDCTitle)) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(iEditParts[i], true);
            }
            ++i;
        }
        this.strGDCTitle = this.strGDCTitle.substring(0, this.strGDCTitle.length() - 4);
        if (GlobalVariables.ProjectName == null) {
            GlobalVariables.ProjectName = "";
        }
        GlobalVariables.checkClockTree = false;
        GlobalVariables.isCubeRoverTest = false;
        try {
            LogManager.getInstance().info("GDProject", this.currentProjectName);
        }
        catch (Exception e) {
            System.err.println("Failed to initialize GDC logger: " + e.getMessage());
        }
        if (!GlobalVariables.isInitProject) {
            ProjectConfigUtil.ClearAllGlobalVars();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            final IProject project = root.getProject(this.currentProjectName);
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.Gdc_InitializingProject, -1);
                        GDCEditor.this.deserializeRet = SerializeAccess_Template.DeserializeExtract(project);
                        monitor.done();
                    }
                    catch (Throwable e) {
                        LogManager.getInstance().logThrowable(e);
                        throw new InvocationTargetException(e);
                    }
                }
            };
            Shell shell = Display.getCurrent().getActiveShell();
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
            try {
                progressMonitorDialog.run(true, false, iRunnableWithProgress);
                switch (this.deserializeRet) {
                    case 1: {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)("Project: " + GlobalVariables.ProjectName), (String)"Project is invalid.");
                        return;
                    }
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (SerializeAccess_Template.GDCFile_Flag == 1) {
                SerializeAccess.DeserializeExtract(project);
            }
        } else {
            GlobalVariables.lastSelectedMiddleWare.clear();
        }
        GlobalVariables.openGDCFileFlag = false;
        GlobalVariables.ProjectName = this.currentProjectName;
        this.container = new Composite(parent, 0x1040000);
        Frame frame = SWT_AWT.new_Frame((Composite)this.container);
        frame.setExtendedState(6);
        frame.setTitle("Project Configuration");
        frame.setName("Project Configuration");
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GlobalVariables.ProjectName != null) {
                    timer.cancel();
                    GlobalVariables.ProjectName = "";
                    ProjectConfigUtil.ClearAllGlobalVars();
                    GlobalVariables.isDirtyFlag = false;
                    GlobalVariables.isCodeGenFlag = false;
                    GDCEditor.this.timerFlag = false;
                }
            }
        });
        GdConfigPage.initConfigPage();
        frame.add((Component)GdConfigPage.TabsPanel, "Center");
        frame.pack();
        frame.setLocationRelativeTo(null);
        parent.setFocus();
        timer = new Timer();
        timer.schedule((TimerTask)new MyTimerTask(), 100L, 100L);
        GlobalVariables.openGDCFileFlag = true;
    }

    public void setFocus() {
        this.container.setFocus();
    }

    public void setDirty(boolean setDirty) {
        if (this.dirty != setDirty) {
            this.dirty = setDirty;
            this.firePropertyChange(257);
        }
    }

    public static GDCEditor getActiveGDCEditor(String strGDCTitle) {
        IWorkbenchPage iWorkbenchPage;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            IEditorReference[] iEditorReferences = iWorkbenchPage.getEditorReferences();
            int i = 0;
            while (i < iEditorReferences.length) {
                String strEditorTitle = iEditorReferences[i].getTitle();
                if (strEditorTitle.contains(".gdc") && !strEditorTitle.equals(strGDCTitle)) {
                    IEditorReference iEditorReference = iEditorReferences[i];
                    IEditorPart activeGDCEditor = iEditorReference.getEditor(false);
                    return (GDCEditor)activeGDCEditor;
                }
                ++i;
            }
        }
        return null;
    }

    class MyTimerTask
    extends TimerTask {
        MyTimerTask() {
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GlobalVariables.isCodeGenFlag) {
                        GDCEditor.this.setDirty(false);
                        GlobalVariables.isCodeGenFlag = false;
                        GlobalVariables.isDirtyFlag = false;
                        GDCEditor.this.timerFlag = false;
                    } else if (GlobalVariables.isDirtyFlag && !GDCEditor.this.timerFlag) {
                        GDCEditor.this.timerFlag = true;
                        GDCEditor.this.setDirty(true);
                    }
                }
            });
        }
    }
}

