/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs.arm.ui;

import com.gigadevice.mbs.Activator;
import com.gigadevice.mbs.arm.Option;
import com.gigadevice.mbs.arm.ToolchainDefinition;
import com.gigadevice.utils.preferences.EclipsePreferences;
import com.gigadevice.venustool.TargetOSInfo;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.ui.newui.ICPropertyTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CTestToolChainPropertyTab
extends AbstractCBuildPropertyTab
implements ICPropertyTab {
    private static final String TOOL_CCOMPILER_ID = "com.gigadevice.mbs.arm.tool.CCompiler";
    private static final String TOOLCHAIN_ID = "com.gigadevice.mbs.arm.toolChain";
    private Combo combotoolchainName;
    private Text TextToolChainPrefix;
    private Text TextToolChainPath;
    private Text TextBuildToolPath;
    private EclipsePreferences projPreferences = com.gigadevice.mbs.arm.Activator.getInstance().getProjectPreferences();
    private IConfiguration fConfig;
    private IConfiguration fLastUpdatedConfig;
    private IProject project;

    public CTestToolChainPropertyTab() {
        com.gigadevice.mbs.arm.Activator.setFieldEditorParent(null);
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.fConfig = this.getCfg();
        this.project = this.page.getProject();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.usercomp.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        this.usercomp.setLayoutData((Object)layoutData);
        Label LbltoolchainName = new Label(this.usercomp, 0);
        LbltoolchainName.setText("Toolchain Name: ");
        this.combotoolchainName = new Combo(this.usercomp, 2056);
        for (ToolchainDefinition tempToolchain : ToolchainDefinition.getToolchainList()) {
            this.combotoolchainName.add(tempToolchain.getToolchainName());
        }
        this.combotoolchainName.select(ToolchainDefinition.getToolchainDefaultIndex());
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.combotoolchainName.setLayoutData((Object)layoutData);
        Label LbltoolchainPrefix = new Label(this.usercomp, 0);
        LbltoolchainPrefix.setText("Toolchain Prefix: ");
        this.TextToolChainPrefix = new Text(this.usercomp, 2052);
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.TextToolChainPrefix.setLayoutData((Object)layoutData);
        this.TextToolChainPrefix.setEditable(true);
        Label label = new Label(this.usercomp, 0);
        label.setText("ToolChain Path:");
        this.TextToolChainPath = new Text(this.usercomp, 2052);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.TextToolChainPath.setLayoutData((Object)layoutData);
        Button button = new Button(this.usercomp, 0);
        button.setText("Browse");
        layoutData = new GridData(16384, 128, false, false, 1, 1);
        button.setLayoutData((Object)layoutData);
        Label buildLabel = new Label(this.usercomp, 0);
        buildLabel.setText("Build Tool Path:");
        this.TextBuildToolPath = new Text(this.usercomp, 2052);
        layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.TextBuildToolPath.setLayoutData((Object)layoutData);
        Button buildbutton = new Button(this.usercomp, 0);
        buildbutton.setText("Browse");
        layoutData = new GridData(16384, 128, false, false, 1, 1);
        buildbutton.setLayoutData((Object)layoutData);
        if (TargetOSInfo.isLinux()) {
            buildLabel.setVisible(false);
            this.TextBuildToolPath.setVisible(false);
            buildbutton.setVisible(false);
        }
        this.updateControlsForConfig(this.fConfig);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(CTestToolChainPropertyTab.this.usercomp.getShell(), 65536);
                String ToolChainPath = CTestToolChainPropertyTab.this.TextToolChainPath.getText();
                ToolChainPath = Option.getAbsolutePath(ToolChainPath);
                dirDialog.setFilterPath(ToolChainPath);
                String browsedDirectory = dirDialog.open();
                if (browsedDirectory == null) {
                    return;
                }
                if (CTestToolChainPropertyTab.this.checkToolchainFileExists(browsedDirectory, CTestToolChainPropertyTab.this.TextToolChainPrefix.getText())) {
                    browsedDirectory = Option.getRelativePath(browsedDirectory);
                    CTestToolChainPropertyTab.this.TextToolChainPath.setText(browsedDirectory);
                }
            }
        });
        buildbutton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(CTestToolChainPropertyTab.this.usercomp.getShell(), 65536);
                String BuildToolPath = CTestToolChainPropertyTab.this.TextBuildToolPath.getText();
                BuildToolPath = Option.getAbsolutePath(BuildToolPath);
                dirDialog.setFilterPath(BuildToolPath);
                String browsedDirectory = dirDialog.open();
                browsedDirectory = Option.getRelativePath(browsedDirectory);
                if (browsedDirectory.equals("")) {
                    return;
                }
                CTestToolChainPropertyTab.this.TextBuildToolPath.setText(browsedDirectory);
            }
        });
    }

    public void handleTabEvent(int kind, Object data) {
        super.handleTabEvent(kind, data);
    }

    public boolean canBeVisible() {
        return this.isThisPlugin();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        try {
            if (!this.updateConfig(CTestToolChainPropertyTab.getCfg((ICConfigurationDescription)src.getConfiguration()))) {
                return;
            }
            if (!this.updateConfig(CTestToolChainPropertyTab.getCfg((ICConfigurationDescription)dst.getConfiguration()))) {
                return;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        this.updatePreferences();
        ManagedBuildManager.saveBuildInfo((IProject)this.project, (boolean)true);
        if (this.checkLinkFileUpdateNeeded(this.getCfg()).booleanValue() && !this.UpdataTemplateLdParameters().booleanValue()) {
            return;
        }
    }

    protected void performDefaults() {
    }

    protected void updateData(ICResourceDescription cfg) {
    }

    protected void updateButtons() {
    }

    public boolean canSupportMultiCfg() {
        return true;
    }

    private boolean updateConfig(IConfiguration srcConfig) throws BuildException {
        IToolChain toolchain = srcConfig.getToolChain();
        String ToolChainName = this.combotoolchainName.getText();
        IOption option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_NAME);
        srcConfig.setOption((IHoldsOptions)toolchain, option, ToolChainName);
        String BuildToolPath = this.TextBuildToolPath.getText();
        IOption option3 = toolchain.getOptionById(Option.OPTIONID_BUILDTOOL_PATH);
        srcConfig.setOption((IHoldsOptions)toolchain, option3, BuildToolPath);
        Option.getToolsPath();
        String ToolChainPath = this.TextToolChainPath.getText();
        if (!this.checkToolchainFileExists(Option.getAbsolutePath(ToolChainPath), this.TextToolChainPrefix.getText())) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Information ", (String)"The current configuration of the toolChain is invalid and has been restored to the default configuration");
            if (TargetOSInfo.isWindows()) {
                this.TextToolChainPrefix.setText("arm-none-eabi-");
                this.TextToolChainPath.setText(".\\Tools\\GNU Tools ARM Embedded\\xpack-arm-none-eabi-gcc\\9.2.1-1.1\\bin");
            } else if (TargetOSInfo.isLinux()) {
                this.TextToolChainPrefix.setText("arm-none-eabi-");
                this.TextToolChainPath.setText("./Tools/GNUToolsARMEmbedded/xpack-arm-none-eabi-gcc/9.2.1-1.1/bin");
            }
            return false;
        }
        IOption option2 = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_PATH);
        srcConfig.setOption((IHoldsOptions)toolchain, option2, ToolChainPath);
        try {
            int index = ToolchainDefinition.getToolchainIndex(ToolChainName);
            ToolchainDefinition targetToolchain = ToolchainDefinition.getToolchain(index);
            String ToolchainPrefix = this.TextToolChainPrefix.getText();
            targetToolchain.updateToolchainPrefix(ToolchainPrefix.trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_PREFIX);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getToolchainPrefix().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_C);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getCCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_CPP);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getCPPCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_RM);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getRmCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_MAKE);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getMakeCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_OBJCOPY);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getObjcopyCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_OBJDUMP);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getObjdumpCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_SIZE);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getSizeCommander().trim());
            option = toolchain.getOptionById(Option.OPTIONID_TOOLCHAIN_AR);
            srcConfig.setOption((IHoldsOptions)toolchain, option, targetToolchain.getArchiverCommander().trim());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            com.gigadevice.mbs.arm.Activator.log("CTestToolChainPropertyTab.updateConfig():" + ToolChainName + " not found.");
            System.out.println("com.gigadevice.mbs.armCTestToolChainPropertyTab.updateConfig():" + ToolChainName + " not found.");
            return false;
        }
        return true;
    }

    private boolean checkToolchainFileExists(String ToolChainPath, String ToolChainPrefix) {
        File folder = new File(ToolChainPath);
        if (!folder.exists() && !folder.isDirectory()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning ", (String)"The toolChain path does not exist or is not a folder. Please check the path configuration.");
            return false;
        }
        ArrayList<String> toolchainList = new ArrayList<String>();
        if (TargetOSInfo.isWindows()) {
            toolchainList.add(String.valueOf(ToolChainPrefix) + "gcc.exe");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "objcopy.exe");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "objdump.exe");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "size.exe");
        } else if (TargetOSInfo.isLinux()) {
            toolchainList.add(String.valueOf(ToolChainPrefix) + "gcc");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "objcopy");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "objdump");
            toolchainList.add(String.valueOf(ToolChainPrefix) + "size");
        }
        boolean result = true;
        String Tips = "";
        int i = 0;
        while (i < toolchainList.size()) {
            File file = new File(String.valueOf(ToolChainPath) + File.separator + (String)toolchainList.get(i));
            if (!file.exists()) {
                Tips = String.valueOf(Tips) + (String)toolchainList.get(i) + "," + System.lineSeparator();
                result = false;
            }
            ++i;
        }
        if (!result) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning ", (String)("Files: " + System.lineSeparator() + Tips + "do not exist. Please check the toolchain path configuration."));
            return false;
        }
        return true;
    }

    private Boolean UpdataTemplateLdParameters() {
        String sCCompilerId;
        IToolChain toolchain = this.getCfg().getToolChain();
        ITool[] OtherTools = toolchain.getToolsBySuperClassId(sCCompilerId = TOOL_CCOMPILER_ID);
        if (OtherTools != null) {
            ITool[] iToolArray = OtherTools;
            int n = OtherTools.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    ITool tool = iToolArray[n2];
                    String sId = Option.OPTIONID_CCOMPILER_HIDE;
                    IOption option = tool.getOptionBySuperClassId(sId);
                    if (option != null) {
                        String sepStr = "^";
                        if (!this.projPreferences.getLinkFileSrcPath(this.project).isEmpty()) {
                            String oldPath = this.projPreferences.getLinkFileSrcPath(this.project);
                            String newPath = this.projPreferences.getLinkFileTargetPath(this.project);
                            String estack = this.projPreferences.getLinkFileStackOrigin(this.project);
                            String MinStackSize = this.projPreferences.getLinkFileStacklength(this.project);
                            String flashOrigin = this.projPreferences.getLinkFileFlashOrigin(this.project);
                            String flashLength = this.projPreferences.getLinkFileFlashlength(this.project);
                            String ramOrigin = this.projPreferences.getLinkFileRamOrigin(this.project);
                            String ramLength = this.projPreferences.getLinkFileRamLength(this.project);
                            String codeLocation = this.projPreferences.getLinkFileCodeLoaction(this.project);
                            String LdInfoStr = String.valueOf(oldPath) + sepStr + newPath + sepStr + estack + sepStr + MinStackSize + sepStr + flashOrigin + sepStr + flashLength + sepStr + ramOrigin + sepStr + ramLength + sepStr + codeLocation;
                            ManagedBuildManager.setOption((IConfiguration)this.getCfg(), (IHoldsOptions)tool, (IOption)option, (String)LdInfoStr);
                        } else {
                            try {
                                String[] ldinfoArray;
                                int size;
                                String valueStr = option.getStringValue();
                                if (valueStr.equals("")) {
                                    this.UpdataParameters();
                                }
                                if ((size = (ldinfoArray = valueStr.split(String.valueOf(File.separator) + sepStr)).length) > 8) {
                                    int i = 0;
                                    String oldPath = ldinfoArray[i++];
                                    String newPath = ldinfoArray[i++];
                                    String estack = ldinfoArray[i++];
                                    String MinStackSize = ldinfoArray[i++];
                                    String flashOrigin = ldinfoArray[i++];
                                    String flashLength = ldinfoArray[i++];
                                    String ramOrigin = ldinfoArray[i++];
                                    String ramLength = ldinfoArray[i++];
                                    String codeLocation = ldinfoArray[i++];
                                    this.projPreferences.putLinkFileSrcPath(oldPath, this.project);
                                    this.projPreferences.putLinkFileTargetPath(newPath, this.project);
                                    this.projPreferences.putLinkFileCodeLoaction(codeLocation, this.project);
                                    this.projPreferences.putLinkFileRamLength(ramLength, this.project);
                                    this.projPreferences.putLinkFileRamOrigin(ramOrigin, this.project);
                                    this.projPreferences.putLinkFileFlashlength(flashLength, this.project);
                                    this.projPreferences.putLinkFileFlashOrigin(flashOrigin, this.project);
                                    this.projPreferences.putLinkFileStacklength(MinStackSize, this.project);
                                    this.projPreferences.putLinkFileStackOrigin(estack, this.project);
                                    this.projPreferences.flush(this.project);
                                    break block9;
                                }
                                return false;
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                                return false;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    private void UpdataParameters() {
        String sCCompilerId;
        IToolChain toolchain = this.getCfg().getToolChain();
        ITool[] OtherTools = toolchain.getToolsBySuperClassId(sCCompilerId = TOOL_CCOMPILER_ID);
        if (OtherTools != null) {
            ITool[] iToolArray = OtherTools;
            int n = OtherTools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                String sepStr = "^";
                String oldPath = "";
                String newPath = "";
                String estack = "";
                String MinStackSize = "";
                String flashOrigin = "";
                String flashLength = "";
                String ramOrigin = "";
                String ramLength = "";
                String codeLocation = "";
                try {
                    oldPath = "";
                    newPath = "";
                    estack = tool.getOptionBySuperClassId(Option.OPTIONID_CCOMPILER_STACKBASE).getStringValue();
                    flashOrigin = tool.getOptionBySuperClassId(Option.OPTIONID_CCOMPILER_CODEBASE).getStringValue();
                    flashLength = tool.getOptionBySuperClassId(Option.OPTIONID_CCOMPILER_CODESIZE).getStringValue();
                    ramOrigin = tool.getOptionBySuperClassId(Option.OPTIONID_CCOMPILER_RAMBASE).getStringValue();
                    ramLength = tool.getOptionBySuperClassId(Option.OPTIONID_CCOMPILER_RAMSIZE).getStringValue();
                    codeLocation = "";
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
                String flashBaseInFlash = "";
                String flashSizeInFlash = "";
                String ramBaseInFlash = "";
                String ramSizeInFlash = "";
                String flashBaseInRam = "";
                String flashSizeInRam = "";
                String ramBaseInRam = "";
                String ramSizeInRam = "";
                this.projPreferences.putLinkFileSrcPath(oldPath, this.project);
                this.projPreferences.putLinkFileTargetPath(newPath, this.project);
                this.projPreferences.putLinkFileCodeLoaction(codeLocation, this.project);
                this.projPreferences.putLinkFileRamLength(ramLength, this.project);
                this.projPreferences.putLinkFileRamOrigin(ramOrigin, this.project);
                this.projPreferences.putLinkFileFlashlength(flashLength, this.project);
                this.projPreferences.putLinkFileFlashOrigin(flashOrigin, this.project);
                this.projPreferences.putLinkFileStacklength(MinStackSize, this.project);
                this.projPreferences.putLinkFileStackOrigin(estack, this.project);
                this.projPreferences.putFlashBaseInFlash(flashBaseInFlash, this.project);
                this.projPreferences.putFlashSizeInFlash(flashSizeInFlash, this.project);
                this.projPreferences.putRamBaseInFlash(ramBaseInFlash, this.project);
                this.projPreferences.putRamSizeInFlash(ramSizeInFlash, this.project);
                this.projPreferences.putFlashBaseInRam(flashBaseInRam, this.project);
                this.projPreferences.putFlashSizeInRam(flashSizeInRam, this.project);
                this.projPreferences.putRamBaseInRam(ramBaseInRam, this.project);
                this.projPreferences.putRamSizeInRam(ramSizeInRam, this.project);
                this.projPreferences.flush(this.project);
                String ldorigininfo = String.valueOf(flashBaseInFlash) + sepStr + flashSizeInFlash + sepStr + ramBaseInFlash + sepStr + ramSizeInFlash + sepStr + flashBaseInRam + sepStr + flashSizeInRam + sepStr + ramBaseInRam + sepStr + ramSizeInRam;
                String LdInfoStr = String.valueOf(oldPath) + sepStr + newPath + sepStr + estack + sepStr + MinStackSize + sepStr + flashOrigin + sepStr + flashLength + sepStr + ramOrigin + sepStr + ramLength + sepStr + codeLocation + sepStr + ldorigininfo;
                String sId = Option.OPTIONID_CCOMPILER_HIDE;
                IOption option = tool.getOptionBySuperClassId(sId);
                if (option != null) {
                    ManagedBuildManager.setOption((IConfiguration)this.getCfg(), (IHoldsOptions)tool, (IOption)option, (String)LdInfoStr);
                }
                ++n2;
            }
        }
    }

    public static String getOptionValueFromTool(ITool holderTool, String optId) {
        IOption option = holderTool.getOptionBySuperClassId(optId);
        if (option != null) {
            String sValue = null;
            try {
                sValue = option.getStringValue();
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            if (sValue != null && sValue.length() > 0) {
                sValue = sValue.trim();
                return sValue;
            }
        }
        return null;
    }

    private Boolean checkLinkFileUpdateNeeded(IConfiguration configuration) {
        String sCCompilerId;
        Boolean dirtyflag = false;
        String TargetCodePostion = this.projPreferences.getCodePostion(this.project);
        String TargetStackBase = this.projPreferences.getStackBase(this.project);
        String TargetStackSize = this.projPreferences.getStackSize(this.project);
        IToolChain toolchain = configuration.getToolChain();
        ITool[] OtherTools = toolchain.getToolsBySuperClassId(sCCompilerId = TOOL_CCOMPILER_ID);
        if (OtherTools != null) {
            ITool[] iToolArray = OtherTools;
            int n = OtherTools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                String sValue = CTestToolChainPropertyTab.getOptionValueFromTool(tool, Option.OPTIONID_CCOMPILER_CODEPOSITION);
                if (sValue != null && sValue.length() > 0) {
                    this.projPreferences.putCodePostion(sValue, this.project);
                    this.projPreferences.flush(this.project);
                    if (!sValue.equals(TargetCodePostion)) {
                        dirtyflag = true;
                    }
                    TargetCodePostion = sValue;
                }
                if ((sValue = CTestToolChainPropertyTab.getOptionValueFromTool(tool, Option.OPTIONID_CCOMPILER_STACKBASE)) != null && sValue.length() > 0) {
                    this.projPreferences.putStackBase(sValue, this.project);
                    this.projPreferences.flush(this.project);
                    if (!sValue.equals(TargetStackBase)) {
                        dirtyflag = true;
                    }
                    TargetStackBase = sValue;
                }
                if ((sValue = CTestToolChainPropertyTab.getOptionValueFromTool(tool, Option.OPTIONID_CCOMPILER_STACKSIZE)) != null && sValue.length() > 0) {
                    this.projPreferences.putStackSize(sValue, this.project);
                    this.projPreferences.flush(this.project);
                    if (!sValue.equals(TargetStackSize)) {
                        dirtyflag = true;
                    }
                    TargetStackSize = sValue;
                }
                ++n2;
            }
        }
        return dirtyflag;
    }

    protected void performOK() {
        try {
            if (!this.updateConfig(this.fConfig)) {
                return;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        this.updatePreferences();
        if (this.checkLinkFileUpdateNeeded(this.getCfg()).booleanValue() && !this.UpdataTemplateLdParameters().booleanValue()) {
            return;
        }
    }

    private boolean isThisPlugin() {
        IConfiguration fConfig = this.getCfg();
        String toolchainId = fConfig.getToolChain().getBaseId();
        if (!toolchainId.startsWith("com.gigadevice.mbs.arm.toolChain.")) {
            if (com.gigadevice.mbs.arm.Activator.getInstance().isDebugging()) {
                System.out.println("com.gigadevice.mbs.armCTestToolChainPropertyTab.isThisPlugin() return false");
            }
            return false;
        }
        return true;
    }

    protected void updateToolChainPrefix(String toolchainName) {
        assert (this.fConfig != null);
        String toolchainPrefix = this.projPreferences.getToolchainPrefix(this.project);
        this.TextToolChainPrefix.setText(toolchainPrefix);
    }

    protected void updateToolchainPath(String toolchainName) {
        assert (this.fConfig != null);
        String toolchainPath = this.projPreferences.getToolchainPath(toolchainName, this.project);
        this.TextToolChainPath.setText(toolchainPath);
    }

    protected void updateBuildToolsPath() {
        assert (this.fConfig != null);
        String Path2 = this.projPreferences.getBuildToolsPath(this.project);
        this.TextBuildToolPath.setText(Path2);
    }

    private void updateControlsForConfig(IConfiguration config) {
        if (com.gigadevice.mbs.arm.Activator.getInstance().isDebugging()) {
            System.out.println("com.gigadevice.mbs.armCTestToolChainPropertyTab.updateControlsForConfig() for " + config.getName());
        }
        if (!this.isThisPlugin()) {
            return;
        }
        String fSelectedToolchainName = Option.getOptionStringValue((IConfiguration)config, (String)Option.OPTIONID_TOOLCHAIN_NAME);
        if (fSelectedToolchainName != null && fSelectedToolchainName.length() > 0) {
            try {
                int index = ToolchainDefinition.getToolchainIndex(fSelectedToolchainName);
                ToolchainDefinition targetToolchain = ToolchainDefinition.getToolchain(index);
                this.fConfig = config;
                if (com.gigadevice.mbs.arm.Activator.getInstance().isDebugging()) {
                    System.out.println("arm.Toolchains.updateControlsForConfig() fConfig=" + this.fConfig);
                }
                this.fLastUpdatedConfig = config;
                this.InitInformation(config);
                if (this.TextToolChainPrefix.getText().length() == 0) {
                    this.updateToolChainPrefix(targetToolchain.getToolchainPrefix().trim());
                }
                if (this.TextToolChainPath.getText().length() == 0) {
                    this.updateToolchainPath(targetToolchain.getToolchainPrefix().trim());
                }
                if (this.TextBuildToolPath.getText().length() == 0) {
                    this.updateBuildToolsPath();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                com.gigadevice.mbs.arm.Activator.log("CTestToolChainPropertyTab.updateControlsForConfig():" + fSelectedToolchainName + " not found.");
                System.out.println("com.gigadevice.mbs.armCTestToolChainPropertyTab.updateControlsForConfig():" + fSelectedToolchainName + " not found.");
                if (TargetOSInfo.isWindows()) {
                    this.TextToolChainPrefix.setText("arm-none-eabi-");
                    this.TextToolChainPath.setText("./Tools/GNU Tools ARM Embedded/xpack-arm-none-eabi-gcc/9.2.1-1.1/bin");
                    this.TextBuildToolPath.setText("./Tools/Build Tools/2.10-20180103-1919/bin");
                } else if (TargetOSInfo.isLinux()) {
                    this.TextToolChainPrefix.setText("arm-none-eabi-");
                    this.TextToolChainPath.setText("./Tools/GNUToolsARMEmbedded/xpack-arm-none-eabi-gcc/9.2.1-1.1/bin");
                    this.TextBuildToolPath.setText("./Tools/BuildTools/2.10-20180103-1919/bin");
                }
                return;
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
        }
    }

    private void InitInformation(IConfiguration srcConfig) throws BuildException {
        srcConfig.getToolChain();
        String value = null;
        value = Option.getOptionStringValue((IConfiguration)srcConfig, (String)Option.OPTIONID_TOOLCHAIN_NAME);
        value = value.trim();
        if (value != null && value.length() > 0) {
            this.combotoolchainName.select(ToolchainDefinition.getToolchainIndex(value));
        }
        if ((value = Option.getOptionStringValue((IConfiguration)srcConfig, (String)Option.OPTIONID_TOOLCHAIN_PATH)) != null && value.length() > 0) {
            value = value.trim();
            if (TargetOSInfo.isLinux()) {
                value = value.replaceAll(" ", "");
            }
            this.TextToolChainPath.setText(value);
        }
        if ((value = Option.getOptionStringValue((IConfiguration)srcConfig, (String)Option.OPTIONID_TOOLCHAIN_PREFIX)) != null && value.length() > 0) {
            value = value.trim();
            this.TextToolChainPrefix.setText(value);
        }
        if ((value = Option.getOptionStringValue((IConfiguration)srcConfig, (String)Option.OPTIONID_BUILDTOOL_PATH)) != null && value.length() > 0) {
            value = value.trim();
            this.TextBuildToolPath.setText(value);
        }
    }

    private void updatePreferences() {
        String toolchainName = this.combotoolchainName.getText();
        this.projPreferences.putToolchainName(toolchainName, this.project);
        this.projPreferences.putToolchainPrefix(this.TextToolChainPrefix.getText(), this.project);
        this.UpdateGDB();
        this.projPreferences.putToolchainPath(toolchainName, this.TextToolChainPath.getText(), this.project);
        this.projPreferences.putBuildToolsPath(this.TextBuildToolPath.getText(), this.project);
        this.projPreferences.flush(this.project);
    }

    public void UpdateGDB() {
        String value;
        ILaunchConfiguration launchConfig = CTestToolChainPropertyTab.getTargetLanuchConfiguration(this.project);
        if (launchConfig == null) {
            return;
        }
        ILaunchConfigurationWorkingCopy launchConfigTemp = null;
        try {
            launchConfigTemp = launchConfig.getWorkingCopy();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (launchConfigTemp != null && (value = this.TextToolChainPath.getText()) != null && value.length() > 0) {
            value = value.trim();
            String AbsolutePath = Option.getAbsolutePath(value);
            launchConfigTemp.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", String.valueOf(AbsolutePath) + File.separator + this.TextToolChainPrefix.getText() + "gdb.exe");
            try {
                launchConfigTemp.doSave();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ILaunchConfiguration getTargetLanuchConfiguration(IProject project) {
        ILaunchBarManager manager = (ILaunchBarManager)Activator.getService(ILaunchBarManager.class);
        ILaunchConfiguration launchConfig = null;
        try {
            launchConfig = manager.getActiveLaunchConfiguration();
            if (launchConfig == null) {
                return null;
            }
            String projectName = launchConfig.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (!projectName.equalsIgnoreCase(project.getName())) {
                launchConfig = null;
                ILaunchDescriptor[] descs = manager.getLaunchDescriptors();
                ILaunchConfiguration tmp = null;
                int i = 0;
                while (i < descs.length) {
                    ILaunchTarget[] targets = manager.getLaunchTargets(descs[i]);
                    tmp = manager.getLaunchConfiguration(descs[i], targets[0]);
                    if (tmp == null) {
                        return null;
                    }
                    String tmpName = tmp.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                    if (tmpName.equalsIgnoreCase(project.getName())) {
                        launchConfig = tmp;
                    }
                    ++i;
                }
            }
            if (launchConfig != null) return launchConfig;
            return null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

