/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs.arm;

import com.gigadevice.mbs.arm.Activator;
import com.gigadevice.mbs.arm.Option;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;

public class ConfigurationBuildMacroSupplier
implements IConfigurationBuildMacroSupplier {
    private String[] fCmds = new String[]{"command_c", "command_cpp", "command_objcopy", "command_objdump", "command_size", "command_ar", "command_make", "command_rm", "command_prefix"};
    private static String CROSS_FLAGS = "cross_toolchain_flags";
    private static String INCLUDE_FLAGS = "cross_includes";
    private static String SYMBOL_FLAGS = "cross_symbols";
    private String[] fileGenerateCmds = new String[]{"generate_map", "generate_list", "generate_hex", "generate_bin"};
    private static String OBJCPY_OTHER_FLAGS = "objcpy_others";
    private static String OBJDUMP_OTHER_FLAGS = "objdump_others";
    private static String SIZE_OTHER_FLAGS = "size_others";

    public IBuildMacro getMacro(String macroName, IConfiguration configuration, IBuildMacroProvider provider) {
        String sValue;
        String sCmd;
        IToolChain toolchain = configuration.getToolChain();
        String[] stringArray = this.fCmds;
        int n = this.fCmds.length;
        int n2 = 0;
        while (n2 < n) {
            sCmd = stringArray[n2];
            if (sCmd.equals(macroName)) {
                String sId = String.valueOf(Option.OPTIONID_TOOLCHAIN) + sCmd.replace("command_", "");
                IOption option = toolchain.getOptionBySuperClassId(sId);
                if (option != null) {
                    int index;
                    String sVal = (String)option.getValue();
                    if (!sCmd.equals("command_prefix") && (index = sVal.lastIndexOf("-")) > 0) {
                        sVal = sVal.substring(index + 1, sVal.length());
                    }
                    return new BuildMacro(macroName, 1, sVal);
                }
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("com.gigadevice.mbs.arm.ConfigurationBuildMacroSupplier.getMacro(): " + sId + "not found. ");
                }
                return null;
            }
            ++n2;
        }
        if (CROSS_FLAGS.equals(macroName) && (sValue = Option.getToolChainFlags(configuration)) != null && sValue.length() > 0) {
            return new BuildMacro(macroName, 1, sValue);
        }
        if (SYMBOL_FLAGS.equals(macroName) && (sValue = Option.getSymbolFlags(configuration)) != null && sValue.length() > 0) {
            return new BuildMacro(macroName, 1, sValue);
        }
        stringArray = this.fileGenerateCmds;
        n = this.fileGenerateCmds.length;
        n2 = 0;
        while (n2 < n) {
            sCmd = stringArray[n2];
            if (sCmd.equals(macroName)) {
                String sId = String.valueOf(Option.OPTIONID_OUTPUTFILE) + sCmd.replace("generate_", "");
                IOption option = toolchain.getOptionBySuperClassId(sId);
                if (option != null) {
                    try {
                        if (option.getBooleanValue()) {
                            String sVal = option.getCommand();
                            return new BuildMacro(macroName, 1, sVal);
                        }
                    }
                    catch (BuildException e) {
                        e.printStackTrace();
                    }
                }
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("com.gigadevice.mbs.arm.ConfigurationBuildMacroSupplier.getMacro(): " + sId + "not found. ");
                }
                return null;
            }
            ++n2;
        }
        if (OBJCPY_OTHER_FLAGS.equals(macroName) && (sValue = Option.getObjCpyOtherFlags(configuration)) != null && sValue.length() > 0) {
            return new BuildMacro(macroName, 1, sValue);
        }
        if (OBJDUMP_OTHER_FLAGS.equals(macroName) && (sValue = Option.getObjDumpOtherFlags(configuration)) != null && sValue.length() > 0) {
            return new BuildMacro(macroName, 1, sValue);
        }
        if (SIZE_OTHER_FLAGS.equals(macroName) && (sValue = Option.getSizeOtherFlags(configuration)) != null && sValue.length() > 0) {
            return new BuildMacro(macroName, 1, sValue);
        }
        return null;
    }

    public IBuildMacro[] getMacros(IConfiguration configuration, IBuildMacroProvider provider) {
        String sValue;
        IOption option;
        String sId;
        String cmd;
        IToolChain toolchain = configuration.getToolChain();
        ArrayList<BuildMacro> oMacrosList = new ArrayList<BuildMacro>();
        String[] stringArray = this.fCmds;
        int n = this.fCmds.length;
        int n2 = 0;
        while (n2 < n) {
            cmd = stringArray[n2];
            sId = String.valueOf(Option.OPTIONID_TOOLCHAIN) + cmd.replace("command_", "");
            option = toolchain.getOptionBySuperClassId(sId);
            if (option != null) {
                int index;
                sValue = (String)option.getValue();
                if (!cmd.equals("command_prefix") && (index = sValue.lastIndexOf("-")) > 0) {
                    sValue = sValue.substring(index + 1, sValue.length());
                }
                oMacrosList.add(new BuildMacro(cmd, 1, sValue));
            }
            ++n2;
        }
        sValue = Option.getToolChainFlags(configuration);
        if (sValue != null && sValue.length() > 0) {
            oMacrosList.add(new BuildMacro(CROSS_FLAGS, 1, sValue));
        }
        if ((sValue = Option.getSymbolFlags(configuration)) != null && sValue.length() > 2) {
            oMacrosList.add(new BuildMacro(SYMBOL_FLAGS, 1, sValue));
        }
        stringArray = this.fileGenerateCmds;
        n = this.fileGenerateCmds.length;
        n2 = 0;
        while (n2 < n) {
            cmd = stringArray[n2];
            sId = String.valueOf(Option.OPTIONID_OUTPUTFILE) + cmd.replace("generate_", "");
            option = toolchain.getOptionBySuperClassId(sId);
            if (option != null) {
                try {
                    if (option.getBooleanValue()) {
                        sValue = option.getCommand();
                        oMacrosList.add(new BuildMacro(cmd, 1, sValue));
                    }
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        sValue = Option.getObjCpyOtherFlags(configuration);
        if (sValue != null && sValue.length() > 0) {
            oMacrosList.add(new BuildMacro(OBJCPY_OTHER_FLAGS, 1, sValue));
        }
        if ((sValue = Option.getObjDumpOtherFlags(configuration)) != null && sValue.length() > 0) {
            oMacrosList.add(new BuildMacro(OBJDUMP_OTHER_FLAGS, 1, sValue));
        }
        if ((sValue = Option.getSizeOtherFlags(configuration)) != null && sValue.length() > 0) {
            oMacrosList.add(new BuildMacro(SIZE_OTHER_FLAGS, 1, sValue));
        }
        return oMacrosList.toArray(new IBuildMacro[0]);
    }
}

