/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.adapter.jlink;

import com.gigadevice.adapter.AdapterInterface;
import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.venustool.adapter.JLinkInfoUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;

public class JLinkOperation
extends AdapterInterface {
    private static String JLINK_PATH = "";
    private static String SCRIPT_PATH = "";

    @Override
    public Boolean eraseChip() {
        char[] McuID = new char[10];
        if (!this.readMcuID(McuID).booleanValue()) {
            return false;
        }
        ArrayList<String> scriptStrList = new ArrayList<String>();
        scriptStrList.add("device " + JLinkOperation.getJlinkMCUPart(TargetAdapter.getTargetMcuPartNo()));
        if (TargetAdapter.getInterface() == 0) {
            scriptStrList.add("if JTAG");
            scriptStrList.add("JTAGConf -1,-1");
        } else if (TargetAdapter.getInterface() == 1) {
            scriptStrList.add("if SWD");
        }
        scriptStrList.add("speed 4000");
        scriptStrList.add("r");
        scriptStrList.add("erase");
        scriptStrList.add("r");
        scriptStrList.add("g");
        scriptStrList.add("q");
        String content = "";
        for (String str : scriptStrList) {
            content = String.valueOf(content) + str + System.getProperty("line.separator");
        }
        return JLinkOperation.jlinkCliScriptExecute(content);
    }

    public Boolean downloadBin(byte[] pData, long DownloadAddress, long DataLenght) {
        Boolean flag = false;
        return flag;
    }

    @Override
    public Boolean readMcuID(char[] retVal) {
        Boolean readIDFlag;
        block24: {
            readIDFlag = false;
            ArrayList<String> scriptStrList = new ArrayList<String>();
            scriptStrList.add("device " + JLinkOperation.getJlinkMCUPart(TargetAdapter.getTargetMcuPartNo()));
            if (TargetAdapter.getInterface() == 0) {
                scriptStrList.add("if JTAG");
                scriptStrList.add("JTAGConf -1,-1");
            } else if (TargetAdapter.getInterface() == 1) {
                scriptStrList.add("if SWD");
            }
            scriptStrList.add("speed 4000");
            scriptStrList.add("r");
            scriptStrList.add("q");
            String scriptContent = "";
            for (String str : scriptStrList) {
                scriptContent = String.valueOf(scriptContent) + str + System.getProperty("line.separator");
            }
            JLINK_PATH = AdapterUtils.getJlinkExePath();
            SCRIPT_PATH = AdapterUtils.getJlinkScriptPath();
            JLinkOperation.createJlinkScript(scriptContent);
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(JLINK_PATH);
            String jlinkConfigFile = AdapterUtils.getJlinkConfigFilePath();
            Path jlinkConfigPath = Paths.get(jlinkConfigFile, new String[0]);
            if (Files.exists(jlinkConfigPath, new LinkOption[0])) {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(jlinkConfigFile);
                    InputStreamReader reader = new InputStreamReader(fin);
                    BufferedReader buffReader = new BufferedReader(reader);
                    String strTmp = "";
                    try {
                        while ((strTmp = buffReader.readLine()) != null) {
                            commands.add(strTmp);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    buffReader.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                commands.add("-NoGui");
                commands.add("1");
            }
            commands.add("-CommandFile");
            commands.add(SCRIPT_PATH);
            ProcessBuilder processBuilder = new ProcessBuilder(commands);
            try {
                Process process = processBuilder.start();
                boolean finished = process.waitFor(5000L, TimeUnit.MILLISECONDS);
                if (finished) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        int index;
                        System.out.println(line);
                        if (TargetAdapter.getInterface() == 0) {
                            if (line.contains("JTAG chain detection found")) {
                                readIDFlag = true;
                                char[] unknownChars = "Unknown".toCharArray();
                                int len = Math.min(unknownChars.length, retVal.length);
                                int i = 0;
                                while (i < len) {
                                    retVal[i] = unknownChars[i];
                                    ++i;
                                }
                                continue;
                            }
                            if (!line.contains("Id: 0x") || !readIDFlag.booleanValue()) continue;
                            int idIndex = line.indexOf("Id: 0x");
                            if (idIndex <= 0) break;
                            int endIndex = line.indexOf(",", idIndex);
                            if (endIndex == -1) {
                                endIndex = line.length();
                            }
                            String idStr = line.substring(idIndex + 4, endIndex).trim();
                            char[] idChars = idStr.toCharArray();
                            int len = Math.min(idChars.length, retVal.length);
                            int i = 0;
                            while (i < len) {
                                retVal[i] = idChars[i];
                                ++i;
                            }
                            readIDFlag = true;
                            break;
                        }
                        if (TargetAdapter.getInterface() != 1) continue;
                        if (line.contains("Found SW-DP with ID")) {
                            line = line.replace("Found SW-DP with ID", "");
                            line = line.replace(" ", "");
                            int len = line.length();
                            index = 0;
                            while (index < len) {
                                retVal[index] = line.charAt(index);
                                ++index;
                            }
                            readIDFlag = true;
                            break;
                        }
                        if (!line.contains("DPIDR:")) continue;
                        line = line.replace("DPIDR:", "");
                        line = line.replace(" ", "");
                        int len = line.length();
                        index = 0;
                        while (index < len) {
                            retVal[index] = line.charAt(index);
                            ++index;
                        }
                        readIDFlag = true;
                        break;
                    }
                    int exitCode = process.exitValue();
                    System.out.println("Exited with code: " + exitCode);
                    break block24;
                }
                System.out.println("Process did not finish within the timeout.");
                process.destroy();
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        JLinkOperation.deleteJlinkScript();
        return readIDFlag;
    }

    @Override
    public Boolean downloadBin(String TargetFileName, long DownloadAddress) {
        char[] McuID = new char[10];
        if (!this.readMcuID(McuID).booleanValue()) {
            return false;
        }
        ArrayList<String> scriptStrList = new ArrayList<String>();
        scriptStrList.add("device " + JLinkOperation.getJlinkMCUPart(TargetAdapter.getTargetMcuPartNo()));
        if (TargetAdapter.getInterface() == 0) {
            scriptStrList.add("if JTAG");
            scriptStrList.add("JTAGConf -1,-1");
        } else if (TargetAdapter.getInterface() == 1) {
            scriptStrList.add("if SWD");
        }
        scriptStrList.add("speed 4000");
        scriptStrList.add("r");
        scriptStrList.add("loadfile \"" + TargetFileName + "\" " + Long.toHexString(DownloadAddress));
        scriptStrList.add("r");
        scriptStrList.add("g");
        scriptStrList.add("q");
        String content = "";
        for (String str : scriptStrList) {
            content = String.valueOf(content) + str + System.getProperty("line.separator");
        }
        return JLinkOperation.jlinkCliScriptExecute(content);
    }

    public static Boolean jlinkCliScriptExecute(String scriptContent) {
        Boolean flag = false;
        JLINK_PATH = AdapterUtils.getJlinkExePath();
        Path path = Paths.get(JLINK_PATH, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            System.out.println("The file does not exist\u951b\ufffd" + path);
            return false;
        }
        SCRIPT_PATH = AdapterUtils.getJlinkScriptPath();
        JLinkOperation.createJlinkScript(scriptContent);
        String jlinkConfigFile = AdapterUtils.getJlinkConfigFilePath();
        Path jlinkConfigPath = Paths.get(jlinkConfigFile, new String[0]);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(JLINK_PATH);
        if (Files.exists(jlinkConfigPath, new LinkOption[0])) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(jlinkConfigFile);
                InputStreamReader reader = new InputStreamReader(fin);
                BufferedReader buffReader = new BufferedReader(reader);
                String strTmp = "";
                try {
                    while ((strTmp = buffReader.readLine()) != null) {
                        commands.add(strTmp);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                buffReader.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            commands.add("-NoGui");
            commands.add("1");
        }
        commands.add("-CommandFile");
        commands.add(SCRIPT_PATH);
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        try {
            Process process = processBuilder.start();
            boolean finished = process.waitFor(10L, TimeUnit.SECONDS);
            if (finished) {
                int exitCode = process.exitValue();
                System.out.println("Exited with code: " + exitCode);
                flag = true;
            } else {
                System.out.println("Process did not finish within the timeout.");
                process.destroy();
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        JLinkOperation.deleteJlinkScript();
        return flag;
    }

    public static String getJlinkMCUPart(String mcuPart) {
        mcuPart = JLinkInfoUtils.getJLinkPartNum((String)mcuPart);
        return mcuPart;
    }

    private static Boolean createJlinkScript(String scriptContent) {
        SCRIPT_PATH = AdapterUtils.getJlinkScriptPath();
        File file = new File(SCRIPT_PATH);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(scriptContent);
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("\u9359\u6220\u6553\u95bf\u6b12\ue1e4:" + e.getMessage());
            return false;
        }
    }

    private static Boolean deleteJlinkScript() {
        SCRIPT_PATH = AdapterUtils.getJlinkScriptPath();
        File file = new File(SCRIPT_PATH);
        if (file.exists()) {
            if (file.delete()) {
                System.out.println("\u93c2\u56e6\u6b22\u5bb8\u53c9\u579a\u9354\u71b7\u57b9\u95c4\u3083\ufffd\ufffd");
                return true;
            }
            System.out.println("\u93c3\u72b3\u7876\u9352\u72bb\u6ace\u93c2\u56e6\u6b22");
        } else {
            System.out.println("\u93c2\u56e6\u6b22\u6d93\u5d85\u74e8\u9366\u3123\ufffd\ufffd");
        }
        return false;
    }

    public static Boolean checkJlinkGDBServerFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            String gdbName;
            String string = gdbName = System.getProperty("os.name").toLowerCase().contains("win") ? "JLinkGDBServerCL.exe" : "JLinkGDBServerCLExe";
            if (file.getName().equals(gdbName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean setProjectAndUpdateOption(IProject project) {
        return null;
    }

    @Override
    public Boolean downloadHex(String TargetHexFileName, String DownloadAddress, String DownloadLength) {
        return null;
    }
}

