/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.adapter.gdlink;

import com.gigadevice.adapter.AdapterInterface;
import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.TargetOSInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDLinkOperation
extends AdapterInterface {
    private static String MCUPartNo = "";
    private static boolean ConnectUnderReset = false;
    private static boolean NeedSDCommand = false;
    private static String GDLINK_PATH = "";
    private static String SCRIPT_PATH = "";
    private static TargetAdapter.MbsType mbsSel;

    public static void setConnectUnderReset(boolean mConnectUnderReset) {
        ConnectUnderReset = mConnectUnderReset;
    }

    public static void setMCUPartNo(String mCUPartNo) {
        MCUPartNo = mCUPartNo;
    }

    @Override
    public Boolean setProjectAndUpdateOption(IProject project) {
        try {
            mbsSel = AdapterUtils.getToolChainType(project);
            ILaunchConfiguration launchConfig = AdapterUtils.getTargetLanuchConfiguration(project);
            if (launchConfig != null) {
                ConnectUnderReset = launchConfig.getAttribute("com.gigadevice.debug.connectUnderReset", false);
                MCUPartNo = launchConfig.getAttribute("com.gigadevice.debug.launch.device", "");
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean readMcuID(char[] retVal) {
        Boolean readIDFlag = false;
        NeedSDCommand = false;
        ArrayList<String> scriptStrList = new ArrayList<String>();
        if (ConnectUnderReset) {
            scriptStrList.add("SetConnectUnderReset 1");
        } else {
            scriptStrList.add("SetConnectUnderReset 0");
        }
        scriptStrList.add("connect");
        scriptStrList.add("q");
        String scriptContent = "";
        for (String str : scriptStrList) {
            scriptContent = String.valueOf(scriptContent) + str + System.getProperty("line.separator");
        }
        GDLINK_PATH = GDLinkOperation.getGDLinkPath();
        SCRIPT_PATH = GDLinkOperation.getScriptPath();
        GDLinkOperation.createGDLinkScript(scriptContent);
        ProcessBuilder processBuilder = GDLinkOperation.createProcessBuilder(GDLINK_PATH, SCRIPT_PATH);
        try {
            Process process = processBuilder.start();
            boolean finished = process.waitFor(10L, TimeUnit.SECONDS);
            if (finished) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    int len;
                    if (line.contains("SWD ID:")) {
                        line = line.replace("SWD ID:", "");
                        line = line.replace(" ", "");
                        len = line.length();
                        int index = 0;
                        while (index < len) {
                            retVal[index] = line.charAt(index);
                            ++index;
                        }
                        readIDFlag = true;
                        break;
                    }
                    if (line.contains("#0 ID:")) {
                        line = line.split(",")[0];
                        line = line.replace("#0 ID:", "");
                        line = line.replace(" ", "");
                        len = line.length();
                        int index = 0;
                        while (index < len) {
                            retVal[index] = line.charAt(index);
                            ++index;
                        }
                        readIDFlag = true;
                        break;
                    }
                    if (!line.contains("please set Part No")) continue;
                    NeedSDCommand = true;
                    break;
                }
                int exitCode = process.exitValue();
                System.out.println("Exited with code: " + exitCode);
            } else {
                System.out.println("Process did not finish within the timeout.");
                process.destroy();
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        GDLinkOperation.deleteGDLinkScript();
        if (NeedSDCommand) {
            readIDFlag = this.readMcuIDByPartNo(retVal);
        }
        return readIDFlag;
    }

    public Boolean readMcuIDByPartNo(char[] retVal) {
        Boolean readIDFlag = false;
        ArrayList<String> scriptStrList = new ArrayList<String>();
        if (ConnectUnderReset) {
            scriptStrList.add("SetConnectUnderReset 1");
        } else {
            scriptStrList.add("SetConnectUnderReset 0");
        }
        scriptStrList.add("connect");
        scriptStrList.add("sd" + MCUPartNo);
        scriptStrList.add("q");
        String scriptContent = "";
        for (String str : scriptStrList) {
            scriptContent = String.valueOf(scriptContent) + str + System.getProperty("line.separator");
        }
        GDLINK_PATH = GDLinkOperation.getGDLinkPath();
        SCRIPT_PATH = GDLinkOperation.getScriptPath();
        GDLinkOperation.createGDLinkScript(scriptContent);
        ProcessBuilder processBuilder = GDLinkOperation.createProcessBuilder(GDLINK_PATH, SCRIPT_PATH);
        try {
            Process process = processBuilder.start();
            boolean finished = process.waitFor(10L, TimeUnit.SECONDS);
            if (finished) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    int len;
                    if (line.contains("SWD ID:")) {
                        line = line.replace("SWD ID:", "");
                        line = line.replace(" ", "");
                        len = line.length();
                        int index = 0;
                        while (index < len) {
                            retVal[index] = line.charAt(index);
                            ++index;
                        }
                        readIDFlag = true;
                        break;
                    }
                    if (!line.contains("#0 ID:")) continue;
                    line = line.split(",")[0];
                    line = line.replace("#0 ID:", "");
                    line = line.replace(" ", "");
                    len = line.length();
                    int index = 0;
                    while (index < len) {
                        retVal[index] = line.charAt(index);
                        ++index;
                    }
                    readIDFlag = true;
                    break;
                }
                int exitCode = process.exitValue();
                System.out.println("Exited with code: " + exitCode);
            } else {
                System.out.println("Process did not finish within the timeout.");
                process.destroy();
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        GDLinkOperation.deleteGDLinkScript();
        return readIDFlag;
    }

    @Override
    public Boolean downloadBin(String TargetFileName, long DownloadAddress) {
        char[] McuID = new char[10];
        if (!this.readMcuID(McuID).booleanValue()) {
            return false;
        }
        ArrayList<String> scriptStrList = new ArrayList<String>();
        if (ConnectUnderReset) {
            scriptStrList.add("SetConnectUnderReset 1");
        } else {
            scriptStrList.add("SetConnectUnderReset 0");
        }
        scriptStrList.add("connect");
        if (NeedSDCommand) {
            scriptStrList.add("sd" + MCUPartNo);
        }
        scriptStrList.add("load \"" + TargetFileName + "\" " + Long.toHexString(DownloadAddress));
        scriptStrList.add("q");
        String content = "";
        for (String str : scriptStrList) {
            content = String.valueOf(content) + str + System.getProperty("line.separator");
        }
        return GDLinkOperation.CliScriptExecute(content);
    }

    @Override
    public Boolean downloadHex(String TargetHexFileName, String DownloadAddress, String DownloadLength) {
        char[] McuID = new char[10];
        if (!this.readMcuID(McuID).booleanValue()) {
            return false;
        }
        ArrayList<String> scriptStrList = new ArrayList<String>();
        if (ConnectUnderReset) {
            scriptStrList.add("SetConnectUnderReset 1");
        } else {
            scriptStrList.add("SetConnectUnderReset 0");
        }
        scriptStrList.add("connect");
        if (NeedSDCommand) {
            scriptStrList.add("sd" + MCUPartNo);
        }
        scriptStrList.add("load \"" + TargetHexFileName + "\" ");
        scriptStrList.add("halt");
        scriptStrList.add("r");
        scriptStrList.add("g");
        scriptStrList.add("q");
        String content = "";
        for (String str : scriptStrList) {
            content = String.valueOf(content) + str + System.getProperty("line.separator");
        }
        return GDLinkOperation.CliScriptExecute(content);
    }

    @Override
    public Boolean eraseChip() {
        char[] McuID = new char[10];
        if (!this.readMcuID(McuID).booleanValue()) {
            return false;
        }
        ArrayList<String> scriptStrList = new ArrayList<String>();
        if (ConnectUnderReset) {
            scriptStrList.add("SetConnectUnderReset 1");
        } else {
            scriptStrList.add("SetConnectUnderReset 0");
        }
        scriptStrList.add("connect");
        if (NeedSDCommand) {
            scriptStrList.add("sd" + MCUPartNo);
        }
        scriptStrList.add("erase");
        scriptStrList.add("q");
        String content = "";
        for (String str : scriptStrList) {
            content = String.valueOf(content) + str + System.getProperty("line.separator");
        }
        return GDLinkOperation.CliScriptExecute(content);
    }

    public static Boolean CliScriptExecute(String scriptContent) {
        Boolean flag = false;
        String EXEPath = GDLinkOperation.getGDLinkPath();
        Path path = Paths.get(EXEPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            System.out.println("The file does not exist.");
            return false;
        }
        SCRIPT_PATH = GDLinkOperation.getScriptPath();
        GDLinkOperation.createGDLinkScript(scriptContent);
        ProcessBuilder processBuilder = GDLinkOperation.createProcessBuilder(EXEPath, SCRIPT_PATH);
        if (processBuilder != null) {
            try {
                Process process = processBuilder.start();
                boolean finished = process.waitFor(300L, TimeUnit.SECONDS);
                if (finished) {
                    int exitCode = process.exitValue();
                    System.out.println("Exited with code: " + exitCode);
                    if (exitCode == 0) {
                        flag = true;
                    }
                } else {
                    System.out.println("Process did not finish within the timeout.");
                    process.destroy();
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
        GDLinkOperation.deleteGDLinkScript();
        return flag;
    }

    public static ProcessBuilder createProcessBuilder(String EXEPath, String SCRIPT_PATH) {
        ProcessBuilder processBuilder = new ProcessBuilder(EXEPath, "-commandfile", "-e", SCRIPT_PATH);
        return processBuilder;
    }

    private static String getGDLinkPath() {
        String path = TargetOSInfo.isWindows() ? String.valueOf(GeneralPathUtil.getToolsPath()) + File.separator + "GDLinkGDBServer" + File.separator + "GDLink_CLI.exe" : String.valueOf(GeneralPathUtil.getToolsPath()) + File.separator + "GDLinkGDBServer" + File.separator + "bin" + File.separator + "GDLink_CLI";
        return path;
    }

    private static String getScriptPath() {
        String path = TargetOSInfo.isWindows() ? String.valueOf(GeneralPathUtil.getToolsPath()) + File.separator + "GDLinkGDBServer" + File.separator + "gdlinkscript.gdlink" : String.valueOf(GeneralPathUtil.getToolsPath()) + File.separator + "GDLinkGDBServer" + File.separator + "bin" + File.separator + "gdlinkscript.gdlink";
        return path;
    }

    public static Boolean createGDLinkScript(String scriptContent) {
        SCRIPT_PATH = GDLinkOperation.getScriptPath();
        File file = new File(SCRIPT_PATH);
        try {
            boolean created = file.createNewFile();
            if (created) {
                System.out.println("File create success");
            } else {
                System.out.println("File create not success");
            }
        }
        catch (IOException e) {
            System.out.println("create fail: " + e.getMessage());
        }
        try {
            Throwable e = null;
            Object var3_7 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(scriptContent);
                return true;
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            System.out.println("\u9359\u6220\u6553\u95bf\u6b12\ue1e4:" + e.getMessage());
            return false;
        }
    }

    private static Boolean deleteGDLinkScript() {
        SCRIPT_PATH = GDLinkOperation.getScriptPath();
        File file = new File(SCRIPT_PATH);
        if (file.exists()) {
            if (file.delete()) {
                System.out.println("\u93c2\u56e6\u6b22\u5bb8\u53c9\u579a\u9354\u71b7\u57b9\u95c4\u3083\ufffd\ufffd");
                return true;
            }
            System.out.println("\u93c3\u72b3\u7876\u9352\u72bb\u6ace\u93c2\u56e6\u6b22");
        } else {
            System.out.println("\u93c2\u56e6\u6b22\u6d93\u5d85\u74e8\u9366\u3123\ufffd\ufffd");
        }
        return false;
    }
}

