/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.adapter;

import com.gigadevice.adapter.AdapterInterface;
import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.adapter.gdlink.GDLinkOperation;
import com.gigadevice.adapter.jlink.JLinkOperation;
import com.gigadevice.utils.ProjectUtils;
import com.gigadevice.utils.constants.DebugConstants;
import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class TargetAdapter {
    private static AdapterType AdapterSel;
    private static TIFType TIFSel;
    private static String TargetMcuPartNo;
    private static AdapterInterface AdapterIf;
    private static MbsType CoreType;
    private static String ServerPath;
    public static MessageConsole console;
    public static MessageConsoleStream fOut;
    public static long flashAddress;

    public static void PrintToConsole(String type, String Message) {
        if (Message == null) {
            return;
        }
        if (Message.isEmpty()) {
            return;
        }
        if (fOut == null) {
            fOut = TargetAdapter.GetConsoleStream();
        }
        fOut.println(String.valueOf(System.lineSeparator()) + type + ":" + Message);
        console.activate();
    }

    public static void setTargetMcuPartNo(String valstr) {
        TargetMcuPartNo = valstr;
    }

    public static String getTargetMcuPartNo() {
        return TargetMcuPartNo;
    }

    public static void setDebuggerAdapter(AdapterType TargetSel) {
        AdapterSel = TargetSel;
    }

    public static AdapterType getDebuggerAdapter() {
        return AdapterSel;
    }

    public static void setInterface(TIFType TargetSel) {
        TIFSel = TargetSel;
    }

    public static int getInterface() {
        return TIFSel.ordinal();
    }

    public static void setCoreType(MbsType core) {
        CoreType = core;
    }

    public static MbsType getCoreType() {
        return CoreType;
    }

    private static Boolean readMcuID(char[] retVal) {
        return AdapterIf.readMcuID(retVal);
    }

    private static Boolean setProjectAndUpdateOption(IProject project) {
        return AdapterIf.setProjectAndUpdateOption(project);
    }

    private static Boolean downloadBin(String TargetFileName, long DownloadAddress) {
        return AdapterIf.downloadBin(TargetFileName, DownloadAddress);
    }

    private static Boolean downloadHex(String TargetHexFileName, String DownloadAddress, String DownloadLength) {
        return AdapterIf.downloadHex(TargetHexFileName, DownloadAddress, DownloadLength);
    }

    private static Boolean UpdateAdapterInfo(IProject project) {
        ILaunchConfiguration launchConfig = null;
        launchConfig = AdapterUtils.getTargetLanuchConfiguration(project);
        if (launchConfig == null) {
            TargetAdapter.PrintToConsole("Warning", "Fail to get information of lanuch Configuration");
            return false;
        }
        try {
            String debugger = launchConfig.getAttribute("com.gigadevice.debug.launch.jtagDevice", "");
            String dbgInterface = launchConfig.getAttribute("com.gigadevice.debug.launch.interface", "");
            debugger = debugger.trim();
            dbgInterface = dbgInterface.trim();
            if (debugger.length() > 0 && dbgInterface.length() > 0) {
                return TargetAdapter.UpdateAdapterInfo(project, debugger, dbgInterface);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Boolean UpdateAdapterInfo(IProject project, String DebuggerSel, String InterfaceSel) {
        String TargetMcuStr = AdapterUtils.getTargetMcuPartNo(project);
        if (TargetMcuStr != null && TargetMcuStr.length() > 0) {
            TargetAdapter.setTargetMcuPartNo(TargetMcuStr);
        }
        MbsType TargetCore = AdapterUtils.getToolChainType(project);
        TargetAdapter.setCoreType(TargetCore);
        if (DebuggerSel.equals(DebugConstants.debuggerEnum.GDLink.toString())) {
            TargetAdapter.setDebuggerAdapter(AdapterType.GDLink);
            AdapterIf = new GDLinkOperation();
        } else if (DebuggerSel.equals(DebugConstants.debuggerEnum.JLink.toString())) {
            TargetAdapter.setDebuggerAdapter(AdapterType.JLink);
            AdapterIf = new JLinkOperation();
        } else {
            return false;
        }
        if (InterfaceSel.equals(DebugConstants.interfaceEnum.jtag.toString())) {
            TargetAdapter.setInterface(TIFType.JTAG);
        }
        if (InterfaceSel.equals(DebugConstants.interfaceEnum.swd.toString())) {
            TargetAdapter.setInterface(TIFType.SWD);
        }
        TargetAdapter.setProjectAndUpdateOption(project);
        return true;
    }

    static MessageConsoleStream GetConsoleStream() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        console = new MessageConsole("Gigadevice MCU Eclipse console", null);
        MessageConsoleStream fOut = console.newMessageStream();
        manager.addConsoles(new IConsole[]{console});
        return fOut;
    }

    public static String readMcuID(IProject project, String DebuggerSel, String InterfaceSel) {
        Boolean retFlag;
        String retVal = null;
        char[] McuID = new char[10];
        if (fOut == null) {
            fOut = TargetAdapter.GetConsoleStream();
        }
        if ((retFlag = TargetAdapter.UpdateAdapterInfo(project, DebuggerSel, InterfaceSel)).booleanValue() && (retFlag = TargetAdapter.readMcuID(McuID)).booleanValue()) {
            retVal = new String(McuID);
            return retVal;
        }
        return null;
    }

    public static Boolean downloadBin(IProject project) {
        if (fOut == null) {
            fOut = TargetAdapter.GetConsoleStream();
        }
        console.activate();
        Boolean retFlag = TargetAdapter.UpdateAdapterInfo(project);
        if (!retFlag.booleanValue()) {
            return false;
        }
        long DownloadAddress = flashAddress;
        IConfiguration cfg = ProjectUtils.getActiveConfigurationsForProject((IProject)project);
        if (cfg == null) {
            return false;
        }
        String TargetFileName = AdapterUtils.getDownloadFilePath(project, ".bin");
        if (TargetFileName == null || TargetFileName.isEmpty()) {
            TargetAdapter.PrintToConsole("Warning", "Can't get target binary file");
            return false;
        }
        File f = new File(TargetFileName);
        byte[] Data = AdapterUtils.File2ByteArray(f);
        if (Data == null || Data.length == 0) {
            TargetAdapter.PrintToConsole("Warning", String.valueOf(TargetFileName) + " file is empty");
            return false;
        }
        fOut.println(String.valueOf(System.lineSeparator()) + "information: Start downloading...");
        Boolean flag = false;
        if (AdapterSel == AdapterType.JLink) {
            String DownloadAddressStr = "0x" + String.format("%08x", DownloadAddress);
            String cfr_ignored_0 = "0x" + String.format("%08x", Data.length);
            fOut.println(String.valueOf(System.lineSeparator()) + "information: Flash download address  " + DownloadAddressStr);
            flag = TargetAdapter.downloadBin(TargetFileName, DownloadAddress);
        } else {
            TargetFileName = AdapterUtils.getDownloadFilePath(project, ".hex");
            if (TargetFileName == null || TargetFileName.isEmpty()) {
                TargetAdapter.PrintToConsole("Warning", "Can't get target hex file");
                return false;
            }
            MbsType mbsSel = AdapterUtils.getToolChainType(project);
            long PCValue = 0L;
            long MSPValue = 0L;
            if (mbsSel == MbsType.ARM) {
                if (Data.length <= 8) {
                    return false;
                }
                PCValue = AdapterUtils.ByteArray2Long(Data, DownloadAddress, 4);
                MSPValue = AdapterUtils.ByteArray2Long(Data, DownloadAddress, 0);
            } else if (mbsSel == MbsType.RISCV) {
                PCValue = DownloadAddress;
            }
            String PCValueStr = "0x" + String.format("%08x", PCValue);
            String MSPValueStr = "0x" + String.format("%08x", MSPValue);
            flag = TargetAdapter.downloadHex(TargetFileName, PCValueStr, MSPValueStr);
        }
        if (!flag.booleanValue()) {
            fOut.println(String.valueOf(System.lineSeparator()) + "information: Flash download and run failed.");
            return false;
        }
        fOut.println(String.valueOf(System.lineSeparator()) + "information: Flash download and run successful.");
        return flag;
    }

    public static Boolean eraseChip(IProject project) {
        if (fOut == null) {
            fOut = TargetAdapter.GetConsoleStream();
        }
        console.activate();
        Boolean retFlag = TargetAdapter.UpdateAdapterInfo(project);
        if (!retFlag.booleanValue()) {
            return false;
        }
        IConfiguration cfg = ProjectUtils.getActiveConfigurationsForProject((IProject)project);
        if (cfg == null) {
            return false;
        }
        fOut.println(String.valueOf(System.lineSeparator()) + "information: Start erasing...");
        Boolean flag = AdapterIf.eraseChip();
        if (!flag.booleanValue()) {
            fOut.println(String.valueOf(System.lineSeparator()) + "information: Flash erase failed.");
            return false;
        }
        fOut.println(String.valueOf(System.lineSeparator()) + "information: Flash erase successful.");
        return flag;
    }

    public static String getServerPath() {
        return ServerPath;
    }

    public static void setServerPath(String serverPath) {
        ServerPath = serverPath;
    }

    public static enum AdapterType {
        GDLink,
        JLink;

    }

    public static enum MbsType {
        ARM,
        RISCV;

    }

    public static enum TIFType {
        JTAG,
        SWD;

    }
}

