/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.logging.ide;

import com.gigadevice.logging.ide.LogConfigurationUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Platform;

public class LogManager {
    private static final LogManager INSTANCE = new LogManager();
    private Logger ideLoggers = null;
    private final String workspacePath = Platform.getLocation().toOSString();

    private LogManager() {
    }

    public static LogManager getInstance() {
        return INSTANCE;
    }

    public synchronized Logger getIDELogger() {
        if (this.ideLoggers != null) {
            return this.ideLoggers;
        }
        this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
        this.ideLoggers.info("log4j2 initialized");
        return this.ideLoggers;
    }

    public void setProjectLogLevel(String projectName, Level level) {
        LogConfigurationUtil.setLogLevel(projectName, level);
    }

    public void setIDELogLevel(String loggerName, Level level) {
        LogConfigurationUtil.setLogLevel("IDE." + loggerName, level);
    }

    public void info(String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.info("IDE", message);
    }

    public void info(String source, String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.ideLoggers.info("[{}] {}", (Object)source, (Object)message);
    }

    public void warn(String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.warn("IDE", message);
    }

    public void warn(String source, String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.ideLoggers.warn("[{}] {}", (Object)source, (Object)message);
    }

    public void warn(String warningCode, String source, String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.ideLoggers.warn("[{}] [{}] {}", (Object)warningCode, (Object)source, (Object)message);
    }

    public void error(String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.error("IDE", message);
    }

    public void error(String source, String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.ideLoggers.error("[{}] {}", (Object)source, (Object)message);
    }

    public void error(String errorCode, String source, String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.ideLoggers.error("[{}] [{}] {}", (Object)errorCode, (Object)source, (Object)message);
    }

    public void debug(String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.debug("IDE", message);
    }

    public void debug(String source, String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.ideLoggers.debug("[{}] {}", (Object)source, (Object)message);
    }

    public void fatal(String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.fatal("IDE", message);
    }

    public void fatal(String source, String message) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        this.ideLoggers.fatal("[{}] {}", (Object)source, (Object)message);
    }

    public void logThrowable(Throwable throwable) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        if (throwable instanceof Error) {
            this.ideLoggers.fatal("Throwable Error: ", throwable);
        } else {
            this.ideLoggers.fatal("Throwable Exception: ", throwable);
        }
    }

    public void logThrowable(String source, Throwable throwable) {
        if (this.ideLoggers == null) {
            this.ideLoggers = LogConfigurationUtil.configureIDELogger("ide", this.workspacePath);
            this.ideLoggers.info("log4j2 initialized");
        }
        String Source2 = "[" + source + "]";
        this.ideLoggers.fatal(Source2, throwable);
    }

    public synchronized void closeIDELogger(String name) {
        this.ideLoggers = null;
    }

    public synchronized void shutdown() {
        this.ideLoggers = null;
        org.apache.logging.log4j.LogManager.shutdown();
    }
}

