/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.log;

import com.gigadevice.log.DataInfo;
import com.gigadevice.log.LogConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UncaughtExceptionLogger
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = LogManager.getLogger(UncaughtExceptionLogger.class);

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        UncaughtExceptionLogger.logUncaughtException(e);
    }

    public static void registerExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionLogger());
    }

    public static void logUncaughtException(Throwable throwable) {
        throwable.printStackTrace();
        if (LogConfig.isLog()) {
            String dataInfo = "";
            if (DataInfo.isDetect()) {
                dataInfo = DataInfo.getDetectInfo();
            }
            if (throwable instanceof Error) {
                logger.fatal(dataInfo, throwable);
            } else {
                logger.error(dataInfo, throwable);
            }
        }
    }
}

