/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ProjectUtils {
    private static ArrayList<String> addSymbols = new ArrayList();

    public static ArrayList<String> getAddSymbols() {
        if (addSymbols.size() == 0) {
            addSymbols.add("GD_ECLIPSE_GCC");
            addSymbols.add("USE_STDPERIPH_DRIVER");
        }
        return addSymbols;
    }

    public static IConfiguration getActiveConfigurationsForProject(IProject project) {
        ICProjectDescription cProjectDescription = CoreModel.getDefault().getProjectDescription(project);
        if (cProjectDescription == null) {
            return null;
        }
        ICConfigurationDescription cfg = cProjectDescription.getActiveConfiguration();
        if (cfg == null) {
            return null;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            IConfiguration config = info.getManagedProject().getConfiguration(cfg.getId());
            return config;
        }
        return null;
    }

    public static List<IConfiguration> getConfigurationsListForProject(IProject project) {
        ICProjectDescription cProjectDescription = CoreModel.getDefault().getProjectDescription(project);
        if (cProjectDescription == null) {
            return null;
        }
        ICConfigurationDescription[] cfgs = cProjectDescription.getConfigurations();
        if (cfgs == null) {
            return null;
        }
        ArrayList<IConfiguration> list = new ArrayList<IConfiguration>();
        int i = 0;
        while (i < cfgs.length) {
            IConfiguration config;
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            if (info != null && (config = info.getManagedProject().getConfiguration(cfgs[i].getId())) != null) {
                list.add(config);
            }
            ++i;
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public static String parseFilePath(String RootPath, String FileName) {
        String ret = "";
        File dir = new File(RootPath);
        if (!dir.exists()) {
            System.out.println("\u74ba\ue21a\u7dde\u6d93\u5d85\u74e8\u9366\ufffd:" + RootPath);
            return "";
        }
        if (FileName == null || FileName == "") {
            System.out.println("\u93c2\u56e6\u6b22\u935a\u5d84\u8d1f\u7ecc\ufffd");
            return "";
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return "";
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                String dirPath = f.getAbsolutePath();
                f.getName();
                if (dirPath.contains(FileName)) {
                    return dirPath;
                }
                ret = ProjectUtils.parseFilePath(dirPath, FileName);
                if (ret != "") {
                    return ret;
                }
            } else if (f.isFile()) {
                String filePath = f.getAbsolutePath();
                f.getName();
                if (filePath.contains(FileName)) {
                    return filePath;
                }
            }
            ++n2;
        }
        return ret;
    }

    public static String findFileFolder(String RootPath, String FileName) {
        FileName = FileName.replace("/", File.separator);
        String AbsoluteFilePath = ProjectUtils.parseFilePath(RootPath, FileName);
        String AbsoluteFileFolder = AbsoluteFilePath.replace(String.valueOf(File.separator) + FileName, "");
        File RootFile = new File(RootPath);
        File FileFolder = new File(AbsoluteFileFolder);
        String relativeFolder = RootFile.toURI().relativize(FileFolder.toURI()).getPath();
        relativeFolder = relativeFolder.replace("/", File.separator);
        return relativeFolder;
    }

    public static String[] StringToList(String str) {
        if (str.contains(",")) {
            return str.split(",");
        }
        String[] values = new String[]{str};
        return values;
    }

    public static String[] ArrayListToList(ArrayList<String> lArrayList) {
        String[] values = lArrayList.toArray(new String[0]);
        return values;
    }

    public static List<String> getALLFilesPath(File dir, String fileName, List<String> fileList) {
        File[] fs = dir.listFiles();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getAbsolutePath().contains(fileName)) {
                    fileList.add(fs[i].getAbsolutePath());
                }
                if (fs[i].isDirectory()) {
                    try {
                        ProjectUtils.getALLFilesPath(fs[i], fileName, fileList);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return fileList;
    }

    public static List<String> getALLSpecifiedSuffixFilesPath(File dir, String fileName, List<String> fileList) {
        File[] fs = dir.listFiles();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                String Suffix = ProjectUtils.getFileExtension(fs[i].getAbsolutePath());
                if (!Suffix.equals("") && Suffix.equals(fileName)) {
                    fileList.add(fs[i].getAbsolutePath());
                }
                if (fs[i].isDirectory()) {
                    try {
                        ProjectUtils.getALLSpecifiedSuffixFilesPath(fs[i], fileName, fileList);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return fileList;
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(46) == -1) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(46));
    }

    public static List<String> getGDCList(IProject project) {
        ArrayList<String> gdcList = new ArrayList();
        ArrayList<String> filegdcList = new ArrayList<String>();
        String projectPath = project.getLocation().toString();
        File file = new File(projectPath);
        gdcList.clear();
        gdcList = ProjectUtils.getALLFilesPath(file, ".gdc", filegdcList);
        return gdcList;
    }

    public static List<String> getFilesWithSpecifiedSuffix(IProject project, String Suffix) {
        ArrayList<String> List2 = new ArrayList();
        ArrayList<String> fileList = new ArrayList<String>();
        String projectPath = project.getLocation().toString();
        File file = new File(projectPath);
        List2.clear();
        List2 = ProjectUtils.getALLSpecifiedSuffixFilesPath(file, Suffix, fileList);
        return List2;
    }

    public static String getTargetFileFolder(String FilePath) {
        String FileType;
        String FileFolder = "";
        switch (FileType = FilePath.split("\\.")[1]) {
            case "ld": 
            case "lds": {
                FileFolder = "ldscripts";
                break;
            }
            case "S": 
            case "s": {
                FileFolder = "gcc_startup";
                break;
            }
            case "cfg": {
                FileFolder = "openocd_gdlink";
                break;
            }
        }
        return FileFolder;
    }

    public static int analyseMultiFile(String filePath, String FileFolder, ArrayList<String> filePaths) {
        int count = 0;
        String Folder = "";
        if (!FileFolder.equals("") && !(Folder = FileFolder).endsWith(File.separator)) {
            Folder = String.valueOf(Folder) + File.separator;
        }
        if (filePath.contains(",")) {
            String[] fileSourcePathStr;
            String[] stringArray = fileSourcePathStr = filePath.split(",");
            int n = fileSourcePathStr.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                string = String.valueOf(Folder) + string;
                filePaths.add(string.trim());
                ++count;
                ++n2;
            }
        } else {
            filePath = String.valueOf(Folder) + filePath;
            filePaths.add(filePath.trim());
            count = 1;
        }
        return count;
    }

    public static String getFirstFileName(String filePath) {
        String FirstFileName = "";
        FirstFileName = filePath.contains(",") ? filePath.split(",")[0] : filePath;
        return FirstFileName;
    }

    public static String ArrayListToString(ArrayList<String> List2) {
        String result = "";
        for (String string : List2) {
            result = String.valueOf(result) + string + ",";
        }
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String NormalizePath(String path) {
        return path.replace("\\", File.separator).replace("/", File.separator);
    }

    public static boolean isExistingFilePath(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        File file = new File(path);
        return file.exists() && file.isFile();
    }
}

